/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.xz;

import com.teamdev.jxbrowser.engine.ChromiumBinariesExtractionException;
import com.teamdev.jxbrowser.internal.ChromiumArchiveName;
import com.teamdev.jxbrowser.internal.Files;
import com.teamdev.jxbrowser.internal.JniLibraryName;
import com.teamdev.jxbrowser.internal.xz.ExtractionFailed;
import com.teamdev.jxbrowser.internal.xz.JavaResourceExtractor;
import com.teamdev.jxbrowser.internal.xz.JniResourceExtractor;
import com.teamdev.jxbrowser.internal.xz.ResourceExtractor;
import com.teamdev.jxbrowser.internal.xz.SevenZip;
import com.teamdev.jxbrowser.os.Environment;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public final class XzExtractor {
    public static void extract(Path destDir, ChromiumArchiveName xzArchiveName) {
        XzExtractor.canCreateDir(destDir);
        Files.createDirs(destDir);
        String xzUtilName = SevenZip.executableName();
        Path xzArchiveFile = destDir.resolve(xzArchiveName.value());
        Path xzUtilFile = destDir.resolve(xzUtilName);
        try {
            ResourceExtractor extractor = new JavaResourceExtractor();
            extractor.extract(xzArchiveName.value(), xzArchiveFile);
            if (Environment.isLinux() && !Environment.isArm() && XzExtractor.isForkExtractionEnabled()) {
                XzExtractor.extractToolkitLibrary(destDir, extractor);
                extractor = new JniResourceExtractor();
            }
            extractor.extract(xzUtilName, xzUtilFile);
            if (!Environment.isWindows()) {
                Files.restorePermissionsForFile(xzUtilFile);
            }
            SevenZip.create(xzUtilFile.toAbsolutePath()).decompress(xzArchiveFile.toAbsolutePath(), destDir.toAbsolutePath());
        }
        catch (ExtractionFailed | IOException | InterruptedException e) {
            throw new ChromiumBinariesExtractionException("Failed to extract Chromium binaries into " + destDir.toAbsolutePath(), e);
        }
        finally {
            Files.deleteFile(xzArchiveFile);
            Files.deleteFile(xzUtilFile);
        }
    }

    private XzExtractor() {
    }

    private static void extractToolkitLibrary(Path destDir, ResourceExtractor extractor) throws IOException {
        String fileName = JniLibraryName.TOOLKIT.toPlatform();
        Path toolkitLibraryFile = destDir.resolve(fileName);
        extractor.extract(fileName, toolkitLibraryFile);
    }

    private static boolean isForkExtractionEnabled() {
        return !Boolean.getBoolean("jxbrowser.disable.fork.extraction");
    }

    private static void canCreateDir(Path destDir) {
        if (java.nio.file.Files.exists(destDir, new LinkOption[0]) && !java.nio.file.Files.isDirectory(destDir, new LinkOption[0])) {
            throw new IllegalArgumentException("Cannot create directory to extract Chromium. File with the same name already exists: " + destDir.toAbsolutePath());
        }
    }
}

