/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.net.tls;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.net.tls.Cast;
import com.teamdev.jxbrowser.net.tls.Certificate;
import com.teamdev.jxbrowser.net.tls.KeyStoreType;
import com.teamdev.jxbrowser.net.tls.LoadClientCertificateException;
import com.teamdev.jxbrowser.net.tls.SslPrivateKey;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collections;

public interface ClientCertificate
extends Certificate {
    public static ClientCertificate of(X509Certificate x509Cert, SslPrivateKey privateKey) throws CertificateEncodingException {
        Preconditions.checkNotNull(x509Cert);
        Preconditions.checkNotNull(privateKey);
        return Cast.fromCertAndKey(x509Cert, privateKey);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClientCertificate of(Path certFilePath, String certPassword, KeyStoreType keyStoreType) {
        Preconditions.checkNotNull(certFilePath);
        Preconditions.checkNotNull(certPassword);
        Preconditions.checkNotNull(keyStoreType);
        try (FileInputStream inputStream = new FileInputStream(certFilePath.toFile());){
            KeyStore keyStore = KeyStore.getInstance(keyStoreType.name());
            char[] passwordArray = certPassword.toCharArray();
            keyStore.load(inputStream, passwordArray);
            String firstAlias = Collections.list(keyStore.aliases()).get(0);
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(firstAlias);
            Key privateKey = keyStore.getKey(firstAlias, passwordArray);
            ClientCertificate clientCertificate = ClientCertificate.of(x509Certificate, SslPrivateKey.of(privateKey.getEncoded()));
            return clientCertificate;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new LoadClientCertificateException(certFilePath, (Throwable)e);
        }
    }

    @Override
    default public byte[] derEncodedValue() {
        return ((com.teamdev.jxbrowser.net.internal.rpc.ClientCertificate)this).getCertificate().getDerEncodedValue().toByteArray();
    }

    default public SslPrivateKey privateKey() {
        return ((com.teamdev.jxbrowser.net.internal.rpc.ClientCertificate)this).getPrivateKey();
    }
}

