/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.spellcheck.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.event.Observable;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Lazy;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import com.teamdev.jxbrowser.profile.internal.ProfileImpl;
import com.teamdev.jxbrowser.spellcheck.Dictionary;
import com.teamdev.jxbrowser.spellcheck.SpellChecker;
import com.teamdev.jxbrowser.spellcheck.internal.DictionaryImpl;
import com.teamdev.jxbrowser.spellcheck.internal.event.SpellCheckerEvent;
import com.teamdev.jxbrowser.spellcheck.internal.rpc.DictionaryNameList;
import com.teamdev.jxbrowser.spellcheck.internal.rpc.SetDictionaryNamesRequest;
import com.teamdev.jxbrowser.spellcheck.internal.rpc.SetSpellCheckEnabledRequest;
import com.teamdev.jxbrowser.spellcheck.internal.rpc.SpellCheckerStub;
import java.util.Collections;
import java.util.List;

public final class SpellCheckerImpl
extends CloseableImpl
implements Observable<SpellCheckerEvent>,
SpellChecker {
    private final ProfileImpl profile;
    private final Lazy<DictionaryImpl> customDictionary;
    private final ServiceConnectionImpl<SpellCheckerStub> rpc;

    public SpellCheckerImpl(ProfileImpl profile) {
        Preconditions.checkNotNull(profile);
        this.profile = profile;
        EngineImpl engine = profile.engine();
        this.customDictionary = new Lazy<DictionaryImpl>(() -> new DictionaryImpl(this));
        this.rpc = new ServiceConnectionImpl<SpellCheckerStub>(profile.id(), engine.connection(), SpellCheckerStub::new);
    }

    @Override
    public ProfileImpl profile() {
        return this.profile;
    }

    @Override
    public boolean isEnabled() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::getEnabled, this.profile.id())).getValue();
    }

    private void setEnabled(boolean enabled) {
        this.checkNotClosed();
        SetSpellCheckEnabledRequest request = SetSpellCheckEnabledRequest.newBuilder().setProfileId(this.profile.id()).setEnabled(BoolValue.of(enabled)).build();
        this.rpc.invoke(this.rpc.stub()::setEnabled, request);
    }

    @Override
    public void enable() {
        this.setEnabled(true);
    }

    @Override
    public void disable() {
        this.setEnabled(false);
    }

    @Override
    public List<String> dictionaryNames() {
        this.checkNotClosed();
        return Collections.unmodifiableList(((DictionaryNameList)this.rpc.invoke(this.rpc.stub()::getDictionaryNames, this.profile.id())).getDictionaryNameList());
    }

    @Override
    public void dictionaryNames(String ... dictionaryNames) {
        StringPreconditions.checkNotNullEmptyOrBlank(dictionaryNames);
        this.checkNotClosed();
        ImmutableList<String> dictionaries = ImmutableList.copyOf(dictionaryNames);
        DictionaryNameList dictionaryNameList = DictionaryNameList.newBuilder().addAllDictionaryName(dictionaries).build();
        SetDictionaryNamesRequest request = SetDictionaryNamesRequest.newBuilder().setProfileId(this.profile.id()).setDictionaryNames(dictionaryNameList).build();
        this.rpc.invoke(this.rpc.stub()::setDictionaryNames, request);
    }

    @Override
    public Dictionary customDictionary() {
        return this.customDictionary.get();
    }

    @Override
    public <E extends SpellCheckerEvent> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.rpc.on(eventClass, observer);
    }

    @Override
    public void close() {
        SpellCheckerImpl.closeIfNecessary(this.customDictionary);
        this.rpc.close();
        super.close();
    }
}

