/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.ui.internal;

import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableMap;
import com.teamdev.jxbrowser.ui.internal.rpc.Cursor;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;

public final class ToolkitCursors<T> {
    private final ImmutableMap<Cursor.Type, T> cursors;

    public static <T> Builder<T> newBuilder() {
        return new Builder();
    }

    private ToolkitCursors(Builder<T> builder) {
        this.cursors = ImmutableMap.copyOf(((Builder)builder).cursors);
    }

    public Optional<T> get(Cursor.Type type) {
        T cursor = this.cursors.get(type);
        return Optional.ofNullable(cursor);
    }

    public static class Builder<T> {
        private final Map<Cursor.Type, T> cursors = new EnumMap<Cursor.Type, T>(Cursor.Type.class);

        private Builder() {
        }

        public Builder<T> add(Cursor.Type cursorType, T cursor) {
            this.cursors.put(cursorType, cursor);
            return this;
        }

        public ToolkitCursors<T> build() {
            return new ToolkitCursors(this);
        }
    }
}

