/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.internal.mac;

import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.internal.rpc.MemoryId;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.view.internal.mac.NsAccessibility;

public final class NsView {
    private final long nsViewId;
    private final ToolkitLibrary toolkit = ToolkitLibrary.instance();
    private final NsAccessibility nsAccessibility;
    private boolean visible;

    public NsView(BrowserWidget widget) {
        this.nsViewId = this.toolkit.createNsView(0, 0, 1, 1);
        this.nsAccessibility = new NsAccessibility(widget, this);
    }

    long id() {
        return this.nsViewId;
    }

    public void notifyFocusGained() {
        this.nsAccessibility.activateRemoteAccessibilityNode();
    }

    public void notifyFocusLost() {
        this.nsAccessibility.deactivateRemoteAccessibilityNode();
    }

    public void close() {
        this.toolkit.deleteNsView(this.nsViewId);
        this.nsAccessibility.removeRemoteAccessibilityNode();
    }

    public void show(long parentViewId, Rect bounds) {
        Preconditions.checkArgument(parentViewId != 0L);
        if (this.visible) {
            return;
        }
        this.toolkit.showNsView(parentViewId, this.nsViewId);
        this.nsAccessibility.configureRemoteAccessibility(parentViewId);
        this.visible = true;
        this.updateBounds(bounds);
    }

    public void hide() {
        if (!this.visible) {
            return;
        }
        this.toolkit.hideNsView(this.nsViewId);
        this.nsAccessibility.removeRemoteAccessibilityNode();
        this.visible = false;
    }

    public void updateBounds(Rect bounds) {
        if (!this.visible) {
            return;
        }
        this.toolkit.setNsViewBounds(this.nsViewId, bounds.x(), bounds.y(), bounds.width(), bounds.height());
    }

    public void updateSurface(long surfaceId, float scaleFactor) {
        this.updateSurface(surfaceId, scaleFactor, false);
    }

    public void updateSurface(long surfaceId, float scaleFactor, boolean drawBorder) {
        this.toolkit.setNsViewSurface(this.nsViewId, surfaceId, scaleFactor, drawBorder);
    }

    public void updateSurface(Size size, float scaleFactor, MemoryId memoryId, boolean drawBorder) {
        this.toolkit.updateSurface(this.nsViewId, size.width(), size.height(), scaleFactor, memoryId.getValue(), drawBorder);
    }

    public void setNsViewLayer(int contextId, float scaleFactor, boolean drawBorder) {
        this.toolkit.setNsViewLayer(this.nsViewId, contextId, scaleFactor, drawBorder);
    }

    public void setNsViewLayer(int contextId, float scaleFactor) {
        this.toolkit.setNsViewLayer(this.nsViewId, contextId, scaleFactor, false);
    }
}

