/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer.controller;

import java.util.ArrayList;
import java.util.List;
import org.freedesktop.gstreamer.ControlSource;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.lowlevel.GlibAPI;
import org.freedesktop.gstreamer.lowlevel.GstControllerAPI;
import org.freedesktop.gstreamer.lowlevel.GstTimedValueControlSourcePtr;

public class TimedValueControlSource
extends ControlSource {
    public static final String GTYPE_NAME = "GstTimedValueControlSource";
    private final Handle handle;

    protected TimedValueControlSource(Handle handle, boolean needRef) {
        super(handle, needRef);
        this.handle = handle;
    }

    TimedValueControlSource(NativeObject.Initializer init) {
        this(new Handle(init.ptr.as(GstTimedValueControlSourcePtr.class, GstTimedValueControlSourcePtr::new), init.ownsHandle), init.needRef);
    }

    public boolean set(long timestamp, double value) {
        return GstControllerAPI.GSTCONTROLLER_API.gst_timed_value_control_source_set(this.handle.getPointer(), timestamp, value);
    }

    public boolean setFromList(List<ControlSource.TimedValue> timedValues) {
        for (ControlSource.TimedValue timedvalue : timedValues) {
            boolean ok = this.set(timedvalue.timestamp, timedvalue.value);
            if (ok) continue;
            return false;
        }
        return true;
    }

    public List<ControlSource.TimedValue> getAll() {
        ArrayList<ControlSource.TimedValue> list = new ArrayList<ControlSource.TimedValue>();
        for (GlibAPI.GList next = GstControllerAPI.GSTCONTROLLER_API.gst_timed_value_control_source_get_all(this.handle.getPointer()); next != null; next = next.next()) {
            if (next.data == null) continue;
            list.add(new ControlSource.TimedValue(next.data.getLong(0L), next.data.getDouble(8L)));
        }
        return list;
    }

    public boolean unset(long timestamp) {
        return GstControllerAPI.GSTCONTROLLER_API.gst_timed_value_control_source_unset(this.handle.getPointer(), timestamp);
    }

    public void unsetAll() {
        GstControllerAPI.GSTCONTROLLER_API.gst_timed_value_control_source_unset_all(this.handle.getPointer());
    }

    public int getCount() {
        return GstControllerAPI.GSTCONTROLLER_API.gst_timed_value_control_source_get_count(this.handle.getPointer());
    }

    public void invalidateCache() {
        GstControllerAPI.GSTCONTROLLER_API.gst_timed_value_control_invalidate_cache(this.handle.getPointer());
    }

    protected static class Handle
    extends ControlSource.Handle {
        public Handle(GstTimedValueControlSourcePtr ptr, boolean ownsHandle) {
            super(ptr, ownsHandle);
        }

        @Override
        protected GstTimedValueControlSourcePtr getPointer() {
            return (GstTimedValueControlSourcePtr)super.getPointer();
        }
    }
}

