/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer.lowlevel;

import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.freedesktop.gstreamer.Gst;
import org.freedesktop.gstreamer.glib.GMainContext;
import org.freedesktop.gstreamer.glib.GSource;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.glib.Natives;
import org.freedesktop.gstreamer.glib.RefCountedObject;
import org.freedesktop.gstreamer.lowlevel.GPointer;
import org.freedesktop.gstreamer.lowlevel.GlibAPI;

public class MainLoop
extends RefCountedObject {
    private static final List<Runnable> bgTasks = new LinkedList<Runnable>();
    private Thread bgThread;
    private static final GlibAPI.GSourceFunc bgCallback = new GlibAPI.GSourceFunc(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean callback(Pointer source) {
            ArrayList tasks = new ArrayList();
            List list = bgTasks;
            synchronized (list) {
                tasks.addAll(bgTasks);
                bgTasks.clear();
            }
            for (Runnable r : tasks) {
                r.run();
            }
            GlibAPI.GLIB_API.g_source_unref(source);
            return false;
        }
    };

    public MainLoop() {
        this(Natives.initializer(GlibAPI.GLIB_API.g_main_loop_new(Gst.getMainContext(), false)));
    }

    public MainLoop(GMainContext ctx) {
        this(Natives.initializer(GlibAPI.GLIB_API.g_main_loop_new(ctx, false)));
    }

    public MainLoop(NativeObject.Initializer init) {
        super(new Handle(init.ptr, init.ownsHandle), init.needRef);
    }

    public void quit() {
        this.invokeLater(new Runnable(){

            @Override
            public void run() {
                GlibAPI.GLIB_API.g_main_loop_quit(MainLoop.this);
            }
        });
    }

    public void run() {
        GlibAPI.GLIB_API.g_main_loop_run(this);
    }

    public boolean isRunning() {
        return GlibAPI.GLIB_API.g_main_loop_is_running(this);
    }

    public GMainContext getMainContext() {
        return GlibAPI.GLIB_API.g_main_loop_get_context(this);
    }

    public void startInBackground() {
        this.bgThread = new Thread(new Runnable(){

            @Override
            public void run() {
                MainLoop.this.run();
            }
        });
        this.bgThread.setDaemon(true);
        this.bgThread.setName("gmainloop");
        this.bgThread.start();
    }

    public void invokeAndWait(Runnable r) {
        FutureTask<Object> task = new FutureTask<Object>(r, null);
        this.invokeLater(task);
        try {
            task.get();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex.getCause());
        }
        catch (ExecutionException ex) {
            throw new RuntimeException(ex.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeLater(Runnable r) {
        List<Runnable> list = bgTasks;
        synchronized (list) {
            boolean empty = bgTasks.isEmpty();
            bgTasks.add(r);
            if (empty) {
                GSource source = GlibAPI.GLIB_API.g_idle_source_new();
                GlibAPI.GLIB_API.g_source_set_callback(source, bgCallback, source, null);
                source.attach(Gst.getMainContext());
                source.disown();
            }
        }
    }

    private static final class Handle
    extends RefCountedObject.Handle {
        public Handle(GPointer ptr, boolean ownsHandle) {
            super(ptr, ownsHandle);
        }

        @Override
        protected void disposeNativeHandle(GPointer ptr) {
            GlibAPI.GLIB_API.g_main_loop_unref(ptr);
        }

        @Override
        protected void ref() {
            GlibAPI.GLIB_API.g_main_loop_ref(this.getPointer());
        }

        @Override
        protected void unref() {
            GlibAPI.GLIB_API.g_main_loop_unref(this.getPointer());
        }
    }
}

