/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer;

import org.freedesktop.gstreamer.GstObject;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.lowlevel.GValueAPI;
import org.freedesktop.gstreamer.lowlevel.GstControlBindingAPI;
import org.freedesktop.gstreamer.lowlevel.GstControlBindingPtr;

public class ControlBinding
extends GstObject {
    public static final String GTYPE_NAME = "GstControlBinding";
    private final Handle handle;

    protected ControlBinding(Handle handle, boolean needRef) {
        super(handle, needRef);
        this.handle = handle;
    }

    ControlBinding(NativeObject.Initializer init) {
        this(new Handle(init.ptr.as(GstControlBindingPtr.class, GstControlBindingPtr::new), init.ownsHandle), init.needRef);
    }

    public Object getValue(long timestamp) {
        GValueAPI.GValue gValue = GstControlBindingAPI.GSTCONTROLBINDING_API.gst_control_binding_get_value(this.handle.getPointer(), timestamp);
        return gValue == null ? null : gValue.getValue();
    }

    public boolean getValueArray(long timestamp, long interval, Object[] values) {
        GValueAPI.GValueArray gValues = new GValueAPI.GValueArray(values.length);
        boolean ok = GstControlBindingAPI.GSTCONTROLBINDING_API.gst_control_binding_get_g_value_array(this.handle.getPointer(), timestamp, interval, gValues.n_values, gValues);
        if (ok) {
            for (int i = 0; i < values.length; ++i) {
                values[i] = gValues.getValue(i);
            }
        }
        return ok;
    }

    public void setDisabled(boolean disabled) {
        GstControlBindingAPI.GSTCONTROLBINDING_API.gst_control_binding_set_disabled(this.handle.getPointer(), disabled);
    }

    public boolean isDisabled() {
        return GstControlBindingAPI.GSTCONTROLBINDING_API.gst_control_binding_is_disabled(this.handle.getPointer());
    }

    protected static class Handle
    extends GstObject.Handle {
        public Handle(GstControlBindingPtr ptr, boolean ownsHandle) {
            super(ptr, ownsHandle);
        }

        @Override
        protected GstControlBindingPtr getPointer() {
            return (GstControlBindingPtr)super.getPointer();
        }
    }
}

