/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer;

import com.sun.jna.Pointer;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import org.freedesktop.gstreamer.Bin;
import org.freedesktop.gstreamer.Bus;
import org.freedesktop.gstreamer.Clock;
import org.freedesktop.gstreamer.Format;
import org.freedesktop.gstreamer.Segment;
import org.freedesktop.gstreamer.event.SeekFlags;
import org.freedesktop.gstreamer.event.SeekType;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.glib.Natives;
import org.freedesktop.gstreamer.lowlevel.GstElementAPI;
import org.freedesktop.gstreamer.lowlevel.GstObjectPtr;
import org.freedesktop.gstreamer.lowlevel.GstPipelineAPI;
import org.freedesktop.gstreamer.lowlevel.GstQueryAPI;
import org.freedesktop.gstreamer.query.Query;

public class Pipeline
extends Bin {
    public static final String GST_NAME = "pipeline";
    public static final String GTYPE_NAME = "GstPipeline";
    private static Logger LOG = Logger.getLogger(Pipeline.class.getName());
    private final Handle handle;

    protected Pipeline(NativeObject.Initializer init) {
        this(new Handle(init.ptr.as(GstObjectPtr.class, GstObjectPtr::new), init.ownsHandle), init.needRef);
    }

    Pipeline(Handle handle, boolean needRef) {
        super(handle, needRef);
        this.handle = handle;
        handle.busRef.set(GstPipelineAPI.GSTPIPELINE_API.gst_pipeline_get_bus(this));
    }

    public Pipeline() {
        this(Natives.initializer(GstPipelineAPI.GSTPIPELINE_API.ptr_gst_pipeline_new(null), false));
    }

    public Pipeline(String name) {
        this(Pipeline.initializer(name));
    }

    private static NativeObject.Initializer initializer(String name) {
        Pointer new_pipeline = GstPipelineAPI.GSTPIPELINE_API.ptr_gst_pipeline_new(name);
        return Natives.initializer(new_pipeline, false);
    }

    public void setAutoFlushBus(boolean flush) {
        GstPipelineAPI.GSTPIPELINE_API.gst_pipeline_set_auto_flush_bus(this, flush);
    }

    public boolean getAutoFlushBus() {
        return GstPipelineAPI.GSTPIPELINE_API.gst_pipeline_get_auto_flush_bus(this);
    }

    public boolean setClock(Clock clock) {
        return GstPipelineAPI.GSTPIPELINE_API.gst_pipeline_set_clock(this, clock);
    }

    @Override
    public Clock getClock() {
        return GstPipelineAPI.GSTPIPELINE_API.gst_pipeline_get_clock(this);
    }

    public void useClock(Clock clock) {
        GstPipelineAPI.GSTPIPELINE_API.gst_pipeline_use_clock(this, clock);
    }

    @Override
    public Bus getBus() {
        return (Bus)this.handle.busRef.get();
    }

    public boolean seek(long time) {
        return this.seek(time, TimeUnit.NANOSECONDS);
    }

    public boolean seek(long time, TimeUnit unit) {
        return this.seek(1.0, Format.TIME, EnumSet.of(SeekFlags.FLUSH, SeekFlags.KEY_UNIT), SeekType.SET, TimeUnit.NANOSECONDS.convert(time, unit), SeekType.NONE, -1L);
    }

    public boolean seek(double rate, Format format, EnumSet<SeekFlags> seekFlags, SeekType startType, long start, SeekType stopType, long stop) {
        return super.seek(rate, format, seekFlags, startType, start, stopType, stop);
    }

    @Override
    public boolean seek(double rate, Format format, Set<SeekFlags> seekFlags, SeekType startType, long start, SeekType stopType, long stop) {
        return super.seek(rate, format, seekFlags, startType, start, stopType, stop);
    }

    public long queryPosition(TimeUnit unit) {
        return unit.convert(this.queryPosition(Format.TIME), TimeUnit.NANOSECONDS);
    }

    @Override
    public long queryPosition(Format format) {
        return super.queryPosition(format);
    }

    public long queryDuration(TimeUnit unit) {
        return unit.convert(this.queryDuration(Format.TIME), TimeUnit.NANOSECONDS);
    }

    @Override
    public long queryDuration(Format format) {
        return super.queryDuration(format);
    }

    public Segment querySegment() {
        return this.querySegment(Format.TIME);
    }

    public Segment querySegment(Format format) {
        Query qry = GstQueryAPI.GSTQUERY_API.gst_query_new_segment(format);
        GstElementAPI.GSTELEMENT_API.gst_element_query(this, qry);
        double[] rate = new double[]{0.0};
        Format[] fmt = new Format[]{Format.UNDEFINED};
        long[] start_value = new long[]{0L};
        long[] stop_value = new long[]{0L};
        GstQueryAPI.GSTQUERY_API.gst_query_parse_segment(qry, rate, fmt, start_value, stop_value);
        return new Segment(rate[0], fmt[0], start_value[0], stop_value[0]);
    }

    static class Handle
    extends Bin.Handle {
        private final AtomicReference<Bus> busRef = new AtomicReference();

        public Handle(GstObjectPtr ptr, boolean ownsHandle) {
            super(ptr, ownsHandle);
        }

        @Override
        public void invalidate() {
            this.disposeBus();
            super.invalidate();
        }

        @Override
        public void dispose() {
            this.disposeBus();
            super.dispose();
        }

        private void disposeBus() {
            Bus bus = this.busRef.getAndSet(null);
            if (bus != null) {
                bus.dispose();
            }
        }
    }
}

