/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer.elements;

import java.io.File;
import java.net.URI;
import java.util.EnumSet;
import java.util.Set;
import org.freedesktop.gstreamer.Element;
import org.freedesktop.gstreamer.Gst;
import org.freedesktop.gstreamer.Pad;
import org.freedesktop.gstreamer.Pipeline;
import org.freedesktop.gstreamer.TagList;
import org.freedesktop.gstreamer.elements.PlayFlags;
import org.freedesktop.gstreamer.glib.NativeFlags;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.lowlevel.GstAPI;

public class PlayBin
extends Pipeline {
    public static final String GST_NAME = "playbin";
    public static final String GTYPE_NAME = "GstPlayBin";

    public PlayBin(String name) {
        this(PlayBin.makeRawElement(GST_NAME, name));
    }

    public PlayBin(String name, URI uri) {
        this(name);
        this.setURI(uri);
    }

    PlayBin(NativeObject.Initializer init) {
        super(init);
    }

    public void setInputFile(File file) {
        this.setURI(file.toURI());
    }

    public void setURI(URI uri) {
        this.set("uri", uri);
    }

    public void setAudioSink(Element element) {
        this.setElement("audio-sink", element);
    }

    public void setVideoSink(Element element) {
        this.setElement("video-sink", element);
    }

    public void setTextSink(Element element) {
        this.setElement("text-sink", element);
    }

    public void setVisualization(Element element) {
        this.setElement("vis-plugin", element);
    }

    private void setElement(String key, Element element) {
        this.set(key, element);
    }

    public void setFlags(Set<PlayFlags> flags) {
        this.set("flags", NativeFlags.toInt(flags));
    }

    public Set<PlayFlags> getFlags() {
        Object flags = this.get("flags");
        if (flags instanceof Number) {
            return NativeFlags.fromInt(PlayFlags.class, ((Number)flags).intValue());
        }
        return EnumSet.noneOf(PlayFlags.class);
    }

    public void setVolume(double volume) {
        this.set("volume", Math.max(Math.min(volume, 1.0), 0.0));
    }

    public double getVolume() {
        return ((Number)this.get("volume")).doubleValue();
    }

    public int getCurrentAudio() {
        return (Integer)this.get("current-audio");
    }

    public void setCurrentAudio(int n) {
        this.set("current-audio", n);
    }

    public int getNAudio() {
        return (Integer)this.get("n-audio");
    }

    public Pad getAudioPad(int audioStreamIndex) {
        return this.emit(Pad.class, "get-audio-pad", audioStreamIndex);
    }

    public TagList getAudioTags(int audioStreamIndex) {
        return this.emit(TagList.class, "get-audio-tags", audioStreamIndex);
    }

    public int getCurrentText() {
        return (Integer)this.get("current-text");
    }

    public void setCurrentText(int n) {
        this.set("current-text", n);
    }

    public int getNText() {
        return (Integer)this.get("n-text");
    }

    public Pad getTextPad(int textStreamIndex) {
        return this.emit(Pad.class, "get-text-pad", textStreamIndex);
    }

    public TagList getTextTags(int textStreamIndex) {
        return this.emit(TagList.class, "get-text-tags", textStreamIndex);
    }

    public void connect(final ABOUT_TO_FINISH listener) {
        this.connect(ABOUT_TO_FINISH.class, listener, new GstAPI.GstCallback(){

            public void callback(PlayBin elem) {
                listener.aboutToFinish(elem);
            }
        });
    }

    public void disconnect(ABOUT_TO_FINISH listener) {
        this.disconnect(ABOUT_TO_FINISH.class, listener);
    }

    public void connect(final VIDEO_CHANGED listener) {
        this.connect(VIDEO_CHANGED.class, listener, new GstAPI.GstCallback(){

            public void callback(PlayBin elem) {
                listener.videoChanged(elem);
            }
        });
    }

    public void disconnect(VIDEO_CHANGED listener) {
        this.disconnect(VIDEO_CHANGED.class, listener);
    }

    public void connect(final AUDIO_CHANGED listener) {
        this.connect(AUDIO_CHANGED.class, listener, new GstAPI.GstCallback(){

            public void callback(PlayBin elem) {
                listener.audioChanged(elem);
            }
        });
    }

    public void disconnect(AUDIO_CHANGED listener) {
        this.disconnect(AUDIO_CHANGED.class, listener);
    }

    public void connect(final TEXT_CHANGED listener) {
        this.connect(TEXT_CHANGED.class, listener, new GstAPI.GstCallback(){

            public void callback(PlayBin elem) {
                listener.textChanged(elem);
            }
        });
    }

    public void disconnect(TEXT_CHANGED listener) {
        this.disconnect(TEXT_CHANGED.class, listener);
    }

    public void connect(final VIDEO_TAGS_CHANGED listener) {
        this.connect(VIDEO_TAGS_CHANGED.class, listener, new GstAPI.GstCallback(){

            public void callback(PlayBin elem, int stream) {
                listener.videoTagsChanged(elem, stream);
            }
        });
    }

    public void disconnect(VIDEO_TAGS_CHANGED listener) {
        this.disconnect(VIDEO_TAGS_CHANGED.class, listener);
    }

    public void connect(final AUDIO_TAGS_CHANGED listener) {
        this.connect(AUDIO_TAGS_CHANGED.class, listener, new GstAPI.GstCallback(){

            public void callback(PlayBin elem, int stream) {
                listener.audioTagsChanged(elem, stream);
            }
        });
    }

    public void disconnect(AUDIO_TAGS_CHANGED listener) {
        this.disconnect(AUDIO_TAGS_CHANGED.class, listener);
    }

    public void connect(final TEXT_TAGS_CHANGED listener) {
        this.connect(TEXT_TAGS_CHANGED.class, listener, new GstAPI.GstCallback(){

            public void callback(PlayBin elem, int stream) {
                listener.textTagsChanged(elem, stream);
            }
        });
    }

    public void disconnect(TEXT_TAGS_CHANGED listener) {
        this.disconnect(TEXT_TAGS_CHANGED.class, listener);
    }

    @Gst.Since(minor=10)
    public void connect(final ELEMENT_SETUP listener) {
        Gst.checkVersion(1, 10);
        this.connect(ELEMENT_SETUP.class, listener, new GstAPI.GstCallback(){

            public void callback(PlayBin playbin, Element element) {
                listener.elementSetup(playbin, element);
            }
        });
    }

    @Gst.Since(minor=10)
    public void disconnect(ELEMENT_SETUP listener) {
        this.disconnect(ELEMENT_SETUP.class, listener);
    }

    public void connect(final SOURCE_SETUP listener) {
        this.connect(SOURCE_SETUP.class, listener, new GstAPI.GstCallback(){

            public void callback(PlayBin playbin, Element element) {
                listener.sourceSetup(playbin, element);
            }
        });
    }

    public void disconnect(SOURCE_SETUP listener) {
        this.disconnect(SOURCE_SETUP.class, listener);
    }

    public static interface SOURCE_SETUP {
        public void sourceSetup(PlayBin var1, Element var2);
    }

    @Gst.Since(minor=10)
    public static interface ELEMENT_SETUP {
        public void elementSetup(PlayBin var1, Element var2);
    }

    public static interface TEXT_TAGS_CHANGED {
        public void textTagsChanged(PlayBin var1, int var2);
    }

    public static interface AUDIO_TAGS_CHANGED {
        public void audioTagsChanged(PlayBin var1, int var2);
    }

    public static interface VIDEO_TAGS_CHANGED {
        public void videoTagsChanged(PlayBin var1, int var2);
    }

    public static interface TEXT_CHANGED {
        public void textChanged(PlayBin var1);
    }

    public static interface AUDIO_CHANGED {
        public void audioChanged(PlayBin var1);
    }

    public static interface VIDEO_CHANGED {
        public void videoChanged(PlayBin var1);
    }

    public static interface ABOUT_TO_FINISH {
        public void aboutToFinish(PlayBin var1);
    }
}

