/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer.query;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.freedesktop.gstreamer.MiniObject;
import org.freedesktop.gstreamer.Structure;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.glib.Natives;
import org.freedesktop.gstreamer.lowlevel.GstQueryAPI;
import org.freedesktop.gstreamer.lowlevel.ReferenceManager;
import org.freedesktop.gstreamer.lowlevel.annotations.HasSubtype;
import org.freedesktop.gstreamer.query.AllocationQuery;
import org.freedesktop.gstreamer.query.ConvertQuery;
import org.freedesktop.gstreamer.query.DurationQuery;
import org.freedesktop.gstreamer.query.FormatsQuery;
import org.freedesktop.gstreamer.query.LatencyQuery;
import org.freedesktop.gstreamer.query.PositionQuery;
import org.freedesktop.gstreamer.query.QueryType;
import org.freedesktop.gstreamer.query.SeekingQuery;
import org.freedesktop.gstreamer.query.SegmentQuery;

@HasSubtype
public class Query
extends MiniObject {
    public static final String GTYPE_NAME = "GstQuery";
    private static final Map<QueryType, Function<NativeObject.Initializer, Query>> TYPE_MAP = new EnumMap<QueryType, Function<NativeObject.Initializer, Query>>(QueryType.class);

    Query(NativeObject.Initializer init) {
        super(init);
    }

    public Structure getStructure() {
        return ReferenceManager.addKeepAliveReference(GstQueryAPI.GSTQUERY_API.gst_query_get_structure(this), this);
    }

    private static Query create(NativeObject.Initializer init) {
        GstQueryAPI.QueryStruct struct = new GstQueryAPI.QueryStruct(init.ptr.getPointer());
        QueryType type = (QueryType)struct.readField("type");
        return TYPE_MAP.getOrDefault(type, Query::new).apply(init);
    }

    static {
        TYPE_MAP.put(QueryType.ALLOCATION, AllocationQuery::new);
        TYPE_MAP.put(QueryType.CONVERT, ConvertQuery::new);
        TYPE_MAP.put(QueryType.DURATION, DurationQuery::new);
        TYPE_MAP.put(QueryType.FORMATS, FormatsQuery::new);
        TYPE_MAP.put(QueryType.LATENCY, LatencyQuery::new);
        TYPE_MAP.put(QueryType.POSITION, PositionQuery::new);
        TYPE_MAP.put(QueryType.SEEKING, SeekingQuery::new);
        TYPE_MAP.put(QueryType.SEGMENT, SegmentQuery::new);
    }

    public static class Types
    implements NativeObject.TypeProvider {
        @Override
        public Stream<NativeObject.TypeRegistration<?>> types() {
            return Stream.of(Natives.registration(Query.class, Query.GTYPE_NAME, x$0 -> Query.create(x$0)));
        }
    }
}

