/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import org.romstation.application.C;
import org.romstation.application.D;
import org.romstation.application.F;
import org.romstation.application.I;
import org.romstation.application.RomStation;

public class E {
    public static Path a() {
        switch (E.c()) {
            case WINDOWS: {
                return Paths.get(System.getenv("LOCALAPPDATA"), new String[0]);
            }
            case MAC_OS: {
                return Paths.get(System.getProperty("user.home"), "Library", "Application Support");
            }
        }
        return null;
    }

    public static Path b() {
        Path userDataDirectory = E.a();
        if (userDataDirectory == null) {
            return Paths.get("", new String[0]).toAbsolutePath();
        }
        return userDataDirectory.resolve("RomStation");
    }

    public static D c() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("windows")) {
            return D.WINDOWS;
        }
        if (osName.startsWith("mac")) {
            return D.MAC_OS;
        }
        if (osName.startsWith("linux")) {
            return D.LINUX;
        }
        return D.OTHER;
    }

    public static C d() {
        if (System.getProperty("os.arch").contains("64")) {
            return C.X64;
        }
        return C.X86;
    }

    public static C e() {
        boolean is64bit = System.getProperty("os.name").contains("Windows") ? System.getenv("ProgramFiles(x86)") != null : System.getProperty("os.arch").contains("64");
        return is64bit ? C.X64 : C.X86;
    }

    public static String f() {
        switch (E.c()) {
            case WINDOWS: {
                JsonArray jsonArray = I.a("csproduct", "uuid");
                if (jsonArray.size() == 0) break;
                JsonObject jsonObject = jsonArray.get(0).getAsJsonObject();
                return jsonObject.has("UUID") ? jsonObject.get("UUID").getAsString() : null;
            }
            case MAC_OS: {
                JsonObject hardwareOverview;
                JsonObject jsonObject = F.a("SPHardwareDataType");
                JsonObject hardware = jsonObject.getAsJsonObject("Hardware");
                if (hardware == null || (hardwareOverview = hardware.getAsJsonObject("Hardware Overview")) == null) break;
                return hardwareOverview.get("Hardware UUID").getAsString();
            }
        }
        return null;
    }

    public static JsonObject g() {
        switch (E.c()) {
            case WINDOWS: {
                JsonObject json = new JsonObject();
                json.add("os", (JsonElement)I.a("os", "Caption", "ServicePackMajorVersion", "Version", "osarchitecture", "BuildNumber"));
                json.add("computersystem", (JsonElement)I.a("computersystem", "Manufacturer", "Model", "NumberofProcessors", "totalphysicalmemory"));
                json.add("cpu", (JsonElement)I.a("cpu", "Name", "MaxClockSpeed", "NumberOfCores"));
                json.add("gpu", (JsonElement)I.b("win32_VideoController", "Name", "DriverVersion"));
                return json;
            }
            case MAC_OS: {
                return F.a("SPHardwareDataType", "SPSoftwareDataType", "SPDisplaysDataType");
            }
        }
        return new JsonObject();
    }

    public static String h() {
        try {
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
            return E.a(networkInterface);
        }
        catch (SocketException exception) {
            RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
        }
        catch (UnknownHostException exception) {
            RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
        }
        return null;
    }

    public static String a(NetworkInterface networkInterface) {
        try {
            byte[] hardwareAddress;
            if (networkInterface != null && (hardwareAddress = networkInterface.getHardwareAddress()) != null) {
                StringBuilder stringBuilder = new StringBuilder();
                for (byte b2 : hardwareAddress) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('-');
                    }
                    stringBuilder.append(String.format("%02x", b2).toUpperCase());
                }
                return stringBuilder.toString();
            }
        }
        catch (SocketException exception) {
            RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
        }
        return null;
    }
}

