/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javafx.concurrent.Task;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import org.romstation.application.RomStation;
import org.romstation.application.ab;
import org.romstation.application.b;
import org.romstation.application.database.entity.Developer;
import org.romstation.application.database.entity.Game;
import org.romstation.application.database.entity.GameFile;
import org.romstation.application.database.entity.GameProfile;
import org.romstation.application.database.entity.Genre;
import org.romstation.application.database.entity.I18n;
import org.romstation.application.database.entity.Image;
import org.romstation.application.database.entity.Language;
import org.romstation.application.database.entity.Link;
import org.romstation.application.database.entity.Locale;
import org.romstation.application.database.entity.Publisher;
import org.romstation.application.database.entity.System;
import org.romstation.application.database.entity.Tag;
import org.romstation.application.database.entity.Translation;
import org.romstation.application.io.a;

public class ac
extends Task<List<Game>> {
    private final List<ab> a;
    private final List<Game> b = new LinkedList<Game>();
    private EntityManager c;
    private Map<String, Locale> d;
    private JsonArray e;
    private JsonArray f;
    private JsonArray g;
    private JsonArray h;
    private JsonArray i;
    private JsonArray j;

    public ac(List<ab> games) {
        this.a = games;
    }

    protected void scheduled() {
        this.updateTitle(RomStation.d().getString("legacyGameImporterTask.title"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Game> a() throws IOException {
        this.c = org.romstation.application.b.c();
        this.d = this.c.createNamedQuery("Locale.findAll", Locale.class).getResultList().stream().collect(Collectors.toMap(Locale::getTag, Function.identity()));
        try {
            for (ab legacyGame : this.a) {
                Game game;
                this.updateMessage(MessageFormat.format(RomStation.d().getString("legacyGameImporterTask.message"), legacyGame.getTitle()));
                if (this.isCancelled()) {
                    break;
                }
                try {
                    game = (Game)this.c.createQuery("select game from Game game where game.rid = :rid", Game.class).setParameter("rid", (Object)legacyGame.getRsId()).setMaxResults(1).getSingleResult();
                }
                catch (NoResultException e2) {
                    game = this.a(legacyGame);
                }
                if (legacyGame.getFilename() != null && !legacyGame.getFilename().isEmpty()) {
                    GameFile gameFile = this.a(game, legacyGame);
                    gameFile.getProfiles().add(this.a(gameFile, legacyGame));
                    game.getFiles().add(gameFile);
                }
                this.c.getTransaction().begin();
                this.c.persist((Object)game);
                this.c.getTransaction().commit();
                this.b.add(game);
                this.updateValue(this.b);
                this.updateProgress(this.b.size(), this.a.size());
            }
        }
        finally {
            this.c.close();
        }
        return this.b;
    }

    private Game a(ab legacyGame) throws IOException {
        Path target;
        String name;
        Game game = new Game();
        if (legacyGame.getRsId() != 0) {
            game.setRid(legacyGame.getRsId());
        }
        if (legacyGame.getTitle() != null) {
            game.setTitle(legacyGame.getTitle().replaceFirst("(?i)\\(Dis(c|k|que) \\d\\)", "").trim());
        }
        if (legacyGame.getConsole() != null && !legacyGame.getConsole().isEmpty()) {
            game.setSystem(this.b(legacyGame.getConsole()));
        }
        if (legacyGame.getRegion() != null && !legacyGame.getRegion().isEmpty()) {
            game.setLanguages(this.b(legacyGame.getRegion().split(" - ")));
        }
        if (legacyGame.getGenre() != null && !legacyGame.getGenre().isEmpty()) {
            game.setGenres(this.a(legacyGame.getGenre().split(" - ")));
        }
        if (legacyGame.getPlayers() != 0) {
            game.setPlayers(legacyGame.getPlayers());
        }
        if (legacyGame.getDate() != 0) {
            game.setYear(legacyGame.getDate());
        }
        if (legacyGame.getDeveloper() != null && !legacyGame.getDeveloper().isEmpty()) {
            game.setDeveloper(this.c(legacyGame.getDeveloper()));
        }
        if (legacyGame.getPublisher() != null && !legacyGame.getPublisher().isEmpty()) {
            game.setPublisher(this.d(legacyGame.getPublisher()));
        }
        if (legacyGame.getTags() != null && !legacyGame.getTags().isEmpty()) {
            game.setTags(this.c(legacyGame.getTags().split(",")));
        }
        if (legacyGame.getUrl() != null && !legacyGame.getUrl().isEmpty()) {
            game.getLinks().add(new Link("URL", legacyGame.getUrl()));
        }
        if (legacyGame.getRsId() != 0) {
            name = org.romstation.application.io.a.a(MessageFormat.format("{0} - {1,number,#}", game.getTitle(), legacyGame.getRsId()));
            target = Paths.get(RomStation.c().getProperty("path.games"), "downloads", name);
            Files.createDirectories(target, new FileAttribute[0]);
            game.setDirectory(target.toString());
            game.setManaged(true);
        } else if (legacyGame.isLink()) {
            if (legacyGame.getFilename() != null) {
                game.setDirectory(legacyGame.getDirectory().toString());
            }
        } else {
            name = org.romstation.application.io.a.a(MessageFormat.format("{0} - {1,number,#}", game.getTitle(), legacyGame.getId()));
            target = Paths.get(RomStation.c().getProperty("path.games"), "legacy", name);
            Files.createDirectories(target, new FileAttribute[0]);
            game.setDirectory(target.toString());
            game.setManaged(true);
        }
        if (legacyGame.getScreenshot() != null && !legacyGame.getScreenshot().isEmpty()) {
            Path source = Paths.get(legacyGame.getScreenshot(), new String[0]);
            if (legacyGame.isLink()) {
                game.setGraphic(new Image(source));
            } else if (Files.exists(source, new LinkOption[0])) {
                target = Paths.get(game.getDirectory(), "images", source.getFileName().toString());
                Files.createDirectories(target, new FileAttribute[0]);
                Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
                game.setGraphic(new Image(target));
            }
        }
        if (legacyGame.getLastUse() != 0L) {
            game.setLastUse(legacyGame.getLastUse());
        }
        return game;
    }

    private GameFile a(Game game, ab legacyGame) throws IOException {
        GameFile gameFile = new GameFile();
        int gameFileRid = 0;
        if (legacyGame.getRsId() != 0 && (gameFileRid = Files.isDirectory(Paths.get(legacyGame.getFilename(), new String[0]), new LinkOption[0]) ? this.a(String.valueOf(legacyGame.getRsId())) : this.a(Paths.get(legacyGame.getFilename(), new String[0]).getFileName().toString().split("\\.")[0])) != 0) {
            gameFile.setRid(gameFileRid);
        }
        gameFile.setName(legacyGame.getTitle());
        if (!game.isManaged() || legacyGame.isLink()) {
            gameFile.setDirectory(legacyGame.getDirectory().toString());
        } else {
            Path source = Paths.get(legacyGame.getFilename(), new String[0]);
            Path target = gameFileRid != 0 ? Paths.get(game.getDirectory(), "files", String.format("%d - %d", gameFileRid, Instant.now().getEpochSecond())) : Paths.get(game.getDirectory(), "files", String.format("%d - %d", legacyGame.getId(), Instant.now().getEpochSecond()));
            Files.createDirectories(target, new FileAttribute[0]);
            if (Files.isRegularFile(source, new LinkOption[0])) {
                Files.move(source, target.resolve(source.getFileName()), StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
            }
            gameFile.setDirectory(target.toString());
            gameFile.setManaged(true);
        }
        gameFile.setGame(game);
        gameFile.getMetas().put("legacy", "{\"id\": " + legacyGame.getId() + "}");
        return gameFile;
    }

    private GameProfile a(GameFile gameFile, ab legacyGame) {
        GameProfile gameProfile = new GameProfile();
        gameProfile.setName("default");
        Path directory = Paths.get(gameFile.getDirectory(), new String[0]);
        Path file = Paths.get(legacyGame.getFilename(), new String[0]);
        if (legacyGame.getExecutable() != null && !legacyGame.getExecutable().isEmpty() && Files.isDirectory(file, new LinkOption[0])) {
            gameProfile.setPath(directory.resolve(legacyGame.getRelativeExecutable()).toString());
        } else {
            gameProfile.setPath(directory.resolve(file.getFileName()).toString());
        }
        gameProfile.setParameters(legacyGame.getParameters());
        gameProfile.setGameFile(gameFile);
        return gameProfile;
    }

    private int a(String value) throws IOException {
        if (this.j == null) {
            try (InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/importer/legacy/games_files.json"));){
                JsonParser jsonParser = new JsonParser();
                this.j = jsonParser.parse((Reader)reader).getAsJsonArray();
            }
        }
        Optional<JsonElement> optional = StreamSupport.stream(this.j.spliterator(), false).filter(jsonElement -> jsonElement.getAsJsonObject().get("rename").getAsString().split("\\.")[0].equals(value)).findAny();
        return optional.map(jsonElement -> jsonElement.getAsJsonObject().get("id").getAsInt()).orElse(0);
    }

    private System b(String value) throws IOException {
        Optional<JsonElement> optional;
        if (this.e == null) {
            try (InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/importer/legacy/systems.json"));){
                JsonParser jsonParser = new JsonParser();
                this.e = jsonParser.parse((Reader)reader).getAsJsonArray();
            }
        }
        if ((optional = StreamSupport.stream(this.e.spliterator(), false).filter(jsonElement -> {
            for (JsonElement alias : jsonElement.getAsJsonObject().get("aliases").getAsJsonArray()) {
                if (!alias.getAsString().equals(value)) continue;
                return true;
            }
            return false;
        }).findAny()).isPresent()) {
            JsonObject jsonObject = optional.get().getAsJsonObject();
            try {
                return (System)this.c.createQuery("select system from System system where system.rid = :rid", System.class).setParameter("rid", (Object)jsonObject.get("id").getAsInt()).getSingleResult();
            }
            catch (NoResultException e2) {
                return new System(jsonObject.get("id").getAsInt(), jsonObject.get("name").getAsString(), new Image(jsonObject.get("graphic").getAsString()));
            }
        }
        try {
            return (System)this.c.createQuery("select system from System system where system.name like :name", System.class).setParameter("name", (Object)value).setMaxResults(1).getSingleResult();
        }
        catch (NoResultException e3) {
            return new System(null, value, null);
        }
    }

    private List<Genre> a(String[] values) throws IOException {
        LinkedList<Genre> genres = new LinkedList<Genre>();
        if (this.f == null) {
            try (InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/importer/legacy/genres.json"));){
                JsonParser jsonParser = new JsonParser();
                this.f = jsonParser.parse((Reader)reader).getAsJsonArray();
            }
        }
        for (String value : values) {
            Optional<JsonElement> optional = StreamSupport.stream(this.f.spliterator(), false).filter(jsonElement -> jsonElement.getAsJsonObject().get("en").getAsString().equals(value) || jsonElement.getAsJsonObject().get("fr").getAsString().equals(value)).findAny();
            if (optional.isPresent()) {
                JsonObject jsonObject = optional.get().getAsJsonObject();
                try {
                    genres.add((Genre)this.c.createQuery("select genre from Genre genre where genre.rid = :rid", Genre.class).setParameter("rid", (Object)jsonObject.get("id").getAsInt()).getSingleResult());
                }
                catch (NoResultException e2) {
                    I18n i18n = new I18n();
                    i18n.getTranslations().add(new Translation(this.d.get("en"), jsonObject.get("en").getAsString(), i18n));
                    i18n.getTranslations().add(new Translation(this.d.get("fr"), jsonObject.get("fr").getAsString(), i18n));
                    genres.add(new Genre(jsonObject.get("id").getAsInt(), i18n));
                }
                continue;
            }
            try {
                genres.add((Genre)this.c.createQuery("select genre from Genre genre join genre.name.translations translation where translation.string like :string", Genre.class).setParameter("string", (Object)value).setMaxResults(1).getSingleResult());
            }
            catch (NoResultException e3) {
                I18n i18n = new I18n();
                i18n.getTranslations().add(new Translation(this.d.get("en"), value, i18n));
                i18n.getTranslations().add(new Translation(this.d.get("fr"), value, i18n));
                genres.add(new Genre(null, i18n));
            }
        }
        return genres;
    }

    private List<Language> b(String[] values) throws IOException {
        LinkedList<Language> languages = new LinkedList<Language>();
        if (this.g == null) {
            try (InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/importer/legacy/languages.json"));){
                JsonParser jsonParser = new JsonParser();
                this.g = jsonParser.parse((Reader)reader).getAsJsonArray();
            }
        }
        for (String value : values) {
            Optional<JsonElement> optional = StreamSupport.stream(this.g.spliterator(), false).filter(jsonElement -> jsonElement.getAsJsonObject().get("en").getAsString().equals(value) || jsonElement.getAsJsonObject().get("fr").getAsString().equals(value)).findAny();
            if (optional.isPresent()) {
                JsonObject jsonObject = optional.get().getAsJsonObject();
                try {
                    languages.add((Language)this.c.createQuery("select language from Language language where language.rid = :rid", Language.class).setParameter("rid", (Object)jsonObject.get("id").getAsInt()).getSingleResult());
                }
                catch (NoResultException e2) {
                    I18n i18n = new I18n();
                    i18n.getTranslations().add(new Translation(this.d.get("en"), jsonObject.get("en").getAsString(), i18n));
                    i18n.getTranslations().add(new Translation(this.d.get("fr"), jsonObject.get("fr").getAsString(), i18n));
                    languages.add(new Language(jsonObject.get("id").getAsInt(), i18n, new Image(jsonObject.get("graphic").getAsString())));
                }
                continue;
            }
            try {
                languages.add((Language)this.c.createQuery("select language from Language language join language.name.translations translation where translation.string like :string", Language.class).setParameter("string", (Object)value).setMaxResults(1).getSingleResult());
            }
            catch (NoResultException e3) {
                I18n i18n = new I18n();
                i18n.getTranslations().add(new Translation(this.d.get("fr"), value, i18n));
                i18n.getTranslations().add(new Translation(this.d.get("en"), value, i18n));
                languages.add(new Language(null, i18n));
            }
        }
        return languages;
    }

    private Developer c(String value) throws IOException {
        Optional<JsonElement> optional;
        if (value == null || value.isEmpty()) {
            return null;
        }
        if (this.h == null) {
            try (InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/importer/legacy/developers.json"));){
                JsonParser jsonParser = new JsonParser();
                this.h = jsonParser.parse((Reader)reader).getAsJsonArray();
            }
        }
        if ((optional = StreamSupport.stream(this.h.spliterator(), false).filter(jsonElement -> jsonElement.getAsJsonObject().get("name").getAsString().equals(value)).findAny()).isPresent()) {
            JsonObject jsonObject = optional.get().getAsJsonObject();
            try {
                return (Developer)this.c.createQuery("select developer from Developer developer where developer.rid = :rid", Developer.class).setParameter("rid", (Object)jsonObject.get("id").getAsInt()).getSingleResult();
            }
            catch (NoResultException e2) {
                return new Developer(jsonObject.get("id").getAsInt(), jsonObject.get("name").getAsString());
            }
        }
        try {
            return (Developer)this.c.createQuery("select developer from Developer developer where developer.name like :name", Developer.class).setParameter("name", (Object)value).setMaxResults(1).getSingleResult();
        }
        catch (NoResultException e3) {
            return new Developer(null, value);
        }
    }

    private Publisher d(String value) throws IOException {
        Optional<JsonElement> optional;
        if (value == null || value.isEmpty()) {
            return null;
        }
        if (this.i == null) {
            try (InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/importer/legacy/publishers.json"));){
                JsonParser jsonParser = new JsonParser();
                this.i = jsonParser.parse((Reader)reader).getAsJsonArray();
            }
        }
        if ((optional = StreamSupport.stream(this.i.spliterator(), false).filter(jsonElement -> jsonElement.getAsJsonObject().get("name").getAsString().equals(value)).findAny()).isPresent()) {
            JsonObject jsonObject = optional.get().getAsJsonObject();
            try {
                return (Publisher)this.c.createQuery("select publisher from Publisher publisher where publisher.rid = :rid", Publisher.class).setParameter("rid", (Object)jsonObject.get("id").getAsInt()).getSingleResult();
            }
            catch (NoResultException e2) {
                return new Publisher(jsonObject.get("id").getAsInt(), jsonObject.get("name").getAsString());
            }
        }
        try {
            return (Publisher)this.c.createQuery("select publisher from Publisher publisher where publisher.name like :name", Publisher.class).setParameter("name", (Object)value).setMaxResults(1).getSingleResult();
        }
        catch (NoResultException e3) {
            return new Publisher(null, value);
        }
    }

    private List<Tag> c(String[] values) {
        LinkedList<Tag> tags = new LinkedList<Tag>();
        for (String value : values) {
            try {
                tags.add((Tag)this.c.createQuery("select tag from Tag tag left join tag.name.translations translation where translation.string like :string", Tag.class).setParameter("string", (Object)value).setMaxResults(1).getSingleResult());
            }
            catch (NoResultException e2) {
                I18n i18n = new I18n();
                i18n.getTranslations().add(new Translation(this.d.get("en"), value, i18n));
                i18n.getTranslations().add(new Translation(this.d.get("fr"), value, i18n));
                tags.add(new Tag(i18n));
            }
        }
        return tags;
    }

    protected /* synthetic */ Object call() throws Exception {
        return this.a();
    }
}

