/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.teamdev.jxbrowser.js.JsAccessible;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import javafx.application.Platform;
import javafx.scene.control.TableColumn;
import javax.persistence.EntityManager;
import org.romstation.application.RomStation;
import org.romstation.application.an;
import org.romstation.application.b;
import org.romstation.application.cU;
import org.romstation.application.cV;
import org.romstation.application.cx;
import org.romstation.application.cy;
import org.romstation.application.database.entity.Game;
import org.romstation.application.database.entity.GameFile;
import org.romstation.application.network.NetworkOfflineException;
import org.romstation.application.task.EmulatorFileDownloadContextException;
import org.romstation.application.task.h;
import org.romstation.application.task.i;
import org.romstation.application.view.controller.RomStationController;

@JsAccessible
public class Library {
    public static final Set<Consumer<Game>> onGameDeleted = new HashSet<Consumer<Game>>();
    public static final Set<Consumer<GameFile>> onGameFileDeleted = new HashSet<Consumer<GameFile>>();
    public static List<TableColumn<Game, Object>> tableColumns = new LinkedList<TableColumn<Game, Object>>();

    public void onGameDeleted(Consumer<Game> consumer) {
        onGameDeleted.add(consumer);
    }

    public void onGameFileDeleted(Consumer<GameFile> consumer) {
        onGameFileDeleted.add(consumer);
    }

    public void addTableColumn(TableColumn tableColumn) {
        tableColumns.add((TableColumn<Game, Object>)tableColumn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchGame(int rid) {
        try (EntityManager entityManager = b.c();){
            Game game = (Game)entityManager.createNamedQuery("Game.findByRID", Game.class).setParameter("rid", (Object)rid).getSingleResult();
            Platform.runLater(() -> RomStationController.a.post((Object)new cx(game, new String[0])));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchGameFile(int rid) {
        try (EntityManager entityManager = b.c();){
            GameFile gameFile = (GameFile)entityManager.createNamedQuery("GameFile.findByRID", GameFile.class).setParameter("rid", (Object)rid).getSingleResult();
            Platform.runLater(() -> RomStationController.a.post((Object)new cy(gameFile, new String[0])));
        }
    }

    public void downloadGameFile(int gameRid, int gameFileRid) {
        Platform.runLater(() -> cU.a(gameRid, gameFileRid));
    }

    public void uploadGameFile(int gameID, int systemID) {
        Platform.runLater(() -> cV.a(gameID, systemID));
    }

    public void downloadEmulatorFile(int rid) {
        Platform.runLater(() -> {
            try {
                i emulatorFileDownloadTask = new i(new h(rid));
                Thread thread = new Thread((Runnable)((Object)emulatorFileDownloadTask));
                an dialog = new an(emulatorFileDownloadTask);
                thread.start();
                Optional optional = dialog.showAndWait();
            }
            catch (NetworkOfflineException exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
            catch (EmulatorFileDownloadContextException exception) {
                RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDownloadableContent(int rid, String string) {
        JsonParser parser = new JsonParser();
        JsonArray json = parser.parse(string).getAsJsonArray();
        try (EntityManager entityManager = b.c();){
            Game game = (Game)entityManager.createNamedQuery("Game.findByRID", Game.class).setParameter("rid", (Object)rid).getSingleResult();
            for (JsonElement element : json) {
                if (!game.getFiles().stream().noneMatch(file -> Objects.equals(file.getRid(), element.getAsInt()))) continue;
                boolean bl2 = true;
                return bl2;
            }
        }
        return false;
    }
}

