/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.fxml.FXML;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogEvent;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import org.romstation.application.RomStation;
import org.romstation.application.ap;
import org.romstation.application.au;
import org.romstation.application.network.ServerResponseException;
import org.romstation.application.network.b;
import org.romstation.application.view.control.ApplicationFXMLDialog;
import org.romstation.application.view.control.ServerErrorAlert;

public class av<T>
extends ApplicationFXMLDialog<T> {
    private final Task<T> a;
    @FXML
    private DialogPane dialogPane;
    @FXML
    private Label titleLabel;
    @FXML
    private Label messageLabel;
    @FXML
    private Label progressLabel;
    @FXML
    private ProgressBar progressBar;

    public av(Task<T> task) {
        this(task, null);
    }

    public av(Task<T> task, String styleClass) {
        this.a = task;
        this.load(((Object)((Object)this)).getClass().getResource("/fxml/dialog/taskDialog.fxml"));
        this.getDialogPane().getStyleClass().add((Object)styleClass);
    }

    @FXML
    private void initialize() {
        this.a.setOnSucceeded(this::a);
        this.a.setOnFailed(this::b);
        this.a.titleProperty().addListener((observableValue, oldValue, newValue) -> {
            this.dialogPane.setHeaderText(newValue);
            if (oldValue.isEmpty()) {
                this.dialogPane.getScene().getWindow().sizeToScene();
            }
        });
        this.messageLabel.textProperty().bind((ObservableValue)this.a.messageProperty());
        this.progressLabel.textProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.a.progressProperty().isEqualTo(-1)).then("").otherwise((ObservableStringValue)this.a.progressProperty().multiply(100).asString("%.0f%%")));
        this.progressBar.progressProperty().bind((ObservableValue)this.a.progressProperty());
        this.setOnCloseRequest(this::a);
    }

    private void a(WorkerStateEvent event) {
        this.close();
    }

    private void b(WorkerStateEvent event) {
        Throwable exception = event.getSource().getException();
        RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
        if (exception instanceof ServerResponseException) {
            if (((ServerResponseException)exception).a().a() == -99) {
                au dialog = new au(this.getResources().getString("platinumDialog.content.cloudServersNonPlatinumLimitReached"));
                ButtonType buttonType = dialog.showAndWait().orElse(ButtonType.CANCEL);
                if (buttonType.getButtonData() == ButtonBar.ButtonData.OK_DONE) {
                    try {
                        Desktop.getDesktop().browse(new URI(b.b() + "/store"));
                    }
                    catch (IOException | URISyntaxException ex) {
                        RomStation.b().log(Level.WARNING, ex.getMessage(), ex);
                    }
                }
            } else {
                ServerErrorAlert alert = new ServerErrorAlert((ServerResponseException)exception);
                alert.showAndWait();
            }
        } else {
            ap exceptionDialog = new ap(exception);
            exceptionDialog.showAndWait();
        }
        this.close();
    }

    private void a(DialogEvent event) {
        if (this.a.isRunning()) {
            this.a.cancel(false);
        }
    }

    @Override
    protected Object controllerFactory(Class<?> classType) {
        return this;
    }

    @Override
    protected T resultConverter(ButtonType buttonType) {
        return (T)this.a.getValue();
    }
}

