/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.view.control;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.ComboBox;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.HBox;
import org.romstation.application.RomStation;
import org.romstation.application.aM;
import org.romstation.application.database.entity.Developer;

public class DeveloperComboBox
extends HBox {
    @FXML
    private ComboBox<Developer> comboBox;
    @FXML
    private MenuButton menuButton;
    @FXML
    private MenuItem editMenuItem;
    @FXML
    private MenuItem clearMenuItem;
    @FXML
    private ResourceBundle resources;

    public DeveloperComboBox() {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader();
            fxmlLoader.setLocation(((Object)((Object)this)).getClass().getResource("/fxml/control/developerComboBox.fxml"));
            fxmlLoader.setResources(RomStation.d());
            fxmlLoader.setRoot((Object)this);
            fxmlLoader.setController((Object)this);
            fxmlLoader.load();
        }
        catch (IOException exception) {
            RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public ComboBox<Developer> getComboBox() {
        return this.comboBox;
    }

    @FXML
    private void initialize() {
        this.editMenuItem.disableProperty().bind((ObservableValue)this.comboBox.valueProperty().isNull());
        this.clearMenuItem.disableProperty().bind((ObservableValue)this.comboBox.valueProperty().isNull());
    }

    @FXML
    private void create() {
        aM dialog = new aM(new Developer());
        Optional optional = dialog.showAndWait();
        optional.ifPresent(developer -> {
            this.comboBox.getItems().add(developer);
            this.comboBox.setValue(developer);
        });
    }

    @FXML
    private void edit() {
        aM dialog = new aM((Developer)this.comboBox.getSelectionModel().getSelectedItem());
        Optional optional = dialog.showAndWait();
        optional.ifPresent(developer -> {
            this.comboBox.getItems().setAll(new LinkedList(this.comboBox.getItems()));
            this.comboBox.getSelectionModel().select(developer);
        });
    }

    @FXML
    private void clear() {
        this.comboBox.getSelectionModel().clearSelection();
    }
}

