/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.view.controller;

import java.awt.Desktop;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import org.romstation.application.RomStation;
import org.romstation.application.as;
import org.romstation.application.av;
import org.romstation.application.ba;
import org.romstation.application.database.entity.Game;
import org.romstation.application.database.entity.GameFile;
import org.romstation.application.task.n;
import org.romstation.application.view.control.ApplicationAlert;

public class GameFilesPaneController {
    private final Game a;
    @FXML
    private Button deleteButton;
    @FXML
    private Button editButton;
    @FXML
    private Button explorerButton;
    @FXML
    private Button copyButton;
    @FXML
    private TableView<GameFile> tableView;
    @FXML
    private TableColumn<GameFile, Integer> idTableColumn;
    @FXML
    private TableColumn<GameFile, String> nameTableColumn;
    @FXML
    private TableColumn<GameFile, Integer> profilesTableColumn;
    @FXML
    private ResourceBundle resources;

    public GameFilesPaneController(Game game) {
        this.a = game;
    }

    public TableView<GameFile> a() {
        return this.tableView;
    }

    @FXML
    private void initialize() {
        this.deleteButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.tableView.getSelectionModel().getSelectedItems()).isEqualTo(0));
        this.editButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.tableView.getSelectionModel().getSelectedItems()).isNotEqualTo(1));
        this.explorerButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.tableView.getSelectionModel().getSelectedItems()).isNotEqualTo(1));
        this.copyButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.tableView.getSelectionModel().getSelectedItems()).isNotEqualTo(1));
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.profilesTableColumn.setCellValueFactory(param -> new ReadOnlyObjectWrapper((Object)((GameFile)param.getValue()).getProfiles().size()));
        this.tableView.getItems().setAll(this.a.getFiles());
    }

    @FXML
    private void create() {
        GameFile gameFile = new GameFile();
        gameFile.setGame(this.a);
        ba dialog = new ba(gameFile);
        Optional optional = dialog.showAndWait();
        optional.ifPresent(arg_0 -> this.tableView.getItems().add(arg_0));
    }

    @FXML
    private void importFile() {
        as dialog = new as(this.a);
        dialog.showAndWait().ifPresent(arg_0 -> this.tableView.getItems().add(arg_0));
    }

    @FXML
    private void delete() {
        ApplicationAlert alert = new ApplicationAlert(this.resources.getString("gameFile.delete.alert.header"), this.resources.getString("gameFile.delete.alert.content"), Alert.AlertType.CONFIRMATION);
        Optional result = alert.showAndWait();
        if (result.isPresent() && result.get() == ButtonType.OK) {
            n gameFileDeleteTask = new n((List<GameFile>)this.tableView.getSelectionModel().getSelectedItems());
            Thread thread = new Thread((Runnable)((Object)gameFileDeleteTask));
            av<List<GameFile>> dialog = new av<List<GameFile>>(gameFileDeleteTask, "delete");
            thread.start();
            Optional dialogResult = dialog.showAndWait();
            dialogResult.ifPresent(arg_0 -> this.tableView.getItems().removeAll(arg_0));
        }
    }

    @FXML
    private void edit() {
        ba dialog = new ba((GameFile)this.tableView.getSelectionModel().getSelectedItem());
        Optional optional = dialog.showAndWait();
        optional.ifPresent(emulatorFile -> this.tableView.refresh());
    }

    @FXML
    private void openExplorer() {
        GameFile selectedItem = (GameFile)this.tableView.getSelectionModel().getSelectedItem();
        if (selectedItem.getDirectory() != null) {
            try {
                Desktop.getDesktop().open(new File(selectedItem.getDirectory()));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
    }

    @FXML
    private void copy() {
        this.tableView.getItems().add((Object)new GameFile((GameFile)this.tableView.getSelectionModel().getSelectedItem()));
    }
}

