/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.view.controller;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javax.persistence.EntityManager;
import org.romstation.application.aC;
import org.romstation.application.aN;
import org.romstation.application.b;
import org.romstation.application.database.entity.Genre;

public class GenresPaneController {
    private final ObservableList<Genre> a = FXCollections.observableList(new LinkedList());
    @FXML
    private MenuItem createMenuItem;
    @FXML
    private MenuItem selectMenuItem;
    @FXML
    private Button removeButton;
    @FXML
    private Button editButton;
    @FXML
    private ListView<Genre> listView;
    @FXML
    private ResourceBundle resources;

    public GenresPaneController() {
        EntityManager entityManager = b.c();
        this.a.setAll((Collection)entityManager.createNamedQuery("Genre.findAll", Genre.class).getResultList());
        this.a.sort(Comparator.comparing(genre -> genre.getName().getDefaultString()));
        entityManager.close();
    }

    public ListView<Genre> a() {
        return this.listView;
    }

    private List<Genre> b() {
        return this.a.stream().filter(language -> !this.listView.getItems().contains(language)).collect(Collectors.toList());
    }

    @FXML
    private void initialize() {
        this.selectMenuItem.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.listView.getItems()).isEqualTo((ObservableNumberValue)Bindings.size(this.a)));
        this.removeButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.listView.getSelectionModel().getSelectedItems()).isEqualTo(0));
        this.editButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.listView.getSelectionModel().getSelectedItems()).isNotEqualTo(1));
        this.listView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    @FXML
    private void create(ActionEvent event) {
        aN dialog = new aN(new Genre());
        Optional optional = dialog.showAndWait();
        optional.ifPresent(genre -> this.listView.getItems().add(genre));
    }

    @FXML
    private void select(ActionEvent event) {
        aC dialog = new aC(this.b());
        dialog.c().getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        Optional optional = dialog.showAndWait();
        optional.ifPresent(items -> this.listView.getItems().addAll((Collection)items));
    }

    @FXML
    private void edit(ActionEvent event) {
        aN dialog = new aN((Genre)this.listView.getSelectionModel().getSelectedItem());
        Optional optional = dialog.showAndWait();
        optional.ifPresent(genre -> this.listView.refresh());
    }

    @FXML
    private void remove(ActionEvent event) {
        this.listView.getItems().removeAll((Collection)this.listView.getSelectionModel().getSelectedItems());
    }
}

