/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.view.controller;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javax.persistence.EntityManager;
import org.romstation.application.aD;
import org.romstation.application.aO;
import org.romstation.application.b;
import org.romstation.application.database.entity.Language;

public class LanguagesPaneController {
    private final ObservableList<Language> a = FXCollections.observableList(new LinkedList());
    @FXML
    private MenuItem createMenuItem;
    @FXML
    private MenuItem selectMenuItem;
    @FXML
    private Button removeButton;
    @FXML
    private Button editButton;
    @FXML
    private ListView<Language> listView;
    @FXML
    private ResourceBundle resources;

    public LanguagesPaneController() {
        EntityManager entityManager = b.c();
        this.a.setAll((Collection)entityManager.createNamedQuery("Language.findAll", Language.class).getResultList());
        this.a.sort(Comparator.comparing(language -> language.getName().getDefaultString()));
        entityManager.close();
    }

    public ListView<Language> a() {
        return this.listView;
    }

    private List<Language> b() {
        return this.a.stream().filter(language -> !this.listView.getItems().contains(language)).collect(Collectors.toList());
    }

    @FXML
    private void initialize() {
        this.selectMenuItem.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.listView.getItems()).isEqualTo((ObservableNumberValue)Bindings.size(this.a)));
        this.removeButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.listView.getSelectionModel().getSelectedItems()).isEqualTo(0));
        this.editButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.listView.getSelectionModel().getSelectedItems()).isNotEqualTo(1));
        this.listView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    @FXML
    private void create(ActionEvent event) {
        aO dialog = new aO(new Language());
        Optional optional = dialog.showAndWait();
        optional.ifPresent(language -> this.listView.getItems().add(language));
    }

    @FXML
    private void select(ActionEvent event) {
        aD dialog = new aD(this.b());
        dialog.c().getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        Optional optional = dialog.showAndWait();
        optional.ifPresent(items -> this.listView.getItems().addAll((Collection)items));
    }

    @FXML
    private void edit(ActionEvent event) {
        aO dialog = new aO((Language)this.listView.getSelectionModel().getSelectedItem());
        Optional optional = dialog.showAndWait();
        optional.ifPresent(language -> this.listView.refresh());
    }

    @FXML
    private void remove(ActionEvent event) {
        this.listView.getItems().removeAll((Collection)this.listView.getSelectionModel().getSelectedItems());
    }
}

