/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.view.controller;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.Image;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.romstation.application.E;
import org.romstation.application.RomStation;
import org.romstation.application.ag;
import org.romstation.application.al;
import org.romstation.application.am;
import org.romstation.application.ap;
import org.romstation.application.bL;
import org.romstation.application.ce;
import org.romstation.application.cf;
import org.romstation.application.cg;
import org.romstation.application.ch;
import org.romstation.application.network.InvalidServerResponseException;
import org.romstation.application.network.NetworkOfflineException;
import org.romstation.application.network.ServerResponseException;
import org.romstation.application.network.a;
import org.romstation.application.network.b;
import org.romstation.application.network.c;
import org.romstation.application.network.d;
import org.romstation.application.network.f;
import org.romstation.application.task.y;
import org.romstation.application.view.control.ApplicationAlert;
import org.romstation.application.view.controller.ApplicationView;
import org.romstation.application.view.controller.browser.BrowserController;
import org.romstation.application.view.controller.database.DatabaseController;
import org.romstation.application.view.controller.emulators.EmulatorsController;
import org.romstation.application.view.controller.library.LibraryController;

public class RomStationController {
    public static final EventBus a = new EventBus(RomStationController.class.getName());
    private Stage b;
    private Scene c;
    private y d = new y(ag.a());
    @FXML
    private BorderPane root;
    @FXML
    private ToggleGroup viewToggleGroup;
    @FXML
    private ToggleButton browserToggleButton;
    @FXML
    private BrowserController browserController;
    @FXML
    private ToggleButton libraryToggleButton;
    @FXML
    private LibraryController libraryController;
    @FXML
    private ToggleButton emulatorsToggleButton;
    @FXML
    private EmulatorsController emulatorsController;
    @FXML
    private ToggleButton databaseToggleButton;
    @FXML
    private DatabaseController databaseController;
    @FXML
    private HBox offlinePane;
    @FXML
    private ResourceBundle resources;

    @FXML
    private void initialize() {
        a.register((Object)this);
        org.romstation.application.network.b.c().addListener((observableValue, oldValue, newValue) -> {
            switch (newValue) {
                case ONLINE: {
                    this.offlinePane.setVisible(false);
                    this.offlinePane.setManaged(false);
                    break;
                }
                case OFFLINE: {
                    this.offlinePane.setVisible(true);
                    this.offlinePane.setManaged(true);
                }
            }
        });
        this.viewToggleGroup.selectedToggleProperty().addListener((observableValue, previousValue, currentValue) -> {
            if (currentValue != null) {
                if (currentValue == this.browserToggleButton) {
                    a.post((Object)new cg(ApplicationView.BROWSER));
                } else if (currentValue == this.libraryToggleButton) {
                    a.post((Object)new cg(ApplicationView.LIBRARY));
                } else if (currentValue == this.emulatorsToggleButton) {
                    a.post((Object)new cg(ApplicationView.EMULATORS));
                } else if (currentValue == this.databaseToggleButton) {
                    a.post((Object)new cg(ApplicationView.DATABASE));
                }
            } else {
                this.viewToggleGroup.selectToggle(previousValue);
            }
        });
        this.a(ApplicationView.valueOf(RomStation.c().getProperty("application.startScreen")));
    }

    public void a(Stage stage) {
        this.b = stage;
        stage.setTitle(String.format("RomStation %s", "2.9.2"));
        stage.setWidth(Double.parseDouble(RomStation.c().getProperty("window.width")));
        stage.setHeight(Double.parseDouble(RomStation.c().getProperty("window.height")));
        stage.setMaximized(Boolean.parseBoolean(RomStation.c().getProperty("window.maximized")));
        stage.getIcons().add((Object)new Image(Paths.get("images/icons/romstation.png", new String[0]).toUri().toString()));
        stage.setOnCloseRequest(this::a);
        this.c = new Scene((Parent)this.root);
        this.c.getStylesheets().add((Object)RomStation.e());
        stage.setScene(this.c);
    }

    @FXML
    private void onSettingsAction(ActionEvent event) {
        bL dialog = new bL();
        dialog.showAndWait();
    }

    @FXML
    private void connect() {
        org.romstation.application.network.b.a(org.romstation.application.network.c.UNDEFINED);
        try {
            f builder = new f(org.romstation.application.network.b.b() + "/romstation/scripts/soft/start.php");
            builder.a().a("v", 229).a("os", E.c().a()).a("arch", E.d().a());
            a request = new a(builder.b());
            d response = request.b();
            if (response.b().get("version").getAsInt() > 229) {
                am dialog = new am();
                Optional result = dialog.showAndWait();
                if (result.isPresent() && ((ButtonType)result.get()).getButtonData() == ButtonBar.ButtonData.OK_DONE) {
                    ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                    switch (E.c()) {
                        case WINDOWS: {
                            processBuilder.command("Updater.exe", "--url=" + org.romstation.application.network.b.b() + response.b().get("manifest").getAsString(), "--build=229", "--target=" + response.b().get("version").getAsInt());
                            break;
                        }
                        case MAC_OS: {
                            processBuilder.command("open", "Updater.app", "--args", "--url=" + org.romstation.application.network.b.b() + response.b().get("manifest").getAsString(), "--build=229", "--target=" + response.b().get("version").getAsInt());
                        }
                    }
                    try {
                        processBuilder.start();
                        System.exit(1);
                    }
                    catch (IOException exception) {
                        RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
                        ap exceptionDialog = new ap(exception);
                        exceptionDialog.showAndWait();
                        org.romstation.application.network.b.a(org.romstation.application.network.c.OFFLINE);
                    }
                } else {
                    org.romstation.application.network.b.a(org.romstation.application.network.c.OFFLINE);
                }
            } else {
                this.d.c();
                if (this.d.a().b()) {
                    Thread thread = new Thread((Runnable)((Object)this.d));
                    thread.start();
                    org.romstation.application.network.b.a(org.romstation.application.network.c.ONLINE);
                } else {
                    al dialog = new al();
                    dialog.showAndWait();
                    org.romstation.application.network.b.a(org.romstation.application.network.c.OFFLINE);
                }
            }
        }
        catch (NetworkOfflineException exception) {
            RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
        }
        catch (MalformedURLException | InvalidServerResponseException | ServerResponseException exception) {
            RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
            al dialog = new al();
            dialog.showAndWait();
            org.romstation.application.network.b.a(org.romstation.application.network.c.OFFLINE);
        }
    }

    private void a(ApplicationView screen) {
        switch (screen) {
            case BROWSER: {
                this.viewToggleGroup.selectToggle((Toggle)this.browserToggleButton);
                break;
            }
            case LIBRARY: {
                this.viewToggleGroup.selectToggle((Toggle)this.libraryToggleButton);
                break;
            }
            case EMULATORS: {
                this.viewToggleGroup.selectToggle((Toggle)this.emulatorsToggleButton);
                break;
            }
            case DATABASE: {
                this.viewToggleGroup.selectToggle((Toggle)this.databaseToggleButton);
            }
        }
    }

    private void a(WindowEvent event) {
        if (Boolean.parseBoolean(RomStation.c().getProperty("application.confirmExit"))) {
            ApplicationAlert alert = new ApplicationAlert(Alert.AlertType.CONFIRMATION);
            alert.setHeaderText(this.resources.getString("application.close.alert.header"));
            alert.setContentText(this.resources.getString("application.close.alert.content"));
            Optional result = alert.showAndWait();
            if (result.isPresent() && result.get() != ButtonType.OK) {
                event.consume();
            }
        }
    }

    @Subscribe
    private void a(ce event) {
        this.connect();
    }

    @Subscribe
    private void a(ch event) {
        this.a(event.a());
    }

    @Subscribe
    private void a(cf event) {
        RomStation.c().setProperty("window.width", String.valueOf(this.b.getWidth()));
        RomStation.c().setProperty("window.height", String.valueOf(this.b.getHeight()));
        RomStation.c().setProperty("window.maximized", String.valueOf(this.b.isMaximized()));
        this.d.cancel(false);
    }
}

