/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.view.controller.database;

import com.google.common.eventbus.Subscribe;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Duration;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.romstation.application.aM;
import org.romstation.application.b;
import org.romstation.application.ce;
import org.romstation.application.cj;
import org.romstation.application.database.entity.Developer;
import org.romstation.application.view.control.ApplicationAlert;
import org.romstation.application.view.control.SearchField;
import org.romstation.application.view.controller.RomStationController;

public class DatabaseDevelopersViewController {
    private Timeline a;
    @FXML
    private Button addButton;
    @FXML
    private Button editButton;
    @FXML
    private Button deleteButton;
    @FXML
    private SearchField nameSearchField;
    @FXML
    private Label searchResultLabel;
    @FXML
    private TableView<Developer> tableView;
    @FXML
    private TableColumn<Developer, Integer> idTableColumn;
    @FXML
    private TableColumn<Developer, String> nameTableColumn;
    @FXML
    private TableColumn<Developer, Long> libraryReferencesTableColumn;
    @FXML
    private ResourceBundle resources;

    @FXML
    private void initialize() {
        RomStationController.a.register((Object)this);
        this.nameSearchField.textProperty().addListener((observable, oldValue, newValue) -> this.a.playFromStart());
        this.a = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)250.0), event -> this.a(), new KeyValue[0])});
        this.libraryReferencesTableColumn.setCellValueFactory(param -> {
            EntityManager entityManager = b.c();
            Long values = (Long)entityManager.createQuery("select count(game) from Game game where game.developer = :developer", Long.class).setParameter("developer", param.getValue()).getSingleResult();
            entityManager.close();
            return new ReadOnlyObjectWrapper((Object)values);
        });
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.editButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.tableView.getSelectionModel().getSelectedItems()).isNotEqualTo(1));
        this.deleteButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.tableView.getSelectionModel().getSelectedItems()).isEqualTo(0));
    }

    @Subscribe
    private void a(ce event) {
        this.a();
    }

    @Subscribe
    private void a(cj event) {
        this.a();
    }

    private void a() {
        EntityManager entityManager = b.c();
        TypedQuery query = this.nameSearchField.getText() == null || this.nameSearchField.getText().isEmpty() ? entityManager.createNamedQuery("Developer.findAll", Developer.class) : entityManager.createQuery("select developer from Developer developer where upper(developer.name) like concat('%',:name,'%')", Developer.class).setParameter("name", (Object)this.nameSearchField.getText().toUpperCase());
        this.tableView.getItems().setAll((Collection)query.getResultList());
        long max = (Long)entityManager.createNamedQuery("Developer.countAll", Long.class).getSingleResult();
        entityManager.close();
        this.searchResultLabel.setText(MessageFormat.format(this.resources.getString("database.developers.search.result"), this.tableView.getItems().size(), max));
    }

    @FXML
    private void add() {
        aM dialog = new aM(new Developer());
        Optional optional = dialog.showAndWait();
        optional.ifPresent(developer -> {
            EntityManager entityManager = b.c();
            entityManager.getTransaction().begin();
            entityManager.persist(developer);
            entityManager.getTransaction().commit();
            entityManager.close();
            RomStationController.a.post((Object)new cj());
        });
    }

    @FXML
    private void delete() {
        ApplicationAlert alert = new ApplicationAlert(this.resources.getString("developer.delete.confirmation.alert.header"), this.resources.getString("developer.delete.confirmation.alert.content"), Alert.AlertType.CONFIRMATION);
        Optional result = alert.showAndWait();
        if (result.isPresent() && result.get() == ButtonType.OK) {
            EntityManager entityManager = b.c();
            entityManager.getTransaction().begin();
            this.tableView.getSelectionModel().getSelectedItems().forEach(developer -> {
                Developer entity = (Developer)entityManager.merge(developer);
                entityManager.remove((Object)entity);
            });
            entityManager.getTransaction().commit();
            entityManager.close();
            RomStationController.a.post((Object)new cj());
        }
    }

    @FXML
    private void edit() {
        aM dialog = new aM((Developer)this.tableView.getSelectionModel().getSelectedItem());
        Optional optional = dialog.showAndWait();
        optional.ifPresent(developer -> {
            EntityManager entityManager = b.c();
            entityManager.getTransaction().begin();
            Developer entity = (Developer)entityManager.merge(developer);
            entityManager.persist((Object)entity);
            entityManager.getTransaction().commit();
            entityManager.close();
            RomStationController.a.post((Object)new cj());
        });
    }

    @FXML
    private void keyPressed(KeyEvent keyEvent) {
        if (!this.tableView.getSelectionModel().isEmpty() && keyEvent.getCode() == KeyCode.DELETE) {
            this.delete();
        }
    }
}

