/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.view.controller.emulators;

import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.util.Callback;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.JoinType;
import org.romstation.application.b;
import org.romstation.application.ci;
import org.romstation.application.cq;
import org.romstation.application.d;
import org.romstation.application.database.entity.Emulator;
import org.romstation.application.database.entity.System;
import org.romstation.application.e;
import org.romstation.application.f;
import org.romstation.application.g;
import org.romstation.application.h;
import org.romstation.application.i;
import org.romstation.application.j;
import org.romstation.application.k;
import org.romstation.application.q;
import org.romstation.application.r;
import org.romstation.application.s;
import org.romstation.application.t;
import org.romstation.application.view.control.cell.query.NamedFilterListCell;
import org.romstation.application.view.controller.RomStationController;
import org.romstation.application.x;

public class EmulatorsFiltersController {
    private final x a;
    private final NamedFilterListCell.Factory b;
    @FXML
    private ListView<d> systemsListView;
    @FXML
    private ListView<d> activeFiltersListView;
    @FXML
    private Button resetFiltersButton;
    @FXML
    private Button deleteFiltersButton;

    public EmulatorsFiltersController() {
        RomStationController.a.register((Object)this);
        this.a = new x(null, new h(new k("root", "name"), i.UPPER), q.MATCH, new g<String>(String.class));
        this.b = new NamedFilterListCell.Factory(Emulator.class);
    }

    @FXML
    private void initialize() {
        this.systemsListView.setCellFactory((Callback)this.b);
        this.activeFiltersListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.activeFiltersListView.setItems(this.b.b());
        this.activeFiltersListView.getItems().addListener(c2 -> {
            this.systemsListView.refresh();
            this.a();
        });
        this.resetFiltersButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.activeFiltersListView.getItems()).isEqualTo(0));
        this.deleteFiltersButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.activeFiltersListView.getSelectionModel().getSelectedItems()).isEqualTo(0));
    }

    private Optional<r> a(List<d> namedFilters) {
        List items = namedFilters.stream().filter(arg_0 -> this.activeFiltersListView.getItems().contains(arg_0)).map(d::g).collect(Collectors.toList());
        if (items.isEmpty()) {
            return Optional.empty();
        }
        r groupFilter = new r(s.OR);
        groupFilter.c().setAll(items);
        return Optional.of(groupFilter);
    }

    public void a() {
        r root = new r(s.AND);
        root.c().add((Object)this.a);
        this.a((List<d>)this.systemsListView.getItems()).ifPresent(groupFilter -> root.c().add(groupFilter));
        EntityManager entityManager = org.romstation.application.b.c();
        e<Emulator> queryBuilder = new e<Emulator>(Emulator.class);
        queryBuilder.a(root);
        f<Emulator> context = new f<Emulator>(queryBuilder, entityManager, Emulator.class);
        h queryExpression = new h(new k("root"), i.GET);
        TypedQuery<Emulator> typedQuery = queryBuilder.a(queryExpression, context, true);
        ObservableList emulators = FXCollections.observableList((List)typedQuery.getResultList());
        entityManager.close();
        RomStationController.a.post((Object)new cq((List<Emulator>)emulators));
    }

    public void a(String name) {
        this.a.c().a(name);
        this.a();
    }

    @FXML
    public void resetFilters(ActionEvent actionEvent) {
        this.activeFiltersListView.getItems().clear();
    }

    @FXML
    private void deleteFilters(ActionEvent actionEvent) {
        ObservableList selectedItems = this.activeFiltersListView.getSelectionModel().getSelectedItems();
        this.activeFiltersListView.getItems().removeAll(new ArrayList(selectedItems));
    }

    @Subscribe
    private void a(ci event) {
        this.b.a();
        this.b();
        this.a();
    }

    public void b() {
        this.systemsListView.getItems().setAll(this.c());
    }

    private List<d> c() {
        EntityManager entityManager = org.romstation.application.b.c();
        List entities = entityManager.createQuery("select distinct system from Emulator emulator join emulator.files file join file.profiles profile join profile.systems system order by system.name asc", System.class).getResultList();
        entityManager.close();
        return entities.stream().map(system -> {
            t<System> filter = new t<System>(null, new h(new k("profile", "systems"), i.GET), q.IS_MEMBER, new g<System>((System)system, System.class));
            filter.l().add(new j("file", new k("root", "files"), JoinType.LEFT));
            filter.l().add(new j("profile", new k("file", "profiles"), JoinType.LEFT));
            return new d(System.class + ":" + system.getId(), system.getName(), system.getGraphic(), filter);
        }).collect(Collectors.toList());
    }
}

