/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal;

import com.teamdev.jxbrowser.browser.internal.rpc.DoneTabbing;
import javafx.application.Platform;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

final class FocusTraversal {
    private static final String TRAVERSAL_EVENT_TEXT = "jxbrowser-traversal-event";

    private FocusTraversal() {
    }

    static void traverseFocus(Node node, DoneTabbing event) {
        Platform.runLater(() -> {
            boolean shiftDown = event.getReason() == DoneTabbing.Reason.DONE_TABBING_PREV;
            node.fireEvent((Event)FocusTraversal.tabEvent(node, (EventType<KeyEvent>)KeyEvent.KEY_PRESSED, shiftDown));
            node.fireEvent((Event)FocusTraversal.tabEvent(node, (EventType<KeyEvent>)KeyEvent.KEY_RELEASED, shiftDown));
        });
    }

    static boolean isTraversalEvent(KeyEvent event) {
        boolean isTraversalEvent = event.getText().equals(TRAVERSAL_EVENT_TEXT);
        boolean isTab = event.getCode() == KeyCode.TAB;
        return isTab && isTraversalEvent;
    }

    private static KeyEvent tabEvent(Node node, EventType<KeyEvent> eventType, boolean shiftDown) {
        return new KeyEvent(null, (EventTarget)node, eventType, "\t", TRAVERSAL_EVENT_TEXT, KeyCode.TAB, shiftDown, false, false, false);
    }
}

