/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.math.DoubleMath;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;

public final class HiDpi {
    private static final double EPSILON = 1.0E-5;
    private static final float MIN_DPI_THRESHOLD = 1.5f;

    public static boolean isPlatformDpiAware(double deviceScaleFactor) {
        if (Environment.isLinux()) {
            return false;
        }
        if (Environment.isMac()) {
            return true;
        }
        if (Environment.isWindows() && Environment.isJre8()) {
            return DoubleMath.fuzzyCompare((double)deviceScaleFactor, (double)HiDpi.minHiDpiThreshold(), (double)1.0E-5) >= 0;
        }
        return true;
    }

    private HiDpi() {
    }

    private static float minHiDpiThreshold() {
        Preconditions.checkState((Environment.isJre8() && Environment.isWindows() ? 1 : 0) != 0);
        String threshold = System.getProperty("glass.win.minHiDPI");
        if (threshold != null) {
            try {
                return Float.parseFloat(threshold);
            }
            catch (NumberFormatException ignored) {
                Logger.trace((String)"Couldn't read value of glass.win.minHiDPI.", (Object[])new Object[0]);
            }
        }
        return 1.5f;
    }
}

