/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.view.javafx.internal.BrowserNode;
import com.teamdev.jxbrowser.view.javafx.internal.ClosestParentTab;
import com.teamdev.jxbrowser.view.javafx.internal.window.NativeAwareWindow;
import javafx.scene.Node;

final class NodeVisibility {
    private final BrowserNode node;

    public static NodeVisibility newInstance(BrowserNode node) {
        Preconditions.checkNotNull((Object)node);
        return new NodeVisibility(node);
    }

    private NodeVisibility(BrowserNode node) {
        this.node = node;
    }

    boolean isNotVisible() {
        if (this.isWindowHidden()) {
            return true;
        }
        return !this.isVisibleOnScene();
    }

    boolean isVisibleOnScene() {
        if (this.isTreeInvisible()) {
            return false;
        }
        return !this.isInHiddenTab();
    }

    private boolean isWindowHidden() {
        NativeAwareWindow window = this.node.window();
        return window == null || !window.toolkitWindow().isShowing();
    }

    private boolean isTreeInvisible() {
        for (Node parent = this.node.asNode(); parent != null; parent = parent.getParent()) {
            if (parent.isVisible()) continue;
            return true;
        }
        return false;
    }

    private boolean isInHiddenTab() {
        return ClosestParentTab.ofNode(this.node.asNode()).map(t -> !t.isSelected()).orElse(false);
    }
}

