/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font.freetype;

import com.sun.javafx.font.CompositeFontResource;
import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.font.freetype.OSPango;
import com.sun.javafx.font.freetype.PangoGlyphString;
import com.sun.javafx.text.GlyphLayout;
import com.sun.javafx.text.TextRun;

class PangoGlyphLayout
extends GlyphLayout {
    private long str = 0L;

    PangoGlyphLayout() {
    }

    private int getSlot(PGFont font, PangoGlyphString glyphString) {
        CompositeFontResource fr = (CompositeFontResource)font.getFontResource();
        long fallbackFont = glyphString.font;
        long fallbackFd = OSPango.pango_font_describe(fallbackFont);
        String fallbackFamily = OSPango.pango_font_description_get_family(fallbackFd);
        int fallbackStyle = OSPango.pango_font_description_get_style(fallbackFd);
        int fallbackWeight = OSPango.pango_font_description_get_weight(fallbackFd);
        OSPango.pango_font_description_free(fallbackFd);
        boolean bold = fallbackWeight == 700;
        boolean italic = fallbackStyle != 0;
        PrismFontFactory prismFactory = PrismFontFactory.getFontFactory();
        PGFont fallbackPGFont = prismFactory.createFont(fallbackFamily, bold, italic, font.getSize());
        String fallbackFullname = fallbackPGFont.getFullName();
        String primaryFullname = fr.getSlotResource(0).getFullName();
        int slot = 0;
        if (!fallbackFullname.equalsIgnoreCase(primaryFullname)) {
            slot = fr.getSlotForFont(fallbackFullname);
            if (PrismFontFactory.debugFonts) {
                System.err.println("\tFallback font= " + fallbackFullname + " slot=" + (slot >> 24));
            }
        }
        return slot;
    }

    private boolean check(long checkValue, String message, long fontmap, long context, long desc, long attrList) {
        if (checkValue != 0L) {
            return false;
        }
        if (message != null && PrismFontFactory.debugFonts) {
            System.err.println(message);
        }
        if (attrList != 0L) {
            OSPango.pango_attr_list_unref(attrList);
        }
        if (desc != 0L) {
            OSPango.pango_font_description_free(desc);
        }
        if (context != 0L) {
            OSPango.g_object_unref(context);
        }
        if (fontmap != 0L) {
            OSPango.g_object_unref(fontmap);
        }
        return true;
    }

    @Override
    public void layout(TextRun run, PGFont font, FontStrike strike, char[] text) {
        long end;
        long start;
        long runs;
        boolean rtl;
        long fontmap;
        FontResource fr = font.getFontResource();
        boolean composite = fr instanceof CompositeFontResource;
        if (composite) {
            fr = ((CompositeFontResource)fr).getSlotResource(0);
        }
        if (this.check(fontmap = OSPango.pango_ft2_font_map_new(), "Failed allocating PangoFontMap.", 0L, 0L, 0L, 0L)) {
            return;
        }
        long context = OSPango.pango_font_map_create_context(fontmap);
        if (this.check(context, "Failed allocating PangoContext.", fontmap, 0L, 0L, 0L)) {
            return;
        }
        boolean bl = rtl = (run.getLevel() & 1) != 0;
        if (rtl) {
            OSPango.pango_context_set_base_dir(context, 1);
        }
        float size = font.getSize();
        int style = fr.isItalic() ? 2 : 0;
        int weight = fr.isBold() ? 700 : 400;
        long desc = OSPango.pango_font_description_new();
        if (this.check(desc, "Failed allocating FontDescription.", fontmap, context, 0L, 0L)) {
            return;
        }
        OSPango.pango_font_description_set_family(desc, fr.getFamilyName());
        OSPango.pango_font_description_set_absolute_size(desc, size * 1024.0f);
        OSPango.pango_font_description_set_stretch(desc, 4);
        OSPango.pango_font_description_set_style(desc, style);
        OSPango.pango_font_description_set_weight(desc, weight);
        long attrList = OSPango.pango_attr_list_new();
        if (this.check(attrList, "Failed allocating PangoAttributeList.", fontmap, context, desc, 0L)) {
            return;
        }
        long attr = OSPango.pango_attr_font_desc_new(desc);
        if (this.check(attr, "Failed allocating PangoAttribute.", fontmap, context, desc, attrList)) {
            return;
        }
        OSPango.pango_attr_list_insert(attrList, attr);
        if (!composite) {
            attr = OSPango.pango_attr_fallback_new(false);
            OSPango.pango_attr_list_insert(attrList, attr);
        }
        if (this.str == 0L) {
            this.str = OSPango.g_utf16_to_utf8(text);
            if (this.check(this.str, "Failed allocating UTF-8 buffer.", fontmap, context, desc, attrList)) {
                return;
            }
        }
        if ((runs = OSPango.pango_itemize(context, this.str, (int)((start = OSPango.g_utf8_offset_to_pointer(this.str, run.getStart())) - this.str), (int)((end = OSPango.g_utf8_offset_to_pointer(this.str, run.getEnd())) - start), attrList, 0L)) != 0L) {
            int runsCount = OSPango.g_list_length(runs);
            PangoGlyphString[] pangoGlyphs = new PangoGlyphString[runsCount];
            for (int i = 0; i < runsCount; ++i) {
                long pangoItem = OSPango.g_list_nth_data(runs, i);
                if (pangoItem == 0L) continue;
                pangoGlyphs[i] = OSPango.pango_shape(this.str, pangoItem);
                OSPango.pango_item_free(pangoItem);
            }
            OSPango.g_list_free(runs);
            int glyphCount = 0;
            for (PangoGlyphString g : pangoGlyphs) {
                if (g == null) continue;
                glyphCount += g.num_glyphs;
            }
            int[] glyphs = new int[glyphCount];
            float[] pos = new float[glyphCount * 2 + 2];
            int[] indices = new int[glyphCount];
            int gi = 0;
            int ci = rtl ? run.getLength() : 0;
            int width = 0;
            for (PangoGlyphString g : pangoGlyphs) {
                int slot;
                if (g == null) continue;
                int n = slot = composite ? this.getSlot(font, g) : 0;
                if (rtl) {
                    ci -= g.num_chars;
                }
                for (int i = 0; i < g.num_glyphs; ++i) {
                    int gg;
                    int gii = gi + i;
                    if (slot != -1 && 0 <= (gg = g.glyphs[i]) && gg <= 0xFFFFFF) {
                        glyphs[gii] = slot << 24 | gg;
                    }
                    if (size != 0.0f) {
                        pos[2 + (gii << 1)] = (float)(width += g.widths[i]) / 1024.0f;
                    }
                    indices[gii] = g.log_clusters[i] + ci;
                }
                if (!rtl) {
                    ci += g.num_chars;
                }
                gi += g.num_glyphs;
            }
            run.shape(glyphCount, glyphs, pos, indices);
        }
        this.check(0L, null, fontmap, context, desc, attrList);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.str != 0L) {
            OSPango.g_free(this.str);
            this.str = 0L;
        }
    }
}

