/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.dom;

import com.sun.webkit.Disposer;
import com.sun.webkit.DisposerRecord;
import com.sun.webkit.dom.CSSPrimitiveValueImpl;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.RGBColor;

public class RGBColorImpl
implements RGBColor {
    private final long peer;

    RGBColorImpl(long peer) {
        this.peer = peer;
        Disposer.addRecord(this, new SelfDisposer(peer));
    }

    static RGBColor create(long peer) {
        if (peer == 0L) {
            return null;
        }
        return new RGBColorImpl(peer);
    }

    long getPeer() {
        return this.peer;
    }

    public boolean equals(Object that) {
        return that instanceof RGBColorImpl && this.peer == ((RGBColorImpl)that).peer;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    static long getPeer(RGBColor arg) {
        return arg == null ? 0L : ((RGBColorImpl)arg).getPeer();
    }

    private static native void dispose(long var0);

    static RGBColor getImpl(long peer) {
        return RGBColorImpl.create(peer);
    }

    @Override
    public CSSPrimitiveValue getRed() {
        return CSSPrimitiveValueImpl.getImpl(RGBColorImpl.getRedImpl(this.getPeer()));
    }

    static native long getRedImpl(long var0);

    @Override
    public CSSPrimitiveValue getGreen() {
        return CSSPrimitiveValueImpl.getImpl(RGBColorImpl.getGreenImpl(this.getPeer()));
    }

    static native long getGreenImpl(long var0);

    @Override
    public CSSPrimitiveValue getBlue() {
        return CSSPrimitiveValueImpl.getImpl(RGBColorImpl.getBlueImpl(this.getPeer()));
    }

    static native long getBlueImpl(long var0);

    public CSSPrimitiveValue getAlpha() {
        return CSSPrimitiveValueImpl.getImpl(RGBColorImpl.getAlphaImpl(this.getPeer()));
    }

    static native long getAlphaImpl(long var0);

    private static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long peer) {
            this.peer = peer;
        }

        @Override
        public void dispose() {
            RGBColorImpl.dispose(this.peer);
        }
    }
}

