/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.ObservableList;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SelectionModel;

public abstract class MultipleSelectionModel<T>
extends SelectionModel<T> {
    private ObjectProperty<SelectionMode> selectionMode;

    public final void setSelectionMode(SelectionMode value) {
        this.selectionModeProperty().set(value);
    }

    public final SelectionMode getSelectionMode() {
        return this.selectionMode == null ? SelectionMode.SINGLE : (SelectionMode)((Object)this.selectionMode.get());
    }

    public final ObjectProperty<SelectionMode> selectionModeProperty() {
        if (this.selectionMode == null) {
            this.selectionMode = new ObjectPropertyBase<SelectionMode>(SelectionMode.SINGLE){

                @Override
                protected void invalidated() {
                    if (MultipleSelectionModel.this.getSelectionMode() == SelectionMode.SINGLE && !MultipleSelectionModel.this.isEmpty()) {
                        int lastIndex = MultipleSelectionModel.this.getSelectedIndex();
                        MultipleSelectionModel.this.clearSelection();
                        MultipleSelectionModel.this.select(lastIndex);
                    }
                }

                @Override
                public Object getBean() {
                    return MultipleSelectionModel.this;
                }

                @Override
                public String getName() {
                    return "selectionMode";
                }
            };
        }
        return this.selectionMode;
    }

    public abstract ObservableList<Integer> getSelectedIndices();

    public abstract ObservableList<T> getSelectedItems();

    public abstract void selectIndices(int var1, int ... var2);

    public void selectRange(int start, int end) {
        if (start == end) {
            return;
        }
        boolean asc = start < end;
        int low = asc ? start : end;
        int high = asc ? end : start;
        int arrayLength = high - low - 1;
        int[] indices = new int[arrayLength];
        int startValue = asc ? low : high;
        int firstVal = asc ? startValue++ : startValue--;
        for (int i = 0; i < arrayLength; ++i) {
            indices[i] = asc ? startValue++ : startValue--;
        }
        this.selectIndices(firstVal, indices);
    }

    public abstract void selectAll();

    @Override
    public abstract void selectFirst();

    @Override
    public abstract void selectLast();
}

