require 'zlib'
require 'json'
require 'tmpdir'
require 'fileutils'
require_relative 'gems/inifile-3.0.0/lib/inifile.rb'

def find_emulator_file(emulator_name)
  emulator_file = $romstation.database.emulator_file.query('SELECT * FROM EMULATOR_FILE JOIN EMULATOR_FILE_META meta ON EMULATOR_FILE.ID = meta.EMULATOR_FILE_ID WHERE meta.VALUE LIKE ?', emulator_name)
  emulator_file.any? ? emulator_file[0] : nil
end

def crc32(filename)
  data = IO.binread(filename)
  crc32 = Zlib.crc32(data)
  crc32.to_s(16)
end

def fix_dolphin_ini(dolphin_dir)
  ini = IniFile.load(File.join(dolphin_dir, "User/Config/Dolphin.ini"))
  if ini
    ini["Core"]["MemcardAPath"] = "User/GC/MemoryCardA.EUR.raw" if ini["Core"]["MemcardAPath"]&.end_with?("Emulation/GameCube/Dolphin/User/GC/MemoryCardA.EUR.raw")
    ini["Core"]["MemcardBPath"] = "User/GC/MemoryCardB.EUR.raw" if ini["Core"]["MemcardBPath"]&.end_with?("Emulation/GameCube/Dolphin/User/GC/MemoryCardB.EUR.raw")
    ini.save
  end
end

def copy_dolphin_memcards(dolphin_dir)
  ini = IniFile.load(File.join(dolphin_dir, "User/Config/Dolphin.ini"))
  if ini
    if ini["Core"]["MemcardAPath"]&.end_with?("Emulation/GameCube/Dolphin/User/GC/MemoryCardA.EUR.raw") && File.file?(ini["Core"]["MemcardAPath"])
      FileUtils.mv(ini["Core"]["MemcardAPath"], File.join(emulator_file.directory, "User/GC/MemoryCardA#2.EUR.raw"))
    end
    if ini["Core"]["MemcardBPath"]&.end_with?("Emulation/GameCube/Dolphin/User/GC/MemoryCardB.EUR.raw") && File.file?(ini["Core"]["MemcardBPath"])
      FileUtils.mv(ini["Core"]["MemcardBPath"], File.join(emulator_file.directory, "User/GC/MemoryCardB#2.EUR.raw"))
    end
  end
end

def fix_pSX_ini(psx_dir)
  ini = IniFile.load(File.join(psx_dir, "psx.ini"))
  if ini
    save = nil
    if ini["Cards"]["Card1"] == '..\ePSXe\memcards\epsxe000.mcr'
      ini["Cards"]["Card1"] = 'cards/card1.bin'
      save = true
    end
    if ini["Cards"]["Card2"] == '..\ePSXe\memcards\epsxe001.mcr'
      ini["Cards"]["Card2"] = 'cards/card2.bin'
      save = true
    end
    if save
      ini.delete_section("Language")
      ini.save
    end
  end
end

def copy_ePSXe_memcards(psx_dir, epsxe_dir)
  #copy card 1
  psx_card1_path = File.join(psx_dir, "cards/card1.bin")
  if !File.file?(psx_card1_path) || crc32(psx_card1_path) == "958c8a42"
    epsxe_card1_path = File.join(epsxe_dir, "memcards/epsxe000.mcr")
    FileUtils.cp(epsxe_card1_path, psx_card1_path) if File.file?(epsxe_card1_path)
  end
  #copy card 2
  psx_card2_path = File.join(psx_dir, "cards/card2.bin")
  if !File.file?(psx_card2_path) || crc32(psx_card2_path) == "db3c4147"
    epsxe_card2_path = File.join(epsxe_dir, "memcards/epsxe001.mcr")
    FileUtils.cp(epsxe_card2_path, psx_card2_path) if File.file?(epsxe_card2_path)
  end
end

def initialize
  @on_pre_persist = $romstation.database.emulator_file.on_pre_persist
  $romstation.database.emulator_file.on_pre_persist = -> (emulator_file) {
    if emulator_file.metas["legacy"]
      json = JSON.parse emulator_file.metas["legacy"]
      case json["name"]
      when "Dolphin"
        fix_dolphin_ini(emulator_file.directory)
      when "pSX"
        fix_pSX_ini emulator_file.directory
        epsxe_emulator_file = find_emulator_file "ePSXe"
        copy_ePSXe_memcards(emulator_file.directory, epsxe_emulator_file.directory) if epsxe_emulator_file
      when "ePSXe"
        psx_emulator_file = find_emulator_file "pSX"
        copy_ePSXe_memcards(psx_emulator_file.directory, emulator_file.directory) if psx_emulator_file
      end
    end

    @on_pre_persist&.call(emulator_file)
  }

  @on_init = $romstation.system.on_init
  $romstation.system.on_init = -> (process) {
    emulator_file = process.context.emulator_profile.emulator_file
    if emulator_file.metas["legacy"]
      json = JSON.parse emulator_file.metas["legacy"]
      case json["name"]
      when "Dolphin"
        copy_dolphin_memcards(emulator_file.directory)
        fix_dolphin_ini(emulator_file.directory)
      when "pSX"
        epsxe_emulator_file = find_emulator_file "ePSXe"
        copy_ePSXe_memcards(emulator_file.directory, epsxe_emulator_file.directory) if epsxe_emulator_file
      end
    end
    emulator_profile = process.context.emulator_profile
    if emulator_profile.metas["legacy"]
      emulator_dir = File.dirname(File.expand_path(emulator_profile.path))
      json = JSON.parse emulator_profile.metas["legacy"]
      json["commands"].each do |command|
        case command
        when /\/ef\((?<filename>[\w.]+),(?<line>\d+),(?<string>.+)\)/i
          filename = File.join(emulator_dir, $LAST_MATCH_INFO['filename'])
          lines = File.readlines(filename)
          lines[($LAST_MATCH_INFO['line'].to_i) - 1] = process.context.eval($LAST_MATCH_INFO['string'])
          File.open(filename, "w") {|file| file.puts lines }
        when /\/ecf\((?<filename>[\w.]+),(?<section>[\w.]+),(?<key>[\w.]+),(?<value>.+)\)/i
          filename = File.join(emulator_dir, $LAST_MATCH_INFO['filename'])
          ini = IniFile.load(filename)
          ini[$LAST_MATCH_INFO['section']][$LAST_MATCH_INFO['key']] = process.context.eval($LAST_MATCH_INFO['value'])
          ini.save
        end
      end
    end

    @on_init&.call(process)
  }

  @on_ready = $romstation.system.on_ready
  $romstation.system.on_ready = -> (process) {
    emulator_file = process.context.emulator_profile.emulator_file
    if emulator_file.emulator.name.downcase == "no$gba" && emulator_file.metas["legacy"]
      process.parameters = process.parameters.gsub('/', '\\') if process.parameters
    end

    @on_ready&.call(process)
  }

  $romstation.system.set_property("game", -> (ctx) {
    "${game.profile.path}"
  })

  $romstation.system.set_property("gamepath", -> (ctx) {
    File.dirname(ctx.eval("${game}")) if ctx.game_profile
  })

  $romstation.system.set_property("currentdirectory", -> (ctx) {
    Dir.pwd
  })

  $romstation.system.set_property("homedirectory", -> (ctx) {
    Dir.home
  })

  $romstation.system.set_property("temporarydirectory", -> (ctx) {
    Dir.tmpdir
  })
end