def initialize
    $romstation.system.set_property("emulator.directory", -> (ctx) {
        File.expand_path ctx.emulator_profile.emulator_file.emulator.directory
    })

    $romstation.system.set_property("emulator.file.directory", -> (ctx) {
        File.expand_path ctx.emulator_profile.emulator_file.directory
    })

    $romstation.system.set_property("game.file.directory", -> (ctx) {
        File.expand_path ctx.game_profile.game_file.directory if ctx.game_profile
    })

    @game_profile_path = $romstation.system.get_property "game.profile.path"
    $romstation.system.set_property("game.profile.path", -> (ctx) {
        @game_profile_path&.call(ctx)

        return File.expand_path ctx.game_profile.path if ctx.game_profile
    })

    @game_profile_path_parent = $romstation.system.get_property "game.profile.path.parent"
    $romstation.system.set_property("game.profile.path.parent", -> (ctx) {
        @game_profile_path_parent&.call(ctx)

        return File.dirname ctx.game_profile.path if ctx.game_profile
    })

    $romstation.system.set_property("game.profile.parameters", -> (ctx) {
        ctx.game_profile.parameters if ctx.game_profile
    })
end