class Archive

    attr_accessor :id, :source, :output_dir, :output_path, :timestamp

    def initialize(id, source, output_dir, output_path = nil, timestamp = Time.now.to_i)
        @id = id
        @source = source
        @output_dir = output_dir
        @output_path = output_path
        @timestamp = timestamp
    end

    def update_timestamp()
        @timestamp = Time.now.to_i
    end

    def output_full_path()
        File.join(@output_dir, @output_path)
    end

    def to_json(*a)
        {
            :id => @id, :source => @source, :output_dir => @output_dir, :output_path => @output_path, :timestamp => @timestamp
        }.to_json(*a)
    end

end