CREATE TABLE I18N(ID INT PRIMARY KEY NOT NULL)
CREATE TABLE IMAGE(ID INT PRIMARY KEY NOT NULL, PATH VARCHAR(255))
CREATE TABLE LOCALE(ID INT PRIMARY KEY NOT NULL, TAG VARCHAR(5), GRAPHIC_IMAGE_ID INT, NAME_I18N_ID INT, CONSTRAINT FKOP2XHB6FX6J8SOWPRF9M8SLVO FOREIGN KEY (GRAPHIC_IMAGE_ID) REFERENCES IMAGE (ID) ON DELETE SET NULL, CONSTRAINT FKCEKNK8GU17CUCO5E681G3GPMA FOREIGN KEY (NAME_I18N_ID) REFERENCES I18N (ID) ON DELETE SET NULL)
CREATE TABLE "TRANSLATION"(ID INT PRIMARY KEY NOT NULL, STRING VARCHAR(32672), I18N_ID INT, LOCALE_ID INT, CONSTRAINT FKGVLJI0HBHHSJBUM3R4XIBXJJX FOREIGN KEY (I18N_ID) REFERENCES I18N (ID) ON DELETE CASCADE, CONSTRAINT FK8G5NJULXV7ONYR23N37P6X1VD FOREIGN KEY (LOCALE_ID) REFERENCES LOCALE (ID) ON DELETE CASCADE, CONSTRAINT UKG1TOHF66KKK4PKLKRD440B7R3 UNIQUE (LOCALE_ID, I18N_ID))
CREATE TABLE SCRIPT(ID INT PRIMARY KEY NOT NULL, PATH VARCHAR(255))
CREATE TABLE SYSTEM(ID INT PRIMARY KEY NOT NULL, NAME VARCHAR(255), RID INT, GRAPHIC_IMAGE_ID INT, CONSTRAINT FKEQO0CWRH2ISPWS8XIVFMQTX5R FOREIGN KEY (GRAPHIC_IMAGE_ID) REFERENCES IMAGE (ID) ON DELETE SET NULL)
CREATE TABLE GENRE(ID INT PRIMARY KEY NOT NULL, RID INT, GRAPHIC_IMAGE_ID INT, NAME_I18N_ID INT, CONSTRAINT FKP5T95D439RD4T748H5ERLFSHX FOREIGN KEY (GRAPHIC_IMAGE_ID) REFERENCES IMAGE (ID) ON DELETE SET NULL, CONSTRAINT FK25KHT6N6F8CJOAUW8Y3I6OMND FOREIGN KEY (NAME_I18N_ID) REFERENCES I18N (ID) ON DELETE SET NULL)
CREATE TABLE LANGUAGE(ID INT PRIMARY KEY NOT NULL, RID INT, GRAPHIC_IMAGE_ID INT, NAME_I18N_ID INT, CONSTRAINT FKC89247DL61V0E2JJ0CD8TEQ7U FOREIGN KEY (GRAPHIC_IMAGE_ID) REFERENCES IMAGE (ID) ON DELETE SET NULL, CONSTRAINT FK9TGKN7AJVYFJ5T43UEVRXUH72 FOREIGN KEY (NAME_I18N_ID) REFERENCES I18N (ID) ON DELETE SET NULL)
CREATE TABLE PUBLISHER(ID INT PRIMARY KEY NOT NULL, NAME VARCHAR(255), RID INT)
CREATE TABLE SERIES(ID INT PRIMARY KEY NOT NULL, NAME VARCHAR(255), RID INT)
CREATE TABLE TAG(ID INT PRIMARY KEY NOT NULL, RID INT, GRAPHIC_IMAGE_ID INT, NAME_I18N_ID INT, CONSTRAINT FKAGEMCOY8E7Y5EJ6NAWDUOSAOX FOREIGN KEY (GRAPHIC_IMAGE_ID) REFERENCES IMAGE (ID) ON DELETE SET NULL, CONSTRAINT FKC4P7P3NCI8E0NJ0193DAD29CE FOREIGN KEY (NAME_I18N_ID) REFERENCES I18N (ID) ON DELETE SET NULL)
CREATE TABLE LINK(ID INT PRIMARY KEY NOT NULL, NAME VARCHAR(255), LOCATION VARCHAR(255), "EXTERNAL" BOOLEAN NOT NULL DEFAULT FALSE)
CREATE TABLE DEVELOPER(ID INT PRIMARY KEY NOT NULL, NAME VARCHAR(255), RID INT)
CREATE TABLE EMULATOR(ID INT PRIMARY KEY NOT NULL, NAME VARCHAR(255), RID INT, GRAPHIC_IMAGE_ID INT, DIRECTORY VARCHAR(255), MANAGED BOOLEAN NOT NULL DEFAULT FALSE, CONSTRAINT FKFAHLGNP6AMYTALSJ6CBHSU00B FOREIGN KEY (GRAPHIC_IMAGE_ID) REFERENCES IMAGE (ID) ON DELETE SET NULL)
CREATE TABLE EMULATOR_META(EMULATOR_ID INT NOT NULL, "KEY" VARCHAR(255), VALUE VARCHAR(32672), CONSTRAINT FKB89Q6JDWOM2OV5E6F4P0IC9DF FOREIGN KEY (EMULATOR_ID) REFERENCES EMULATOR (ID) ON DELETE CASCADE)
CREATE TABLE EMULATOR_FILE(ID INT PRIMARY KEY NOT NULL, NAME VARCHAR(255), DIRECTORY VARCHAR(255), RID INT, EMULATOR_ID INT, MANAGED BOOLEAN NOT NULL DEFAULT FALSE, CONSTRAINT FKMJF1QWTQ2QA767PBGXRQWTUGI FOREIGN KEY (EMULATOR_ID) REFERENCES EMULATOR (ID) ON DELETE CASCADE)
CREATE TABLE EMULATOR_FILE_META(EMULATOR_FILE_ID INT NOT NULL, "KEY" VARCHAR(255), VALUE VARCHAR(32672), CONSTRAINT FK1QIUR7W64N58MT1UC5C2DUBPW FOREIGN KEY (EMULATOR_FILE_ID) REFERENCES EMULATOR_FILE (ID) ON DELETE CASCADE)
CREATE TABLE EMULATOR_FILE_SCRIPT(EMULATOR_FILE_ID INT NOT NULL, SCRIPT_ID INT NOT NULL, CONSTRAINT FK6L4LFQ35HXHKLAARM98PQE74Y FOREIGN KEY (EMULATOR_FILE_ID) REFERENCES EMULATOR_FILE (ID) ON DELETE CASCADE, CONSTRAINT FKS03JLI3K3IV3ND4QO9H4M0HNB FOREIGN KEY (SCRIPT_ID) REFERENCES SCRIPT (ID) ON DELETE CASCADE)
CREATE TABLE EMULATOR_PROFILE(ID INT PRIMARY KEY NOT NULL, NAME VARCHAR(255), PARAMETERS VARCHAR(255), PATH VARCHAR(255), WORKING_DIRECTORY VARCHAR(255), EMULATOR_FILE_ID INT, CONSTRAINT FKPF3OFOJKRK8JP6TE9B02UOCLF FOREIGN KEY (EMULATOR_FILE_ID) REFERENCES EMULATOR_FILE (ID) ON DELETE CASCADE)
CREATE TABLE EMULATOR_PROFILE_META(EMULATOR_PROFILE_ID INT NOT NULL, "KEY" VARCHAR(255), VALUE VARCHAR(32672), CONSTRAINT FKCCUWIVYS84FCJ31H2XDLNB7GO FOREIGN KEY (EMULATOR_PROFILE_ID) REFERENCES EMULATOR_PROFILE (ID) ON DELETE CASCADE)
CREATE TABLE EMULATOR_PROFILE_SCRIPT(EMULATOR_PROFILE_ID INT NOT NULL, SCRIPT_ID INT NOT NULL, CONSTRAINT FK5MB68OH02J7C6CK72IMR6K8GT FOREIGN KEY (EMULATOR_PROFILE_ID) REFERENCES EMULATOR_PROFILE (ID) ON DELETE CASCADE, CONSTRAINT FK95CQRWX3LA0HFV57K1R3S1XIG FOREIGN KEY (SCRIPT_ID) REFERENCES SCRIPT (ID) ON DELETE CASCADE)
CREATE TABLE EMULATOR_PROFILE_SYSTEM(EMULATOR_PROFILE_ID INT NOT NULL, SYSTEM_ID INT NOT NULL, CONSTRAINT FK9241OHHH6LGMKEXK44C4MLV78 FOREIGN KEY (EMULATOR_PROFILE_ID) REFERENCES EMULATOR_PROFILE (ID) ON DELETE CASCADE, CONSTRAINT FK5E4D3M5PBR07AQP17I1C5CWIS FOREIGN KEY (SYSTEM_ID) REFERENCES SYSTEM (ID) ON DELETE CASCADE)
CREATE TABLE EMULATOR_SCRIPT(EMULATOR_ID INT NOT NULL, SCRIPT_ID INT NOT NULL, CONSTRAINT FKRTU8A1H7TN9IW16SJED3T86K7 FOREIGN KEY (EMULATOR_ID) REFERENCES EMULATOR (ID) ON DELETE CASCADE, CONSTRAINT FK9YN21F29OFLTPT9JF2C6YUFEV FOREIGN KEY (SCRIPT_ID) REFERENCES SCRIPT (ID) ON DELETE CASCADE)
CREATE TABLE EMULATOR_LINK(EMULATOR_ID INT NOT NULL, LINK_ID INT NOT NULL, CONSTRAINT FKNTU8A1C7TN9IX11SJED3T86K7 FOREIGN KEY (EMULATOR_ID) REFERENCES EMULATOR (ID) ON DELETE CASCADE, CONSTRAINT FKTYN2QF29OFLTPT7JS2C0YUFEV FOREIGN KEY (LINK_ID) REFERENCES LINK (ID) ON DELETE CASCADE)
CREATE TABLE GAME(ID INT PRIMARY KEY NOT NULL, LAST_USE BIGINT, PLAYED BIGINT, PLAYERS INT, TITLE VARCHAR(255), RID INT, "YEAR" INT, GRAPHIC_IMAGE_ID INT, DESCRIPTION_I18N_ID INT, DEVELOPER_ID INT, PUBLISHER_ID INT, DIRECTORY VARCHAR(255), SYSTEM_ID INT, MANAGED BOOLEAN NOT NULL DEFAULT FALSE, CONSTRAINT FK78O2CAGW5QXEFDW8F2KPF4Y7F FOREIGN KEY (GRAPHIC_IMAGE_ID) REFERENCES IMAGE (ID) ON DELETE SET NULL, CONSTRAINT FKD0X4956LH7Y87Q3DU692PJJWD FOREIGN KEY (DESCRIPTION_I18N_ID) REFERENCES I18N (ID) ON DELETE SET NULL, CONSTRAINT FKPI5UOKAQP8TXRL4WAMM1Y936C FOREIGN KEY (DEVELOPER_ID) REFERENCES DEVELOPER (ID) ON DELETE SET NULL, CONSTRAINT FKM0EIMJM36ENUQ1TTUYIJKIOAE FOREIGN KEY (PUBLISHER_ID) REFERENCES PUBLISHER (ID) ON DELETE SET NULL, CONSTRAINT FKM9CCU0JQ532D6GY6SBWIELV8F FOREIGN KEY (SYSTEM_ID) REFERENCES SYSTEM (ID) ON DELETE SET NULL)
CREATE TABLE GAME_GENRE(GAME_ID INT NOT NULL, GENRE_ID INT NOT NULL, CONSTRAINT FK3QIFVO99P4SBQIBYGATO2DO8A FOREIGN KEY (GAME_ID) REFERENCES GAME (ID) ON DELETE CASCADE, CONSTRAINT FK8G0NTVGXARMH2Q4TO3A7K3DQO FOREIGN KEY (GENRE_ID) REFERENCES GENRE (ID) ON DELETE CASCADE)
CREATE TABLE GAME_LANGUAGE(GAME_ID INT NOT NULL, LANGUAGE_ID INT NOT NULL, CONSTRAINT FKTC9D6IBL85TLYSH0RYEDJVX4I FOREIGN KEY (GAME_ID) REFERENCES GAME (ID) ON DELETE CASCADE, CONSTRAINT FK7N0NWL2QJXGY9YPJHMWKPKY32 FOREIGN KEY (LANGUAGE_ID) REFERENCES LANGUAGE (ID) ON DELETE CASCADE)
CREATE TABLE GAME_META(GAME_ID INT NOT NULL, "KEY" VARCHAR(255), VALUE VARCHAR(32672), CONSTRAINT FKNYJHSVOIACVMOIC0P41PKW7HF FOREIGN KEY (GAME_ID) REFERENCES GAME (ID) ON DELETE CASCADE)
CREATE TABLE GAME_FILE(ID INT PRIMARY KEY NOT NULL, NAME VARCHAR(255), DIRECTORY VARCHAR(255), RID INT, GAME_ID INT, MANAGED BOOLEAN NOT NULL DEFAULT FALSE, CONSTRAINT FKMJF1QWTQ2QA767UBGXRQWTUGV FOREIGN KEY (GAME_ID) REFERENCES GAME (ID) ON DELETE CASCADE)
CREATE TABLE GAME_FILE_META(GAME_FILE_ID INT NOT NULL, "KEY" VARCHAR(255), VALUE VARCHAR(32672), CONSTRAINT FK1QIUR7D64N58MT1UC5C2DUBPE FOREIGN KEY (GAME_FILE_ID) REFERENCES GAME_FILE (ID) ON DELETE CASCADE)
CREATE TABLE GAME_FILE_SCRIPT(GAME_FILE_ID INT NOT NULL, SCRIPT_ID INT NOT NULL, CONSTRAINT FK6L4LFQ35HXHKLAARM98PQE70Y FOREIGN KEY (GAME_FILE_ID) REFERENCES GAME_FILE (ID) ON DELETE CASCADE, CONSTRAINT FKS03JLI3K3IV3ND4QO9H4M0TNB FOREIGN KEY (SCRIPT_ID) REFERENCES SCRIPT (ID) ON DELETE CASCADE)
CREATE TABLE GAME_PROFILE(ID INT PRIMARY KEY NOT NULL, NAME VARCHAR(255), PARAMETERS VARCHAR(255), PATH VARCHAR(255), EMULATOR_PROFILE_ID INT, GAME_FILE_ID INT, CONSTRAINT FKVGAO8YVT012IUXPV8FUR4TD3P FOREIGN KEY (EMULATOR_PROFILE_ID) REFERENCES EMULATOR_PROFILE (ID) ON DELETE SET NULL, CONSTRAINT FEMJF1QWTQ2QA767DBGXRQWTUGV FOREIGN KEY (GAME_FILE_ID) REFERENCES GAME_FILE (ID) ON DELETE CASCADE)
CREATE TABLE GAME_PROFILE_META(GAME_PROFILE_ID INT NOT NULL, "KEY" VARCHAR(255), VALUE VARCHAR(32672), CONSTRAINT FK8QIUR7D64N53MT1UC5C2DUBPE FOREIGN KEY (GAME_PROFILE_ID) REFERENCES GAME_PROFILE (ID) ON DELETE CASCADE)
CREATE TABLE GAME_PROFILE_SCRIPT(GAME_PROFILE_ID INT NOT NULL, SCRIPT_ID INT NOT NULL, CONSTRAINT FK3L4LFQ34HXHKLAARM88PQE70Y FOREIGN KEY (GAME_PROFILE_ID) REFERENCES GAME_PROFILE (ID) ON DELETE CASCADE, CONSTRAINT FKT03JLK3K3IV3ND4MO9H4M0TNB FOREIGN KEY (SCRIPT_ID) REFERENCES SCRIPT (ID) ON DELETE CASCADE)
CREATE TABLE GAME_SCRIPT(GAME_ID INT NOT NULL, SCRIPT_ID INT NOT NULL, CONSTRAINT FK5UOOBVETIL69WEYKL78SU1F5C FOREIGN KEY (GAME_ID) REFERENCES GAME (ID) ON DELETE CASCADE, CONSTRAINT FKSB1J98XDA7KAS00ELY3OB66DN FOREIGN KEY (SCRIPT_ID) REFERENCES SCRIPT (ID) ON DELETE CASCADE)
CREATE TABLE GAME_SERIES(GAME_ID INT NOT NULL, SERIES_ID INT NOT NULL, CONSTRAINT FKMK59Y378WDMMI846SWNL2SMUN FOREIGN KEY (GAME_ID) REFERENCES GAME (ID) ON DELETE CASCADE, CONSTRAINT FKITEPOMDB0J06LW3BG0WSLA3ME FOREIGN KEY (SERIES_ID) REFERENCES SERIES (ID) ON DELETE CASCADE)
CREATE TABLE GAME_TAG(GAME_ID INT NOT NULL, TAG_ID INT NOT NULL, CONSTRAINT FK9OIDOXE1A9G6EMXSK2536C7PT FOREIGN KEY (GAME_ID) REFERENCES GAME (ID) ON DELETE CASCADE, CONSTRAINT FKIJF9ESITIX10SWJ72SQ6XUD8F FOREIGN KEY (TAG_ID) REFERENCES TAG (ID) ON DELETE CASCADE)
CREATE TABLE GAME_LINK(GAME_ID INT NOT NULL, LINK_ID INT NOT NULL, CONSTRAINT FKWGU8Y1C7TN9IX11SJED3T86K7 FOREIGN KEY (GAME_ID) REFERENCES GAME (ID) ON DELETE CASCADE, CONSTRAINT FKBKN2LF24OFLTPT7JS2C0YUFEV FOREIGN KEY (LINK_ID) REFERENCES LINK (ID) ON DELETE CASCADE)

CREATE SEQUENCE EMULATOR_SEQUENCE INCREMENT BY 1 START WITH 20
CREATE SEQUENCE EMULATOR_FILE_SEQUENCE INCREMENT BY 1 START WITH 20
CREATE SEQUENCE EMULATOR_PROFILE_SEQUENCE INCREMENT BY 1 START WITH 75
CREATE SEQUENCE GAME_SEQUENCE INCREMENT BY 1 START WITH 1
CREATE SEQUENCE GAME_FILE_SEQUENCE INCREMENT BY 1 START WITH 1
CREATE SEQUENCE GAME_PROFILE_SEQUENCE INCREMENT BY 1 START WITH 1
CREATE SEQUENCE GENRE_SEQUENCE INCREMENT BY 1 START WITH 1
CREATE SEQUENCE I18N_SEQUENCE INCREMENT BY 1 START WITH 5
CREATE SEQUENCE LANGUAGE_SEQUENCE INCREMENT BY 1 START WITH 1
CREATE SEQUENCE LOCALE_SEQUENCE INCREMENT BY 1 START WITH 5
CREATE SEQUENCE DEVELOPER_SEQUENCE INCREMENT BY 1 START WITH 1
CREATE SEQUENCE PUBLISHER_SEQUENCE INCREMENT BY 1 START WITH 1
CREATE SEQUENCE IMAGE_SEQUENCE INCREMENT BY 1 START WITH 50
CREATE SEQUENCE SCRIPT_SEQUENCE INCREMENT BY 1 START WITH 1
CREATE SEQUENCE SERIES_SEQUENCE INCREMENT BY 1 START WITH 1
CREATE SEQUENCE SYSTEM_SEQUENCE INCREMENT BY 1 START WITH 50
CREATE SEQUENCE TAG_SEQUENCE INCREMENT BY 1 START WITH 1
CREATE SEQUENCE TRANSLATION_SEQUENCE INCREMENT BY 1 START WITH 10
CREATE SEQUENCE LINK_SEQUENCE INCREMENT BY 1 START WITH 10