/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import xeij.M68kException;
import xeij.MC68000;
import xeij.MainMemory;
import xeij.XEiJ;

enum IRBEnum {
    Bitrev{

        @Override
        public int bench(boolean bl) throws M68kException {
            int n = 0;
            XEiJ.regOC = 192;
            for (int i = 0; i < 100000000; ++i) {
                XEiJ.regRn[0] = i << i | i >>> -i;
                XEiJ.regCCR = 0x1F & i;
                if (bl) {
                    MC68000.irpCmp2Chk2Byte();
                }
                n = n * 3 + XEiJ.regRn[0];
                n = n * 3 + XEiJ.regCCR;
            }
            return n;
        }
    }
    ,
    Byterev{

        @Override
        public int bench(boolean bl) throws M68kException {
            int n = 0;
            XEiJ.regOC = 704;
            for (int i = 0; i < 100000000; ++i) {
                XEiJ.regRn[0] = i << i | i >>> -i;
                XEiJ.regCCR = 0x1F & i;
                if (bl) {
                    MC68000.irpCmp2Chk2Word();
                }
                n = n * 3 + XEiJ.regRn[0];
                n = n * 3 + XEiJ.regCCR;
            }
            return n;
        }
    }
    ,
    BtstReg{

        @Override
        public int bench(boolean bl) throws M68kException {
            int n = 0;
            XEiJ.regOC = 768;
            for (int i = 0; i < 100000000; ++i) {
                XEiJ.regRn[0] = i << i | i >>> -i;
                XEiJ.regRn[1] = i << -i | i >>> i;
                XEiJ.regCCR = 0x1F & i;
                if (bl) {
                    MC68000.irpBtstReg();
                }
                n = n * 3 + XEiJ.regCCR;
            }
            return n;
        }
    }
    ,
    MoveToDRWord{

        @Override
        public int bench(boolean bl) throws M68kException {
            int n;
            int n2 = 0;
            XEiJ.regOC = 12289;
            for (n = 0; n < 50000000; ++n) {
                XEiJ.regRn[0] = n << n | n >>> -n;
                XEiJ.regRn[1] = n << -n | n >>> n;
                XEiJ.regCCR = 0x1F & n;
                if (bl) {
                    MC68000.irpMoveToDRWord();
                }
                n2 = n2 * 3 + XEiJ.regRn[0];
                n2 = n2 * 3 + XEiJ.regCCR;
            }
            XEiJ.regOC = 12304;
            XEiJ.regRn[8] = 0x200000;
            for (n = 0; n < 50000000; ++n) {
                XEiJ.regRn[0] = n << n | n >>> -n;
                int n3 = n << -n | n >>> n;
                MainMemory.mmrM8[0x200000] = (byte)(n3 >> 8);
                MainMemory.mmrM8[0x200001] = (byte)n3;
                XEiJ.regCCR = 0x1F & n;
                if (bl) {
                    MC68000.irpMoveToDRWord();
                }
                n2 = n2 * 3 + XEiJ.regRn[0];
                n2 = n2 * 3 + XEiJ.regCCR;
            }
            return n2;
        }
    }
    ,
    TstByte{

        @Override
        public int bench(boolean bl) throws M68kException {
            int n = 0;
            XEiJ.regOC = 18944;
            for (int i = 0; i < 100000000; ++i) {
                XEiJ.regRn[0] = i << i | i >>> -i;
                XEiJ.regCCR = 0x1F & i;
                if (bl) {
                    MC68000.irpTstByte();
                }
                n = n * 3 + XEiJ.regCCR;
            }
            return n;
        }
    }
    ,
    TstLong{

        @Override
        public int bench(boolean bl) throws M68kException {
            int n = 0;
            XEiJ.regOC = 19072;
            for (int i = 0; i < 100000000; ++i) {
                XEiJ.regRn[0] = i << i | i >>> -i;
                XEiJ.regCCR = 0x1F & i;
                if (bl) {
                    MC68000.irpTstLong();
                }
                n = n * 3 + XEiJ.regCCR;
            }
            return n;
        }
    }
    ,
    SubToRegByte{

        @Override
        public int bench(boolean bl) throws M68kException {
            int n = 0;
            XEiJ.regOC = 36865;
            XEiJ.regRn[0] = 0;
            for (int i = 0; i < 100000000; ++i) {
                XEiJ.regRn[1] = i << i | i >>> -i;
                XEiJ.regCCR = 0x1F & i;
                if (bl) {
                    MC68000.irpSubToRegByte();
                }
                n = n * 3 + XEiJ.regRn[0];
                n = n * 3 + XEiJ.regCCR;
            }
            return n;
        }
    }
    ,
    SubToRegWord{

        @Override
        public int bench(boolean bl) throws M68kException {
            int n = 0;
            XEiJ.regOC = 36929;
            XEiJ.regRn[0] = 0;
            for (int i = 0; i < 100000000; ++i) {
                XEiJ.regRn[1] = i << i | i >>> -i;
                XEiJ.regCCR = 0x1F & i;
                if (bl) {
                    MC68000.irpSubToRegWord();
                }
                n = n * 3 + XEiJ.regRn[0];
                n = n * 3 + XEiJ.regCCR;
            }
            return n;
        }
    }
    ,
    SubToRegLong{

        @Override
        public int bench(boolean bl) throws M68kException {
            int n = 0;
            XEiJ.regOC = 36993;
            XEiJ.regRn[0] = 0;
            for (int i = 0; i < 100000000; ++i) {
                XEiJ.regRn[1] = i << i | i >>> -i;
                XEiJ.regCCR = 0x1F & i;
                if (bl) {
                    MC68000.irpSubToRegLong();
                }
                n = n * 3 + XEiJ.regRn[0];
                n = n * 3 + XEiJ.regCCR;
            }
            return n;
        }
    }
    ,
    AddToRegByte{

        @Override
        public int bench(boolean bl) throws M68kException {
            int n = 0;
            XEiJ.regOC = 53249;
            XEiJ.regRn[0] = 0;
            for (int i = 0; i < 100000000; ++i) {
                XEiJ.regRn[1] = i << i | i >>> -i;
                XEiJ.regCCR = 0x1F & i;
                if (bl) {
                    MC68000.irpAddToRegByte();
                }
                n = n * 3 + XEiJ.regRn[0];
                n = n * 3 + XEiJ.regCCR;
            }
            return n;
        }
    }
    ,
    AddToRegWord{

        @Override
        public int bench(boolean bl) throws M68kException {
            int n = 0;
            XEiJ.regOC = 53313;
            XEiJ.regRn[0] = 0;
            for (int i = 0; i < 100000000; ++i) {
                XEiJ.regRn[1] = i << i | i >>> -i;
                XEiJ.regCCR = 0x1F & i;
                if (bl) {
                    MC68000.irpAddToRegWord();
                }
                n = n * 3 + XEiJ.regRn[0];
                n = n * 3 + XEiJ.regCCR;
            }
            return n;
        }
    }
    ,
    AddToRegLong{

        @Override
        public int bench(boolean bl) throws M68kException {
            int n = 0;
            XEiJ.regOC = 53377;
            XEiJ.regRn[0] = 0;
            for (int i = 0; i < 100000000; ++i) {
                XEiJ.regRn[1] = i << i | i >>> -i;
                XEiJ.regCCR = 0x1F & i;
                if (bl) {
                    MC68000.irpAddToRegLong();
                }
                n = n * 3 + XEiJ.regRn[0];
                n = n * 3 + XEiJ.regCCR;
            }
            return n;
        }
    }
    ,
    AddToMemByte{

        @Override
        public int bench(boolean bl) throws M68kException {
            int n;
            int n2 = 0;
            XEiJ.regOC = 53505;
            XEiJ.regRn[0] = 0;
            for (n = 0; n < 50000000; ++n) {
                XEiJ.regRn[1] = n << n | n >>> -n;
                XEiJ.regCCR = 0x1F & n;
                if (bl) {
                    MC68000.irpAddToMemByte();
                }
                n2 = n2 * 3 + XEiJ.regRn[0];
                n2 = n2 * 3 + XEiJ.regCCR;
            }
            XEiJ.regOC = 53520;
            XEiJ.regRn[8] = 0x200000;
            MainMemory.mmrM8[0x200000] = 0;
            for (n = 0; n < 50000000; ++n) {
                XEiJ.regRn[0] = n << n | n >>> -n;
                XEiJ.regCCR = 0x1F & n;
                if (bl) {
                    MC68000.irpAddToMemByte();
                }
                n2 = n2 * 3 + (MainMemory.mmrM8[0x200000] & 0xFF);
                n2 = n2 * 3 + XEiJ.regCCR;
            }
            return n2;
        }
    };


    public abstract int bench(boolean var1) throws M68kException;
}

