/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import xeij.ADPCM;
import xeij.CRTC;
import xeij.DataBreakPoint;
import xeij.FDC;
import xeij.GraphicScreen;
import xeij.HD63450;
import xeij.HDC;
import xeij.IOInterrupt;
import xeij.InstructionBreakPoint;
import xeij.Keyboard;
import xeij.M68kException;
import xeij.MC68060;
import xeij.MC68901;
import xeij.MainMemory;
import xeij.Multilingual;
import xeij.OPM;
import xeij.PPI;
import xeij.PrinterPort;
import xeij.RP5C15;
import xeij.RasterBreakPoint;
import xeij.SPC;
import xeij.SRAM;
import xeij.ScreenModeTest;
import xeij.SoundSource;
import xeij.SpriteScreen;
import xeij.TickerQueue;
import xeij.VideoController;
import xeij.WaitInstruction;
import xeij.XEiJ;
import xeij.Z8530;

public enum MemoryMappedDevice {
    MMD_MMR{

        public String toString() {
            return Multilingual.mlnJapanese ? "\u30e1\u30a4\u30f3\u30e1\u30e2\u30ea" : "Main Memory";
        }

        @Override
        protected byte mmdPbs(int n) {
            return MainMemory.mmrM8[n &= 0xFFFFFF];
        }

        @Override
        protected int mmdPbz(int n) {
            return MainMemory.mmrM8[n &= 0xFFFFFF] & 0xFF;
        }

        @Override
        protected int mmdPws(int n) {
            return MainMemory.mmrM8[n &= 0xFFFFFF] << 8 | MainMemory.mmrM8[n + 1] & 0xFF;
        }

        @Override
        protected int mmdPwz(int n) {
            return (char)(MainMemory.mmrM8[n &= 0xFFFFFF] << 8 | MainMemory.mmrM8[n + 1] & 0xFF);
        }

        @Override
        protected int mmdPls(int n) {
            return MainMemory.mmrM8[n &= 0xFFFFFF] << 24 | (MainMemory.mmrM8[n + 1] & 0xFF) << 16 | (char)(MainMemory.mmrM8[n + 2] << 8 | MainMemory.mmrM8[n + 3] & 0xFF);
        }

        @Override
        protected byte mmdRbs(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.ram;
            return MainMemory.mmrM8[n &= 0xFFFFFF];
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.ram;
            return MainMemory.mmrM8[n &= 0xFFFFFF] & 0xFF;
        }

        @Override
        protected int mmdRws(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.ram;
            return MainMemory.mmrM8[n &= 0xFFFFFF] << 8 | MainMemory.mmrM8[n + 1] & 0xFF;
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.ram;
            return (char)(MainMemory.mmrM8[n &= 0xFFFFFF] << 8 | MainMemory.mmrM8[n + 1] & 0xFF);
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.ramlong;
            return MainMemory.mmrM8[n &= 0xFFFFFF] << 24 | (MainMemory.mmrM8[n + 1] & 0xFF) << 16 | (char)(MainMemory.mmrM8[n + 2] << 8 | MainMemory.mmrM8[n + 3] & 0xFF);
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.ram;
            MainMemory.mmrM8[n &= 0xFFFFFF] = (byte)n2;
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.ram;
            MainMemory.mmrM8[n &= 0xFFFFFF] = (byte)(n2 >> 8);
            MainMemory.mmrM8[n + 1] = (byte)n2;
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.ramlong;
            MainMemory.mmrM8[n &= 0xFFFFFF] = (byte)(n2 >> 24);
            MainMemory.mmrM8[n + 1] = (byte)(n2 >> 16);
            MainMemory.mmrM8[n + 2] = (byte)(n2 >> 8);
            MainMemory.mmrM8[n + 3] = (byte)n2;
        }
    }
    ,
    MMD_MM1{

        public String toString() {
            return Multilingual.mlnJapanese ? "1MB \u642d\u8f09\u6a5f\u306e 2MB \u76ee" : "2nd MB of machines with 1MB";
        }

        @Override
        protected byte mmdRbs(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.ram;
            return (byte)((n & 1) == 0 ? this.mmdRwz(n) >> 8 : this.mmdRwz(n));
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.ram;
            return (n & 1) == 0 ? this.mmdRwz(n) >> 8 : this.mmdRwz(n) & 0xFF;
        }

        @Override
        protected int mmdRws(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.ram;
            return (short)this.mmdRwz(n);
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.ram;
            return XEiJ.currentModel.isShodai() ? 24832 : 65535;
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.ramlong;
            return this.mmdRwz(n) << 16 | this.mmdRwz(n + 2);
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.ram;
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.ram;
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.ramlong;
        }
    }
    ,
    MMD_XMM{

        public String toString() {
            return Multilingual.mlnJapanese ? "\u62e1\u5f35\u30e1\u30e2\u30ea" : "Expansion Memory";
        }

        @Override
        protected byte mmdPbs(int n) {
            return XEiJ.busExMemoryArray[n -= XEiJ.busExMemoryStart];
        }

        @Override
        protected int mmdPbz(int n) {
            return XEiJ.busExMemoryArray[n -= XEiJ.busExMemoryStart] & 0xFF;
        }

        @Override
        protected int mmdPws(int n) {
            return XEiJ.busExMemoryArray[n -= XEiJ.busExMemoryStart] << 8 | XEiJ.busExMemoryArray[n + 1] & 0xFF;
        }

        @Override
        protected int mmdPwz(int n) {
            return (char)(XEiJ.busExMemoryArray[n -= XEiJ.busExMemoryStart] << 8 | XEiJ.busExMemoryArray[n + 1] & 0xFF);
        }

        @Override
        protected int mmdPls(int n) {
            return XEiJ.busExMemoryArray[n -= XEiJ.busExMemoryStart] << 24 | (XEiJ.busExMemoryArray[n + 1] & 0xFF) << 16 | (char)(XEiJ.busExMemoryArray[n + 2] << 8 | XEiJ.busExMemoryArray[n + 3] & 0xFF);
        }

        @Override
        protected byte mmdRbs(int n) throws M68kException {
            return XEiJ.busExMemoryArray[n -= XEiJ.busExMemoryStart];
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            return XEiJ.busExMemoryArray[n -= XEiJ.busExMemoryStart] & 0xFF;
        }

        @Override
        protected int mmdRws(int n) throws M68kException {
            return XEiJ.busExMemoryArray[n -= XEiJ.busExMemoryStart] << 8 | XEiJ.busExMemoryArray[n + 1] & 0xFF;
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            return (char)(XEiJ.busExMemoryArray[n -= XEiJ.busExMemoryStart] << 8 | XEiJ.busExMemoryArray[n + 1] & 0xFF);
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            return XEiJ.busExMemoryArray[n -= XEiJ.busExMemoryStart] << 24 | (XEiJ.busExMemoryArray[n + 1] & 0xFF) << 16 | (char)(XEiJ.busExMemoryArray[n + 2] << 8 | XEiJ.busExMemoryArray[n + 3] & 0xFF);
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            XEiJ.busExMemoryArray[n -= XEiJ.busExMemoryStart] = (byte)n2;
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            XEiJ.busExMemoryArray[n -= XEiJ.busExMemoryStart] = (byte)(n2 >> 8);
            XEiJ.busExMemoryArray[n + 1] = (byte)n2;
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            XEiJ.busExMemoryArray[n -= XEiJ.busExMemoryStart] = (byte)(n2 >> 24);
            XEiJ.busExMemoryArray[n + 1] = (byte)(n2 >> 16);
            XEiJ.busExMemoryArray[n + 2] = (byte)(n2 >> 8);
            XEiJ.busExMemoryArray[n + 3] = (byte)n2;
        }
    }
    ,
    MMD_GE0{

        public String toString() {
            return Multilingual.mlnJapanese ? "\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30b9\u753b\u9762 (512 \u30c9\u30c3\u30c8 16 \u8272 \u30da\u30fc\u30b8 0)" : "Graphics Screen (512 dots 16 colors page 0)";
        }

        @Override
        protected byte mmdPbs(int n) {
            return (n & 1) == 0 ? (byte)0 : GraphicScreen.graM4[n >> 1 & 0x3FFFF];
        }

        @Override
        protected int mmdPbz(int n) {
            return (n & 1) == 0 ? 0 : GraphicScreen.graM4[n >> 1 & 0x3FFFF];
        }

        @Override
        protected int mmdPws(int n) {
            return GraphicScreen.graM4[n >> 1 & 0x3FFFF];
        }

        @Override
        protected int mmdPwz(int n) {
            return GraphicScreen.graM4[n >> 1 & 0x3FFFF];
        }

        @Override
        protected int mmdPls(int n) {
            return GraphicScreen.graM4[n >> 1 & 0x3FFFF] << 16 | GraphicScreen.graM4[n + 2 >> 1 & 0x3FFFF];
        }

        @Override
        protected byte mmdRbs(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            return (n & 1) == 0 ? (byte)0 : GraphicScreen.graM4[n >> 1 & 0x3FFFF];
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            return (n & 1) == 0 ? 0 : GraphicScreen.graM4[n >> 1 & 0x3FFFF];
        }

        @Override
        protected int mmdRws(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            return GraphicScreen.graM4[n >> 1 & 0x3FFFF];
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            return GraphicScreen.graM4[n >> 1 & 0x3FFFF];
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram * 2L;
            return GraphicScreen.graM4[n >> 1 & 0x3FFFF] << 16 | GraphicScreen.graM4[n + 2 >> 1 & 0x3FFFF];
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            if ((n & 1) != 0) {
                GraphicScreen.graM4[n >> 1 & 0x3FFFF] = (byte)(n2 & 0xF);
                int n3 = (n >> 10) - CRTC.crtR13GrYCurr[0] & 0x1FF;
                CRTC.crtRasterStamp[n3] = 0;
                CRTC.crtRasterStamp[n3 + 512] = 0;
            }
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            GraphicScreen.graM4[n >> 1 & 0x3FFFF] = (byte)(n2 & 0xF);
            int n3 = (n >> 10) - CRTC.crtR13GrYCurr[0] & 0x1FF;
            CRTC.crtRasterStamp[n3] = 0;
            CRTC.crtRasterStamp[n3 + 512] = 0;
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram * 2L;
            GraphicScreen.graM4[n >> 1 & 0x3FFFF] = (byte)(n2 >> 16 & 0xF);
            GraphicScreen.graM4[n + 2 >> 1 & 0x3FFFF] = (byte)(n2 & 0xF);
            int n3 = (n >> 10) - CRTC.crtR13GrYCurr[0] & 0x1FF;
            CRTC.crtRasterStamp[n3] = 0;
            CRTC.crtRasterStamp[n3 + 512] = 0;
            if ((n & 0x3FE) == 1022) {
                n3 = n3 + 1 & 0x1FF;
                CRTC.crtRasterStamp[n3] = 0;
                CRTC.crtRasterStamp[n3 + 512] = 0;
            }
        }
    }
    ,
    MMD_GE1{

        public String toString() {
            return Multilingual.mlnJapanese ? "\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30b9\u753b\u9762 (512 \u30c9\u30c3\u30c8 16 \u8272 \u30da\u30fc\u30b8 1)" : "Graphics Screen (512 dots 16 colors page 1)";
        }

        @Override
        protected byte mmdPbs(int n) {
            return (n & 1) == 0 ? (byte)0 : GraphicScreen.graM4[262144 + (n >> 1 & 0x3FFFF)];
        }

        @Override
        protected int mmdPbz(int n) {
            return (n & 1) == 0 ? 0 : GraphicScreen.graM4[262144 + (n >> 1 & 0x3FFFF)];
        }

        @Override
        protected int mmdPws(int n) {
            return GraphicScreen.graM4[262144 + (n >> 1 & 0x3FFFF)];
        }

        @Override
        protected int mmdPwz(int n) {
            return GraphicScreen.graM4[262144 + (n >> 1 & 0x3FFFF)];
        }

        @Override
        protected int mmdPls(int n) {
            return GraphicScreen.graM4[262144 + (n >> 1 & 0x3FFFF)] << 16 | GraphicScreen.graM4[262144 + (n + 2 >> 1 & 0x3FFFF)];
        }

        @Override
        protected byte mmdRbs(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            return (n & 1) == 0 ? (byte)0 : GraphicScreen.graM4[262144 + (n >> 1 & 0x3FFFF)];
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            return (n & 1) == 0 ? 0 : GraphicScreen.graM4[262144 + (n >> 1 & 0x3FFFF)];
        }

        @Override
        protected int mmdRws(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            return GraphicScreen.graM4[262144 + (n >> 1 & 0x3FFFF)];
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            return GraphicScreen.graM4[262144 + (n >> 1 & 0x3FFFF)];
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram * 2L;
            return GraphicScreen.graM4[262144 + (n >> 1 & 0x3FFFF)] << 16 | GraphicScreen.graM4[262144 + (n + 2 >> 1 & 0x3FFFF)];
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            if ((n & 1) != 0) {
                GraphicScreen.graM4[262144 + (n >> 1 & 0x3FFFF)] = (byte)(n2 & 0xF);
                int n3 = (n >> 10) - CRTC.crtR13GrYCurr[1] & 0x1FF;
                CRTC.crtRasterStamp[n3] = 0;
                CRTC.crtRasterStamp[n3 + 512] = 0;
            }
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            GraphicScreen.graM4[262144 + (n >> 1 & 0x3FFFF)] = (byte)(n2 & 0xF);
            int n3 = (n >> 10) - CRTC.crtR13GrYCurr[1] & 0x1FF;
            CRTC.crtRasterStamp[n3] = 0;
            CRTC.crtRasterStamp[n3 + 512] = 0;
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram * 2L;
            GraphicScreen.graM4[262144 + (n >> 1 & 0x3FFFF)] = (byte)(n2 >> 16 & 0xF);
            GraphicScreen.graM4[262144 + (n + 2 >> 1 & 0x3FFFF)] = (byte)(n2 & 0xF);
            int n3 = (n >> 10) - CRTC.crtR13GrYCurr[1] & 0x1FF;
            CRTC.crtRasterStamp[n3] = 0;
            CRTC.crtRasterStamp[n3 + 512] = 0;
            if ((n & 0x3FE) == 1022) {
                n3 = n3 + 1 & 0x1FF;
                CRTC.crtRasterStamp[n3] = 0;
                CRTC.crtRasterStamp[n3 + 512] = 0;
            }
        }
    }
    ,
    MMD_GE2{

        public String toString() {
            return Multilingual.mlnJapanese ? "\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30b9\u753b\u9762 (512 \u30c9\u30c3\u30c8 16 \u8272 \u30da\u30fc\u30b8 2)" : "Graphics Screen (512 dots 16 colors page 2)";
        }

        @Override
        protected byte mmdPbs(int n) {
            return (n & 1) == 0 ? (byte)0 : GraphicScreen.graM4[524288 + (n >> 1 & 0x3FFFF)];
        }

        @Override
        protected int mmdPbz(int n) {
            return (n & 1) == 0 ? 0 : GraphicScreen.graM4[524288 + (n >> 1 & 0x3FFFF)];
        }

        @Override
        protected int mmdPws(int n) {
            return GraphicScreen.graM4[524288 + (n >> 1 & 0x3FFFF)];
        }

        @Override
        protected int mmdPwz(int n) {
            return GraphicScreen.graM4[524288 + (n >> 1 & 0x3FFFF)];
        }

        @Override
        protected int mmdPls(int n) {
            return GraphicScreen.graM4[524288 + (n >> 1 & 0x3FFFF)] << 16 | GraphicScreen.graM4[524288 + (n + 2 >> 1 & 0x3FFFF)];
        }

        @Override
        protected byte mmdRbs(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            return (n & 1) == 0 ? (byte)0 : GraphicScreen.graM4[524288 + (n >> 1 & 0x3FFFF)];
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            return (n & 1) == 0 ? 0 : GraphicScreen.graM4[524288 + (n >> 1 & 0x3FFFF)];
        }

        @Override
        protected int mmdRws(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            return GraphicScreen.graM4[524288 + (n >> 1 & 0x3FFFF)];
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            return GraphicScreen.graM4[524288 + (n >> 1 & 0x3FFFF)];
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram * 2L;
            return GraphicScreen.graM4[524288 + (n >> 1 & 0x3FFFF)] << 16 | GraphicScreen.graM4[524288 + (n + 2 >> 1 & 0x3FFFF)];
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            if ((n & 1) != 0) {
                GraphicScreen.graM4[524288 + (n >> 1 & 0x3FFFF)] = (byte)(n2 & 0xF);
                int n3 = (n >> 10) - CRTC.crtR13GrYCurr[2] & 0x1FF;
                CRTC.crtRasterStamp[n3] = 0;
                CRTC.crtRasterStamp[n3 + 512] = 0;
            }
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            GraphicScreen.graM4[524288 + (n >> 1 & 0x3FFFF)] = (byte)(n2 & 0xF);
            int n3 = (n >> 10) - CRTC.crtR13GrYCurr[2] & 0x1FF;
            CRTC.crtRasterStamp[n3] = 0;
            CRTC.crtRasterStamp[n3 + 512] = 0;
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram * 2L;
            GraphicScreen.graM4[524288 + (n >> 1 & 0x3FFFF)] = (byte)(n2 >> 16 & 0xF);
            GraphicScreen.graM4[524288 + (n + 2 >> 1 & 0x3FFFF)] = (byte)(n2 & 0xF);
            int n3 = (n >> 10) - CRTC.crtR13GrYCurr[2] & 0x1FF;
            CRTC.crtRasterStamp[n3] = 0;
            CRTC.crtRasterStamp[n3 + 512] = 0;
            if ((n & 0x3FE) == 1022) {
                n3 = n3 + 1 & 0x1FF;
                CRTC.crtRasterStamp[n3] = 0;
                CRTC.crtRasterStamp[n3 + 512] = 0;
            }
        }
    }
    ,
    MMD_GE3{

        public String toString() {
            return Multilingual.mlnJapanese ? "\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30b9\u753b\u9762 (512 \u30c9\u30c3\u30c8 16 \u8272 \u30da\u30fc\u30b8 3)" : "Graphics Screen (512 dots 16 colors page 3)";
        }

        @Override
        protected byte mmdPbs(int n) {
            return (n & 1) == 0 ? (byte)0 : GraphicScreen.graM4[786432 + (n >> 1 & 0x3FFFF)];
        }

        @Override
        protected int mmdPbz(int n) {
            return (n & 1) == 0 ? 0 : GraphicScreen.graM4[786432 + (n >> 1 & 0x3FFFF)];
        }

        @Override
        protected int mmdPws(int n) {
            return GraphicScreen.graM4[786432 + (n >> 1 & 0x3FFFF)];
        }

        @Override
        protected int mmdPwz(int n) {
            return GraphicScreen.graM4[786432 + (n >> 1 & 0x3FFFF)];
        }

        @Override
        protected int mmdPls(int n) {
            return GraphicScreen.graM4[786432 + (n >> 1 & 0x3FFFF)] << 16 | GraphicScreen.graM4[786432 + (n + 2 >> 1 & 0x3FFFF)];
        }

        @Override
        protected byte mmdRbs(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            return (n & 1) == 0 ? (byte)0 : GraphicScreen.graM4[786432 + (n >> 1 & 0x3FFFF)];
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            return (n & 1) == 0 ? 0 : GraphicScreen.graM4[786432 + (n >> 1 & 0x3FFFF)];
        }

        @Override
        protected int mmdRws(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            return GraphicScreen.graM4[786432 + (n >> 1 & 0x3FFFF)];
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            return GraphicScreen.graM4[786432 + (n >> 1 & 0x3FFFF)];
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram * 2L;
            return GraphicScreen.graM4[786432 + (n >> 1 & 0x3FFFF)] << 16 | GraphicScreen.graM4[786432 + (n + 2 >> 1 & 0x3FFFF)];
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            if ((n & 1) != 0) {
                GraphicScreen.graM4[786432 + (n >> 1 & 0x3FFFF)] = (byte)(n2 & 0xF);
                int n3 = (n >> 10) - CRTC.crtR13GrYCurr[3] & 0x1FF;
                CRTC.crtRasterStamp[n3] = 0;
                CRTC.crtRasterStamp[n3 + 512] = 0;
            }
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            GraphicScreen.graM4[786432 + (n >> 1 & 0x3FFFF)] = (byte)(n2 & 0xF);
            int n3 = (n >> 10) - CRTC.crtR13GrYCurr[3] & 0x1FF;
            CRTC.crtRasterStamp[n3] = 0;
            CRTC.crtRasterStamp[n3 + 512] = 0;
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram * 2L;
            GraphicScreen.graM4[786432 + (n >> 1 & 0x3FFFF)] = (byte)(n2 >> 16 & 0xF);
            GraphicScreen.graM4[786432 + (n + 2 >> 1 & 0x3FFFF)] = (byte)(n2 & 0xF);
            int n3 = (n >> 10) - CRTC.crtR13GrYCurr[3] & 0x1FF;
            CRTC.crtRasterStamp[n3] = 0;
            CRTC.crtRasterStamp[n3 + 512] = 0;
            if ((n & 0x3FE) == 1022) {
                n3 = n3 + 1 & 0x1FF;
                CRTC.crtRasterStamp[n3] = 0;
                CRTC.crtRasterStamp[n3 + 512] = 0;
            }
        }
    }
    ,
    MMD_GF0{

        public String toString() {
            return Multilingual.mlnJapanese ? "\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30b9\u753b\u9762 (512 \u30c9\u30c3\u30c8 256 \u8272 \u30da\u30fc\u30b8 0)" : "Graphics Screen (512 dots 256 colors page 0)";
        }

        @Override
        protected byte mmdPbs(int n) {
            return (byte)((n & 1) == 0 ? 0 : GraphicScreen.graM4[262144 + (n >> 1 & 0x3FFFF)] << 4 | GraphicScreen.graM4[n >> 1 & 0x3FFFF]);
        }

        @Override
        protected int mmdPbz(int n) {
            return (n & 1) == 0 ? 0 : GraphicScreen.graM4[262144 + (n >> 1 & 0x3FFFF)] << 4 | GraphicScreen.graM4[n >> 1 & 0x3FFFF];
        }

        @Override
        protected int mmdPws(int n) {
            int n2 = n >> 1 & 0x3FFFF;
            return GraphicScreen.graM4[262144 + n2] << 4 | GraphicScreen.graM4[n2];
        }

        @Override
        protected int mmdPwz(int n) {
            int n2 = n >> 1 & 0x3FFFF;
            return GraphicScreen.graM4[262144 + n2] << 4 | GraphicScreen.graM4[n2];
        }

        @Override
        protected int mmdPls(int n) {
            int n2 = n >> 1 & 0x3FFFF;
            int n3 = n + 2 >> 1 & 0x3FFFF;
            return GraphicScreen.graM4[262144 + n2] << 20 | GraphicScreen.graM4[n2] << 16 | GraphicScreen.graM4[262144 + n3] << 4 | GraphicScreen.graM4[n3];
        }

        @Override
        protected byte mmdRbs(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            return (byte)((n & 1) == 0 ? 0 : GraphicScreen.graM4[262144 + (n >> 1 & 0x3FFFF)] << 4 | GraphicScreen.graM4[n >> 1 & 0x3FFFF]);
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            return (n & 1) == 0 ? 0 : GraphicScreen.graM4[262144 + (n >> 1 & 0x3FFFF)] << 4 | GraphicScreen.graM4[n >> 1 & 0x3FFFF];
        }

        @Override
        protected int mmdRws(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            int n2 = n >> 1 & 0x3FFFF;
            return GraphicScreen.graM4[262144 + n2] << 4 | GraphicScreen.graM4[n2];
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            int n2 = n >> 1 & 0x3FFFF;
            return GraphicScreen.graM4[262144 + n2] << 4 | GraphicScreen.graM4[n2];
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram * 2L;
            int n2 = n >> 1 & 0x3FFFF;
            int n3 = n + 2 >> 1 & 0x3FFFF;
            return GraphicScreen.graM4[262144 + n2] << 20 | GraphicScreen.graM4[n2] << 16 | GraphicScreen.graM4[262144 + n3] << 4 | GraphicScreen.graM4[n3];
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            if ((n & 1) != 0) {
                int n3 = n >> 1 & 0x3FFFF;
                GraphicScreen.graM4[262144 + n3] = (byte)(n2 >> 4 & 0xF);
                GraphicScreen.graM4[n3] = (byte)(n2 & 0xF);
                int n4 = (n >>= 10) - CRTC.crtR13GrYCurr[0] & 0x1FF;
                CRTC.crtRasterStamp[n4] = 0;
                CRTC.crtRasterStamp[n4 + 512] = 0;
                n4 = n - CRTC.crtR13GrYCurr[1] & 0x1FF;
                CRTC.crtRasterStamp[n4] = 0;
                CRTC.crtRasterStamp[n4 + 512] = 0;
            }
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            int n3 = n >> 1 & 0x3FFFF;
            GraphicScreen.graM4[262144 + n3] = (byte)(n2 >> 4 & 0xF);
            GraphicScreen.graM4[n3] = (byte)(n2 & 0xF);
            int n4 = (n >>= 10) - CRTC.crtR13GrYCurr[0] & 0x1FF;
            CRTC.crtRasterStamp[n4] = 0;
            CRTC.crtRasterStamp[n4 + 512] = 0;
            n4 = n - CRTC.crtR13GrYCurr[1] & 0x1FF;
            CRTC.crtRasterStamp[n4] = 0;
            CRTC.crtRasterStamp[n4 + 512] = 0;
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram * 2L;
            int n3 = n >> 1 & 0x3FFFF;
            int n4 = n + 2 >> 1 & 0x3FFFF;
            GraphicScreen.graM4[262144 + n3] = (byte)(n2 >> 20 & 0xF);
            GraphicScreen.graM4[n3] = (byte)(n2 >> 16 & 0xF);
            GraphicScreen.graM4[262144 + n4] = (byte)(n2 >> 4 & 0xF);
            GraphicScreen.graM4[n4] = (byte)(n2 & 0xF);
            int n5 = n + 2 >>> 10;
            int n6 = n5 - CRTC.crtR13GrYCurr[0] & 0x1FF;
            CRTC.crtRasterStamp[n6] = 0;
            CRTC.crtRasterStamp[n6 + 512] = 0;
            n6 = n5 - CRTC.crtR13GrYCurr[1] & 0x1FF;
            CRTC.crtRasterStamp[n6] = 0;
            CRTC.crtRasterStamp[n6 + 512] = 0;
            if ((n >>>= 10) != n5) {
                n6 = n - CRTC.crtR13GrYCurr[0] & 0x1FF;
                CRTC.crtRasterStamp[n6] = 0;
                CRTC.crtRasterStamp[n6 + 512] = 0;
                n6 = n - CRTC.crtR13GrYCurr[1] & 0x1FF;
                CRTC.crtRasterStamp[n6] = 0;
                CRTC.crtRasterStamp[n6 + 512] = 0;
            }
        }
    }
    ,
    MMD_GF1{

        public String toString() {
            return Multilingual.mlnJapanese ? "\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30b9\u753b\u9762 (512 \u30c9\u30c3\u30c8 256 \u8272 \u30da\u30fc\u30b8 1)" : "Graphics Screen (512 dots 256 colors page 1)";
        }

        @Override
        protected byte mmdPbs(int n) {
            return (byte)((n & 1) == 0 ? 0 : GraphicScreen.graM4[786432 + (n >> 1 & 0x3FFFF)] << 4 | GraphicScreen.graM4[524288 + (n >> 1 & 0x3FFFF)]);
        }

        @Override
        protected int mmdPbz(int n) {
            return (n & 1) == 0 ? 0 : GraphicScreen.graM4[786432 + (n >> 1 & 0x3FFFF)] << 4 | GraphicScreen.graM4[524288 + (n >> 1 & 0x3FFFF)];
        }

        @Override
        protected int mmdPws(int n) {
            int n2 = n >> 1 & 0x3FFFF;
            return GraphicScreen.graM4[786432 + n2] << 4 | GraphicScreen.graM4[524288 + n2];
        }

        @Override
        protected int mmdPwz(int n) {
            int n2 = n >> 1 & 0x3FFFF;
            return GraphicScreen.graM4[786432 + n2] << 4 | GraphicScreen.graM4[524288 + n2];
        }

        @Override
        protected int mmdPls(int n) {
            int n2 = n >> 1 & 0x3FFFF;
            int n3 = n + 2 >> 1 & 0x3FFFF;
            return GraphicScreen.graM4[786432 + n2] << 20 | GraphicScreen.graM4[524288 + n2] << 16 | GraphicScreen.graM4[786432 + n3] << 4 | GraphicScreen.graM4[524288 + n3];
        }

        @Override
        protected byte mmdRbs(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            return (byte)((n & 1) == 0 ? 0 : GraphicScreen.graM4[786432 + (n >> 1 & 0x3FFFF)] << 4 | GraphicScreen.graM4[524288 + (n >> 1 & 0x3FFFF)]);
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            return (n & 1) == 0 ? 0 : GraphicScreen.graM4[786432 + (n >> 1 & 0x3FFFF)] << 4 | GraphicScreen.graM4[524288 + (n >> 1 & 0x3FFFF)];
        }

        @Override
        protected int mmdRws(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            int n2 = n >> 1 & 0x3FFFF;
            return GraphicScreen.graM4[786432 + n2] << 4 | GraphicScreen.graM4[524288 + n2];
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            int n2 = n >> 1 & 0x3FFFF;
            return GraphicScreen.graM4[786432 + n2] << 4 | GraphicScreen.graM4[524288 + n2];
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram * 2L;
            int n2 = n >> 1 & 0x3FFFF;
            int n3 = n + 2 >> 1 & 0x3FFFF;
            return GraphicScreen.graM4[786432 + n2] << 20 | GraphicScreen.graM4[524288 + n2] << 16 | GraphicScreen.graM4[786432 + n3] << 4 | GraphicScreen.graM4[524288 + n3];
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            if ((n & 1) != 0) {
                int n3 = n >> 1 & 0x3FFFF;
                GraphicScreen.graM4[786432 + n3] = (byte)(n2 >> 4 & 0xF);
                GraphicScreen.graM4[524288 + n3] = (byte)(n2 & 0xF);
                int n4 = (n >>= 10) - CRTC.crtR13GrYCurr[2] & 0x1FF;
                CRTC.crtRasterStamp[n4] = 0;
                CRTC.crtRasterStamp[n4 + 512] = 0;
                n4 = n - CRTC.crtR13GrYCurr[3] & 0x1FF;
                CRTC.crtRasterStamp[n4] = 0;
                CRTC.crtRasterStamp[n4 + 512] = 0;
            }
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            int n3 = n >> 1 & 0x3FFFF;
            GraphicScreen.graM4[786432 + n3] = (byte)(n2 >> 4 & 0xF);
            GraphicScreen.graM4[524288 + n3] = (byte)(n2 & 0xF);
            int n4 = (n >>= 10) - CRTC.crtR13GrYCurr[2] & 0x1FF;
            CRTC.crtRasterStamp[n4] = 0;
            CRTC.crtRasterStamp[n4 + 512] = 0;
            n4 = n - CRTC.crtR13GrYCurr[3] & 0x1FF;
            CRTC.crtRasterStamp[n4] = 0;
            CRTC.crtRasterStamp[n4 + 512] = 0;
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram * 2L;
            int n3 = n >> 1 & 0x3FFFF;
            int n4 = n + 2 >> 1 & 0x3FFFF;
            GraphicScreen.graM4[786432 + n3] = (byte)(n2 >> 20 & 0xF);
            GraphicScreen.graM4[524288 + n3] = (byte)(n2 >> 16 & 0xF);
            GraphicScreen.graM4[786432 + n4] = (byte)(n2 >> 4 & 0xF);
            GraphicScreen.graM4[524288 + n4] = (byte)(n2 & 0xF);
            int n5 = n + 2 >>> 10;
            int n6 = n5 - CRTC.crtR13GrYCurr[2] & 0x1FF;
            CRTC.crtRasterStamp[n6] = 0;
            CRTC.crtRasterStamp[n6 + 512] = 0;
            n6 = n5 - CRTC.crtR13GrYCurr[3] & 0x1FF;
            CRTC.crtRasterStamp[n6] = 0;
            CRTC.crtRasterStamp[n6 + 512] = 0;
            if ((n >>>= 10) != n5) {
                n6 = n - CRTC.crtR13GrYCurr[2] & 0x1FF;
                CRTC.crtRasterStamp[n6] = 0;
                CRTC.crtRasterStamp[n6 + 512] = 0;
                n6 = n - CRTC.crtR13GrYCurr[3] & 0x1FF;
                CRTC.crtRasterStamp[n6] = 0;
                CRTC.crtRasterStamp[n6 + 512] = 0;
            }
        }
    }
    ,
    MMD_GM2{

        public String toString() {
            return Multilingual.mlnJapanese ? "\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30b9\u753b\u9762 (\u30e1\u30e2\u30ea\u30e2\u30fc\u30c9 2)" : "Graphics Screen (memory mode 2)";
        }

        @Override
        protected byte mmdPbs(int n) {
            if ((n & 0x80001) == 1) {
                int n2 = n >> 1 & 0x3FFFF;
                return (byte)(GraphicScreen.graM4[262144 + n2] << 4 | GraphicScreen.graM4[n2]);
            }
            return 0;
        }

        @Override
        protected int mmdPbz(int n) {
            if ((n & 0x80001) == 1) {
                int n2 = n >> 1 & 0x3FFFF;
                return GraphicScreen.graM4[262144 + n2] << 4 | GraphicScreen.graM4[n2];
            }
            return 0;
        }

        @Override
        protected int mmdPws(int n) {
            int n2 = n >> 1 & 0x3FFFF;
            if ((n & 0x80000) == 0) {
                return GraphicScreen.graM4[262144 + n2] << 4 | GraphicScreen.graM4[n2];
            }
            return GraphicScreen.graM4[786432 + n2] << 4 | GraphicScreen.graM4[524288 + n2];
        }

        @Override
        protected int mmdPwz(int n) {
            int n2 = n >> 1 & 0x3FFFF;
            if ((n & 0x80000) == 0) {
                return GraphicScreen.graM4[262144 + n2] << 4 | GraphicScreen.graM4[n2];
            }
            return GraphicScreen.graM4[786432 + n2] << 4 | GraphicScreen.graM4[524288 + n2];
        }

        @Override
        protected int mmdPls(int n) {
            return this.mmdPws(n) << 16 | this.mmdPwz(n + 2);
        }

        @Override
        protected byte mmdRbs(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            if ((n & 0x80001) == 1) {
                int n2 = n >> 1 & 0x3FFFF;
                return (byte)(GraphicScreen.graM4[262144 + n2] << 4 | GraphicScreen.graM4[n2]);
            }
            return 0;
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            if ((n & 0x80001) == 1) {
                int n2 = n >> 1 & 0x3FFFF;
                return GraphicScreen.graM4[262144 + n2] << 4 | GraphicScreen.graM4[n2];
            }
            return 0;
        }

        @Override
        protected int mmdRws(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            int n2 = n >> 1 & 0x3FFFF;
            if ((n & 0x80000) == 0) {
                return GraphicScreen.graM4[262144 + n2] << 4 | GraphicScreen.graM4[n2];
            }
            return GraphicScreen.graM4[786432 + n2] << 4 | GraphicScreen.graM4[524288 + n2];
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            int n2 = n >> 1 & 0x3FFFF;
            if ((n & 0x80000) == 0) {
                return GraphicScreen.graM4[262144 + n2] << 4 | GraphicScreen.graM4[n2];
            }
            return GraphicScreen.graM4[786432 + n2] << 4 | GraphicScreen.graM4[524288 + n2];
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            return this.mmdRws(n) << 16 | this.mmdRwz(n + 2);
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            int n3 = n >> 1 & 0x3FFFF;
            if ((n & 1) == 0) {
                if (XEiJ.currentMPU < 6) {
                    GraphicScreen.graM4[786432 + n3] = (byte)(n2 >> 4 & 0xF);
                    GraphicScreen.graM4[524288 + n3] = (byte)(n2 & 0xF);
                } else {
                    GraphicScreen.graM4[786432 + n3] = 0;
                    GraphicScreen.graM4[524288 + n3] = 0;
                }
                int n4 = (n >>>= 10) - CRTC.crtR13GrYCurr[3] & 0x1FF;
                CRTC.crtRasterStamp[n4] = 0;
                CRTC.crtRasterStamp[n4 + 512] = 0;
                n4 = n - CRTC.crtR13GrYCurr[2] & 0x1FF;
                CRTC.crtRasterStamp[n4] = 0;
                CRTC.crtRasterStamp[n4 + 512] = 0;
            } else {
                GraphicScreen.graM4[262144 + n3] = (byte)(n2 >> 4 & 0xF);
                GraphicScreen.graM4[n3] = (byte)(n2 & 0xF);
                int n5 = (n >>>= 10) - CRTC.crtR13GrYCurr[1] & 0x1FF;
                CRTC.crtRasterStamp[n5] = 0;
                CRTC.crtRasterStamp[n5 + 512] = 0;
                n5 = n - CRTC.crtR13GrYCurr[0] & 0x1FF;
                CRTC.crtRasterStamp[n5] = 0;
                CRTC.crtRasterStamp[n5 + 512] = 0;
            }
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            int n3 = n >> 1 & 0x3FFFF;
            GraphicScreen.graM4[786432 + n3] = (byte)(n2 >> 4 & 0xF);
            GraphicScreen.graM4[524288 + n3] = (byte)(n2 & 0xF);
            GraphicScreen.graM4[262144 + n3] = (byte)(n2 >> 4 & 0xF);
            GraphicScreen.graM4[n3] = (byte)(n2 & 0xF);
            int n4 = (n >>>= 10) - CRTC.crtR13GrYCurr[3] & 0x1FF;
            CRTC.crtRasterStamp[n4] = 0;
            CRTC.crtRasterStamp[n4 + 512] = 0;
            n4 = n - CRTC.crtR13GrYCurr[2] & 0x1FF;
            CRTC.crtRasterStamp[n4] = 0;
            CRTC.crtRasterStamp[n4 + 512] = 0;
            n4 = n - CRTC.crtR13GrYCurr[1] & 0x1FF;
            CRTC.crtRasterStamp[n4] = 0;
            CRTC.crtRasterStamp[n4 + 512] = 0;
            n4 = n - CRTC.crtR13GrYCurr[0] & 0x1FF;
            CRTC.crtRasterStamp[n4] = 0;
            CRTC.crtRasterStamp[n4 + 512] = 0;
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            this.mmdWw(n, n2 >> 16);
            this.mmdWw(n + 2, n2);
        }
    }
    ,
    MMD_GG0{

        public String toString() {
            return Multilingual.mlnJapanese ? "\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30b9\u753b\u9762 (512 \u30c9\u30c3\u30c8 65536 \u8272)" : "Graphics Screen (512 dots 65536 colors)";
        }

        @Override
        protected byte mmdPbs(int n) {
            int n2 = n >> 1 & 0x3FFFF;
            return (byte)((n & 1) == 0 ? GraphicScreen.graM4[786432 + n2] << 4 | GraphicScreen.graM4[524288 + n2] : GraphicScreen.graM4[262144 + n2] << 4 | GraphicScreen.graM4[n2]);
        }

        @Override
        protected int mmdPbz(int n) {
            int n2 = n >> 1 & 0x3FFFF;
            return (n & 1) == 0 ? GraphicScreen.graM4[786432 + n2] << 4 | GraphicScreen.graM4[524288 + n2] : GraphicScreen.graM4[262144 + n2] << 4 | GraphicScreen.graM4[n2];
        }

        @Override
        protected int mmdPws(int n) {
            int n2 = n >> 1 & 0x3FFFF;
            return (short)(GraphicScreen.graM4[786432 + n2] << 12 | GraphicScreen.graM4[524288 + n2] << 8 | GraphicScreen.graM4[262144 + n2] << 4 | GraphicScreen.graM4[n2]);
        }

        @Override
        protected int mmdPwz(int n) {
            int n2 = n >> 1 & 0x3FFFF;
            return GraphicScreen.graM4[786432 + n2] << 12 | GraphicScreen.graM4[524288 + n2] << 8 | GraphicScreen.graM4[262144 + n2] << 4 | GraphicScreen.graM4[n2];
        }

        @Override
        protected int mmdPls(int n) {
            int n2 = n >> 1 & 0x3FFFF;
            int n3 = n + 2 >> 1 & 0x3FFFF;
            return GraphicScreen.graM4[786432 + n2] << 28 | GraphicScreen.graM4[524288 + n2] << 24 | GraphicScreen.graM4[262144 + n2] << 20 | GraphicScreen.graM4[n2] << 16 | GraphicScreen.graM4[786432 + n3] << 12 | GraphicScreen.graM4[524288 + n3] << 8 | GraphicScreen.graM4[262144 + n3] << 4 | GraphicScreen.graM4[n3];
        }

        @Override
        protected byte mmdRbs(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            int n2 = n >> 1 & 0x3FFFF;
            return (byte)((n & 1) == 0 ? GraphicScreen.graM4[786432 + n2] << 4 | GraphicScreen.graM4[524288 + n2] : GraphicScreen.graM4[262144 + n2] << 4 | GraphicScreen.graM4[n2]);
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            int n2 = n >> 1 & 0x3FFFF;
            return (n & 1) == 0 ? GraphicScreen.graM4[786432 + n2] << 4 | GraphicScreen.graM4[524288 + n2] : GraphicScreen.graM4[262144 + n2] << 4 | GraphicScreen.graM4[n2];
        }

        @Override
        protected int mmdRws(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            int n2 = n >> 1 & 0x3FFFF;
            return (short)(GraphicScreen.graM4[786432 + n2] << 12 | GraphicScreen.graM4[524288 + n2] << 8 | GraphicScreen.graM4[262144 + n2] << 4 | GraphicScreen.graM4[n2]);
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            int n2 = n >> 1 & 0x3FFFF;
            return GraphicScreen.graM4[786432 + n2] << 12 | GraphicScreen.graM4[524288 + n2] << 8 | GraphicScreen.graM4[262144 + n2] << 4 | GraphicScreen.graM4[n2];
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram * 2L;
            int n2 = n >> 1 & 0x3FFFF;
            int n3 = n + 2 >> 1 & 0x3FFFF;
            return GraphicScreen.graM4[786432 + n2] << 28 | GraphicScreen.graM4[524288 + n2] << 24 | GraphicScreen.graM4[262144 + n2] << 20 | GraphicScreen.graM4[n2] << 16 | GraphicScreen.graM4[786432 + n3] << 12 | GraphicScreen.graM4[524288 + n3] << 8 | GraphicScreen.graM4[262144 + n3] << 4 | GraphicScreen.graM4[n3];
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            int n3 = n >> 1 & 0x3FFFF;
            if ((n & 1) == 0) {
                GraphicScreen.graM4[786432 + n3] = (byte)(n2 >> 4 & 0xF);
                GraphicScreen.graM4[524288 + n3] = (byte)(n2 & 0xF);
                int n4 = (n >>= 10) - CRTC.crtR13GrYCurr[2] & 0x1FF;
                CRTC.crtRasterStamp[n4] = 0;
                CRTC.crtRasterStamp[n4 + 512] = 0;
                n4 = n - CRTC.crtR13GrYCurr[3] & 0x1FF;
                CRTC.crtRasterStamp[n4] = 0;
                CRTC.crtRasterStamp[n4 + 512] = 0;
            } else {
                GraphicScreen.graM4[262144 + n3] = (byte)(n2 >> 4 & 0xF);
                GraphicScreen.graM4[n3] = (byte)(n2 & 0xF);
                int n5 = (n >>= 10) - CRTC.crtR13GrYCurr[0] & 0x1FF;
                CRTC.crtRasterStamp[n5] = 0;
                CRTC.crtRasterStamp[n5 + 512] = 0;
                n5 = n - CRTC.crtR13GrYCurr[1] & 0x1FF;
                CRTC.crtRasterStamp[n5] = 0;
                CRTC.crtRasterStamp[n5 + 512] = 0;
            }
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            int n3 = n >> 1 & 0x3FFFF;
            GraphicScreen.graM4[786432 + n3] = (byte)(n2 >> 12 & 0xF);
            GraphicScreen.graM4[524288 + n3] = (byte)(n2 >> 8 & 0xF);
            GraphicScreen.graM4[262144 + n3] = (byte)(n2 >> 4 & 0xF);
            GraphicScreen.graM4[n3] = (byte)(n2 & 0xF);
            int n4 = (n >>= 10) - CRTC.crtR13GrYCurr[0] & 0x1FF;
            CRTC.crtRasterStamp[n4] = 0;
            CRTC.crtRasterStamp[n4 + 512] = 0;
            n4 = n - CRTC.crtR13GrYCurr[1] & 0x1FF;
            CRTC.crtRasterStamp[n4] = 0;
            CRTC.crtRasterStamp[n4 + 512] = 0;
            n4 = n - CRTC.crtR13GrYCurr[2] & 0x1FF;
            CRTC.crtRasterStamp[n4] = 0;
            CRTC.crtRasterStamp[n4 + 512] = 0;
            n4 = n - CRTC.crtR13GrYCurr[3] & 0x1FF;
            CRTC.crtRasterStamp[n4] = 0;
            CRTC.crtRasterStamp[n4 + 512] = 0;
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram * 2L;
            int n3 = n >> 1 & 0x3FFFF;
            int n4 = n + 2 >> 1 & 0x3FFFF;
            GraphicScreen.graM4[786432 + n3] = (byte)(n2 >>> 28);
            GraphicScreen.graM4[524288 + n3] = (byte)(n2 >> 24 & 0xF);
            GraphicScreen.graM4[262144 + n3] = (byte)(n2 >> 20 & 0xF);
            GraphicScreen.graM4[n3] = (byte)(n2 >> 16 & 0xF);
            GraphicScreen.graM4[786432 + n4] = (byte)((char)n2 >> 12);
            GraphicScreen.graM4[524288 + n4] = (byte)(n2 >> 8 & 0xF);
            GraphicScreen.graM4[262144 + n4] = (byte)(n2 >> 4 & 0xF);
            GraphicScreen.graM4[n4] = (byte)(n2 & 0xF);
            int n5 = n + 2 >>> 10;
            int n6 = n5 - CRTC.crtR13GrYCurr[0] & 0x1FF;
            CRTC.crtRasterStamp[n6] = 0;
            CRTC.crtRasterStamp[n6 + 512] = 0;
            n6 = n5 - CRTC.crtR13GrYCurr[1] & 0x1FF;
            CRTC.crtRasterStamp[n6] = 0;
            CRTC.crtRasterStamp[n6 + 512] = 0;
            n6 = n5 - CRTC.crtR13GrYCurr[2] & 0x1FF;
            CRTC.crtRasterStamp[n6] = 0;
            CRTC.crtRasterStamp[n6 + 512] = 0;
            n6 = n5 - CRTC.crtR13GrYCurr[3] & 0x1FF;
            CRTC.crtRasterStamp[n6] = 0;
            CRTC.crtRasterStamp[n6 + 512] = 0;
            if ((n >>>= 10) != n5) {
                n6 = n - CRTC.crtR13GrYCurr[0] & 0x1FF;
                CRTC.crtRasterStamp[n6] = 0;
                CRTC.crtRasterStamp[n6 + 512] = 0;
                n6 = n - CRTC.crtR13GrYCurr[1] & 0x1FF;
                CRTC.crtRasterStamp[n6] = 0;
                CRTC.crtRasterStamp[n6 + 512] = 0;
                n6 = n - CRTC.crtR13GrYCurr[2] & 0x1FF;
                CRTC.crtRasterStamp[n6] = 0;
                CRTC.crtRasterStamp[n6 + 512] = 0;
                n6 = n - CRTC.crtR13GrYCurr[3] & 0x1FF;
                CRTC.crtRasterStamp[n6] = 0;
                CRTC.crtRasterStamp[n6 + 512] = 0;
            }
        }
    }
    ,
    MMD_GH0{

        public String toString() {
            return Multilingual.mlnJapanese ? "\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30b9\u753b\u9762 (1024 \u30c9\u30c3\u30c8 16 \u8272)" : "Graphics Screen (1024 dots 16 colors)";
        }

        @Override
        protected byte mmdPbs(int n) {
            return (n & 1) == 0 ? (byte)0 : GraphicScreen.graM4[n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00];
        }

        @Override
        protected int mmdPbz(int n) {
            return (n & 1) == 0 ? 0 : GraphicScreen.graM4[n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00];
        }

        @Override
        protected int mmdPws(int n) {
            return GraphicScreen.graM4[n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00];
        }

        @Override
        protected int mmdPwz(int n) {
            return GraphicScreen.graM4[n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00];
        }

        @Override
        protected int mmdPls(int n) {
            int n2 = n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            int n3 = (n += 2) >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            return GraphicScreen.graM4[n2] << 16 | GraphicScreen.graM4[n3];
        }

        @Override
        protected byte mmdRbs(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            return (n & 1) == 0 ? (byte)0 : GraphicScreen.graM4[n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00];
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            return (n & 1) == 0 ? 0 : GraphicScreen.graM4[n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00];
        }

        @Override
        protected int mmdRws(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            return GraphicScreen.graM4[n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00];
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            return GraphicScreen.graM4[n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00];
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram * 2L;
            int n2 = n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            int n3 = (n += 2) >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            return GraphicScreen.graM4[n2] << 16 | GraphicScreen.graM4[n3];
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            if ((n & 1) != 0) {
                CRTC.crtRasterStamp[(n >> 11) - CRTC.crtR13GrYCurr[0] & 0x3FF] = 0;
                GraphicScreen.graM4[n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00] = (byte)(n2 & 0xF);
            }
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            CRTC.crtRasterStamp[(n >> 11) - CRTC.crtR13GrYCurr[0] & 0x3FF] = 0;
            GraphicScreen.graM4[n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00] = (byte)(n2 & 0xF);
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram * 2L;
            CRTC.crtRasterStamp[(n >> 11) - CRTC.crtR13GrYCurr[0] & 0x3FF] = 0;
            GraphicScreen.graM4[n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00] = (byte)(n2 >> 16 & 0xF);
            CRTC.crtRasterStamp[((n += 2) >> 11) - CRTC.crtR13GrYCurr[0] & 0x3FF] = 0;
            GraphicScreen.graM4[n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00] = (byte)(n2 & 0xF);
        }
    }
    ,
    MMD_GI0{

        public String toString() {
            return Multilingual.mlnJapanese ? "\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30b9\u753b\u9762 (1024 \u30c9\u30c3\u30c8 256 \u8272)" : "Graphics Screen (1024 dots 256 colors)";
        }

        @Override
        protected byte mmdPbs(int n) {
            int n2 = n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            return (byte)((n & 1) == 0 ? 0 : GraphicScreen.graM4[0x100000 + n2] << 4 | GraphicScreen.graM4[n2]);
        }

        @Override
        protected int mmdPbz(int n) {
            int n2 = n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            return (n & 1) == 0 ? 0 : GraphicScreen.graM4[0x100000 + n2] << 4 | GraphicScreen.graM4[n2];
        }

        @Override
        protected int mmdPws(int n) {
            int n2 = n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            return GraphicScreen.graM4[0x100000 + n2] << 4 | GraphicScreen.graM4[n2];
        }

        @Override
        protected int mmdPwz(int n) {
            int n2 = n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            return GraphicScreen.graM4[0x100000 + n2] << 4 | GraphicScreen.graM4[n2];
        }

        @Override
        protected int mmdPls(int n) {
            int n2 = n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            int n3 = (n += 2) >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            return GraphicScreen.graM4[0x100000 + n2] << 20 | GraphicScreen.graM4[n2] << 16 | GraphicScreen.graM4[0x100000 + n3] << 4 | GraphicScreen.graM4[n3];
        }

        @Override
        protected byte mmdRbs(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            int n2 = n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            return (byte)((n & 1) == 0 ? 0 : GraphicScreen.graM4[0x100000 + n2] << 4 | GraphicScreen.graM4[n2]);
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            int n2 = n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            return (n & 1) == 0 ? 0 : GraphicScreen.graM4[0x100000 + n2] << 4 | GraphicScreen.graM4[n2];
        }

        @Override
        protected int mmdRws(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            int n2 = n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            return GraphicScreen.graM4[0x100000 + n2] << 4 | GraphicScreen.graM4[n2];
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            int n2 = n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            return GraphicScreen.graM4[0x100000 + n2] << 4 | GraphicScreen.graM4[n2];
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram * 2L;
            int n2 = n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            int n3 = (n += 2) >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            return GraphicScreen.graM4[0x100000 + n2] << 20 | GraphicScreen.graM4[n2] << 16 | GraphicScreen.graM4[0x100000 + n3] << 4 | GraphicScreen.graM4[n3];
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            if ((n & 1) != 0) {
                CRTC.crtRasterStamp[(n >> 11) - CRTC.crtR13GrYCurr[0] & 0x3FF] = 0;
                int n3 = n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
                GraphicScreen.graM4[0x100000 + n3] = (byte)(n2 >> 4 & 0xF);
                GraphicScreen.graM4[n3] = (byte)(n2 & 0xF);
            }
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            CRTC.crtRasterStamp[(n >> 11) - CRTC.crtR13GrYCurr[0] & 0x3FF] = 0;
            int n3 = n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            GraphicScreen.graM4[0x100000 + n3] = (byte)(n2 >> 4 & 0xF);
            GraphicScreen.graM4[n3] = (byte)(n2 & 0xF);
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram * 2L;
            CRTC.crtRasterStamp[(n >> 11) - CRTC.crtR13GrYCurr[0] & 0x3FF] = 0;
            int n3 = n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            CRTC.crtRasterStamp[((n += 2) >> 11) - CRTC.crtR13GrYCurr[0] & 0x3FF] = 0;
            int n4 = n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            GraphicScreen.graM4[0x100000 + n3] = (byte)(n2 >> 20 & 0xF);
            GraphicScreen.graM4[n3] = (byte)(n2 >> 16 & 0xF);
            GraphicScreen.graM4[0x100000 + n4] = (byte)(n2 >> 4 & 0xF);
            GraphicScreen.graM4[n4] = (byte)(n2 & 0xF);
        }
    }
    ,
    MMD_GJ0{

        public String toString() {
            return Multilingual.mlnJapanese ? "\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30b9\u753b\u9762 (1024 \u30c9\u30c3\u30c8 65536 \u8272)" : "Graphics Screen (1024 dots 65536 colors)";
        }

        @Override
        protected byte mmdPbs(int n) {
            int n2 = n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            return (byte)((n & 1) == 0 ? GraphicScreen.graM4[0x300000 + n2] << 4 | GraphicScreen.graM4[0x200000 + n2] : GraphicScreen.graM4[0x100000 + n2] << 4 | GraphicScreen.graM4[n2]);
        }

        @Override
        protected int mmdPbz(int n) {
            int n2 = n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            return (n & 1) == 0 ? GraphicScreen.graM4[0x300000 + n2] << 4 | GraphicScreen.graM4[0x200000 + n2] : GraphicScreen.graM4[0x100000 + n2] << 4 | GraphicScreen.graM4[n2];
        }

        @Override
        protected int mmdPws(int n) {
            int n2 = n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            return (short)(GraphicScreen.graM4[0x300000 + n2] << 12 | GraphicScreen.graM4[0x200000 + n2] << 8 | GraphicScreen.graM4[0x100000 + n2] << 4 | GraphicScreen.graM4[n2]);
        }

        @Override
        protected int mmdPwz(int n) {
            int n2 = n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            return GraphicScreen.graM4[0x300000 + n2] << 12 | GraphicScreen.graM4[0x200000 + n2] << 8 | GraphicScreen.graM4[0x100000 + n2] << 4 | GraphicScreen.graM4[n2];
        }

        @Override
        protected int mmdPls(int n) {
            int n2 = n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            int n3 = (n += 2) >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            return GraphicScreen.graM4[0x300000 + n2] << 28 | GraphicScreen.graM4[0x200000 + n2] << 24 | GraphicScreen.graM4[0x100000 + n2] << 20 | GraphicScreen.graM4[n2] << 16 | GraphicScreen.graM4[0x300000 + n3] << 12 | GraphicScreen.graM4[0x200000 + n3] << 8 | GraphicScreen.graM4[0x100000 + n3] << 4 | GraphicScreen.graM4[n3];
        }

        @Override
        protected byte mmdRbs(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            int n2 = n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            return (byte)((n & 1) == 0 ? GraphicScreen.graM4[0x300000 + n2] << 4 | GraphicScreen.graM4[0x200000 + n2] : GraphicScreen.graM4[0x100000 + n2] << 4 | GraphicScreen.graM4[n2]);
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            int n2 = n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            return (n & 1) == 0 ? GraphicScreen.graM4[0x300000 + n2] << 4 | GraphicScreen.graM4[0x200000 + n2] : GraphicScreen.graM4[0x100000 + n2] << 4 | GraphicScreen.graM4[n2];
        }

        @Override
        protected int mmdRws(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            int n2 = n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            return (short)(GraphicScreen.graM4[0x300000 + n2] << 12 | GraphicScreen.graM4[0x200000 + n2] << 8 | GraphicScreen.graM4[0x100000 + n2] << 4 | GraphicScreen.graM4[n2]);
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            int n2 = n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            return GraphicScreen.graM4[0x300000 + n2] << 12 | GraphicScreen.graM4[0x200000 + n2] << 8 | GraphicScreen.graM4[0x100000 + n2] << 4 | GraphicScreen.graM4[n2];
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram * 2L;
            int n2 = n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            int n3 = (n += 2) >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            return GraphicScreen.graM4[0x300000 + n2] << 28 | GraphicScreen.graM4[0x200000 + n2] << 24 | GraphicScreen.graM4[0x100000 + n2] << 20 | GraphicScreen.graM4[n2] << 16 | GraphicScreen.graM4[0x300000 + n3] << 12 | GraphicScreen.graM4[0x200000 + n3] << 8 | GraphicScreen.graM4[0x100000 + n3] << 4 | GraphicScreen.graM4[n3];
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            CRTC.crtRasterStamp[(n >> 11) - CRTC.crtR13GrYCurr[0] & 0x3FF] = 0;
            int n3 = n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            if ((n & 1) == 0) {
                GraphicScreen.graM4[0x300000 + n3] = (byte)(n2 >> 4 & 0xF);
                GraphicScreen.graM4[0x200000 + n3] = (byte)(n2 & 0xF);
            } else {
                GraphicScreen.graM4[0x100000 + n3] = (byte)(n2 >> 4 & 0xF);
                GraphicScreen.graM4[n3] = (byte)(n2 & 0xF);
            }
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram;
            CRTC.crtRasterStamp[(n >> 11) - CRTC.crtR13GrYCurr[0] & 0x3FF] = 0;
            int n3 = n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            GraphicScreen.graM4[0x300000 + n3] = (byte)((char)n2 >> 12);
            GraphicScreen.graM4[0x200000 + n3] = (byte)(n2 >> 8 & 0xF);
            GraphicScreen.graM4[0x100000 + n3] = (byte)(n2 >> 4 & 0xF);
            GraphicScreen.graM4[n3] = (byte)(n2 & 0xF);
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.gvram * 2L;
            CRTC.crtRasterStamp[(n >> 11) - CRTC.crtR13GrYCurr[0] & 0x3FF] = 0;
            int n3 = n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            CRTC.crtRasterStamp[((n += 2) >> 11) - CRTC.crtR13GrYCurr[0] & 0x3FF] = 0;
            int n4 = n >> 1 & 0x801FF | n << 8 & 0x40000 | n >> 2 & 0x3FE00;
            GraphicScreen.graM4[0x300000 + n3] = (byte)(n2 >>> 28);
            GraphicScreen.graM4[0x200000 + n3] = (byte)(n2 >> 24 & 0xF);
            GraphicScreen.graM4[0x100000 + n3] = (byte)(n2 >> 20 & 0xF);
            GraphicScreen.graM4[n3] = (byte)(n2 >> 16 & 0xF);
            GraphicScreen.graM4[0x300000 + n4] = (byte)((char)n2 >> 12);
            GraphicScreen.graM4[0x200000 + n4] = (byte)(n2 >> 8 & 0xF);
            GraphicScreen.graM4[0x100000 + n4] = (byte)(n2 >> 4 & 0xF);
            GraphicScreen.graM4[n4] = (byte)(n2 & 0xF);
        }
    }
    ,
    MMD_TXT{

        public String toString() {
            return Multilingual.mlnJapanese ? "\u30c6\u30ad\u30b9\u30c8\u753b\u9762" : "Text Screen";
        }

        @Override
        protected byte mmdPbs(int n) {
            return MainMemory.mmrM8[n &= 0xFFFFFF];
        }

        @Override
        protected int mmdPbz(int n) {
            return MainMemory.mmrM8[n &= 0xFFFFFF] & 0xFF;
        }

        @Override
        protected int mmdPws(int n) {
            return MainMemory.mmrM8[n &= 0xFFFFFF] << 8 | MainMemory.mmrM8[n + 1] & 0xFF;
        }

        @Override
        protected int mmdPwz(int n) {
            return (char)(MainMemory.mmrM8[n &= 0xFFFFFF] << 8 | MainMemory.mmrM8[n + 1] & 0xFF);
        }

        @Override
        protected int mmdPls(int n) {
            return MainMemory.mmrM8[n &= 0xFFFFFF] << 24 | (MainMemory.mmrM8[n + 1] & 0xFF) << 16 | (char)(MainMemory.mmrM8[n + 2] << 8 | MainMemory.mmrM8[n + 3] & 0xFF);
        }

        @Override
        protected byte mmdRbs(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.tvram;
            return MainMemory.mmrM8[n &= 0xFFFFFF];
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.tvram;
            return MainMemory.mmrM8[n &= 0xFFFFFF] & 0xFF;
        }

        @Override
        protected int mmdRws(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.tvram;
            return MainMemory.mmrM8[n &= 0xFFFFFF] << 8 | MainMemory.mmrM8[n + 1] & 0xFF;
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.tvram;
            return (char)(MainMemory.mmrM8[n &= 0xFFFFFF] << 8 | MainMemory.mmrM8[n + 1] & 0xFF);
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.tvram * 2L;
            return MainMemory.mmrM8[n &= 0xFFFFFF] << 24 | (MainMemory.mmrM8[n + 1] & 0xFF) << 16 | (char)(MainMemory.mmrM8[n + 2] << 8 | MainMemory.mmrM8[n + 3] & 0xFF);
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.tvram;
            n &= 0xFFFFFF;
            if (CRTC.crtSimAccess) {
                n &= 0xE1FFFF;
                if (CRTC.crtBitMask) {
                    int n3 = CRTC.crtR23Mask >> ((~n & 1) << 3);
                    n2 &= ~n3;
                    if (CRTC.crtSimPlane0) {
                        MainMemory.mmrM8[n] = (byte)(MainMemory.mmrM8[n] & n3 | n2);
                    }
                    if (CRTC.crtSimPlane1) {
                        MainMemory.mmrM8[n + 131072] = (byte)(MainMemory.mmrM8[n + 131072] & n3 | n2);
                    }
                    if (CRTC.crtSimPlane2) {
                        MainMemory.mmrM8[n + 262144] = (byte)(MainMemory.mmrM8[n + 262144] & n3 | n2);
                    }
                    if (CRTC.crtSimPlane3) {
                        MainMemory.mmrM8[n + 393216] = (byte)(MainMemory.mmrM8[n + 393216] & n3 | n2);
                    }
                } else {
                    if (CRTC.crtSimPlane0) {
                        MainMemory.mmrM8[n] = (byte)n2;
                    }
                    if (CRTC.crtSimPlane1) {
                        MainMemory.mmrM8[n + 131072] = (byte)n2;
                    }
                    if (CRTC.crtSimPlane2) {
                        MainMemory.mmrM8[n + 262144] = (byte)n2;
                    }
                    if (CRTC.crtSimPlane3) {
                        MainMemory.mmrM8[n + 393216] = (byte)n2;
                    }
                }
            } else if (CRTC.crtBitMask) {
                int n4 = CRTC.crtR23Mask >> ((~n & 1) << 3);
                MainMemory.mmrM8[n] = (byte)(MainMemory.mmrM8[n] & n4 | n2 & ~n4);
            } else {
                MainMemory.mmrM8[n] = (byte)n2;
            }
            n = ((n & 0x1FFFF) >> 7) - CRTC.crtR11TxYCurr & 0x3FC;
            CRTC.crtRasterStamp[n] = 0;
            CRTC.crtRasterStamp[n + 1] = 0;
            CRTC.crtRasterStamp[n + 2] = 0;
            CRTC.crtRasterStamp[n + 3] = 0;
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.tvram;
            n &= 0xFFFFFF;
            if (CRTC.crtSimAccess) {
                n &= 0xE1FFFF;
                if (CRTC.crtBitMask) {
                    int n3 = CRTC.crtR23Mask;
                    int n4 = n3 >> 8;
                    int n5 = n2 >> 8 & ~n4;
                    n2 &= ~n3;
                    if (CRTC.crtSimPlane0) {
                        MainMemory.mmrM8[n] = (byte)(MainMemory.mmrM8[n] & n4 | n5);
                        MainMemory.mmrM8[n + 1] = (byte)(MainMemory.mmrM8[n + 1] & n3 | n2);
                    }
                    if (CRTC.crtSimPlane1) {
                        MainMemory.mmrM8[n + 131072] = (byte)(MainMemory.mmrM8[n + 131072] & n4 | n5);
                        MainMemory.mmrM8[n + 131073] = (byte)(MainMemory.mmrM8[n + 131073] & n3 | n2);
                    }
                    if (CRTC.crtSimPlane2) {
                        MainMemory.mmrM8[n + 262144] = (byte)(MainMemory.mmrM8[n + 262144] & n4 | n5);
                        MainMemory.mmrM8[n + 262145] = (byte)(MainMemory.mmrM8[n + 262145] & n3 | n2);
                    }
                    if (CRTC.crtSimPlane3) {
                        MainMemory.mmrM8[n + 393216] = (byte)(MainMemory.mmrM8[n + 393216] & n4 | n5);
                        MainMemory.mmrM8[n + 393217] = (byte)(MainMemory.mmrM8[n + 393217] & n3 | n2);
                    }
                } else {
                    int n6 = n2 >> 8;
                    if (CRTC.crtSimPlane0) {
                        MainMemory.mmrM8[n] = (byte)n6;
                        MainMemory.mmrM8[n + 1] = (byte)n2;
                    }
                    if (CRTC.crtSimPlane1) {
                        MainMemory.mmrM8[n + 131072] = (byte)n6;
                        MainMemory.mmrM8[n + 131073] = (byte)n2;
                    }
                    if (CRTC.crtSimPlane2) {
                        MainMemory.mmrM8[n + 262144] = (byte)n6;
                        MainMemory.mmrM8[n + 262145] = (byte)n2;
                    }
                    if (CRTC.crtSimPlane3) {
                        MainMemory.mmrM8[n + 393216] = (byte)n6;
                        MainMemory.mmrM8[n + 393217] = (byte)n2;
                    }
                }
            } else if (CRTC.crtBitMask) {
                int n7 = CRTC.crtR23Mask;
                int n8 = n7 >> 8;
                MainMemory.mmrM8[n] = (byte)(MainMemory.mmrM8[n] & n8 | n2 >> 8 & ~n8);
                MainMemory.mmrM8[n + 1] = (byte)(MainMemory.mmrM8[n + 1] & n7 | n2 & ~n7);
            } else {
                MainMemory.mmrM8[n] = (byte)(n2 >> 8);
                MainMemory.mmrM8[n + 1] = (byte)n2;
            }
            n = ((n & 0x1FFFF) >> 7) - CRTC.crtR11TxYCurr & 0x3FC;
            CRTC.crtRasterStamp[n] = 0;
            CRTC.crtRasterStamp[n + 1] = 0;
            CRTC.crtRasterStamp[n + 2] = 0;
            CRTC.crtRasterStamp[n + 3] = 0;
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.tvram * 2L;
            n &= 0xFFFFFF;
            if (CRTC.crtSimAccess) {
                n &= 0xE1FFFF;
                if (CRTC.crtBitMask) {
                    int n3 = CRTC.crtR23Mask;
                    int n4 = n3 >> 8;
                    int n5 = n2 >> 24 & ~n4;
                    int n6 = n2 >> 16 & ~n3;
                    int n7 = n2 >> 8 & ~n4;
                    n2 &= ~n3;
                    if (CRTC.crtSimPlane0) {
                        MainMemory.mmrM8[n] = (byte)(MainMemory.mmrM8[n] & n4 | n5);
                        MainMemory.mmrM8[n + 1] = (byte)(MainMemory.mmrM8[n + 1] & n3 | n6);
                        MainMemory.mmrM8[n + 2] = (byte)(MainMemory.mmrM8[n + 2] & n4 | n7);
                        MainMemory.mmrM8[n + 3] = (byte)(MainMemory.mmrM8[n + 3] & n3 | n2);
                    }
                    if (CRTC.crtSimPlane1) {
                        MainMemory.mmrM8[n + 131072] = (byte)(MainMemory.mmrM8[n + 131072] & n4 | n5);
                        MainMemory.mmrM8[n + 131073] = (byte)(MainMemory.mmrM8[n + 131073] & n3 | n6);
                        MainMemory.mmrM8[n + 131074] = (byte)(MainMemory.mmrM8[n + 131074] & n4 | n7);
                        MainMemory.mmrM8[n + 131075] = (byte)(MainMemory.mmrM8[n + 131075] & n3 | n2);
                    }
                    if (CRTC.crtSimPlane2) {
                        MainMemory.mmrM8[n + 262144] = (byte)(MainMemory.mmrM8[n + 262144] & n4 | n5);
                        MainMemory.mmrM8[n + 262145] = (byte)(MainMemory.mmrM8[n + 262145] & n3 | n6);
                        MainMemory.mmrM8[n + 262146] = (byte)(MainMemory.mmrM8[n + 262146] & n4 | n7);
                        MainMemory.mmrM8[n + 262147] = (byte)(MainMemory.mmrM8[n + 262147] & n3 | n2);
                    }
                    if (CRTC.crtSimPlane3) {
                        MainMemory.mmrM8[n + 393216] = (byte)(MainMemory.mmrM8[n + 393216] & n4 | n5);
                        MainMemory.mmrM8[n + 393217] = (byte)(MainMemory.mmrM8[n + 393217] & n3 | n6);
                        MainMemory.mmrM8[n + 393218] = (byte)(MainMemory.mmrM8[n + 393218] & n4 | n7);
                        MainMemory.mmrM8[n + 393219] = (byte)(MainMemory.mmrM8[n + 393219] & n3 | n2);
                    }
                } else {
                    int n8 = n2 >> 24;
                    int n9 = n2 >> 16;
                    int n10 = n2 >> 8;
                    if (CRTC.crtSimPlane0) {
                        MainMemory.mmrM8[n] = (byte)n8;
                        MainMemory.mmrM8[n + 1] = (byte)n9;
                        MainMemory.mmrM8[n + 2] = (byte)n10;
                        MainMemory.mmrM8[n + 3] = (byte)n2;
                    }
                    if (CRTC.crtSimPlane1) {
                        MainMemory.mmrM8[n + 131072] = (byte)n8;
                        MainMemory.mmrM8[n + 131073] = (byte)n9;
                        MainMemory.mmrM8[n + 131074] = (byte)n10;
                        MainMemory.mmrM8[n + 131075] = (byte)n2;
                    }
                    if (CRTC.crtSimPlane2) {
                        MainMemory.mmrM8[n + 262144] = (byte)n8;
                        MainMemory.mmrM8[n + 262145] = (byte)n9;
                        MainMemory.mmrM8[n + 262146] = (byte)n10;
                        MainMemory.mmrM8[n + 262147] = (byte)n2;
                    }
                    if (CRTC.crtSimPlane3) {
                        MainMemory.mmrM8[n + 393216] = (byte)n8;
                        MainMemory.mmrM8[n + 393217] = (byte)n9;
                        MainMemory.mmrM8[n + 393218] = (byte)n10;
                        MainMemory.mmrM8[n + 393219] = (byte)n2;
                    }
                }
            } else if (CRTC.crtBitMask) {
                int n11 = CRTC.crtR23Mask;
                int n12 = n11 >> 8;
                MainMemory.mmrM8[n] = (byte)(MainMemory.mmrM8[n] & n12 | n2 >> 24 & ~n12);
                MainMemory.mmrM8[n + 1] = (byte)(MainMemory.mmrM8[n + 1] & n11 | n2 >> 16 & ~n11);
                MainMemory.mmrM8[n + 2] = (byte)(MainMemory.mmrM8[n + 1] & n12 | n2 >> 8 & ~n12);
                MainMemory.mmrM8[n + 3] = (byte)(MainMemory.mmrM8[n + 1] & n11 | n2 & ~n11);
            } else {
                MainMemory.mmrM8[n] = (byte)(n2 >> 24);
                MainMemory.mmrM8[n + 1] = (byte)(n2 >> 16);
                MainMemory.mmrM8[n + 2] = (byte)(n2 >> 8);
                MainMemory.mmrM8[n + 3] = (byte)n2;
            }
            int n13 = ((n & 0x1FFFF) >> 7) - CRTC.crtR11TxYCurr & 0x3FC;
            CRTC.crtRasterStamp[n13] = 0;
            CRTC.crtRasterStamp[n13 + 1] = 0;
            CRTC.crtRasterStamp[n13 + 2] = 0;
            CRTC.crtRasterStamp[n13 + 3] = 0;
            if ((n = ((n + 2 & 0x1FFFF) >> 7) - CRTC.crtR11TxYCurr & 0x3FC) != n13) {
                CRTC.crtRasterStamp[n] = 0;
                CRTC.crtRasterStamp[n + 1] = 0;
                CRTC.crtRasterStamp[n + 2] = 0;
                CRTC.crtRasterStamp[n + 3] = 0;
            }
        }
    }
    ,
    MMD_CRT{

        public String toString() {
            return Multilingual.mlnJapanese ? "CRT \u30b3\u30f3\u30c8\u30ed\u30fc\u30e9" : "CRT Controller";
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.crtc;
            int n2 = n & 0x7FF;
            if (n2 < 1024) {
                switch (n2 &= 0x3F) {
                    case 40: {
                        return CRTC.crtTextStorage << 4 | CRTC.crtGraphicStorage << 3 | CRTC.crtMemoryModePort;
                    }
                    case 41: {
                        return CRTC.crtHighResoPort << 4 | CRTC.crtVResoPort << 2 | CRTC.crtHResoPort;
                    }
                    case 42: {
                        return (CRTC.crtBitMask ? 2 : 0) | (CRTC.crtSimAccess ? 1 : 0);
                    }
                    case 43: {
                        return (CRTC.crtSimPlane3 ? 128 : 0) | (CRTC.crtSimPlane2 ? 64 : 0) | (CRTC.crtSimPlane1 ? 32 : 0) | (CRTC.crtSimPlane0 ? 16 : 0) | (CRTC.crtCCPlane3 ? 8 : 0) | (CRTC.crtCCPlane2 ? 4 : 0) | (CRTC.crtCCPlane1 ? 2 : 0) | (CRTC.crtCCPlane0 ? 1 : 0);
                    }
                }
                return 0;
            }
            if ((n2 &= 0xFF) < 128) {
                return super.mmdRbz(n);
            }
            if ((n2 &= 1) == 0) {
                return 0;
            }
            return (CRTC.crtRasterCopyOn ? 8 : 0) | (CRTC.crtClearFrames != 0 ? 2 : 0);
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.crtc;
            int n2 = n & 0x7FF;
            if (n2 < 1024) {
                switch (n2 &= 0x3F) {
                    case 40: {
                        return CRTC.crtTextStorage << 12 | CRTC.crtGraphicStorage << 11 | CRTC.crtMemoryModePort << 8 | CRTC.crtHighResoPort << 4 | CRTC.crtVResoPort << 2 | CRTC.crtHResoPort;
                    }
                    case 42: {
                        return (CRTC.crtBitMask ? 512 : 0) | (CRTC.crtSimAccess ? 256 : 0) | (CRTC.crtSimPlane3 ? 128 : 0) | (CRTC.crtSimPlane2 ? 64 : 0) | (CRTC.crtSimPlane1 ? 32 : 0) | (CRTC.crtSimPlane0 ? 16 : 0) | (CRTC.crtCCPlane3 ? 8 : 0) | (CRTC.crtCCPlane2 ? 4 : 0) | (CRTC.crtCCPlane1 ? 2 : 0) | (CRTC.crtCCPlane0 ? 1 : 0);
                    }
                }
                return 0;
            }
            if ((n2 &= 0xFF) < 128) {
                return super.mmdRbz(n);
            }
            return (CRTC.crtRasterCopyOn ? 8 : 0) | (CRTC.crtClearFrames != 0 ? 2 : 0);
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            return this.mmdRwz(n) << 16 | this.mmdRwz(n + 2);
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.crtc;
            int n3 = n & 0x7FF;
            if (n3 < 1024) {
                switch (n3 &= 0x3F) {
                    case 1: {
                        int n4;
                        CRTC.crtR00HFrontEndPort = n2 & 0xFF | (CRTC.crtR00Bit0Zero ? 0 : 1);
                        int n5 = n4 = CRTC.crtR00HFrontEndMask == 0 ? CRTC.crtR00HFrontEndPort : CRTC.crtR00HFrontEndTest;
                        if (CRTC.crtR00HFrontEndCurr != n4) {
                            CRTC.crtR00HFrontEndCurr = n4;
                            CRTC.crtRestart();
                        }
                        return;
                    }
                    case 3: {
                        int n6;
                        CRTC.crtR01HSyncEndPort = n2 & 0xFF;
                        int n7 = n6 = CRTC.crtR01HSyncEndMask == 0 ? CRTC.crtR01HSyncEndPort : CRTC.crtR01HSyncEndTest;
                        if (CRTC.crtR01HSyncEndCurr != n6) {
                            CRTC.crtR01HSyncEndCurr = n6;
                            CRTC.crtRestart();
                        }
                        return;
                    }
                    case 5: {
                        int n8;
                        CRTC.crtR02HBackEndPort = n2 & 0xFF;
                        int n9 = n8 = CRTC.crtR02HBackEndMask == 0 ? CRTC.crtR02HBackEndPort : CRTC.crtR02HBackEndTest;
                        if (CRTC.crtR02HBackEndCurr != n8) {
                            CRTC.crtR02HBackEndCurr = n8;
                            CRTC.crtRestart();
                        }
                        return;
                    }
                    case 7: {
                        int n10;
                        CRTC.crtR03HDispEndPort = n2 & 0xFF;
                        int n11 = n10 = CRTC.crtR03HDispEndMask == 0 ? CRTC.crtR03HDispEndPort : CRTC.crtR03HDispEndTest;
                        if (CRTC.crtR03HDispEndCurr != n10) {
                            CRTC.crtR03HDispEndCurr = n10;
                            CRTC.crtRestart();
                        }
                        return;
                    }
                    case 8: {
                        int n12;
                        CRTC.crtR04VFrontEndPort = (n2 & CRTC.crtVerticalMask >> 8) << 8 | CRTC.crtR04VFrontEndPort & 0xFF;
                        int n13 = n12 = CRTC.crtR04VFrontEndMask == 0 ? CRTC.crtR04VFrontEndPort : CRTC.crtR04VFrontEndTest;
                        if (CRTC.crtR04VFrontEndCurr != n12) {
                            CRTC.crtR04VFrontEndCurr = n12;
                            CRTC.crtUpdateRasterHash();
                            CRTC.crtRestart();
                        }
                        return;
                    }
                    case 9: {
                        int n14;
                        CRTC.crtR04VFrontEndPort = CRTC.crtR04VFrontEndPort & 0xFFFFFF00 | n2 & 0xFF;
                        int n15 = n14 = CRTC.crtR04VFrontEndMask == 0 ? CRTC.crtR04VFrontEndPort : CRTC.crtR04VFrontEndTest;
                        if (CRTC.crtR04VFrontEndCurr != n14) {
                            CRTC.crtR04VFrontEndCurr = n14;
                            CRTC.crtUpdateRasterHash();
                            CRTC.crtRestart();
                        }
                        return;
                    }
                    case 10: {
                        int n16;
                        CRTC.crtR05VSyncEndPort = (n2 & CRTC.crtVerticalMask >> 8) << 8 | CRTC.crtR05VSyncEndPort & 0xFF;
                        int n17 = n16 = CRTC.crtR05VSyncEndMask == 0 ? CRTC.crtR05VSyncEndPort : CRTC.crtR05VSyncEndTest;
                        if (CRTC.crtR05VSyncEndCurr != n16) {
                            CRTC.crtR05VSyncEndCurr = n16;
                            CRTC.crtRestart();
                        }
                        return;
                    }
                    case 11: {
                        int n18;
                        CRTC.crtR05VSyncEndPort = CRTC.crtR05VSyncEndPort & 0xFFFFFF00 | n2 & 0xFF;
                        int n19 = n18 = CRTC.crtR05VSyncEndMask == 0 ? CRTC.crtR05VSyncEndPort : CRTC.crtR05VSyncEndTest;
                        if (CRTC.crtR05VSyncEndCurr != n18) {
                            CRTC.crtR05VSyncEndCurr = n18;
                            CRTC.crtRestart();
                        }
                        return;
                    }
                    case 12: {
                        int n20;
                        CRTC.crtR06VBackEndPort = (n2 & CRTC.crtVerticalMask >> 8) << 8 | CRTC.crtR06VBackEndPort & 0xFF;
                        int n21 = n20 = CRTC.crtR06VBackEndMask == 0 ? CRTC.crtR06VBackEndPort : CRTC.crtR06VBackEndTest;
                        if (CRTC.crtR06VBackEndCurr != n20) {
                            CRTC.crtR06VBackEndCurr = n20;
                            CRTC.crtVDispStart = n20 + 1;
                            CRTC.crtUpdateRasterHash();
                            CRTC.crtRestart();
                        }
                        return;
                    }
                    case 13: {
                        int n22;
                        CRTC.crtR06VBackEndPort = CRTC.crtR06VBackEndPort & 0xFFFFFF00 | n2 & 0xFF;
                        int n23 = n22 = CRTC.crtR06VBackEndMask == 0 ? CRTC.crtR06VBackEndPort : CRTC.crtR06VBackEndTest;
                        if (CRTC.crtR06VBackEndCurr != n22) {
                            CRTC.crtR06VBackEndCurr = n22;
                            CRTC.crtVDispStart = n22 + 1;
                            CRTC.crtUpdateRasterHash();
                            CRTC.crtRestart();
                        }
                        return;
                    }
                    case 14: {
                        int n24;
                        CRTC.crtR07VDispEndPort = (n2 & CRTC.crtVerticalMask >> 8) << 8 | CRTC.crtR07VDispEndPort & 0xFF;
                        int n25 = n24 = CRTC.crtR07VDispEndMask == 0 ? CRTC.crtR07VDispEndPort : CRTC.crtR07VDispEndTest;
                        if (CRTC.crtR07VDispEndCurr != n24) {
                            CRTC.crtR07VDispEndCurr = n24;
                            CRTC.crtVIdleStart = n24 + 1;
                            CRTC.crtUpdateRasterHash();
                            CRTC.crtRestart();
                        }
                        return;
                    }
                    case 15: {
                        int n26;
                        CRTC.crtR07VDispEndPort = CRTC.crtR07VDispEndPort & 0xFFFFFF00 | n2 & 0xFF;
                        int n27 = n26 = CRTC.crtR07VDispEndMask == 0 ? CRTC.crtR07VDispEndPort : CRTC.crtR07VDispEndTest;
                        if (CRTC.crtR07VDispEndCurr != n26) {
                            CRTC.crtR07VDispEndCurr = n26;
                            CRTC.crtVIdleStart = n26 + 1;
                            CRTC.crtUpdateRasterHash();
                            CRTC.crtRestart();
                        }
                        return;
                    }
                    case 17: {
                        if (CRTC.crtR08Adjust != (n2 &= 0xFF)) {
                            CRTC.crtR08Adjust = n2;
                            CRTC.crtRestart();
                        }
                        return;
                    }
                    case 18: {
                        int n28;
                        CRTC.crtR09IRQRasterPort = (n2 & CRTC.crtVerticalMask >> 8) << 8 | CRTC.crtR09IRQRasterPort & 0xFF;
                        int n29 = n28 = CRTC.crtR09IRQRasterMask == 0 ? CRTC.crtR09IRQRasterPort : CRTC.crtR09IRQRasterTest;
                        if (CRTC.crtR09IRQRasterCurr != n28) {
                            CRTC.crtR09IRQRasterCurr = n28;
                            CRTC.crtUpdateRasterHash();
                            RasterBreakPoint.rbpCheckIRQ();
                        }
                        return;
                    }
                    case 19: {
                        int n30;
                        CRTC.crtR09IRQRasterPort = CRTC.crtR09IRQRasterPort & 0xFFFFFF00 | n2 & 0xFF;
                        int n31 = n30 = CRTC.crtR09IRQRasterMask == 0 ? CRTC.crtR09IRQRasterPort : CRTC.crtR09IRQRasterTest;
                        if (CRTC.crtR09IRQRasterCurr != n30) {
                            CRTC.crtR09IRQRasterCurr = n30;
                            CRTC.crtUpdateRasterHash();
                            RasterBreakPoint.rbpCheckIRQ();
                        }
                        return;
                    }
                    case 20: {
                        int n32;
                        CRTC.crtR10TxXPort = (n2 & 3) << 8 | CRTC.crtR10TxXPort & 0xFF;
                        int n33 = n32 = CRTC.crtR10TxXMask == 0 ? CRTC.crtR10TxXPort : CRTC.crtR10TxXTest;
                        if (CRTC.crtR10TxXCurr != n32) {
                            CRTC.crtR10TxXCurr = n32;
                            CRTC.crtAllStamp += 2;
                        }
                        return;
                    }
                    case 21: {
                        int n34;
                        CRTC.crtR10TxXPort = CRTC.crtR10TxXPort & 0xFFFFFF00 | n2 & 0xFF;
                        int n35 = n34 = CRTC.crtR10TxXMask == 0 ? CRTC.crtR10TxXPort : CRTC.crtR10TxXTest;
                        if (CRTC.crtR10TxXCurr != n34) {
                            CRTC.crtR10TxXCurr = n34;
                            CRTC.crtAllStamp += 2;
                        }
                        return;
                    }
                    case 22: {
                        int n36;
                        CRTC.crtR11TxYPort = (n2 & 3) << 8 | CRTC.crtR11TxYPort & 0xFF;
                        int n37 = n36 = CRTC.crtR11TxYMask == 0 ? CRTC.crtR11TxYPort : CRTC.crtR11TxYTest;
                        if (CRTC.crtR11TxYCurr != n36) {
                            CRTC.crtR11TxYCurr = n36;
                        }
                        return;
                    }
                    case 23: {
                        int n38;
                        CRTC.crtR11TxYPort = CRTC.crtR11TxYPort & 0xFFFFFF00 | n2 & 0xFF;
                        int n39 = n38 = CRTC.crtR11TxYMask == 0 ? CRTC.crtR11TxYPort : CRTC.crtR11TxYTest;
                        if (CRTC.crtR11TxYCurr != n38) {
                            CRTC.crtR11TxYCurr = n38;
                        }
                        return;
                    }
                    case 24: 
                    case 28: 
                    case 32: 
                    case 36: {
                        int n40;
                        int n41 = n3 - 24 >> 2;
                        CRTC.crtR12GrXPort[n41] = (n2 & (n41 == 0 ? 3 : 1)) << 8 | CRTC.crtR12GrXPort[n41] & 0xFF;
                        int n42 = n40 = CRTC.crtR12GrXMask[n41] == 0 ? CRTC.crtR12GrXPort[n41] : CRTC.crtR12GrXTest[n41];
                        if (CRTC.crtR12GrXCurr[n41] != n40) {
                            CRTC.crtR12GrXCurr[n41] = n40;
                            CRTC.crtAllStamp += 2;
                        }
                        return;
                    }
                    case 25: 
                    case 29: 
                    case 33: 
                    case 37: {
                        int n43;
                        int n44 = n3 - 24 >> 2;
                        CRTC.crtR12GrXPort[n44] = CRTC.crtR12GrXPort[n44] & 0xFFFFFF00 | n2 & 0xFF;
                        int n45 = n43 = CRTC.crtR12GrXMask[n44] == 0 ? CRTC.crtR12GrXPort[n44] : CRTC.crtR12GrXTest[n44];
                        if (CRTC.crtR12GrXCurr[n44] != n43) {
                            CRTC.crtR12GrXCurr[n44] = n43;
                            CRTC.crtAllStamp += 2;
                        }
                        return;
                    }
                    case 26: 
                    case 30: 
                    case 34: 
                    case 38: {
                        int n46;
                        int n47 = n3 - 24 >> 2;
                        CRTC.crtR13GrYPort[n47] = (n2 & (n47 == 0 ? 3 : 1)) << 8 | CRTC.crtR13GrYPort[n47] & 0xFF;
                        int n48 = n46 = CRTC.crtR13GrYMask[n47] == 0 ? CRTC.crtR13GrYPort[n47] : CRTC.crtR13GrYTest[n47];
                        if (CRTC.crtR13GrYCurr[n47] != n46) {
                            CRTC.crtR13GrYCurr[n47] = n46;
                        }
                        return;
                    }
                    case 27: 
                    case 31: 
                    case 35: 
                    case 39: {
                        int n49;
                        int n50 = n3 - 24 >> 2;
                        CRTC.crtR13GrYPort[n50] = CRTC.crtR13GrYPort[n50] & 0xFFFFFF00 | n2 & 0xFF;
                        int n51 = n49 = CRTC.crtR13GrYMask[n50] == 0 ? CRTC.crtR13GrYPort[n50] : CRTC.crtR13GrYTest[n50];
                        if (CRTC.crtR13GrYCurr[n50] != n49) {
                            CRTC.crtR13GrYCurr[n50] = n49;
                        }
                        return;
                    }
                    case 40: {
                        CRTC.crtSetMemoryMode(n2 >> 4, n2 >> 3, n2);
                        return;
                    }
                    case 41: {
                        int n52;
                        CRTC.crtHighResoPort = n2 >>> 4 & 1;
                        CRTC.crtVResoPort = n2 >>> 2 & 3;
                        CRTC.crtHResoPort = n2 & 3;
                        SpriteScreen.sprAccessible = SpriteScreen.spr768x512 || (n2 & 0x12) != 18;
                        int n53 = CRTC.crtHighResoMask == 0 ? CRTC.crtHighResoPort : CRTC.crtHighResoTest;
                        int n54 = CRTC.crtVResoMask == 0 ? CRTC.crtVResoPort : CRTC.crtVResoTest;
                        int n55 = n52 = CRTC.crtHResoMask == 0 ? CRTC.crtHResoPort : CRTC.crtHResoTest;
                        if (CRTC.crtHighResoCurr != n53 || CRTC.crtVResoCurr != n54 || CRTC.crtHResoCurr != n52) {
                            CRTC.crtHighResoCurr = n53;
                            CRTC.crtVResoCurr = n54;
                            CRTC.crtHResoCurr = n52;
                            CRTC.crtRestart();
                        }
                        return;
                    }
                    case 42: {
                        CRTC.crtBitMask = (n2 & 2) != 0;
                        CRTC.crtSimAccess = (n2 & 1) != 0;
                        return;
                    }
                    case 43: {
                        CRTC.crtSimPlane3 = (byte)n2 < 0;
                        CRTC.crtSimPlane2 = n2 << 25 < 0;
                        CRTC.crtSimPlane1 = n2 << 26 < 0;
                        CRTC.crtSimPlane0 = n2 << 27 < 0;
                        CRTC.crtCCPlane3 = n2 << 28 < 0;
                        CRTC.crtCCPlane2 = n2 << 29 < 0;
                        CRTC.crtCCPlane1 = (n2 & 2) != 0;
                        CRTC.crtCCPlane0 = (n2 & 1) != 0;
                        return;
                    }
                    case 44: {
                        CRTC.crtR22SrcBlock = n2 & 0xFF;
                        return;
                    }
                    case 45: {
                        CRTC.crtR22DstBlock = n2 & 0xFF;
                        return;
                    }
                    case 46: {
                        CRTC.crtR23Mask = (n2 & 0xFF) << 8 | CRTC.crtR23Mask & 0xFF;
                        return;
                    }
                    case 47: {
                        CRTC.crtR23Mask = CRTC.crtR23Mask & 0xFFFFFF00 | n2 & 0xFF;
                        return;
                    }
                }
                return;
            }
            if ((n3 &= 0xFF) >= 128) {
                boolean bl;
                if ((n3 &= 1) == 0) {
                    return;
                }
                boolean bl2 = bl = (n2 & 8) != 0;
                if (CRTC.crtRasterCopyOn != bl) {
                    CRTC.crtRasterCopyOn = bl;
                    CRTC.crtUpdateRasterHash();
                }
                if (CRTC.crtClearFrames == 0) {
                    CRTC.crtClearStandby = (n2 & 2) != 0;
                }
                return;
            }
            super.mmdWb(n, n2);
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.crtc;
            int n3 = n & 0x7FF;
            if (n3 < 1024) {
                switch (n3 &= 0x3F) {
                    case 0: {
                        int n4;
                        CRTC.crtR00HFrontEndPort = n2 & 0xFF | (CRTC.crtR00Bit0Zero ? 0 : 1);
                        int n5 = n4 = CRTC.crtR00HFrontEndMask == 0 ? CRTC.crtR00HFrontEndPort : CRTC.crtR00HFrontEndTest;
                        if (CRTC.crtR00HFrontEndCurr != n4) {
                            CRTC.crtR00HFrontEndCurr = n4;
                            CRTC.crtRestart();
                        }
                        return;
                    }
                    case 2: {
                        int n6;
                        CRTC.crtR01HSyncEndPort = n2 & 0xFF;
                        int n7 = n6 = CRTC.crtR01HSyncEndMask == 0 ? CRTC.crtR01HSyncEndPort : CRTC.crtR01HSyncEndTest;
                        if (CRTC.crtR01HSyncEndCurr != n6) {
                            CRTC.crtR01HSyncEndCurr = n6;
                            CRTC.crtRestart();
                        }
                        return;
                    }
                    case 4: {
                        int n8;
                        CRTC.crtR02HBackEndPort = n2 & 0xFF;
                        int n9 = n8 = CRTC.crtR02HBackEndMask == 0 ? CRTC.crtR02HBackEndPort : CRTC.crtR02HBackEndTest;
                        if (CRTC.crtR02HBackEndCurr != n8) {
                            CRTC.crtR02HBackEndCurr = n8;
                            CRTC.crtRestart();
                        }
                        return;
                    }
                    case 6: {
                        int n10;
                        CRTC.crtR03HDispEndPort = n2 & 0xFF;
                        int n11 = n10 = CRTC.crtR03HDispEndMask == 0 ? CRTC.crtR03HDispEndPort : CRTC.crtR03HDispEndTest;
                        if (CRTC.crtR03HDispEndCurr != n10) {
                            CRTC.crtR03HDispEndCurr = n10;
                            CRTC.crtRestart();
                        }
                        return;
                    }
                    case 8: {
                        int n12;
                        CRTC.crtR04VFrontEndPort = n2 & CRTC.crtVerticalMask;
                        int n13 = n12 = CRTC.crtR04VFrontEndMask == 0 ? CRTC.crtR04VFrontEndPort : CRTC.crtR04VFrontEndTest;
                        if (CRTC.crtR04VFrontEndCurr != n12) {
                            CRTC.crtR04VFrontEndCurr = n12;
                            CRTC.crtUpdateRasterHash();
                            CRTC.crtRestart();
                        }
                        return;
                    }
                    case 10: {
                        int n14;
                        CRTC.crtR05VSyncEndPort = n2 & CRTC.crtVerticalMask;
                        int n15 = n14 = CRTC.crtR05VSyncEndMask == 0 ? CRTC.crtR05VSyncEndPort : CRTC.crtR05VSyncEndTest;
                        if (CRTC.crtR05VSyncEndCurr != n14) {
                            CRTC.crtR05VSyncEndCurr = n14;
                            CRTC.crtRestart();
                        }
                        return;
                    }
                    case 12: {
                        int n16;
                        CRTC.crtR06VBackEndPort = n2 & CRTC.crtVerticalMask;
                        int n17 = n16 = CRTC.crtR06VBackEndMask == 0 ? CRTC.crtR06VBackEndPort : CRTC.crtR06VBackEndTest;
                        if (CRTC.crtR06VBackEndCurr != n16) {
                            CRTC.crtR06VBackEndCurr = n16;
                            CRTC.crtVDispStart = n16 + 1;
                            CRTC.crtUpdateRasterHash();
                            CRTC.crtRestart();
                        }
                        return;
                    }
                    case 14: {
                        int n18;
                        CRTC.crtR07VDispEndPort = n2 & CRTC.crtVerticalMask;
                        int n19 = n18 = CRTC.crtR07VDispEndMask == 0 ? CRTC.crtR07VDispEndPort : CRTC.crtR07VDispEndTest;
                        if (CRTC.crtR07VDispEndCurr != n18) {
                            CRTC.crtR07VDispEndCurr = n18;
                            CRTC.crtVIdleStart = n18 + 1;
                            CRTC.crtUpdateRasterHash();
                            CRTC.crtRestart();
                        }
                        return;
                    }
                    case 16: {
                        if (CRTC.crtR08Adjust != (n2 &= 0xFF)) {
                            CRTC.crtR08Adjust = n2;
                            CRTC.crtRestart();
                        }
                        return;
                    }
                    case 18: {
                        int n20;
                        CRTC.crtR09IRQRasterPort = n2 & CRTC.crtVerticalMask;
                        int n21 = n20 = CRTC.crtR09IRQRasterMask == 0 ? CRTC.crtR09IRQRasterPort : CRTC.crtR09IRQRasterTest;
                        if (CRTC.crtR09IRQRasterCurr != n20) {
                            CRTC.crtR09IRQRasterCurr = n20;
                            CRTC.crtUpdateRasterHash();
                            RasterBreakPoint.rbpCheckIRQ();
                        }
                        return;
                    }
                    case 20: {
                        int n22;
                        CRTC.crtR10TxXPort = n2 & 0x3FF;
                        int n23 = n22 = CRTC.crtR10TxXMask == 0 ? CRTC.crtR10TxXPort : CRTC.crtR10TxXTest;
                        if (CRTC.crtR10TxXCurr != n22) {
                            CRTC.crtR10TxXCurr = n22;
                            CRTC.crtAllStamp += 2;
                        }
                        return;
                    }
                    case 22: {
                        int n24;
                        CRTC.crtR11TxYPort = n2 & 0x3FF;
                        int n25 = n24 = CRTC.crtR11TxYMask == 0 ? CRTC.crtR11TxYPort : CRTC.crtR11TxYTest;
                        if (CRTC.crtR11TxYCurr != n24) {
                            CRTC.crtR11TxYCurr = n24;
                        }
                        return;
                    }
                    case 24: 
                    case 28: 
                    case 32: 
                    case 36: {
                        int n26;
                        int n27 = n3 - 24 >> 2;
                        CRTC.crtR12GrXPort[n27] = n2 & (n27 == 0 ? 1023 : 511);
                        int n28 = n26 = CRTC.crtR12GrXMask[n27] == 0 ? CRTC.crtR12GrXPort[n27] : CRTC.crtR12GrXTest[n27];
                        if (CRTC.crtR12GrXCurr[n27] != n26) {
                            CRTC.crtR12GrXCurr[n27] = n26;
                            CRTC.crtAllStamp += 2;
                        }
                        return;
                    }
                    case 26: 
                    case 30: 
                    case 34: 
                    case 38: {
                        int n29;
                        int n30 = n3 - 24 >> 2;
                        CRTC.crtR13GrYPort[n30] = n2 & (n30 == 0 ? 1023 : 511);
                        int n31 = n29 = CRTC.crtR13GrYMask[n30] == 0 ? CRTC.crtR13GrYPort[n30] : CRTC.crtR13GrYTest[n30];
                        if (CRTC.crtR13GrYCurr[n30] != n29) {
                            CRTC.crtR13GrYCurr[n30] = n29;
                        }
                        return;
                    }
                    case 40: {
                        int n32;
                        CRTC.crtSetMemoryMode(n2 >> 12, n2 >> 11, n2 >> 8);
                        CRTC.crtHighResoPort = n2 >>> 4 & 1;
                        CRTC.crtVResoPort = n2 >>> 2 & 3;
                        CRTC.crtHResoPort = n2 & 3;
                        SpriteScreen.sprAccessible = SpriteScreen.spr768x512 || (n2 & 0x12) != 18;
                        int n33 = CRTC.crtHighResoMask == 0 ? CRTC.crtHighResoPort : CRTC.crtHighResoTest;
                        int n34 = CRTC.crtVResoMask == 0 ? CRTC.crtVResoPort : CRTC.crtVResoTest;
                        int n35 = n32 = CRTC.crtHResoMask == 0 ? CRTC.crtHResoPort : CRTC.crtHResoTest;
                        if (CRTC.crtHighResoCurr != n33 || CRTC.crtVResoCurr != n34 || CRTC.crtHResoCurr != n32) {
                            CRTC.crtHighResoCurr = n33;
                            CRTC.crtVResoCurr = n34;
                            CRTC.crtHResoCurr = n32;
                            CRTC.crtRestart();
                        }
                        return;
                    }
                    case 42: {
                        CRTC.crtBitMask = n2 << 22 < 0;
                        CRTC.crtSimAccess = n2 << 23 < 0;
                        CRTC.crtSimPlane3 = (byte)n2 < 0;
                        CRTC.crtSimPlane2 = n2 << 25 < 0;
                        CRTC.crtSimPlane1 = n2 << 26 < 0;
                        CRTC.crtSimPlane0 = n2 << 27 < 0;
                        CRTC.crtCCPlane3 = n2 << 28 < 0;
                        CRTC.crtCCPlane2 = n2 << 29 < 0;
                        CRTC.crtCCPlane1 = (n2 & 2) != 0;
                        CRTC.crtCCPlane0 = (n2 & 1) != 0;
                        return;
                    }
                    case 44: {
                        CRTC.crtR22SrcBlock = n2 >> 8 & 0xFF;
                        CRTC.crtR22DstBlock = n2 & 0xFF;
                        return;
                    }
                    case 46: {
                        CRTC.crtR23Mask = (char)n2;
                        return;
                    }
                }
                return;
            }
            if ((n3 &= 0xFF) >= 128) {
                boolean bl;
                boolean bl2 = bl = (n2 & 8) != 0;
                if (CRTC.crtRasterCopyOn != bl) {
                    CRTC.crtRasterCopyOn = bl;
                    CRTC.crtUpdateRasterHash();
                }
                if (CRTC.crtClearFrames == 0) {
                    CRTC.crtClearStandby = (n2 & 2) != 0;
                }
                return;
            }
            super.mmdWw(n, n2);
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            this.mmdWw(n, n2 >> 16);
            this.mmdWw(n + 2, n2);
        }
    }
    ,
    MMD_VCN{

        public String toString() {
            return Multilingual.mlnJapanese ? "\u30d3\u30c7\u30aa\u30b3\u30f3\u30c8\u30ed\u30fc\u30e9" : "Video Controller";
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            int n2 = n & 0x1FFF;
            if (n2 < 1024) {
                XEiJ.mpuClockTime += XEiJ.busWaitTime.palet;
                int n3 = n2 < 512 ? VideoController.vcnPal16G8[n2 >> 1] : VideoController.vcnPal16TSPort[n2 - 512 >> 1];
                return (n2 & 1) == 0 ? n3 >> 8 : n3 & 0xFF;
            }
            XEiJ.mpuClockTime += XEiJ.busWaitTime.vicon;
            int n4 = n2 < 1280 ? VideoController.vcnReg1Port : (n2 < 1536 ? VideoController.vcnReg2Port : (n2 < 1792 ? VideoController.vcnReg3Port : 0));
            return (n2 & 1) == 0 ? n4 >> 8 : n4 & 0xFF;
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            int n2 = n & 0x1FFF;
            if (n2 < 1024) {
                XEiJ.mpuClockTime += XEiJ.busWaitTime.palet;
                return n2 < 512 ? VideoController.vcnPal16G8[n2 >> 1] : VideoController.vcnPal16TSPort[n2 - 512 >> 1];
            }
            XEiJ.mpuClockTime += XEiJ.busWaitTime.vicon;
            return n2 < 1280 ? VideoController.vcnReg1Port : (n2 < 1536 ? VideoController.vcnReg2Port : (n2 < 1792 ? VideoController.vcnReg3Port : 0));
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            return this.mmdRwz(n) << 16 | this.mmdRwz(n + 2);
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            int n3 = n & 0x1FFF;
            if (n3 < 512) {
                XEiJ.mpuClockTime += XEiJ.busWaitTime.palet;
                n2 &= 0xFF;
                int n4 = n3 >> 1;
                if ((n3 & 1) == 0) {
                    VideoController.vcnPal16G8[n4] = n2 << 8 | VideoController.vcnPal16G8[n4] & 0xFF;
                    VideoController.vcnPal32G8[n4] = VideoController.vcnPalTbl[VideoController.vcnPal16G8[n4]];
                    if ((n4 & 1) == 0) {
                        VideoController.vcnPal8G16L[n4] = n2;
                    } else {
                        VideoController.vcnPal8G16H[n4 - 1] = n2 << 8;
                    }
                } else {
                    VideoController.vcnPal16G8[n4] = VideoController.vcnPal16G8[n4] & 0xFFFFFF00 | n2;
                    VideoController.vcnPal32G8[n4] = VideoController.vcnPalTbl[VideoController.vcnPal16G8[n4]];
                    if ((n4 & 1) == 0) {
                        VideoController.vcnPal8G16L[n4 + 1] = n2;
                    } else {
                        VideoController.vcnPal8G16H[n4] = n2 << 8;
                    }
                }
                if ((VideoController.vcnReg3Curr & 0x1F) != 0) {
                    CRTC.crtAllStamp += 2;
                }
            } else if (n3 < 1024) {
                XEiJ.mpuClockTime += XEiJ.busWaitTime.palet;
                n2 &= 0xFF;
                int n5 = n3 - 512 >> 1;
                VideoController.vcnPal16TSPort[n5] = n2 = (n3 & 1) == 0 ? n2 << 8 | VideoController.vcnPal16TS[n5] & 0xFF : VideoController.vcnPal16TS[n5] & 0xFFFFFF00 | n2;
                if (!ScreenModeTest.smtPatternTestOn) {
                    VideoController.vcnPal32TS[n5] = VideoController.vcnPalTbl[n2];
                    if (VideoController.vcnReg3Curr << 25 < 0 && SpriteScreen.sprReg4BgCtrlCurr << 22 < 0 || VideoController.vcnReg3Curr << 26 < 0 && n5 < 16) {
                        CRTC.crtAllStamp += 2;
                    }
                }
            } else if (n3 < 1280) {
                XEiJ.mpuClockTime += XEiJ.busWaitTime.vicon;
                int n6 = n2 = (n3 & 1) == 0 ? 0 : n2 & 7;
                if (VideoController.vcnReg1Port != n2) {
                    VideoController.vcnReg1Port = n2;
                    VideoController.vcnReg1Curr = VideoController.vcnReg1Port & ~VideoController.vcnReg1Mask | VideoController.vcnReg1Test & VideoController.vcnReg1Mask;
                    VideoController.vcnUpdateMode();
                }
            } else if (n3 < 1536) {
                XEiJ.mpuClockTime += XEiJ.busWaitTime.vicon;
                int n7 = n2 = (n3 & 1) == 0 ? (n2 & 0x3F) << 8 | VideoController.vcnReg2Port & 0xFF : VideoController.vcnReg2Port & 0xFFFFFF00 | n2 & 0xFF;
                if (VideoController.vcnReg2Port != n2) {
                    VideoController.vcnReg2Port = n2;
                    VideoController.vcnReg2Curr = VideoController.vcnReg2Port & ~VideoController.vcnReg2Mask | VideoController.vcnReg2Test & VideoController.vcnReg2Mask;
                    VideoController.vcnUpdateMode();
                }
            } else if (n3 < 1792) {
                XEiJ.mpuClockTime += XEiJ.busWaitTime.vicon;
                int n8 = n2 = (n3 & 1) == 0 ? (n2 & 0xFF) << 8 | VideoController.vcnReg3Port & 0xFF : VideoController.vcnReg3Port & 0xFFFFFF00 | n2 & 0xFF;
                if (VideoController.vcnReg3Port != n2) {
                    VideoController.vcnReg3Port = n2;
                    VideoController.vcnReg3Curr = VideoController.vcnReg3Port & ~VideoController.vcnReg3Mask | VideoController.vcnReg3Test & VideoController.vcnReg3Mask;
                    VideoController.vcnUpdateMode();
                }
            } else {
                XEiJ.mpuClockTime += XEiJ.busWaitTime.vicon;
            }
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            int n3 = n & 0x1FFF;
            if (n3 < 512) {
                XEiJ.mpuClockTime += XEiJ.busWaitTime.palet;
                int n4 = n3 >> 1;
                char c = (char)n2;
                VideoController.vcnPal16G8[n4] = c;
                VideoController.vcnPal32G8[n4] = VideoController.vcnPalTbl[c];
                if ((n4 & 1) == 0) {
                    VideoController.vcnPal8G16L[n4] = n2 >> 8 & 0xFF;
                    VideoController.vcnPal8G16L[n4 + 1] = n2 & 0xFF;
                } else {
                    VideoController.vcnPal8G16H[n4 - 1] = n2 & 0xFF00;
                    VideoController.vcnPal8G16H[n4] = (n2 & 0xFF) << 8;
                }
                if ((VideoController.vcnReg3Curr & 0x1F) != 0) {
                    CRTC.crtAllStamp += 2;
                }
            } else if (n3 < 1024) {
                XEiJ.mpuClockTime += XEiJ.busWaitTime.palet;
                int n5 = n3 - 512 >> 1;
                VideoController.vcnPal16TSPort[n5] = n2 = (int)((char)n2);
                if (!ScreenModeTest.smtPatternTestOn) {
                    VideoController.vcnPal32TS[n5] = VideoController.vcnPalTbl[n2];
                    if (VideoController.vcnReg3Curr << 25 < 0 && SpriteScreen.sprReg4BgCtrlCurr << 22 < 0 || VideoController.vcnReg3Curr << 26 < 0 && n5 < 16) {
                        CRTC.crtAllStamp += 2;
                    }
                }
            } else if (n3 < 1280) {
                XEiJ.mpuClockTime += XEiJ.busWaitTime.vicon;
                if (VideoController.vcnReg1Port != (n2 &= 7)) {
                    VideoController.vcnReg1Port = n2;
                    VideoController.vcnReg1Curr = VideoController.vcnReg1Port & ~VideoController.vcnReg1Mask | VideoController.vcnReg1Test & VideoController.vcnReg1Mask;
                    VideoController.vcnUpdateMode();
                }
            } else if (n3 < 1536) {
                XEiJ.mpuClockTime += XEiJ.busWaitTime.vicon;
                if (VideoController.vcnReg2Port != (n2 &= 0x3FFF)) {
                    VideoController.vcnReg2Port = n2;
                    VideoController.vcnReg2Curr = VideoController.vcnReg2Port & ~VideoController.vcnReg2Mask | VideoController.vcnReg2Test & VideoController.vcnReg2Mask;
                    VideoController.vcnUpdateMode();
                }
            } else if (n3 < 1792) {
                XEiJ.mpuClockTime += XEiJ.busWaitTime.vicon;
                if (VideoController.vcnReg3Port != (n2 &= 0xFFFF)) {
                    VideoController.vcnReg3Port = n2;
                    VideoController.vcnReg3Curr = VideoController.vcnReg3Port & ~VideoController.vcnReg3Mask | VideoController.vcnReg3Test & VideoController.vcnReg3Mask;
                    VideoController.vcnUpdateMode();
                }
            } else {
                XEiJ.mpuClockTime += XEiJ.busWaitTime.vicon;
            }
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            this.mmdWw(n, n2 >> 16);
            this.mmdWw(n + 2, n2);
        }
    }
    ,
    MMD_DMA{

        public String toString() {
            return Multilingual.mlnJapanese ? "DMA \u30b3\u30f3\u30c8\u30ed\u30fc\u30e9" : "DMA Controller";
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.dmac;
            return HD63450.dmaReadByte(n);
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.dmac;
            return HD63450.dmaReadWord(n);
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.dmac * 2L;
            return HD63450.dmaReadLong(n);
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.dmac;
            HD63450.dmaWriteByte(n, n2);
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.dmac;
            HD63450.dmaWriteWord(n, n2);
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.dmac * 2L;
            HD63450.dmaWriteLong(n, n2);
        }
    }
    ,
    MMD_SVS{

        public String toString() {
            return Multilingual.mlnJapanese ? "\u30b9\u30fc\u30d1\u30fc\u30d0\u30a4\u30b6\u9818\u57df\u8a2d\u5b9a" : "Supervisor Area Setting";
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            if ((n & 1) == 0) {
                super.mmdWb(n, n2);
            } else {
                XEiJ.mpuClockTime += XEiJ.busWaitTime.sysport;
                MainMemory.mmrSetSupervisorArea(n2);
            }
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            this.mmdWb(n + 1, n2);
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            this.mmdWw(n, n2 >> 16);
            this.mmdWw(n + 2, n2);
        }
    }
    ,
    MMD_MFP{

        public String toString() {
            return Multilingual.mlnJapanese ? "MFP" : "MFP";
        }

        @Override
        protected int mmdPbz(int n) {
            return MC68901.mfpPeekByte(n);
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            return MC68901.mfpReadByte(n);
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            return 0xFF00 | this.mmdRbz(n + 1);
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            return this.mmdRwz(n) << 16 | this.mmdRwz(n + 2);
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            MC68901.mfpWriteByte(n, n2);
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            this.mmdWb(n + 1, n2);
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            this.mmdWw(n, n2 >> 16);
            this.mmdWw(n + 2, n2);
        }
    }
    ,
    MMD_RTC_FIRST{

        public String toString() {
            return Multilingual.mlnJapanese ? "RTC" : "RTC";
        }

        @Override
        protected byte mmdPbs(int n) {
            return (byte)RP5C15.rtcPeekByte(n);
        }

        @Override
        protected int mmdPbz(int n) {
            return RP5C15.rtcPeekByte(n);
        }

        @Override
        protected int mmdPws(int n) {
            return RP5C15.rtcPeekByte(n + 1);
        }

        @Override
        protected int mmdPwz(int n) {
            return RP5C15.rtcPeekByte(n + 1);
        }

        @Override
        protected int mmdPls(int n) {
            return RP5C15.rtcPeekByte(n + 1) << 16 | RP5C15.rtcPeekByte(n + 3);
        }

        @Override
        protected byte mmdRbs(int n) throws M68kException {
            if ((n & 1) == 0 && !XEiJ.currentIsSecond) {
                return super.mmdRbs(n);
            }
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rtc;
            XEiJ.busSuper(MMD_RTC_NEXT, 15245312, 15253504);
            RP5C15.rtcUpdate();
            return (byte)RP5C15.rtcReadByte(n);
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            if ((n & 1) == 0 && !XEiJ.currentIsSecond) {
                return super.mmdRbz(n);
            }
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rtc;
            XEiJ.busSuper(MMD_RTC_NEXT, 15245312, 15253504);
            RP5C15.rtcUpdate();
            return RP5C15.rtcReadByte(n);
        }

        @Override
        protected int mmdRws(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rtc;
            XEiJ.busSuper(MMD_RTC_NEXT, 15245312, 15253504);
            RP5C15.rtcUpdate();
            return RP5C15.rtcReadByte(n + 1);
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rtc;
            XEiJ.busSuper(MMD_RTC_NEXT, 15245312, 15253504);
            RP5C15.rtcUpdate();
            return RP5C15.rtcReadByte(n + 1);
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rtc * 2L;
            XEiJ.busSuper(MMD_RTC_NEXT, 15245312, 15253504);
            RP5C15.rtcUpdate();
            return RP5C15.rtcReadByte(n + 1) << 16 | RP5C15.rtcReadByte(n + 3);
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            if ((n & 1) == 0 && !XEiJ.currentIsSecond) {
                super.mmdWb(n, n2);
            }
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rtc;
            XEiJ.busSuper(MMD_RTC_NEXT, 15245312, 15253504);
            RP5C15.rtcUpdate();
            RP5C15.rtcWriteByte(n, n2);
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rtc;
            XEiJ.busSuper(MMD_RTC_NEXT, 15245312, 15253504);
            RP5C15.rtcUpdate();
            RP5C15.rtcWriteByte(n + 1, n2);
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rtc * 2L;
            XEiJ.busSuper(MMD_RTC_NEXT, 15245312, 15253504);
            RP5C15.rtcUpdate();
            RP5C15.rtcWriteByte(n + 1, n2 >> 16);
            RP5C15.rtcWriteByte(n + 3, n2);
        }
    }
    ,
    MMD_RTC_NEXT{

        public String toString() {
            return Multilingual.mlnJapanese ? "RTC" : "RTC";
        }

        @Override
        protected byte mmdPbs(int n) {
            return (byte)RP5C15.rtcPeekByte(n);
        }

        @Override
        protected int mmdPbz(int n) {
            return RP5C15.rtcPeekByte(n);
        }

        @Override
        protected int mmdPws(int n) {
            return RP5C15.rtcPeekByte(n + 1);
        }

        @Override
        protected int mmdPwz(int n) {
            return RP5C15.rtcPeekByte(n + 1);
        }

        @Override
        protected int mmdPls(int n) {
            return RP5C15.rtcPeekByte(n + 1) << 16 | RP5C15.rtcPeekByte(n + 3);
        }

        @Override
        protected byte mmdRbs(int n) throws M68kException {
            if ((n & 1) == 0 && !XEiJ.currentIsSecond) {
                return super.mmdRbs(n);
            }
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rtc;
            return (byte)RP5C15.rtcReadByte(n);
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            if ((n & 1) == 0 && !XEiJ.currentIsSecond) {
                return super.mmdRbz(n);
            }
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rtc;
            return RP5C15.rtcReadByte(n);
        }

        @Override
        protected int mmdRws(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rtc;
            return RP5C15.rtcReadByte(n + 1);
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rtc;
            return RP5C15.rtcReadByte(n + 1);
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rtc * 2L;
            return RP5C15.rtcReadByte(n + 1) << 16 | RP5C15.rtcReadByte(n + 3);
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            if ((n & 1) == 0 && !XEiJ.currentIsSecond) {
                super.mmdWb(n, n2);
            }
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rtc;
            RP5C15.rtcWriteByte(n, n2);
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rtc;
            RP5C15.rtcWriteByte(n + 1, n2);
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rtc * 2L;
            RP5C15.rtcWriteByte(n + 1, n2 >> 16);
            RP5C15.rtcWriteByte(n + 3, n2);
        }
    }
    ,
    MMD_RTC_TEST{

        public String toString() {
            return Multilingual.mlnJapanese ? "RTC \u30c6\u30b9\u30c8" : "RTC test";
        }

        @Override
        protected byte mmdPbs(int n) {
            return (byte)RP5C15.rtcPeekByte(n);
        }

        @Override
        protected int mmdPbz(int n) {
            return RP5C15.rtcPeekByte(n);
        }

        @Override
        protected int mmdPws(int n) {
            return RP5C15.rtcPeekByte(n + 1);
        }

        @Override
        protected int mmdPwz(int n) {
            return RP5C15.rtcPeekByte(n + 1);
        }

        @Override
        protected int mmdPls(int n) {
            return RP5C15.rtcPeekByte(n + 1) << 16 | RP5C15.rtcPeekByte(n + 3);
        }

        @Override
        protected byte mmdRbs(int n) throws M68kException {
            if ((n & 1) == 0 && !XEiJ.currentIsSecond) {
                return super.mmdRbs(n);
            }
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rtc;
            RP5C15.rtcTestUpdate();
            return (byte)RP5C15.rtcReadByte(n);
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            if ((n & 1) == 0 && !XEiJ.currentIsSecond) {
                return super.mmdRbz(n);
            }
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rtc;
            RP5C15.rtcTestUpdate();
            return RP5C15.rtcReadByte(n);
        }

        @Override
        protected int mmdRws(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rtc;
            RP5C15.rtcTestUpdate();
            return RP5C15.rtcReadByte(n + 1);
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rtc;
            RP5C15.rtcTestUpdate();
            return RP5C15.rtcReadByte(n + 1);
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rtc * 2L;
            RP5C15.rtcTestUpdate();
            return RP5C15.rtcReadByte(n + 1) << 16 | RP5C15.rtcReadByte(n + 3);
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            if ((n & 1) == 0 && !XEiJ.currentIsSecond) {
                super.mmdWb(n, n2);
            }
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rtc;
            RP5C15.rtcTestUpdate();
            RP5C15.rtcWriteByte(n, n2);
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rtc;
            RP5C15.rtcTestUpdate();
            RP5C15.rtcWriteByte(n + 1, n2);
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rtc * 2L;
            RP5C15.rtcTestUpdate();
            RP5C15.rtcWriteByte(n + 1, n2 >> 16);
            RP5C15.rtcWriteByte(n + 3, n2);
        }
    }
    ,
    MMD_PRN{

        public String toString() {
            return Multilingual.mlnJapanese ? "\u30d7\u30ea\u30f3\u30bf\u30dd\u30fc\u30c8" : "Printer Port";
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.prnport;
            return (n &= 3) == 1 ? PrinterPort.prnReadData() : (n == 3 ? PrinterPort.prnReadStrobe() : 255);
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            return 0xFF00 | this.mmdRbz(n + 1);
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            return 0xFF00FF00 | this.mmdRbz(n + 1) << 16 | this.mmdRbz(n + 3);
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.prnport;
            if ((n &= 3) == 1) {
                PrinterPort.prnWriteData(n2);
            } else if (n == 3) {
                PrinterPort.prnWriteStrobe(n2);
            }
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            this.mmdWb(n + 1, n2);
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            this.mmdWb(n + 1, n2 >> 16);
            this.mmdWb(n + 3, n2);
        }
    }
    ,
    MMD_SYS{

        public String toString() {
            return Multilingual.mlnJapanese ? "\u30b7\u30b9\u30c6\u30e0\u30dd\u30fc\u30c8" : "System Port";
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.sysport;
            switch (n & 0xF) {
                case 1: {
                    return 0xF0 | VideoController.vcnTargetContrastPort;
                }
                case 3: {
                    return 0xF8 | XEiJ.pnlStereoscopicShutter;
                }
                case 7: {
                    return 0xF4 | (Keyboard.kbdOn ? 8 : 0) | CRTC.crtHRLPort << 1;
                }
                case 11: {
                    return XEiJ.currentModel.isX68030() ? 220 : (XEiJ.currentMPU < 3 ? (XEiJ.mpuClockMHz <= 10.0 ? 255 : 254) : (XEiJ.mpuClockMHz <= 20.0 ? 255 : 254));
                }
            }
            return 255;
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            return 0xFF00 | this.mmdRbz(n + 1);
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            return 0xFF00FF00 | this.mmdRbz(n + 1) << 16 | this.mmdRbz(n + 3);
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            n2 &= 0xFF;
            switch (n & 0xF) {
                case 1: {
                    int n3;
                    VideoController.vcnTargetContrastPort = n2 & 0xF;
                    int n4 = n3 = VideoController.vcnTargetContrastMask == 0 ? VideoController.vcnTargetContrastPort : VideoController.vcnTargetContrastTest;
                    if (VideoController.vcnTargetContrastCurr != n3) {
                        VideoController.vcnTargetContrastCurr = n3;
                        VideoController.vcnTargetScaledContrast = 3 * VideoController.vcnTargetContrastCurr;
                        CRTC.crtContrastClock = XEiJ.mpuClockTime;
                        CRTC.crtFrameTaskClock = Math.min(CRTC.crtContrastClock, CRTC.crtCaptureClock);
                    }
                    return;
                }
                case 3: {
                    XEiJ.pnlStereoscopicShutter = n2 & 3;
                    break;
                }
                case 7: {
                    int n5;
                    CRTC.crtHRLPort = n2 >> 1 & 1;
                    int n6 = n5 = CRTC.crtHRLMask == 0 ? CRTC.crtHRLPort : CRTC.crtHRLTest;
                    if (CRTC.crtHRLCurr != n5) {
                        CRTC.crtHRLCurr = n5;
                        CRTC.crtRestart();
                    }
                    if ((n2 & 4) != 0) {
                        XEiJ.sysResetNMI();
                    }
                    return;
                }
                case 9: {
                    if (XEiJ.currentModel.isX68030() && XEiJ.currentModel.isX68030()) {
                        XEiJ.mpuROMWaitCycles = (n2 >> 4 & 0xF) + 2;
                        XEiJ.mpuRAMWaitCycles = (n2 & 0xF) == 0 ? 0 : (n2 & 0xF) + 2;
                        XEiJ.mpuSetWait();
                    }
                    return;
                }
                case 13: {
                    SRAM.smrWriteEnableOn = n2 == 49;
                    return;
                }
            }
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            this.mmdWb(n + 1, n2);
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            this.mmdWb(n + 1, n2 >> 16);
            this.mmdWb(n + 3, n2);
        }
    }
    ,
    MMD_OPM{

        public String toString() {
            return Multilingual.mlnJapanese ? "FM \u97f3\u6e90" : "FM Sound Generator";
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            if ((n & 1) == 0 && !XEiJ.currentIsSecond) {
                return super.mmdRbz(n);
            }
            XEiJ.mpuClockTime += XEiJ.busWaitTime.opm;
            return (n & 3) == 3 ? OPM.opmYM2151.readStatus() : 255;
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            return 0xFF00 | this.mmdRbz(n + 1);
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            return 0xFF00FF00 | this.mmdRbz(n + 1) << 16 | this.mmdRbz(n + 3);
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            if ((n & 1) == 0 && !XEiJ.currentIsSecond) {
                super.mmdWb(n, n2);
            }
            XEiJ.mpuClockTime += XEiJ.busWaitTime.opm;
            n &= 0xFFFFFF;
            n2 &= 0xFF;
            if ((n &= 3) == 3) {
                OPM.opmYM2151.generate(2 * (2500 - Math.max(0, (int)((double)(SoundSource.sndBlockClock - XEiJ.mpuClockTime) / 1.6E7))));
                OPM.opmYM2151.writeData(n2);
            } else if (n == 1) {
                OPM.opmYM2151.writeAddress(n2);
            }
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            this.mmdWb(n + 1, n2);
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            this.mmdWb(n + 1, n2 >> 16);
            this.mmdWb(n + 3, n2);
        }
    }
    ,
    MMD_PCM{

        public String toString() {
            return Multilingual.mlnJapanese ? "ADPCM \u97f3\u6e90" : "ADPCM Sound Generator";
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            if ((n & 1) == 0 && !XEiJ.currentIsSecond) {
                return super.mmdRbz(n);
            }
            XEiJ.mpuClockTime += XEiJ.busWaitTime.adpcm;
            return (n & 3) == 1 ? (ADPCM.pcmActive ? 128 : 0) | 0x40 : 255;
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            return 0xFF00 | this.mmdRbz(n + 1);
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            return 0xFF00FF00 | this.mmdRbz(n + 1) << 16 | this.mmdRbz(n + 3);
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            if ((n & 1) == 0 && !XEiJ.currentIsSecond) {
                super.mmdWb(n, n2);
            }
            XEiJ.mpuClockTime += XEiJ.busWaitTime.adpcm;
            n &= 0xFFFFFF;
            if ((n &= 3) == 1) {
                if ((n2 & 1) != 0) {
                    if (ADPCM.pcmActive) {
                        ADPCM.pcmClock = Long.MAX_VALUE;
                        TickerQueue.tkqRemove(SoundSource.sndPcmTicker);
                        ADPCM.pcmActive = false;
                        ADPCM.pcmEncodedData = -1;
                        ADPCM.pcmDecoderPointer = 0;
                        HD63450.dmaRisePCL(3);
                    }
                } else if ((n2 & 2) != 0 && !ADPCM.pcmActive) {
                    int n3 = Math.max(0, (int)((double)(SoundSource.sndBlockClock - XEiJ.mpuClockTime) / 1.6E7));
                    ADPCM.pcmClock = SoundSource.sndBlockClock - 16000000L * (long)n3;
                    TickerQueue.tkqAdd(SoundSource.sndPcmTicker, ADPCM.pcmClock);
                    ADPCM.pcmActive = true;
                    int n4 = 2 * (2500 - n3);
                    if (ADPCM.pcmPointer < n4) {
                        ADPCM.pcmFillBuffer(n4);
                    } else {
                        ADPCM.pcmPointer = n4;
                    }
                    HD63450.dmaFallPCL(3);
                }
            } else if (n == 3 && ADPCM.pcmActive) {
                ADPCM.pcmEncodedData = n2 & 0xFF;
                HD63450.dmaRisePCL(3);
            }
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            this.mmdWb(n + 1, n2);
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            this.mmdWb(n + 1, n2 >> 16);
            this.mmdWb(n + 3, n2);
        }
    }
    ,
    MMD_FDC{

        public String toString() {
            return Multilingual.mlnJapanese ? "FD \u30b3\u30f3\u30c8\u30ed\u30fc\u30e9" : "FD Controller";
        }

        @Override
        protected byte mmdPbs(int n) {
            return (byte)this.mmdPbz(n);
        }

        @Override
        protected int mmdPbz(int n) {
            switch (n &= 0xFFFFFF) {
                case 15286273: {
                    return FDC.fdcPeekStatus();
                }
                case 15286275: {
                    return FDC.fdcPeekData();
                }
                case 15286277: {
                    return FDC.fdcPeekDriveStatus();
                }
            }
            return 255;
        }

        @Override
        protected int mmdPws(int n) {
            return (short)(this.mmdPbz(n) << 8 | this.mmdPbz(n + 1));
        }

        @Override
        protected int mmdPwz(int n) {
            return this.mmdPbz(n) << 8 | this.mmdPbz(n + 1);
        }

        @Override
        protected int mmdPls(int n) {
            return this.mmdPwz(n) << 16 | this.mmdPwz(n + 2);
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            if ((n & 1) == 0 && !XEiJ.currentIsSecond) {
                return super.mmdRbz(n);
            }
            XEiJ.mpuClockTime += XEiJ.busWaitTime.fdc;
            switch (n &= 0xFFFFFF) {
                case 15286273: {
                    return FDC.fdcReadStatus();
                }
                case 15286275: {
                    return FDC.fdcReadData();
                }
                case 15286277: {
                    return FDC.fdcReadDriveStatus();
                }
            }
            return 255;
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            return 0xFF00 | this.mmdRbz(n + 1);
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            return 0xFF00FF00 | this.mmdRbz(n + 1) << 16 | this.mmdRbz(n + 3);
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            if ((n & 1) == 0 && !XEiJ.currentIsSecond) {
                super.mmdWb(n, n2);
            }
            XEiJ.mpuClockTime += XEiJ.busWaitTime.fdc;
            switch (n &= 0xFFFFFF) {
                case 15286273: {
                    FDC.fdcWriteCommand(n2);
                    break;
                }
                case 15286275: {
                    FDC.fdcWriteData(n2);
                    break;
                }
                case 15286277: {
                    FDC.fdcWriteDriveControl(n2);
                    break;
                }
                case 15286279: {
                    FDC.fdcWriteDriveSelect(n2);
                }
            }
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            this.mmdWb(n + 1, n2);
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            this.mmdWb(n + 1, n2 >> 16);
            this.mmdWb(n + 3, n2);
        }
    }
    ,
    MMD_HDC{

        public String toString() {
            return Multilingual.mlnJapanese ? "\u5185\u8535 SASI/SCSI \u30dd\u30fc\u30c8" : "Internal SASI/SCSI Port";
        }

        @Override
        protected int mmdPbz(int n) {
            if ((n & 1) == 0) {
                return 255;
            }
            if (SPC.spcSCSIINOn) {
                if ((n & 0x20) == 0) {
                    return (n & 2) == 0 ? 0 : 255;
                }
                return SPC.spcSCSIINChip.spiPeek(n);
            }
            switch (n & 0x3F) {
                case 1: {
                    return HDC.hdcPeekData();
                }
                case 3: {
                    return HDC.hdcPeekStatus();
                }
                case 5: {
                    return 255;
                }
                case 7: {
                    return 255;
                }
            }
            return 255;
        }

        @Override
        protected int mmdPwz(int n) {
            return 0xFF00 | this.mmdPbz(n + 1);
        }

        @Override
        protected int mmdPls(int n) {
            return 0xFF00FF00 | this.mmdPbz(n + 1) << 16 | this.mmdPbz(n + 3);
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.hdc;
            if ((n & 1) == 0) {
                if (XEiJ.currentIsSecond) {
                    return 255;
                }
                return super.mmdRbz(n);
            }
            if (SPC.spcSCSIINOn) {
                if ((n & 0x20) == 0) {
                    return (n & 2) == 0 ? 0 : 255;
                }
                return SPC.spcSCSIINChip.spiRead(n);
            }
            switch (n & 0x3F) {
                case 1: {
                    return HDC.hdcReadData();
                }
                case 3: {
                    return HDC.hdcReadStatus();
                }
                case 5: {
                    return 255;
                }
                case 7: {
                    return 255;
                }
            }
            return 255;
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            return 0xFF00 | this.mmdRbz(n + 1);
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            return 0xFF00FF00 | this.mmdRbz(n + 1) << 16 | this.mmdRbz(n + 3);
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.hdc;
            if ((n & 1) == 0) {
                if (XEiJ.currentIsSecond) {
                    return;
                }
            } else {
                if (SPC.spcSCSIINOn) {
                    if ((n & 0x20) == 0) {
                        return;
                    }
                    SPC.spcSCSIINChip.spiWrite(n, n2);
                    return;
                }
                switch (n & 0x3F) {
                    case 1: {
                        HDC.hdcWriteData(n2);
                        return;
                    }
                    case 3: {
                        HDC.hdcWriteCommand(n2);
                        return;
                    }
                    case 5: {
                        HDC.hdcWriteReset(n2);
                        return;
                    }
                    case 7: {
                        HDC.hdcWriteSelect(n2);
                        return;
                    }
                }
                return;
            }
            super.mmdWb(n, n2);
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            this.mmdWb(n + 1, n2);
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            this.mmdWb(n + 1, n2 >> 16);
            this.mmdWb(n + 3, n2);
        }
    }
    ,
    MMD_SCC{

        public String toString() {
            return Multilingual.mlnJapanese ? "SCC" : "SCC";
        }

        @Override
        protected int mmdPbz(int n) {
            return Z8530.sccReadByte(n, true);
        }

        @Override
        protected int mmdPwz(int n) {
            return 0xFF00 | this.mmdPbz(n + 1);
        }

        @Override
        protected int mmdPls(int n) {
            return 0xFF00FF00 | this.mmdPbz(n + 1) << 16 | this.mmdPbz(n + 3);
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            if ((n & 1) == 0 && !XEiJ.currentIsSecond) {
                return super.mmdRbz(n);
            }
            return Z8530.sccReadByte(n, false);
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            return 0xFF00 | this.mmdRbz(n + 1);
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            return 0xFF00FF00 | this.mmdRbz(n + 1) << 16 | this.mmdRbz(n + 3);
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            if ((n & 1) == 0 && !XEiJ.currentIsSecond) {
                super.mmdWb(n, n2);
            }
            Z8530.sccWriteByte(n, n2);
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            this.mmdWb(n + 1, n2);
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            this.mmdWb(n + 1, n2 >> 16);
            this.mmdWb(n + 3, n2);
        }
    }
    ,
    MMD_PPI{

        public String toString() {
            return Multilingual.mlnJapanese ? "PPI" : "PPI";
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            if ((n & 1) == 0 && !XEiJ.currentIsSecond) {
                return super.mmdRbz(n);
            }
            XEiJ.mpuClockTime += XEiJ.busWaitTime.ppi;
            return PPI.ppiReadByte(n);
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            return 0xFF00 | this.mmdRbz(n + 1);
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            return 0xFF00FF00 | this.mmdRbz(n + 1) << 16 | this.mmdRbz(n + 3);
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            if ((n & 1) == 0 && !XEiJ.currentIsSecond) {
                super.mmdWb(n, n2);
            }
            XEiJ.mpuClockTime += XEiJ.busWaitTime.ppi;
            PPI.ppiWriteByte(n, n2);
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            this.mmdWb(n + 1, n2);
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            this.mmdWb(n + 1, n2 >> 16);
            this.mmdWb(n + 3, n2);
        }
    }
    ,
    MMD_IOI{

        public String toString() {
            return Multilingual.mlnJapanese ? "I/O \u5272\u308a\u8fbc\u307f" : "I/O Interrupt";
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            if ((n & 1) == 0 && !XEiJ.currentIsSecond) {
                return super.mmdRbz(n);
            }
            XEiJ.mpuClockTime += XEiJ.busWaitTime.ioi;
            if ((n &= 0xFFFFFF) == 15319041) {
                return IOInterrupt.ioiReadStatus();
            }
            if (n == 15319043) {
                return 255;
            }
            return super.mmdRbz(n);
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            return 0xFF00 | this.mmdRbz(n + 1);
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            return 0xFF00FF00 | this.mmdRbz(n + 1) << 16 | this.mmdRbz(n + 3);
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            if ((n & 1) == 0 && !XEiJ.currentIsSecond) {
                super.mmdWb(n, n2);
            }
            XEiJ.mpuClockTime += XEiJ.busWaitTime.ioi;
            if ((n &= 0xFFFFFF) == 15319041) {
                IOInterrupt.ioiWriteEnable(n2);
            } else if (n == 15319043) {
                IOInterrupt.ioiWriteVector(n2);
            } else {
                super.mmdWb(n, n2);
            }
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            this.mmdWb(n + 1, n2);
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            this.mmdWb(n + 1, n2 >> 16);
            this.mmdWb(n + 3, n2);
        }
    }
    ,
    MMD_XB1{

        public String toString() {
            return Multilingual.mlnJapanese ? "\u62e1\u5f35\u30dc\u30fc\u30c9\u9818\u57df 1" : "Expansion Board Area 1";
        }

        @Override
        protected int mmdPbz(int n) {
            if ((n & 0xFFFFE0) == 0xE9E000) {
                if ((7 & XEiJ.currentCopro1) != 0) {
                    return XEiJ.fpuCoproboard1.cirPeekByteZero(n);
                }
                return 255;
            }
            if ((n & 0xFFFFE0) == 15327360) {
                if ((7 & XEiJ.currentCopro2) != 0) {
                    return XEiJ.fpuCoproboard2.cirPeekByteZero(n);
                }
                return 255;
            }
            if ((n & 0xFFFFE0) == 15331360) {
                return MainMemory.mmrM8[n &= 0xFFFFFF] & 0xFF;
            }
            if ((n & 0xFFFFF0) == 15331392) {
                return Keyboard.kbdZKeyIOReadByte(n);
            }
            return 255;
        }

        @Override
        protected int mmdPwz(int n) {
            if ((n & 0xFFFFE0) == 0xE9E000) {
                if ((7 & XEiJ.currentCopro1) != 0) {
                    return XEiJ.fpuCoproboard1.cirPeekWordZero(n);
                }
                return 65535;
            }
            if ((n & 0xFFFFE0) == 15327360) {
                if ((7 & XEiJ.currentCopro2) != 0) {
                    return XEiJ.fpuCoproboard2.cirPeekWordZero(n);
                }
                return 65535;
            }
            if ((n & 0xFFFFE0) == 15331360) {
                return (char)(MainMemory.mmrM8[n &= 0xFFFFFF] << 8 | MainMemory.mmrM8[n + 1] & 0xFF);
            }
            if ((n & 0xFFFFF0) == 15331392) {
                return Keyboard.kbdZKeyIOReadWord(n);
            }
            return 65535;
        }

        @Override
        protected int mmdPls(int n) {
            if ((n & 0xFFFFE0) == 0xE9E000) {
                if ((7 & XEiJ.currentCopro1) != 0) {
                    return XEiJ.fpuCoproboard1.cirPeekLong(n);
                }
                return -1;
            }
            if ((n & 0xFFFFE0) == 15327360) {
                if ((7 & XEiJ.currentCopro2) != 0) {
                    return XEiJ.fpuCoproboard2.cirPeekLong(n);
                }
                return -1;
            }
            if ((n & 0xFFFFE0) == 15331360) {
                return MainMemory.mmrM8[n &= 0xFFFFFF] << 24 | (MainMemory.mmrM8[n + 1] & 0xFF) << 16 | (char)(MainMemory.mmrM8[n + 2] << 8 | MainMemory.mmrM8[n + 3] & 0xFF);
            }
            if ((n & 0xFFFFF0) == 15331392) {
                return Keyboard.kbdZKeyIOReadLong(n);
            }
            return -1;
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            if ((n & 0xFFFFE0) == 0xE9E000) {
                if ((7 & XEiJ.currentCopro1) != 0) {
                    return XEiJ.fpuCoproboard1.cirReadByteZero(n);
                }
                return super.mmdRbz(n);
            }
            if ((n & 0xFFFFE0) == 15327360) {
                if ((7 & XEiJ.currentCopro2) != 0) {
                    return XEiJ.fpuCoproboard2.cirReadByteZero(n);
                }
                return super.mmdRbz(n);
            }
            if ((n & 0xFFFFE0) == 15331360) {
                return MainMemory.mmrM8[n &= 0xFFFFFF] & 0xFF;
            }
            if ((n & 0xFFFFF0) == 15331392) {
                return Keyboard.kbdZKeyIOReadByte(n);
            }
            return super.mmdRbz(n);
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            if ((n & 0xFFFFE0) == 0xE9E000) {
                if ((7 & XEiJ.currentCopro1) != 0) {
                    return XEiJ.fpuCoproboard1.cirReadWordZero(n);
                }
                return super.mmdRwz(n);
            }
            if ((n & 0xFFFFE0) == 15327360) {
                if ((7 & XEiJ.currentCopro2) != 0) {
                    return XEiJ.fpuCoproboard2.cirReadWordZero(n);
                }
                return super.mmdRwz(n);
            }
            if ((n & 0xFFFFE0) == 15331360) {
                return (char)(MainMemory.mmrM8[n &= 0xFFFFFF] << 8 | MainMemory.mmrM8[n + 1] & 0xFF);
            }
            if ((n & 0xFFFFF0) == 15331392) {
                return Keyboard.kbdZKeyIOReadWord(n);
            }
            return super.mmdRwz(n);
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            if ((n & 0xFFFFE0) == 0xE9E000) {
                if ((7 & XEiJ.currentCopro1) != 0) {
                    return XEiJ.fpuCoproboard1.cirReadLong(n);
                }
                return super.mmdRls(n);
            }
            if ((n & 0xFFFFE0) == 15327360) {
                if ((7 & XEiJ.currentCopro2) != 0) {
                    return XEiJ.fpuCoproboard2.cirReadLong(n);
                }
                return super.mmdRls(n);
            }
            if ((n & 0xFFFFE0) == 15331360) {
                return MainMemory.mmrM8[n &= 0xFFFFFF] << 24 | (MainMemory.mmrM8[n + 1] & 0xFF) << 16 | (char)(MainMemory.mmrM8[n + 2] << 8 | MainMemory.mmrM8[n + 3] & 0xFF);
            }
            if ((n & 0xFFFFF0) == 15331392) {
                return Keyboard.kbdZKeyIOReadLong(n);
            }
            return super.mmdRls(n);
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            if ((n & 0xFFFFE0) == 0xE9E000) {
                if ((7 & XEiJ.currentCopro1) != 0) {
                    XEiJ.fpuCoproboard1.cirWriteByte(n, n2);
                    return;
                }
                super.mmdWb(n, n2);
                return;
            }
            if ((n & 0xFFFFE0) == 15327360) {
                if ((7 & XEiJ.currentCopro2) != 0) {
                    XEiJ.fpuCoproboard2.cirWriteByte(n, n2);
                    return;
                }
                super.mmdWb(n, n2);
                return;
            }
            if ((n & 0xFFFFF0) == 15331392) {
                Keyboard.kbdZKeyIOWriteByte(n, n2);
                return;
            }
            super.mmdWb(n, n2);
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            if ((n & 0xFFFFE0) == 0xE9E000) {
                if ((7 & XEiJ.currentCopro1) != 0) {
                    XEiJ.fpuCoproboard1.cirWriteWord(n, n2);
                    return;
                }
                super.mmdWw(n, n2);
                return;
            }
            if ((n & 0xFFFFE0) == 15327360) {
                if ((7 & XEiJ.currentCopro2) != 0) {
                    XEiJ.fpuCoproboard2.cirWriteWord(n, n2);
                    return;
                }
                super.mmdWw(n, n2);
                return;
            }
            if ((n & 0xFFFFF0) == 15331392) {
                Keyboard.kbdZKeyIOWriteWord(n, n2);
                return;
            }
            super.mmdWw(n, n2);
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            if ((n & 0xFFFFE0) == 0xE9E000) {
                if ((7 & XEiJ.currentCopro1) != 0) {
                    XEiJ.fpuCoproboard1.cirWriteLong(n, n2);
                    return;
                }
                super.mmdWl(n, n2);
                return;
            }
            if ((n & 0xFFFFE0) == 15327360) {
                if ((7 & XEiJ.currentCopro2) != 0) {
                    XEiJ.fpuCoproboard2.cirWriteLong(n, n2);
                    return;
                }
                super.mmdWl(n, n2);
                return;
            }
            if ((n & 0xFFFFF0) == 15331392) {
                Keyboard.kbdZKeyIOWriteLong(n, n2);
                return;
            }
            super.mmdWl(n, n2);
        }
    }
    ,
    MMD_EXS{

        public String toString() {
            return Multilingual.mlnJapanese ? "\u62e1\u5f35 SCSI \u30dd\u30fc\u30c8" : "Expansion SCSI Port";
        }

        @Override
        protected int mmdPbz(int n) {
            if ((n & 0xFFFFE0) == 0xEA0000) {
                if ((n & 1) == 0) {
                    return 255;
                }
                return SPC.spcSCSIEXChip.spiPeek(n);
            }
            return 0xFF & MainMemory.mmrM8[n];
        }

        @Override
        protected int mmdPwz(int n) {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.hdc;
            if ((n & 0xFFFFE0) == 0xEA0000) {
                return 0xFF00 | SPC.spcSCSIEXChip.spiPeek(n + 1);
            }
            return (0xFF & MainMemory.mmrM8[n]) << 8 | 0xFF & MainMemory.mmrM8[n + 1];
        }

        @Override
        protected int mmdPls(int n) {
            return this.mmdPwz(n) << 16 | this.mmdPwz(n + 2);
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.hdc;
            if ((n & 0xFFFFE0) == 0xEA0000) {
                if ((n & 1) == 0) {
                    if (XEiJ.currentIsSecond) {
                        return 255;
                    }
                    return super.mmdRbz(n);
                }
                return SPC.spcSCSIEXChip.spiRead(n);
            }
            return 0xFF & MainMemory.mmrM8[n];
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.hdc;
            if ((n & 0xFFFFE0) == 0xEA0000) {
                return 0xFF00 | SPC.spcSCSIEXChip.spiRead(n + 1);
            }
            return (0xFF & MainMemory.mmrM8[n]) << 8 | 0xFF & MainMemory.mmrM8[n + 1];
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            return this.mmdRwz(n) << 16 | this.mmdRwz(n + 2);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.hdc;
            if ((n & 0xFFFFE0) != 0xEA0000) {
                super.mmdWb(n, n2);
                return;
            }
            if ((n & 1) != 0) {
                SPC.spcSCSIEXChip.spiWrite(n, n2);
                return;
            }
            if (XEiJ.currentIsSecond) {
                return;
            }
            super.mmdWb(n, n2);
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.hdc;
            if ((n & 0xFFFFE0) == 0xEA0000) {
                SPC.spcSCSIEXChip.spiWrite(n + 1, n2);
                return;
            }
            super.mmdWw(n, n2);
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            this.mmdWw(n, n2 >> 16);
            this.mmdWw(n + 2, n2);
        }
    }
    ,
    MMD_XB2{

        public String toString() {
            return Multilingual.mlnJapanese ? "\u62e1\u5f35\u30dc\u30fc\u30c9\u9818\u57df 2" : "Expansion Board Area 2";
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            if (15400833 <= (n &= 0xFFFFFF) && n <= 15400841 && (n & 1) != 0) {
                return MainMemory.mmrM8[n] & 0xFF;
            }
            if (XEiJ.bnkOn && n == 15400831) {
                return XEiJ.bnkPageStart >> 17;
            }
            return super.mmdRbz(n);
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            if (15400833 <= (n &= 0xFFFFFF) && n <= 15400841 && (n & 1) != 0) {
                MainMemory.mmrM8[n] = (byte)n2;
                n = (n & 0xE) + 2 << 20;
                for (int i = 1; i <= 128; i <<= 1) {
                    if ((n2 & i) == 0) {
                        XEiJ.busUser(MMD_MMR, n, n + 262144);
                    } else {
                        XEiJ.busSuper(MMD_MMR, n, n + 262144);
                    }
                    n += 262144;
                }
                return;
            }
            if (XEiJ.bnkOn && n == 15400831) {
                XEiJ.bnkPageStart = (n2 & 0xFF) << 17;
                return;
            }
            super.mmdWb(n, n2);
        }
    }
    ,
    MMD_SPR{

        public String toString() {
            return Multilingual.mlnJapanese ? "\u30b9\u30d7\u30e9\u30a4\u30c8\u753b\u9762" : "Sprite Screen";
        }

        @Override
        protected byte mmdRbs(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.sprc;
            return (byte)SpriteScreen.sprReadByte(n);
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.sprc;
            return SpriteScreen.sprReadByte(n);
        }

        @Override
        protected int mmdRws(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.sprc;
            return (short)SpriteScreen.sprReadWord(n);
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.sprc;
            return SpriteScreen.sprReadWord(n);
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.sprc * 2L;
            return SpriteScreen.sprReadLong(n);
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.sprc;
            SpriteScreen.sprWriteByte(n, n2);
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.sprc;
            SpriteScreen.sprWriteWord(n, n2);
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.sprc * 2L;
            SpriteScreen.sprWriteLong(n, n2);
        }
    }
    ,
    MMD_XB3{

        public String toString() {
            return Multilingual.mlnJapanese ? "\u62e1\u5f35\u30dc\u30fc\u30c9\u9818\u57df 3" : "Expansion Board Area 3";
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            if (XEiJ.currentAccelerator == 2 && XEiJ.xt3PortAddress <= (n &= 0xFFFFFF) && n < XEiJ.xt3PortAddress + 16384) {
                return (n & 1) == 0 ? 0 : XEiJ.xt3PortRead();
            }
            return super.mmdRbz(n);
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            if (XEiJ.currentAccelerator == 2 && XEiJ.xt3PortAddress <= (n &= 0xFFFFFF) && n < XEiJ.xt3PortAddress + 16384) {
                return XEiJ.xt3PortRead();
            }
            return super.mmdRwz(n);
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            if (XEiJ.currentAccelerator == 2 && XEiJ.xt3PortAddress <= (n &= 0xFFFFFF) && n < XEiJ.xt3PortAddress + 16384) {
                return XEiJ.xt3PortRead() << 16 | XEiJ.xt3PortRead();
            }
            return super.mmdRls(n);
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            if (XEiJ.currentAccelerator == 2 && XEiJ.xt3PortAddress <= (n &= 0xFFFFFF) && n < XEiJ.xt3PortAddress + 16384) {
                if ((n & 1) != 0) {
                    XEiJ.xt3PortWrite(n2);
                }
                return;
            }
            super.mmdWb(n, n2);
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            if (XEiJ.currentAccelerator == 2 && XEiJ.xt3PortAddress <= (n &= 0xFFFFFF) && n < XEiJ.xt3PortAddress + 16384) {
                XEiJ.xt3PortWrite(n2);
                return;
            }
            super.mmdWw(n, n2);
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            if (XEiJ.currentAccelerator == 2 && XEiJ.xt3PortAddress <= (n &= 0xFFFFFF) && n < XEiJ.xt3PortAddress + 16384) {
                XEiJ.xt3PortWrite(n2 >> 16);
                XEiJ.xt3PortWrite(n2);
                return;
            }
            super.mmdWl(n, n2);
        }
    }
    ,
    MMD_XTM{

        public String toString() {
            return Multilingual.mlnJapanese ? "Xellent30 \u306e SRAM" : "SRAM on Xellent30";
        }

        @Override
        protected byte mmdPbs(int n) {
            return XEiJ.xt3MemoryArray[n -= XEiJ.xt3MemoryPosition];
        }

        @Override
        protected int mmdPbz(int n) {
            return XEiJ.xt3MemoryArray[n -= XEiJ.xt3MemoryPosition] & 0xFF;
        }

        @Override
        protected int mmdPws(int n) {
            return XEiJ.xt3MemoryArray[n -= XEiJ.xt3MemoryPosition] << 8 | XEiJ.xt3MemoryArray[n + 1] & 0xFF;
        }

        @Override
        protected int mmdPwz(int n) {
            return (char)(XEiJ.xt3MemoryArray[n -= XEiJ.xt3MemoryPosition] << 8 | XEiJ.xt3MemoryArray[n + 1] & 0xFF);
        }

        @Override
        protected int mmdPls(int n) {
            return XEiJ.xt3MemoryArray[n -= XEiJ.xt3MemoryPosition] << 24 | (XEiJ.xt3MemoryArray[n + 1] & 0xFF) << 16 | (char)(XEiJ.xt3MemoryArray[n + 2] << 8 | XEiJ.xt3MemoryArray[n + 3] & 0xFF);
        }

        @Override
        protected byte mmdRbs(int n) throws M68kException {
            return XEiJ.xt3MemoryArray[n -= XEiJ.xt3MemoryPosition];
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            return XEiJ.xt3MemoryArray[n -= XEiJ.xt3MemoryPosition] & 0xFF;
        }

        @Override
        protected int mmdRws(int n) throws M68kException {
            return XEiJ.xt3MemoryArray[n -= XEiJ.xt3MemoryPosition] << 8 | XEiJ.xt3MemoryArray[n + 1] & 0xFF;
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            return (char)(XEiJ.xt3MemoryArray[n -= XEiJ.xt3MemoryPosition] << 8 | XEiJ.xt3MemoryArray[n + 1] & 0xFF);
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            return XEiJ.xt3MemoryArray[n -= XEiJ.xt3MemoryPosition] << 24 | (XEiJ.xt3MemoryArray[n + 1] & 0xFF) << 16 | (char)(XEiJ.xt3MemoryArray[n + 2] << 8 | XEiJ.xt3MemoryArray[n + 3] & 0xFF);
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            XEiJ.xt3MemoryArray[n -= XEiJ.xt3MemoryPosition] = (byte)n2;
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            XEiJ.xt3MemoryArray[n -= XEiJ.xt3MemoryPosition] = (byte)(n2 >> 8);
            XEiJ.xt3MemoryArray[n + 1] = (byte)n2;
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            XEiJ.xt3MemoryArray[n -= XEiJ.xt3MemoryPosition] = (byte)(n2 >> 24);
            XEiJ.xt3MemoryArray[n + 1] = (byte)(n2 >> 16);
            XEiJ.xt3MemoryArray[n + 2] = (byte)(n2 >> 8);
            XEiJ.xt3MemoryArray[n + 3] = (byte)n2;
        }
    }
    ,
    MMD_SMR{

        public String toString() {
            return Multilingual.mlnJapanese ? "SRAM" : "SRAM";
        }

        @Override
        protected byte mmdPbs(int n) {
            return MainMemory.mmrM8[n &= 0xFFFFFF];
        }

        @Override
        protected int mmdPbz(int n) {
            return MainMemory.mmrM8[n &= 0xFFFFFF] & 0xFF;
        }

        @Override
        protected int mmdPws(int n) {
            return MainMemory.mmrM8[n &= 0xFFFFFF] << 8 | MainMemory.mmrM8[n + 1] & 0xFF;
        }

        @Override
        protected int mmdPwz(int n) {
            return (char)(MainMemory.mmrM8[n &= 0xFFFFFF] << 8 | MainMemory.mmrM8[n + 1] & 0xFF);
        }

        @Override
        protected int mmdPls(int n) {
            return MainMemory.mmrM8[n &= 0xFFFFFF] << 24 | (MainMemory.mmrM8[n + 1] & 0xFF) << 16 | (char)(MainMemory.mmrM8[n + 2] << 8 | MainMemory.mmrM8[n + 3] & 0xFF);
        }

        @Override
        protected byte mmdRbs(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.sram;
            XEiJ.mpuClockTime += XEiJ.busWaitTime.sram;
            return MainMemory.mmrM8[n &= 0xFFFFFF];
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.sram;
            XEiJ.mpuClockTime += XEiJ.busWaitTime.sram;
            return MainMemory.mmrM8[n &= 0xFFFFFF] & 0xFF;
        }

        @Override
        protected int mmdRws(int n) throws M68kException {
            return (short)this.mmdRwz(n);
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.sram;
            XEiJ.mpuClockTime += XEiJ.busWaitTime.sram;
            char c = (char)(MainMemory.mmrM8[n &= 0xFFFFFF] << 8 | MainMemory.mmrM8[n + 1] & 0xFF);
            return c;
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.sram * 2L;
            XEiJ.mpuClockTime += XEiJ.busWaitTime.sram * 2L;
            int n2 = MainMemory.mmrM8[n &= 0xFFFFFF] << 24 | (MainMemory.mmrM8[n + 1] & 0xFF) << 16 | (char)(MainMemory.mmrM8[n + 2] << 8 | MainMemory.mmrM8[n + 3] & 0xFF);
            return n2;
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.sram;
            if (SRAM.smrWriteEnableOn) {
                XEiJ.mpuClockTime += XEiJ.busWaitTime.sram;
                MainMemory.mmrM8[n &= 0xFFFFFF] = (byte)n2;
                if (n == 15532075 || n == 15532121) {
                    Keyboard.kbdRepaint();
                } else if (n == 15532122 && 0xFE0000 <= XEiJ.regPC0 && XEiJ.regPC0 <= 0xFFFFFF) {
                    SRAM.smrOverride();
                }
            } else {
                System.out.printf("%08X writing $%02X to $%08X in a write-protected state\n", XEiJ.regPC0, n2 & 0xFF, n);
                if (SRAM.smrSRAMBusErrorOn) {
                    super.mmdWb(n, n2);
                }
            }
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.sram;
            if (SRAM.smrWriteEnableOn) {
                XEiJ.mpuClockTime += XEiJ.busWaitTime.sram;
                MainMemory.mmrM8[n &= 0xFFFFFF] = (byte)(n2 >> 8);
                MainMemory.mmrM8[n + 1] = (byte)n2;
                if (n == 15532074 || n == 15532120) {
                    Keyboard.kbdRepaint();
                }
            } else {
                System.out.printf("%08X writing $%04X to $%08X in a write-protected state\n", XEiJ.regPC0, n2 & 0xFFFF, n);
                if (SRAM.smrSRAMBusErrorOn) {
                    super.mmdWw(n, n2);
                }
            }
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            if (SRAM.smrWriteEnableOn) {
                this.mmdWw(n, n2 >> 16);
                this.mmdWw(n + 2, n2);
            } else {
                System.out.printf("%08X writing $%08X to $%08X in a write-protected state\n", XEiJ.regPC0, n2, n);
                if (SRAM.smrSRAMBusErrorOn) {
                    super.mmdWl(n, n2);
                }
            }
        }
    }
    ,
    MMD_XB4{

        public String toString() {
            return Multilingual.mlnJapanese ? "\u62e1\u5f35\u30dc\u30fc\u30c9\u9818\u57df 4" : "Expansion Board Area 4";
        }

        @Override
        protected byte mmdRbs(int n) throws M68kException {
            if (XEiJ.bnkOn) {
                n &= 0xFFFFFF;
                n = XEiJ.bnkPageStart + (n - 0xEE0000);
                return XEiJ.bnkMemory[n];
            }
            return super.mmdRbs(n);
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            if (XEiJ.bnkOn) {
                n &= 0xFFFFFF;
                n = XEiJ.bnkPageStart + (n - 0xEE0000);
                return XEiJ.bnkMemory[n] & 0xFF;
            }
            return super.mmdRbz(n);
        }

        @Override
        protected int mmdRws(int n) throws M68kException {
            if (XEiJ.bnkOn) {
                n &= 0xFFFFFF;
                n = XEiJ.bnkPageStart + (n - 0xEE0000);
                return XEiJ.bnkMemory[n] << 8 | XEiJ.bnkMemory[n + 1] & 0xFF;
            }
            return super.mmdRws(n);
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            if (XEiJ.bnkOn) {
                n &= 0xFFFFFF;
                n = XEiJ.bnkPageStart + (n - 0xEE0000);
                return (XEiJ.bnkMemory[n] & 0xFF) << 8 | XEiJ.bnkMemory[n + 1] & 0xFF;
            }
            return super.mmdRwz(n);
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            if (XEiJ.bnkOn) {
                n &= 0xFFFFFF;
                n = XEiJ.bnkPageStart + (n - 0xEE0000);
                return XEiJ.bnkMemory[n] << 24 | (XEiJ.bnkMemory[n + 1] & 0xFF) << 16 | (XEiJ.bnkMemory[n + 2] & 0xFF) << 8 | XEiJ.bnkMemory[n + 3] & 0xFF;
            }
            return super.mmdRls(n);
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            if (XEiJ.bnkOn) {
                n &= 0xFFFFFF;
                n = XEiJ.bnkPageStart + (n - 0xEE0000);
                XEiJ.bnkMemory[n] = (byte)n2;
                return;
            }
            super.mmdWb(n, n2);
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            if (XEiJ.bnkOn) {
                n &= 0xFFFFFF;
                n = XEiJ.bnkPageStart + (n - 0xEE0000);
                XEiJ.bnkMemory[n] = (byte)(n2 >> 8);
                XEiJ.bnkMemory[n + 1] = (byte)n2;
                return;
            }
            super.mmdWw(n, n2);
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            if (XEiJ.bnkOn) {
                n &= 0xFFFFFF;
                n = XEiJ.bnkPageStart + (n - 0xEE0000);
                XEiJ.bnkMemory[n] = (byte)(n2 >> 24);
                XEiJ.bnkMemory[n + 1] = (byte)(n2 >> 16);
                XEiJ.bnkMemory[n + 2] = (byte)(n2 >> 8);
                XEiJ.bnkMemory[n + 3] = (byte)n2;
                return;
            }
            super.mmdWl(n, n2);
        }
    }
    ,
    MMD_CG1{

        public String toString() {
            return Multilingual.mlnJapanese ? "CGROM" : "CGROM";
        }

        @Override
        protected byte mmdPbs(int n) {
            return MainMemory.mmrM8[n &= 0xFFFFFF];
        }

        @Override
        protected int mmdPbz(int n) {
            return MainMemory.mmrM8[n &= 0xFFFFFF] & 0xFF;
        }

        @Override
        protected int mmdPws(int n) {
            return MainMemory.mmrM8[n &= 0xFFFFFF] << 8 | MainMemory.mmrM8[n + 1] & 0xFF;
        }

        @Override
        protected int mmdPwz(int n) {
            return (char)(MainMemory.mmrM8[n &= 0xFFFFFF] << 8 | MainMemory.mmrM8[n + 1] & 0xFF);
        }

        @Override
        protected int mmdPls(int n) {
            return MainMemory.mmrM8[n &= 0xFFFFFF] << 24 | (MainMemory.mmrM8[n + 1] & 0xFF) << 16 | (char)(MainMemory.mmrM8[n + 2] << 8 | MainMemory.mmrM8[n + 3] & 0xFF);
        }

        @Override
        protected byte mmdRbs(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rom;
            return MainMemory.mmrM8[n &= 0xFFFFFF];
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rom;
            return MainMemory.mmrM8[n &= 0xFFFFFF] & 0xFF;
        }

        @Override
        protected int mmdRws(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rom;
            return MainMemory.mmrM8[n &= 0xFFFFFF] << 8 | MainMemory.mmrM8[n + 1] & 0xFF;
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rom;
            return (char)(MainMemory.mmrM8[n &= 0xFFFFFF] << 8 | MainMemory.mmrM8[n + 1] & 0xFF);
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.romlong;
            return MainMemory.mmrM8[n &= 0xFFFFFF] << 24 | (MainMemory.mmrM8[n + 1] & 0xFF) << 16 | (char)(MainMemory.mmrM8[n + 2] << 8 | MainMemory.mmrM8[n + 3] & 0xFF);
        }
    }
    ,
    MMD_CG2{

        public String toString() {
            return Multilingual.mlnJapanese ? "CGROM" : "CGROM";
        }

        @Override
        protected byte mmdPbs(int n) {
            return MainMemory.mmrM8[n &= 0xFFFFFF];
        }

        @Override
        protected int mmdPbz(int n) {
            return MainMemory.mmrM8[n &= 0xFFFFFF] & 0xFF;
        }

        @Override
        protected int mmdPws(int n) {
            return MainMemory.mmrM8[n &= 0xFFFFFF] << 8 | MainMemory.mmrM8[n + 1] & 0xFF;
        }

        @Override
        protected int mmdPwz(int n) {
            return (char)(MainMemory.mmrM8[n &= 0xFFFFFF] << 8 | MainMemory.mmrM8[n + 1] & 0xFF);
        }

        @Override
        protected int mmdPls(int n) {
            return MainMemory.mmrM8[n &= 0xFFFFFF] << 24 | (MainMemory.mmrM8[n + 1] & 0xFF) << 16 | (char)(MainMemory.mmrM8[n + 2] << 8 | MainMemory.mmrM8[n + 3] & 0xFF);
        }

        @Override
        protected byte mmdRbs(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rom;
            return MainMemory.mmrM8[n &= 0xFFFFFF];
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rom;
            return MainMemory.mmrM8[n &= 0xFFFFFF] & 0xFF;
        }

        @Override
        protected int mmdRws(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rom;
            return MainMemory.mmrM8[n &= 0xFFFFFF] << 8 | MainMemory.mmrM8[n + 1] & 0xFF;
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rom;
            return (char)(MainMemory.mmrM8[n &= 0xFFFFFF] << 8 | MainMemory.mmrM8[n + 1] & 0xFF);
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.romlong;
            return MainMemory.mmrM8[n &= 0xFFFFFF] << 24 | (MainMemory.mmrM8[n + 1] & 0xFF) << 16 | (char)(MainMemory.mmrM8[n + 2] << 8 | MainMemory.mmrM8[n + 3] & 0xFF);
        }
    }
    ,
    MMD_ROM{

        public String toString() {
            return Multilingual.mlnJapanese ? "ROM" : "ROM";
        }

        @Override
        protected byte mmdPbs(int n) {
            return MainMemory.mmrM8[n &= 0xFFFFFF];
        }

        @Override
        protected int mmdPbz(int n) {
            return MainMemory.mmrM8[n &= 0xFFFFFF] & 0xFF;
        }

        @Override
        protected int mmdPws(int n) {
            return MainMemory.mmrM8[n &= 0xFFFFFF] << 8 | MainMemory.mmrM8[n + 1] & 0xFF;
        }

        @Override
        protected int mmdPwz(int n) {
            return (char)(MainMemory.mmrM8[n &= 0xFFFFFF] << 8 | MainMemory.mmrM8[n + 1] & 0xFF);
        }

        @Override
        protected int mmdPls(int n) {
            return MainMemory.mmrM8[n &= 0xFFFFFF] << 24 | (MainMemory.mmrM8[n + 1] & 0xFF) << 16 | (char)(MainMemory.mmrM8[n + 2] << 8 | MainMemory.mmrM8[n + 3] & 0xFF);
        }

        @Override
        protected byte mmdRbs(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rom;
            return MainMemory.mmrM8[n &= 0xFFFFFF];
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rom;
            return MainMemory.mmrM8[n &= 0xFFFFFF] & 0xFF;
        }

        @Override
        protected int mmdRws(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rom;
            return MainMemory.mmrM8[n &= 0xFFFFFF] << 8 | MainMemory.mmrM8[n + 1] & 0xFF;
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.rom;
            return (char)(MainMemory.mmrM8[n &= 0xFFFFFF] << 8 | MainMemory.mmrM8[n + 1] & 0xFF);
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            XEiJ.mpuClockTime += XEiJ.busWaitTime.romlong;
            return MainMemory.mmrM8[n &= 0xFFFFFF] << 24 | (MainMemory.mmrM8[n + 1] & 0xFF) << 16 | (char)(MainMemory.mmrM8[n + 2] << 8 | MainMemory.mmrM8[n + 3] & 0xFF);
        }
    }
    ,
    MMD_IBP{

        public String toString() {
            return Multilingual.mlnJapanese ? "\u547d\u4ee4\u30d6\u30ec\u30fc\u30af\u30dd\u30a4\u30f3\u30c8" : "Instruction Break Point";
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            InstructionBreakPoint.InstructionBreakRecord[] instructionBreakRecordArray = InstructionBreakPoint.ibpHashTable;
            InstructionBreakPoint.InstructionBreakRecord instructionBreakRecord = instructionBreakRecordArray[n >> 1 & 0xFF];
            while (instructionBreakRecord != null) {
                if (instructionBreakRecord.ibrPhysicalAddress == n) {
                    if (instructionBreakRecord.ibrValue == instructionBreakRecord.ibrTarget) {
                        if (instructionBreakRecord.ibrThreshold < 0) {
                            InstructionBreakPoint.ibpRemove(instructionBreakRecord.ibrLogicalAddress, XEiJ.regSRS);
                            XEiJ.mpuContinue = true;
                        } else if (instructionBreakRecord.ibrTarget < instructionBreakRecord.ibrThreshold) {
                            instructionBreakRecord.ibrTarget = instructionBreakRecord.ibrThreshold;
                            XEiJ.mpuContinue = true;
                        } else {
                            if (instructionBreakRecord.ibrScriptElement != null && instructionBreakRecord.ibrScriptElement.exlEval((int)1).exlFloatValue.iszero()) break;
                            ++instructionBreakRecord.ibrTarget;
                            XEiJ.mpuContinue = false;
                        }
                        M68kException.m6eNumber = -1;
                        throw M68kException.m6eSignal;
                    }
                    if (instructionBreakRecord.ibrWaitInstruction != null) {
                        WaitInstruction.instruction = instructionBreakRecord.ibrWaitInstruction;
                        return 19973;
                    }
                    ++instructionBreakRecord.ibrValue;
                    break;
                }
                instructionBreakRecord = instructionBreakRecord.ibrNext;
            }
            return DataBreakPoint.dbpMemoryMap[n >>> 12].mmdRwz(n);
        }
    }
    ,
    MMD_DBP{

        public String toString() {
            return Multilingual.mlnJapanese ? "\u30c7\u30fc\u30bf\u30d6\u30ec\u30fc\u30af\u30dd\u30a4\u30f3\u30c8" : "Data Break Point";
        }

        @Override
        protected byte mmdPbs(int n) {
            return (XEiJ.regSRS != 0 ? XEiJ.busSuperMap : XEiJ.busUserMap)[n >>> 12].mmdPbs(n);
        }

        @Override
        protected int mmdPbz(int n) {
            return (XEiJ.regSRS != 0 ? XEiJ.busSuperMap : XEiJ.busUserMap)[n >>> 12].mmdPbz(n);
        }

        @Override
        protected int mmdPws(int n) {
            return (XEiJ.regSRS != 0 ? XEiJ.busSuperMap : XEiJ.busUserMap)[n >>> 12].mmdPws(n);
        }

        @Override
        protected int mmdPwz(int n) {
            return (XEiJ.regSRS != 0 ? XEiJ.busSuperMap : XEiJ.busUserMap)[n >>> 12].mmdPwz(n);
        }

        @Override
        protected int mmdPls(int n) {
            return (XEiJ.regSRS != 0 ? XEiJ.busSuperMap : XEiJ.busUserMap)[n >>> 12].mmdPls(n);
        }

        @Override
        protected byte mmdRbs(int n) throws M68kException {
            byte by = (XEiJ.regSRS != 0 ? XEiJ.busSuperMap : XEiJ.busUserMap)[n >>> 12].mmdRbs(n);
            DataBreakPoint.dbpBreak(0, n, by, false);
            return by;
        }

        @Override
        protected int mmdRbz(int n) throws M68kException {
            int n2 = (XEiJ.regSRS != 0 ? XEiJ.busSuperMap : XEiJ.busUserMap)[n >>> 12].mmdRbz(n);
            DataBreakPoint.dbpBreak(0, n, n2, false);
            return n2;
        }

        @Override
        protected int mmdRws(int n) throws M68kException {
            int n2 = (XEiJ.regSRS != 0 ? XEiJ.busSuperMap : XEiJ.busUserMap)[n >>> 12].mmdRws(n);
            DataBreakPoint.dbpBreak(1, n, n2, false);
            return n2;
        }

        @Override
        protected int mmdRwz(int n) throws M68kException {
            int n2 = (XEiJ.regSRS != 0 ? XEiJ.busSuperMap : XEiJ.busUserMap)[n >>> 12].mmdRwz(n);
            DataBreakPoint.dbpBreak(1, n, n2, false);
            return n2;
        }

        @Override
        protected int mmdRls(int n) throws M68kException {
            int n2 = (XEiJ.regSRS != 0 ? XEiJ.busSuperMap : XEiJ.busUserMap)[n >>> 12].mmdRls(n);
            DataBreakPoint.dbpBreak(2, n, n2, false);
            return n2;
        }

        @Override
        protected void mmdWb(int n, int n2) throws M68kException {
            (XEiJ.regSRS != 0 ? XEiJ.busSuperMap : XEiJ.busUserMap)[n >>> 12].mmdWb(n, n2);
            DataBreakPoint.dbpBreak(0, n, n2, true);
        }

        @Override
        protected void mmdWw(int n, int n2) throws M68kException {
            (XEiJ.regSRS != 0 ? XEiJ.busSuperMap : XEiJ.busUserMap)[n >>> 12].mmdWw(n, n2);
            DataBreakPoint.dbpBreak(1, n, n2, true);
        }

        @Override
        protected void mmdWl(int n, int n2) throws M68kException {
            (XEiJ.regSRS != 0 ? XEiJ.busSuperMap : XEiJ.busUserMap)[n >>> 12].mmdWl(n, n2);
            DataBreakPoint.dbpBreak(2, n, n2, true);
        }
    }
    ,
    MMD_NUL{

        public String toString() {
            return Multilingual.mlnJapanese ? "\u30cc\u30eb\u30c7\u30d0\u30a4\u30b9" : "Null Device";
        }
    };


    protected byte mmdPbs(int n) {
        return (byte)this.mmdPbz(n);
    }

    protected int mmdPbz(int n) {
        try {
            return this.mmdRbz(n);
        }
        catch (M68kException m68kException) {
            return 255;
        }
    }

    protected int mmdPws(int n) {
        return (short)this.mmdPwz(n);
    }

    protected int mmdPwz(int n) {
        try {
            return this.mmdRwz(n);
        }
        catch (M68kException m68kException) {
            return 65535;
        }
    }

    protected int mmdPls(int n) {
        try {
            return this.mmdRls(n);
        }
        catch (M68kException m68kException) {
            return -1;
        }
    }

    protected byte mmdRbs(int n) throws M68kException {
        return (byte)this.mmdRbz(n);
    }

    protected int mmdRbz(int n) throws M68kException {
        MC68060.m60BusErrorOnRead();
        M68kException.m6eNumber = 2;
        M68kException.m6eAddress = n;
        M68kException.m6eDirection = 1;
        M68kException.m6eSize = 0;
        throw M68kException.m6eSignal;
    }

    protected int mmdRws(int n) throws M68kException {
        return (short)this.mmdRwz(n);
    }

    protected int mmdRwz(int n) throws M68kException {
        MC68060.m60BusErrorOnRead();
        M68kException.m6eNumber = 2;
        M68kException.m6eAddress = n;
        M68kException.m6eDirection = 1;
        M68kException.m6eSize = 1;
        throw M68kException.m6eSignal;
    }

    protected int mmdRls(int n) throws M68kException {
        MC68060.m60BusErrorOnRead();
        M68kException.m6eNumber = 2;
        M68kException.m6eAddress = n;
        M68kException.m6eDirection = 1;
        M68kException.m6eSize = 2;
        throw M68kException.m6eSignal;
    }

    protected void mmdVb(int n, int n2) {
        try {
            this.mmdWb(n, n2);
        }
        catch (M68kException m68kException) {
            // empty catch block
        }
    }

    protected void mmdVw(int n, int n2) {
        try {
            this.mmdWw(n, n2);
        }
        catch (M68kException m68kException) {
            // empty catch block
        }
    }

    protected void mmdVl(int n, int n2) {
        try {
            this.mmdWl(n, n2);
        }
        catch (M68kException m68kException) {
            // empty catch block
        }
    }

    protected void mmdWb(int n, int n2) throws M68kException {
        MC68060.m60BusErrorOnWrite();
        M68kException.m6eNumber = 2;
        M68kException.m6eAddress = n;
        M68kException.m6eDirection = 0;
        M68kException.m6eSize = 0;
        throw M68kException.m6eSignal;
    }

    protected void mmdWw(int n, int n2) throws M68kException {
        MC68060.m60BusErrorOnWrite();
        M68kException.m6eNumber = 2;
        M68kException.m6eAddress = n;
        M68kException.m6eDirection = 0;
        M68kException.m6eSize = 1;
        throw M68kException.m6eSignal;
    }

    protected void mmdWl(int n, int n2) throws M68kException {
        MC68060.m60BusErrorOnWrite();
        M68kException.m6eNumber = 2;
        M68kException.m6eAddress = n;
        M68kException.m6eDirection = 0;
        M68kException.m6eSize = 2;
        throw M68kException.m6eSignal;
    }
}

