/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;

public class NumberSpinner
extends JSpinner
implements ChangeListener,
DocumentListener {
    protected SpinnerNumberModel model;
    protected DecimalFormat format;
    protected JTextField textField;
    private boolean writeLocked;

    public NumberSpinner(SpinnerNumberModel spinnerNumberModel) {
        super(spinnerNumberModel);
        this.model = spinnerNumberModel;
        JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)this.getEditor();
        this.format = numberEditor.getFormat();
        this.textField = numberEditor.getTextField();
        this.writeLocked = false;
        this.removeChangeListener(numberEditor);
        this.addChangeListener(this);
        ((AbstractDocument)this.textField.getDocument()).addDocumentListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (!this.writeLocked) {
            Number number = this.model.getNumber();
            this.textField.setText(number instanceof Double || number instanceof Float ? this.format.format(number.doubleValue()) : this.format.format(number.longValue()));
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.textChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.textChanged();
    }

    protected void textChanged() {
        this.writeLocked = true;
        Number number = this.model.getNumber();
        try {
            Number number2 = this.format.parse(this.textField.getText());
            if (number instanceof Double || number instanceof Float) {
                double d;
                double d2 = number.doubleValue();
                if (d2 != (d = number2.doubleValue()) && ((Number)((Object)this.model.getMinimum())).doubleValue() <= d && d <= ((Number)((Object)this.model.getMaximum())).doubleValue()) {
                    this.model.setValue(number2);
                }
            } else {
                long l;
                long l2 = number.longValue();
                if (l2 != (l = number2.longValue()) && ((Number)((Object)this.model.getMinimum())).longValue() <= l && l <= ((Number)((Object)this.model.getMaximum())).longValue()) {
                    this.model.setValue(number2);
                }
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.writeLocked = false;
    }
}

