/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import xeij.EFPBox;
import xeij.XEiJ;

public class QFP {
    public static final int QFP_P = 0;
    public static final int QFP_M = 0x8000000;
    public static final int QFP_Z = 0x4000000;
    public static final int QFP_I = 0x2000000;
    public static final int QFP_N = 0x1000000;
    public static final int QFP_ZIN = 0x7000000;
    public static final int QFP_MZIN = 0xF000000;
    public static final int QFP_BS = 32768;
    public static final int QFP_SN = 16384;
    public static final int QFP_OE = 8192;
    public static final int QFP_OF = 4096;
    public static final int QFP_UF = 2048;
    public static final int QFP_DZ = 1024;
    public static final int QFP_X2 = 512;
    public static final int QFP_X1 = 256;
    public static final int QFP_EXC = 65280;
    private static final int QFP_GETA_SIZE = 512;
    private static final int QFP_GETA_BASE = -256;
    public static final QFP QFP_ONE = new QFP(0, 0, 1.0, 0.0);
    public static final QFP QFP_TEN = new QFP(0, 0, 10.0, 0.0);
    public static final QFP QFP_TENTO4 = new QFP(0, 0, 10000.0, 0.0);
    public static final QFP QFP_PI = new QFP(0, 0, Math.PI, 1.2246467991473532E-16);
    public static final QFP QFP_LN_2_2 = new QFP(0, 0, 0.34657359027997264, 1.1595234069231498E-17);
    public static int fpsr;
    public int flg;
    public int epp;
    public double dvl;
    public double cvl;
    private static final int[] QFP_ADD_FLG;
    private static final QFP[] QFP_ATH_T;
    private static final QFP QFP_ATH_C1;
    private static final QFP QFP_ATH_C3;
    private static final QFP QFP_ATH_C5;
    private static final QFP QFP_ATH_C7;
    private static final QFP QFP_ATH_C9;
    private static final QFP QFP_ATH_C11;
    private static final QFP QFP_ATH_C13;
    private static final QFP QFP_ATH_C15;
    private static final QFP QFP_ATH_C17;
    private static final QFP QFP_ATH_C19;
    private static final QFP QFP_ATH_C21;
    private static final QFP QFP_ATH_C23;
    private static final QFP QFP_ATH_C25;
    private static final QFP QFP_ATH_C27;
    private static final QFP QFP_ATH_C29;
    private static final QFP QFP_ATH_C31;
    private static final int[] QFP_DIV_FLG;
    private static final int[] QFP_MUL_FLG;
    private static final int[] QFP_SUB_FLG;
    public static final QFP[] QFP_TEN_P16QR;
    public static final QFP[] QFP_TEN_M16QR;

    public QFP() {
        this.set0();
    }

    public QFP(double d) {
        this.setd(d);
    }

    public QFP(float f) {
        this.setf(f);
    }

    public QFP(int n) {
        this.seti(n);
    }

    public QFP(long l) {
        this.setl(l);
    }

    public QFP(QFP qFP) {
        this.flg = qFP.flg;
        this.epp = qFP.epp;
        this.dvl = qFP.dvl;
        this.cvl = qFP.cvl;
    }

    private QFP(int n, int n2, double d, double d2) {
        this.flg = n;
        this.epp = n2;
        this.dvl = d;
        this.cvl = d2;
    }

    public QFP abs() {
        if ((this.flg & 0x8000000) != 0) {
            this.flg ^= 0x8000000;
            this.dvl = -this.dvl;
            this.cvl = -this.cvl;
        }
        return this;
    }

    public QFP abs(QFP qFP) {
        if ((qFP.flg & 0x8000000) != 0) {
            this.flg = qFP.flg ^ 0x8000000;
            this.epp = qFP.epp;
            this.dvl = -qFP.dvl;
            this.cvl = -qFP.cvl;
        } else {
            this.flg = qFP.flg;
            this.epp = qFP.epp;
            this.dvl = qFP.dvl;
            this.cvl = qFP.cvl;
        }
        return this;
    }

    public QFP add(QFP qFP) {
        int n = this.flg;
        int n2 = this.epp;
        double d = this.dvl;
        double d2 = this.cvl;
        int n3 = qFP.flg;
        int n4 = qFP.epp;
        double d3 = qFP.dvl;
        double d4 = qFP.cvl;
        int n5 = QFP_ADD_FLG[n >>> 20 | n3 >>> 24];
        if ((n5 & 0xC7000000) != 0) {
            if (0 <= n5) {
                fpsr |= n5 & 0xFF00;
                this.flg = n5 & 0xF000000;
            } else if (n5 << 1 < 0) {
                this.flg = n3;
                this.epp = n4;
                this.dvl = d3;
                this.cvl = d4;
            }
            return this;
        }
        if (n2 != n4) {
            if (n2 + 128 == n4) {
                d3 = Math.scalb(d3, 128);
                d4 = Math.scalb(d4, 128);
            } else if (n2 - 128 == n4) {
                d3 = Math.scalb(d3, -128);
                d4 = Math.scalb(d4, -128);
            } else {
                if (n2 < n4) {
                    this.flg = n3;
                    this.epp = n4;
                    this.dvl = d3;
                    this.cvl = d4;
                }
                return this;
            }
        }
        double d5 = d + d3;
        double d6 = d - d5;
        d6 = d - (d5 + d6) + (d6 + d3) + d2 + d4;
        d = d5 + d6;
        d2 = d5 - d + d6;
        if (d == 0.0) {
            this.flg = 0x4000000;
            return this;
        }
        this.flg = (int)(Double.doubleToLongBits(d) >>> 36) & 0x8000000;
        int n6 = Math.getExponent(d) - -256 & 0xFFFFFE00;
        if (n6 != 0) {
            n2 += n6;
            d = Math.scalb(d, -n6);
            d2 = Math.scalb(d2, -n6);
        }
        this.epp = n2;
        this.dvl = d;
        this.cvl = d2;
        return this;
    }

    public QFP add(QFP qFP, QFP qFP2) {
        int n = qFP.flg;
        int n2 = qFP.epp;
        double d = qFP.dvl;
        double d2 = qFP.cvl;
        int n3 = qFP2.flg;
        int n4 = qFP2.epp;
        double d3 = qFP2.dvl;
        double d4 = qFP2.cvl;
        int n5 = QFP_ADD_FLG[n >>> 20 | n3 >>> 24];
        if ((n5 & 0xC7000000) != 0) {
            if (0 <= n5) {
                fpsr |= n5 & 0xFF00;
                this.flg = n5 & 0xF000000;
            } else if (n5 << 1 < 0) {
                this.flg = n3;
                this.epp = n4;
                this.dvl = d3;
                this.cvl = d4;
            } else {
                this.flg = n;
                this.epp = n2;
                this.dvl = d;
                this.cvl = d2;
            }
            return this;
        }
        if (n2 != n4) {
            if (n2 + 128 == n4) {
                d3 = Math.scalb(d3, 128);
                d4 = Math.scalb(d4, 128);
            } else if (n2 - 128 == n4) {
                d3 = Math.scalb(d3, -128);
                d4 = Math.scalb(d4, -128);
            } else {
                if (n2 < n4) {
                    this.flg = n3;
                    this.epp = n4;
                    this.dvl = d3;
                    this.cvl = d4;
                } else {
                    this.flg = n;
                    this.epp = n2;
                    this.dvl = d;
                    this.cvl = d2;
                }
                return this;
            }
        }
        double d5 = d + d3;
        double d6 = d - d5;
        d6 = d - (d5 + d6) + (d6 + d3) + d2 + d4;
        d = d5 + d6;
        d2 = d5 - d + d6;
        if (d == 0.0) {
            this.flg = 0x4000000;
            return this;
        }
        this.flg = (int)(Double.doubleToLongBits(d) >>> 36) & 0x8000000;
        int n6 = Math.getExponent(d) - -256 & 0xFFFFFE00;
        if (n6 != 0) {
            n2 += n6;
            d = Math.scalb(d, -n6);
            d2 = Math.scalb(d2, -n6);
        }
        this.epp = n2;
        this.dvl = d;
        this.cvl = d2;
        return this;
    }

    public QFP atanh() {
        return this.atanh(this);
    }

    public QFP atanh(QFP qFP) {
        QFP qFP2;
        int n = qFP.flg;
        if ((n & 0x7000000) != 0) {
            if ((n & 0x2000000) != 0) {
                fpsr |= 0x2000;
                this.flg = 0x1000000;
            } else {
                this.flg = n;
            }
            return this;
        }
        int n2 = (qFP = new QFP().abs(qFP)).cmp1();
        if (0 <= n2) {
            if (n2 == 0) {
                fpsr |= 0x400;
                this.flg = n | 0x2000000;
            } else {
                fpsr |= 0x2000;
                this.flg = 0x1000000;
            }
            return this;
        }
        n2 = 0;
        if (QFP_ATH_T[0].lt(qFP)) {
            qFP2 = new QFP().negdec(qFP);
            n2 = -Math.getExponent(qFP2.dvl);
            if (QFP_ATH_T[n2].lt(qFP)) {
                ++n2;
            }
            qFP2.shl(n2);
            qFP.inc();
            QFP qFP3 = new QFP().add(qFP, qFP2);
            qFP.sub(qFP2).div(qFP3);
        }
        qFP2 = new QFP().squ(qFP);
        this.mul(QFP_ATH_C31, qFP2).add(QFP_ATH_C29).mul(qFP2).add(QFP_ATH_C27).mul(qFP2).add(QFP_ATH_C25).mul(qFP2).add(QFP_ATH_C23).mul(qFP2).add(QFP_ATH_C21).mul(qFP2).add(QFP_ATH_C19).mul(qFP2).add(QFP_ATH_C17).mul(qFP2).add(QFP_ATH_C15).mul(qFP2).add(QFP_ATH_C13).mul(qFP2).add(QFP_ATH_C11).mul(qFP2).add(QFP_ATH_C9).mul(qFP2).add(QFP_ATH_C7).mul(qFP2).add(QFP_ATH_C5).mul(qFP2).add(QFP_ATH_C3).mul(qFP2).add(QFP_ATH_C1).mul(qFP);
        if (n2 != 0) {
            this.add(new QFP(n2).mul(QFP_LN_2_2));
        }
        return this.neg((n & 0x8000000) != 0);
    }

    public int cmp(QFP qFP) {
        int n;
        int n2 = this.flg;
        int n3 = qFP.flg;
        if (((n2 | n3) & 0x7000000) != 0) {
            return EFPBox.EFP_CMP_TABLE[n2 >>> 24] << (n3 >>> 23) >> 30;
        }
        int n4 = n = (n2 & 0x8000000) != 0 ? -1 : 1;
        return n2 != n3 ? n : (this.epp != qFP.epp ? (this.epp < qFP.epp ? -n : n) : (this.dvl != qFP.dvl ? (this.dvl < qFP.dvl ? -n : n) : (this.cvl != qFP.cvl ? (this.cvl < qFP.cvl ? -n : n) : 0)));
    }

    public int cmp1() {
        return (this.flg & 0xF000000) != 0 ? ((this.flg & 0x1000000) != 0 ? 0 : ((this.flg & 0xC000000) != 0 ? -1 : 1)) : (this.epp != 0 ? (this.epp < 0 ? -1 : 1) : (this.dvl != 1.0 ? (this.dvl < 1.0 ? -1 : 1) : (this.cvl < 0.0 ? -1 : (0.0 < this.cvl ? 1 : 0))));
    }

    public QFP dec() {
        return this.sub(QFP_ONE);
    }

    public QFP dec(QFP qFP) {
        return this.sub(qFP, QFP_ONE);
    }

    public QFP div(QFP qFP) {
        int n = QFP_DIV_FLG[this.flg >>> 20 | qFP.flg >>> 24];
        if ((n & 0x7000000) != 0) {
            fpsr |= n & 0xFF00;
            this.flg = n & 0xF000000;
            return this;
        }
        return this.mul(new QFP().rcp(qFP));
    }

    public QFP div(QFP qFP, QFP qFP2) {
        int n = QFP_DIV_FLG[qFP.flg >>> 20 | qFP2.flg >>> 24];
        if ((n & 0x7000000) != 0) {
            fpsr |= n & 0xFF00;
            this.flg = n & 0xF000000;
            return this;
        }
        return this.mul(qFP, new QFP().rcp(qFP2));
    }

    public QFP div2() {
        if ((this.flg & 0x7000000) != 0) {
            return this;
        }
        this.dvl *= 0.5;
        this.cvl *= 0.5;
        int n = Math.getExponent(this.dvl) - -256 & 0xFFFFFE00;
        if (n != 0) {
            this.epp += n;
            this.dvl = Math.scalb(this.dvl, -n);
            this.cvl = Math.scalb(this.cvl, -n);
        }
        return this;
    }

    public QFP div2(QFP qFP) {
        this.flg = qFP.flg;
        if ((this.flg & 0x7000000) != 0) {
            return this;
        }
        this.epp = qFP.epp;
        this.dvl = qFP.dvl * 0.5;
        this.cvl = qFP.cvl * 0.5;
        int n = Math.getExponent(this.dvl) - -256 & 0xFFFFFE00;
        if (n != 0) {
            this.epp += n;
            this.dvl = Math.scalb(this.dvl, -n);
            this.cvl = Math.scalb(this.cvl, -n);
        }
        return this;
    }

    public void dump() {
        this.dump(null, false);
    }

    public void dump(String string) {
        this.dump(string, false);
    }

    public void dump(boolean bl) {
        this.dump(null, bl);
    }

    public void dump(String string, boolean bl) {
        if (string != null) {
            System.out.printf("%s=", string);
        }
        if ((this.flg & 0x7000000) != 0) {
            System.out.printf("QFP{flg:0x%08x", this.flg);
            if (bl) {
                System.out.printf(",val:%s", this.toString());
            }
            System.out.println("}");
        } else {
            System.out.printf("QFP{flg:0x%08x,epp:%d,dvl:%.16g=0x%016x,cvl:%.16g=0x%016x", this.flg, this.epp, this.dvl, Double.doubleToLongBits(this.dvl), this.cvl, Double.doubleToLongBits(this.cvl));
            if (bl) {
                System.out.printf(",val:%s", this.toString());
            }
            System.out.println("}");
        }
    }

    public double getd() {
        int n = this.flg;
        if ((n & 0x7000000) != 0) {
            return (n & 0x4000000) != 0 ? ((n & 0x8000000) == 0 ? 0.0 : -0.0) : ((n & 0x2000000) != 0 ? ((n & 0x8000000) == 0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY) : Double.NaN);
        }
        double d = this.dvl;
        if (this.epp != 0) {
            if (Double.isInfinite(d = Math.scalb(d, this.epp))) {
                fpsr |= 0x1000;
            } else if (d == 0.0) {
                fpsr |= 0x800;
            }
        }
        return d;
    }

    public float getf() {
        int n = this.flg;
        if ((n & 0x7000000) != 0) {
            return (n & 0x4000000) != 0 ? ((n & 0x8000000) == 0 ? 0.0f : -0.0f) : ((n & 0x2000000) != 0 ? ((n & 0x8000000) == 0 ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY) : Float.NaN);
        }
        return (float)this.dvl;
    }

    public int geti() {
        int n = this.flg;
        if ((n & 0x7000000) != 0) {
            if ((n & 0x4000000) != 0) {
                return 0;
            }
            fpsr |= 0x2000;
            return (n & 0x2000000) != 0 ? ((n & 0x8000000) == 0 ? Integer.MAX_VALUE : Integer.MIN_VALUE) : 0;
        }
        if (this.epp != 0) {
            if (this.epp < 0) {
                return 0;
            }
            fpsr |= 0x2000;
            return (n & 0x8000000) == 0 ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        }
        double d = this.dvl;
        double d2 = this.cvl;
        if (d * d2 < 0.0) {
            double d3 = Math.ulp(d) * Math.signum(d2);
            d += d3;
            d2 -= d3;
        }
        if (d <= -2.147483649E9 || 2.147483648E9 <= d) {
            fpsr |= 0x2000;
            return 0.0 <= d ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        }
        return (int)d;
    }

    public long getl() {
        int n = this.flg;
        if ((n & 0x7000000) != 0) {
            if ((n & 0x4000000) != 0) {
                return 0L;
            }
            fpsr |= 0x2000;
            return (n & 0x2000000) != 0 ? ((n & 0x8000000) == 0 ? Long.MAX_VALUE : Long.MIN_VALUE) : 0L;
        }
        if (this.epp != 0) {
            if (this.epp < 0) {
                return 0L;
            }
            fpsr |= 0x2000;
            return (n & 0x8000000) == 0 ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        double d = this.dvl;
        double d2 = this.cvl;
        if (d * d2 < 0.0) {
            double d3 = Math.ulp(d) * Math.signum(d2);
            d += d3;
            d2 -= d3;
        }
        if (d <= -9.223372036854776E18 || 9.223372036854776E18 <= d) {
            fpsr |= 0x2000;
            return 0.0 <= d ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        return (long)d + (long)d2;
    }

    public QFP inc() {
        return this.add(QFP_ONE);
    }

    public boolean lt(QFP qFP) {
        int n;
        int n2 = this.flg;
        int n3 = qFP.flg;
        if (((n2 | n3) & 0x7000000) != 0) {
            return EFPBox.EFP_LT_TABLE[n2 >>> 24] << (n3 >>> 23) < 0;
        }
        int n4 = n = (n2 & 0x8000000) != 0 ? -1 : 1;
        return (n2 != n3 ? n : (this.epp != qFP.epp ? (this.epp < qFP.epp ? -n : n) : (this.dvl != qFP.dvl ? (this.dvl < qFP.dvl ? -n : n) : (this.cvl != qFP.cvl ? (this.cvl < qFP.cvl ? -n : n) : 0)))) < 0;
    }

    public QFP mul(QFP qFP) {
        int n = QFP_MUL_FLG[this.flg >>> 20 | qFP.flg >>> 24];
        if ((n & 0x7000000) != 0) {
            fpsr |= n & 0xFF00;
            this.flg = n & 0xF000000;
            return this;
        }
        int n2 = this.epp + qFP.epp;
        double d = this.dvl;
        double d2 = this.cvl;
        double d3 = qFP.dvl;
        double d4 = qFP.cvl;
        double d5 = d * d3;
        double d6 = 1.34217729E8 * d;
        double d7 = 1.34217729E8 * d3;
        double d8 = d - d6 + d6;
        double d9 = d3 - d7 + d7;
        d6 = d - d8;
        d7 = d3 - d9;
        d6 = (d + d2) * d4 + d2 * d3 + (d8 * d9 - d5 + d7 * d8 + d6 * d9 + d6 * d7);
        d = d5 + d6;
        d2 = d5 - d + d6;
        int n3 = Math.getExponent(d) - -256 & 0xFFFFFE00;
        if (n3 != 0) {
            n2 += n3;
            d = Math.scalb(d, -n3);
            d2 = Math.scalb(d2, -n3);
        }
        this.flg = n;
        this.epp = n2;
        this.dvl = d;
        this.cvl = d2;
        return this;
    }

    public QFP mul(QFP qFP, QFP qFP2) {
        int n = QFP_MUL_FLG[qFP.flg >>> 20 | qFP2.flg >>> 24];
        if ((n & 0x7000000) != 0) {
            fpsr |= n & 0xFF00;
            this.flg = n & 0xF000000;
            return this;
        }
        int n2 = qFP.epp + qFP2.epp;
        double d = qFP.dvl;
        double d2 = qFP.cvl;
        double d3 = qFP2.dvl;
        double d4 = qFP2.cvl;
        double d5 = d * d3;
        double d6 = 1.34217729E8 * d;
        double d7 = 1.34217729E8 * d3;
        double d8 = d - d6 + d6;
        double d9 = d3 - d7 + d7;
        d6 = d - d8;
        d7 = d3 - d9;
        d6 = (d + d2) * d4 + d2 * d3 + (d8 * d9 - d5 + d7 * d8 + d6 * d9 + d6 * d7);
        d = d5 + d6;
        d2 = d5 - d + d6;
        int n3 = Math.getExponent(d) - -256 & 0xFFFFFE00;
        if (n3 != 0) {
            n2 += n3;
            d = Math.scalb(d, -n3);
            d2 = Math.scalb(d2, -n3);
        }
        this.flg = n;
        this.epp = n2;
        this.dvl = d;
        this.cvl = d2;
        return this;
    }

    public QFP mul2() {
        if ((this.flg & 0x7000000) != 0) {
            return this;
        }
        this.dvl *= 2.0;
        this.cvl *= 2.0;
        int n = Math.getExponent(this.dvl) - -256 & 0xFFFFFE00;
        if (n != 0) {
            this.epp += n;
            this.dvl = Math.scalb(this.dvl, -n);
            this.cvl = Math.scalb(this.cvl, -n);
        }
        return this;
    }

    public QFP mul2(QFP qFP) {
        this.flg = qFP.flg;
        if ((this.flg & 0x7000000) != 0) {
            return this;
        }
        this.epp = qFP.epp;
        this.dvl = qFP.dvl * 2.0;
        this.cvl = qFP.cvl * 2.0;
        int n = Math.getExponent(this.dvl) - -256 & 0xFFFFFE00;
        if (n != 0) {
            this.epp += n;
            this.dvl = Math.scalb(this.dvl, -n);
            this.cvl = Math.scalb(this.cvl, -n);
        }
        return this;
    }

    public QFP neg() {
        int n = this.flg;
        if ((n & 0x7000000) != 0) {
            if ((n & 0x6000000) != 0) {
                this.flg = n ^ 0x8000000;
            }
            return this;
        }
        this.flg = n ^ 0x8000000;
        this.dvl = -this.dvl;
        this.cvl = -this.cvl;
        return this;
    }

    public QFP neg(QFP qFP) {
        int n = qFP.flg;
        if ((n & 0x7000000) != 0) {
            if ((n & 0x6000000) != 0) {
                n ^= 0x8000000;
            }
            this.flg = n;
            return this;
        }
        this.flg = n ^ 0x8000000;
        this.dvl = -this.dvl;
        this.cvl = -this.cvl;
        return this;
    }

    public QFP neg(boolean bl) {
        return bl ? this.neg() : this;
    }

    public QFP neg(boolean bl, QFP qFP) {
        return bl ? this.neg(qFP) : this.setq(qFP);
    }

    public QFP negdec() {
        return this.sub(QFP_ONE, this);
    }

    public QFP negdec(QFP qFP) {
        return this.sub(QFP_ONE, qFP);
    }

    public QFP rcp() {
        int n = this.flg;
        if ((n & 0x7000000) != 0) {
            if ((n & 0x4000000) != 0) {
                fpsr |= 0x400;
                n ^= 0x6000000;
            } else if ((n & 0x2000000) != 0) {
                n ^= 0x6000000;
            }
            this.flg = n;
            return this;
        }
        QFP qFP = new QFP(n, -this.epp, 1.0 / this.dvl, 0.0);
        QFP qFP2 = new QFP().squ(qFP).mul(this);
        return this.mul2(qFP).sub(qFP2);
    }

    public QFP rcp(QFP qFP) {
        int n = qFP.flg;
        if ((n & 0x7000000) != 0) {
            if ((n & 0x4000000) != 0) {
                fpsr |= 0x400;
                n ^= 0x6000000;
            } else if ((n & 0x2000000) != 0) {
                n ^= 0x6000000;
            }
            this.flg = n;
            return this;
        }
        QFP qFP2 = new QFP(n, -qFP.epp, 1.0 / qFP.dvl, 0.0);
        QFP qFP3 = new QFP().squ(qFP2).mul(qFP);
        return this.mul2(qFP2).sub(qFP3);
    }

    public final QFP set0() {
        this.flg = 0x4000000;
        return this;
    }

    public final QFP setd(double d) {
        int n = (int)(Double.doubleToLongBits(d) >>> 36) & 0x8000000;
        if (d == 0.0) {
            this.flg = n | 0x4000000;
            return this;
        }
        if (Double.isInfinite(d)) {
            this.flg = n | 0x2000000;
            return this;
        }
        if (Double.isNaN(d)) {
            this.flg = 0x1000000;
            return this;
        }
        this.flg = n;
        this.epp = Math.getExponent(d) - -256 & 0xFFFFFE00;
        this.dvl = Math.scalb(d, -this.epp);
        this.cvl = 0.0;
        return this;
    }

    public final QFP setf(float f) {
        int n = Float.floatToIntBits(f) >>> 4 & 0x8000000;
        if ((double)f == 0.0) {
            this.flg = n | 0x4000000;
            return this;
        }
        if (Float.isInfinite(f)) {
            this.flg = n | 0x2000000;
            return this;
        }
        if (Float.isNaN(f)) {
            this.flg = 0x1000000;
            return this;
        }
        this.flg = n;
        this.epp = 0;
        this.dvl = f;
        this.cvl = 0.0;
        return this;
    }

    public final QFP seti(int n) {
        if (n == 0) {
            this.flg = 0x4000000;
            return this;
        }
        this.flg = n >>> 4 & 0x8000000;
        this.epp = 0;
        this.dvl = n;
        this.cvl = 0.0;
        return this;
    }

    public final QFP setl(long l) {
        if (l == 0L) {
            this.flg = 0x4000000;
            return this;
        }
        this.flg = (int)(l >>> 36) & 0x8000000;
        this.epp = 0;
        this.dvl = l;
        this.cvl = l - (this.dvl == 9.223372036854776E18 ? Long.MIN_VALUE : (long)this.dvl);
        return this;
    }

    public final QFP setq(QFP qFP) {
        this.flg = qFP.flg;
        this.epp = qFP.epp;
        this.dvl = qFP.dvl;
        this.cvl = qFP.cvl;
        return this;
    }

    public QFP shl(int n) {
        if ((this.flg & 0x7000000) != 0) {
            return this;
        }
        int n2 = Math.getExponent(this.dvl);
        this.epp = (n += this.epp + n2) - -256 & 0xFFFFFE00;
        this.dvl = Math.scalb(this.dvl, n -= this.epp + n2);
        this.cvl = Math.scalb(this.cvl, n);
        return this;
    }

    public QFP shr(int n) {
        if ((this.flg & 0x7000000) != 0) {
            return this;
        }
        n = -n;
        int n2 = Math.getExponent(this.dvl);
        this.epp = (n += this.epp + n2) - -256 & 0xFFFFFE00;
        this.dvl = Math.scalb(this.dvl, n -= this.epp + n2);
        this.cvl = Math.scalb(this.cvl, n);
        return this;
    }

    public QFP sqrt() {
        int n = this.flg;
        if ((n & 0xF000000) != 0) {
            if (n == 0x8000000 || n == 0xA000000) {
                fpsr |= 0x2000;
                this.flg = 0x1000000;
            } else {
                this.flg = n;
            }
            return this;
        }
        QFP qFP = new QFP(Math.sqrt(this.dvl)).shl(this.epp >> 1);
        return this.div(this, qFP).add(qFP).div2();
    }

    public QFP sqrt(QFP qFP) {
        int n = qFP.flg;
        if ((n & 0xF000000) != 0) {
            if (n == 0x8000000 || n == 0xA000000) {
                fpsr |= 0x2000;
                this.flg = 0x1000000;
            } else {
                this.flg = n;
            }
            return this;
        }
        QFP qFP2 = new QFP(Math.sqrt(qFP.dvl)).shl(qFP.epp >> 1);
        return this.div(qFP, qFP2).add(qFP2).div2();
    }

    public QFP squ() {
        return this.mul(this, this);
    }

    public QFP squ(QFP qFP) {
        return this.mul(qFP, qFP);
    }

    public QFP sub(QFP qFP) {
        int n = this.flg;
        int n2 = this.epp;
        double d = this.dvl;
        double d2 = this.cvl;
        int n3 = qFP.flg;
        int n4 = qFP.epp;
        double d3 = qFP.dvl;
        double d4 = qFP.cvl;
        int n5 = QFP_SUB_FLG[n >>> 20 | n3 >>> 24];
        if ((n5 & 0xC7000000) != 0) {
            if (0 <= n5) {
                fpsr |= n5 & 0xFF00;
                this.flg = n5 & 0xF000000;
            } else if (n5 << 1 < 0) {
                this.flg = n3 ^ 0x8000000;
                this.epp = n4;
                this.dvl = d3;
                this.cvl = d4;
            }
            return this;
        }
        if (n2 != n4) {
            if (n2 + 128 == n4) {
                d3 = Math.scalb(d3, 128);
                d4 = Math.scalb(d4, 128);
            } else if (n2 - 128 == n4) {
                d3 = Math.scalb(d3, -128);
                d4 = Math.scalb(d4, -128);
            } else {
                if (n2 < n4) {
                    this.flg = n3 ^ 0x8000000;
                    this.epp = n4;
                    this.dvl = d3;
                    this.cvl = d4;
                }
                return this;
            }
        }
        double d5 = d - d3;
        double d6 = d - d5;
        d6 = d - (d5 + d6) + (d6 - d3) + d2 - d4;
        d = d5 + d6;
        d2 = d5 - d + d6;
        if (d == 0.0) {
            this.flg = 0x4000000;
            return this;
        }
        this.flg = (int)(Double.doubleToLongBits(d) >>> 36) & 0x8000000;
        int n6 = Math.getExponent(d) - -256 & 0xFFFFFE00;
        if (n6 != 0) {
            n2 += n6;
            d = Math.scalb(d, -n6);
            d2 = Math.scalb(d2, -n6);
        }
        this.epp = n2;
        this.dvl = d;
        this.cvl = d2;
        return this;
    }

    public QFP sub(QFP qFP, QFP qFP2) {
        int n = qFP.flg;
        int n2 = qFP.epp;
        double d = qFP.dvl;
        double d2 = qFP.cvl;
        int n3 = qFP2.flg;
        int n4 = qFP2.epp;
        double d3 = qFP2.dvl;
        double d4 = qFP2.cvl;
        int n5 = QFP_SUB_FLG[n >>> 20 | n3 >>> 24];
        if ((n5 & 0xC7000000) != 0) {
            if (0 <= n5) {
                fpsr |= n5 & 0xFF00;
                this.flg = n5 & 0xF000000;
            } else if (n5 << 1 < 0) {
                this.flg = n3 ^ 0x8000000;
                this.epp = n4;
                this.dvl = d3;
                this.cvl = d4;
            } else {
                this.flg = n;
                this.epp = n2;
                this.dvl = d;
                this.cvl = d2;
            }
            return this;
        }
        if (n2 != n4) {
            if (n2 + 128 == n4) {
                d3 = Math.scalb(d3, 128);
                d4 = Math.scalb(d4, 128);
            } else if (n2 - 128 == n4) {
                d3 = Math.scalb(d3, -128);
                d4 = Math.scalb(d4, -128);
            } else {
                if (n2 < n4) {
                    this.flg = n3 ^ 0x8000000;
                    this.epp = n4;
                    this.dvl = d3;
                    this.cvl = d4;
                } else {
                    this.flg = n;
                    this.epp = n2;
                    this.dvl = d;
                    this.cvl = d2;
                }
                return this;
            }
        }
        double d5 = d - d3;
        double d6 = d - d5;
        d6 = d - (d5 + d6) + (d6 - d3) + d2 - d4;
        d = d5 + d6;
        d2 = d5 - d + d6;
        if (d == 0.0) {
            this.flg = 0x4000000;
            return this;
        }
        this.flg = (int)(Double.doubleToLongBits(d) >>> 36) & 0x8000000;
        int n6 = Math.getExponent(d) - -256 & 0xFFFFFE00;
        if (n6 != 0) {
            n2 += n6;
            d = Math.scalb(d, -n6);
            d2 = Math.scalb(d2, -n6);
        }
        this.epp = n2;
        this.dvl = d;
        this.cvl = d2;
        return this;
    }

    public String toString() {
        int n;
        int n2 = this.flg;
        if ((n2 & 0x7000000) != 0) {
            return n2 == 0x4000000 ? "0" : (n2 == 0xC000000 ? "-0" : (n2 == 0x2000000 ? "Infinity" : (n2 == 0xA000000 ? "-Infinity" : "NaN")));
        }
        StringBuilder stringBuilder = new StringBuilder();
        QFP qFP = new QFP(this);
        if ((n2 & 0x8000000) != 0) {
            stringBuilder.append('-');
            qFP.neg();
        }
        QFP qFP2 = new QFP();
        int n3 = (int)Math.floor((double)(qFP.epp + Math.getExponent(qFP.dvl)) * 0.3010299956639812);
        if (0 < n3) {
            qFP.mul(QFP_TEN_M16QR[n3 & 0xF]);
            if (16 <= n3) {
                qFP.mul(QFP_TEN_M16QR[16 + (n3 >> 4 & 0xF)]);
                if (256 <= n3) {
                    qFP.mul(QFP_TEN_M16QR[32 + (n3 >> 8 & 0xF)]);
                    if (4096 <= n3) {
                        qFP.mul(QFP_TEN_M16QR[48 + (n3 >> 12)]);
                    }
                }
            }
        } else if (n3 < 0) {
            qFP.mul(QFP_TEN_P16QR[-n3 & 0xF]);
            if (n3 <= -16) {
                qFP.mul(QFP_TEN_P16QR[16 + (-n3 >> 4 & 0xF)]);
                if (n3 <= -256) {
                    qFP.mul(QFP_TEN_P16QR[32 + (-n3 >> 8 & 0xF)]);
                    if (n3 <= -4096) {
                        qFP.mul(QFP_TEN_P16QR[48 + (-n3 >> 12)]);
                    }
                }
            }
        }
        char[] cArray = new char[34];
        int n4 = qFP.geti();
        int n5 = XEiJ.FMT_BCD4[n4];
        cArray[0] = (char)(0x30 | n5 >> 4);
        cArray[1] = (char)(0x30 | n5 & 0xF);
        for (n = 2; n < 34; n += 4) {
            qFP.sub(qFP2.seti(n4)).mul(QFP_TENTO4);
            n4 = qFP.geti();
            n5 = XEiJ.FMT_BCD4[n4];
            cArray[n] = (char)(0x30 | n5 >> 12);
            cArray[n + 1] = (char)(0x30 | n5 >> 8 & 0xF);
            cArray[n + 2] = (char)(0x30 | n5 >> 4 & 0xF);
            cArray[n + 3] = (char)(0x30 | n5 & 0xF);
        }
        n4 = cArray[0] != '0' ? 0 : (cArray[1] != '0' ? 1 : 2);
        n5 = n4 + 30;
        if ('5' <= cArray[n5]) {
            n = n5;
            while (true) {
                int n6 = --n;
                cArray[n6] = (char)(cArray[n6] + '\u0001');
                if ('9' >= cArray[n6]) break;
                cArray[n] = 48;
            }
            if (n < n4) {
                --n4;
                --n5;
            }
        }
        n3 -= n4 - 1;
        while (cArray[n5 - 1] == '0') {
            --n5;
        }
        if (0 <= n3 && n3 < 30) {
            stringBuilder.append(cArray, n4, n3 + 1);
            if ((n4 += n3 + 1) < n5) {
                stringBuilder.append('.').append(cArray, n4, n5 - n4);
            }
        } else if (-4 <= n3 && n3 < 0) {
            stringBuilder.append('0').append('.');
            while (++n3 < 0) {
                stringBuilder.append('0');
            }
            stringBuilder.append(cArray, n4, n5 - n4);
        } else {
            stringBuilder.append(cArray[n4++]);
            if (n4 < n5) {
                stringBuilder.append('.').append(cArray, n4, n5 - n4);
            }
            stringBuilder.append('e').append(n3);
        }
        return stringBuilder.toString();
    }

    static {
        QFP_ADD_FLG = new int[]{0, 0x1000000, 0x2000000, 0x1000000, Integer.MIN_VALUE, 0x1000000, 0x1000000, 0x1000000, 0, 0x1000000, 0xA000000, 0x1000000, Integer.MIN_VALUE, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x2000000, 0x1000000, 0x2000000, 0x1000000, 0x2000000, 0x1000000, 0x1000000, 0x1000000, 0x2000000, 0x1000000, 0x1002000, 0x1000000, 0x2000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, -1073741824, 0x1000000, 0x2000000, 0x1000000, 0x4000000, 0x1000000, 0x1000000, 0x1000000, -1073741824, 0x1000000, 0xA000000, 0x1000000, 0x4000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0, 0x1000000, 0x2000000, 0x1000000, Integer.MIN_VALUE, 0x1000000, 0x1000000, 0x1000000, 0, 0x1000000, 0xA000000, 0x1000000, Integer.MIN_VALUE, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0xA000000, 0x1000000, 0x1002000, 0x1000000, 0xA000000, 0x1000000, 0x1000000, 0x1000000, 0xA000000, 0x1000000, 0xA000000, 0x1000000, 0xA000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, -1073741824, 0x1000000, 0x2000000, 0x1000000, 0x4000000, 0x1000000, 0x1000000, 0x1000000, -1073741824, 0x1000000, 0xA000000, 0x1000000, 0xC000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000};
        QFP_ATH_T = new QFP[]{new QFP(0, 0, 0.1715728752538099, -9.431630403441338E-19), new QFP(0, 0, 0.4775922500725171, 1.5590853768832484E-17), new QFP(0, 0, 0.6995577903553303, 3.2110582903266594E-17), new QFP(0, 0, 0.8375793937167755, -5.0762510607469775E-17), new QFP(0, 0, 0.9153525753504128, 2.3000535131861358E-17), new QFP(0, 0, 0.9567612760176463, 3.890290454328342E-18), new QFP(0, 0, 0.9781443857912641, -9.346200565407802E-18), new QFP(0, 0, 0.989012156377834, 1.2736079970393836E-17), new QFP(0, 0, 0.9944909450302888, -4.7359815523018654E-17), new QFP(0, 0, 0.9972416735721655, 4.389016373436473E-19), new QFP(0, 0, 0.9986198850842214, -3.6363284656465504E-17), new QFP(0, 0, 0.999309704370287, -2.6458551605648638E-17), new QFP(0, 0, 0.9996547926113556, -4.1929838766400063E-17), new QFP(0, 0, 0.9998273814083745, 2.772026519284329E-18), new QFP(0, 0, 0.9999136869793792, 4.339658089914871E-18), new QFP(0, 0, 0.9999568425584273, 5.5743796439049294E-18), new QFP(0, 0, 0.9999784210463906, -1.0475306940486852E-17), new QFP(0, 0, 0.9999892104649886, -6.883607515537424E-18), new QFP(0, 0, 0.9999946052179425, 3.2920870314538643E-18), new QFP(0, 0, 0.9999973026053333, 1.6365613993906895E-17), new QFP(0, 0, 0.9999986513017571, 1.0022756201845535E-17), new QFP(0, 0, 0.9999993256506512, 5.241371932479646E-18), new QFP(0, 0, 0.9999996628252688, 2.6494352064935304E-18), new QFP(0, 0, 0.9999998314126202, 1.3283112589852975E-18), new QFP(0, 0, 0.9999999157063065, 6.646048365041415E-19), new QFP(0, 0, 0.9999999578531524, -5.517879266212656E-17), new QFP(0, 0, 0.999999978926576, -2.7589389312203206E-17), new QFP(0, 0, 0.9999999894632879, -1.3794693778744084E-17), new QFP(0, 0, 0.9999999947316439, 3.473601664374102E-17), new QFP(0, 0, 0.999999997365822, -4.161258984763222E-17), new QFP(0, 0, 0.999999998682911, -2.1673656660090926E-17), new QFP(0, 0, 0.9999999993414554, 4.445748246692946E-17), new QFP(0, 0, 0.9999999996707277, 2.217453112486723E-17), new QFP(0, 0, 0.9999999998353639, -4.4437438195976934E-17), new QFP(0, 0, 0.999999999917682, -2.2222107229777065E-17), new QFP(0, 0, 0.9999999999588409, 4.439925058342209E-17), new QFP(0, 0, 0.9999999999794205, 2.2199413533474238E-17), new QFP(0, 0, 0.9999999999897102, 1.1099653827177917E-17), new QFP(0, 0, 0.9999999999948551, 5.549813678699158E-18), new QFP(0, 0, 0.9999999999974276, -5.27362477006307E-17), new QFP(0, 0, 0.9999999999987138, -2.636812467749596E-17), new QFP(0, 0, 0.9999999999993568, 4.232708868571469E-17), new QFP(0, 0, 0.9999999999996785, -3.4347606940099266E-17), new QFP(0, 0, 0.9999999999998392, -1.717380348297433E-17), new QFP(0, 0, 0.9999999999999196, -8.58690174471834E-18), new QFP(0, 0, 0.9999999999999598, -4.293450873166963E-18), new QFP(0, 0, 0.9999999999999799, -2.14672543678543E-18), new QFP(0, 0, 0.9999999999999899, 5.443778851281462E-17), new QFP(0, 0, 0.999999999999995, -2.8292256974863135E-17), new QFP(0, 0, 0.9999999999999974, 4.1365022743823104E-17), new QFP(0, 0, 0.9999999999999988, -3.4828639859347064E-17), new QFP(0, 0, 0.9999999999999993, 3.80968313015841E-17), new QFP(0, 0, 0.9999999999999997, 1.9048415650792E-17), new QFP(0, 0, 0.9999999999999999, -4.598694340586184E-17), new QFP(0, 0, 0.9999999999999999, 3.25176795283269E-17), new QFP(0, 0, 1.0, -3.925231146709437E-17), new QFP(0, 0, 1.0, -1.962615573354719E-17), new QFP(0, 0, 1.0, -9.813077866773595E-18), new QFP(0, 0, 1.0, -4.9065389333867974E-18), new QFP(0, 0, 1.0, -2.4532694666933987E-18), new QFP(0, 0, 1.0, -1.2266347333466993E-18), new QFP(0, 0, 1.0, -6.133173666733497E-19), new QFP(0, 0, 1.0, -3.0665868333667484E-19), new QFP(0, 0, 1.0, -1.5332934166833742E-19), new QFP(0, 0, 1.0, -7.666467083416871E-20), new QFP(0, 0, 1.0, -3.8332335417084355E-20), new QFP(0, 0, 1.0, -1.9166167708542177E-20), new QFP(0, 0, 1.0, -9.583083854271089E-21), new QFP(0, 0, 1.0, -4.791541927135544E-21), new QFP(0, 0, 1.0, -2.395770963567772E-21), new QFP(0, 0, 1.0, -1.197885481783886E-21), new QFP(0, 0, 1.0, -5.98942740891943E-22), new QFP(0, 0, 1.0, -2.994713704459715E-22), new QFP(0, 0, 1.0, -1.4973568522298576E-22), new QFP(0, 0, 1.0, -7.486784261149288E-23), new QFP(0, 0, 1.0, -3.743392130574644E-23), new QFP(0, 0, 1.0, -1.871696065287322E-23), new QFP(0, 0, 1.0, -9.35848032643661E-24), new QFP(0, 0, 1.0, -4.679240163218305E-24), new QFP(0, 0, 1.0, -2.3396200816091525E-24), new QFP(0, 0, 1.0, -1.1698100408045763E-24), new QFP(0, 0, 1.0, -5.849050204022881E-25), new QFP(0, 0, 1.0, -2.9245251020114406E-25), new QFP(0, 0, 1.0, -1.4622625510057203E-25), new QFP(0, 0, 1.0, -7.311312755028602E-26), new QFP(0, 0, 1.0, -3.655656377514301E-26), new QFP(0, 0, 1.0, -1.8278281887571504E-26), new QFP(0, 0, 1.0, -9.139140943785752E-27), new QFP(0, 0, 1.0, -4.569570471892876E-27), new QFP(0, 0, 1.0, -2.284785235946438E-27), new QFP(0, 0, 1.0, -1.142392617973219E-27), new QFP(0, 0, 1.0, -5.711963089866095E-28), new QFP(0, 0, 1.0, -2.8559815449330475E-28), new QFP(0, 0, 1.0, -1.4279907724665237E-28), new QFP(0, 0, 1.0, -7.139953862332619E-29), new QFP(0, 0, 1.0, -3.5699769311663094E-29), new QFP(0, 0, 1.0, -1.7849884655831547E-29), new QFP(0, 0, 1.0, -8.924942327915773E-30), new QFP(0, 0, 1.0, -4.462471163957887E-30), new QFP(0, 0, 1.0, -2.2312355819789434E-30), new QFP(0, 0, 1.0, -1.1156177909894717E-30), new QFP(0, 0, 1.0, -5.578088954947358E-31), new QFP(0, 0, 1.0, -2.789044477473679E-31), new QFP(0, 0, 1.0, -1.3945222387368396E-31), new QFP(0, 0, 1.0, -6.972611193684198E-32), new QFP(0, 0, 1.0, -3.486305596842099E-32), new QFP(0, 0, 1.0, -1.7431527984210495E-32)};
        QFP_ATH_C1 = new QFP(0, 0, 1.0, -9.393330621391495E-35);
        QFP_ATH_C3 = new QFP(0, 0, 0.3333333333333333, 1.850371707708652E-17);
        QFP_ATH_C5 = new QFP(0, 0, 0.2, -1.1102230247310912E-17);
        QFP_ATH_C7 = new QFP(0, 0, 0.14285714285714285, 7.930165372177135E-18);
        QFP_ATH_C9 = new QFP(0, 0, 0.1111111111111111, 6.167459505832464E-18);
        QFP_ATH_C11 = new QFP(0, 0, 0.09090909090909091, -2.384562426013648E-18);
        QFP_ATH_C13 = new QFP(0, 0, 0.0769230769230769, -5.689870523917149E-18);
        QFP_ATH_C15 = new QFP(0, 0, 0.066666666666671, 3.156706952552385E-18);
        QFP_ATH_C17 = new QFP(0, 0, 0.05882352941129854, -2.211050899723884E-18);
        QFP_ATH_C19 = new QFP(0, 0, 0.05263157898428323, -6.634617578918471E-19);
        QFP_ATH_C21 = new QFP(0, 0, 0.047619045455064776, -2.0839905573375162E-18);
        QFP_ATH_C23 = new QFP(0, 0, 0.043478354455734364, 3.2785549448812097E-18);
        QFP_ATH_C25 = new QFP(0, 0, 0.0399970571813185, 2.072728402942728E-18);
        QFP_ATH_C27 = new QFP(0, 0, 0.03710230194697517, -1.2217488178362663E-18);
        QFP_ATH_C29 = new QFP(0, 0, 0.033519820951320084, -4.112458623040257E-19);
        QFP_ATH_C31 = new QFP(0, 0, 0.04062839429540842, -1.393416109908281E-18);
        QFP_DIV_FLG = new int[]{0, 0x1000000, 0x4000000, 0x1000000, 0, 0x1000000, 0x1000000, 0x1000000, 0x8000000, 0x1000000, 0xC000000, 0x1000000, 0x8000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x2000000, 0x1000000, 0x1002000, 0x1000000, 0x2000400, 0x1000000, 0x1000000, 0x1000000, 0xA000000, 0x1000000, 0x1002000, 0x1000000, 0xA000400, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x4000000, 0x1000000, 0x4000000, 0x1000000, 0x1002000, 0x1000000, 0x1000000, 0x1000000, 0xC000000, 0x1000000, 0xC000000, 0x1000000, 0x1002000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x8000000, 0x1000000, 0xC000000, 0x1000000, 0x8000000, 0x1000000, 0x1000000, 0x1000000, 0, 0x1000000, 0x4000000, 0x1000000, 0, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0xA000000, 0x1000000, 0x1002000, 0x1000000, 0xA000400, 0x1000000, 0x1000000, 0x1000000, 0x2000000, 0x1000000, 0x1002000, 0x1000000, 0x2000400, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0xC000000, 0x1000000, 0xC000000, 0x1000000, 0x1002000, 0x1000000, 0x1000000, 0x1000000, 0x4000000, 0x1000000, 0x4000000, 0x1000000, 0x1002000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000};
        QFP_MUL_FLG = new int[]{0, 0x1000000, 0x2000000, 0x1000000, 0x4000000, 0x1000000, 0x1000000, 0x1000000, 0x8000000, 0x1000000, 0xA000000, 0x1000000, 0xC000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x2000000, 0x1000000, 0x2000000, 0x1000000, 0x1002000, 0x1000000, 0x1000000, 0x1000000, 0xA000000, 0x1000000, 0xA000000, 0x1000000, 0x1002000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x4000000, 0x1000000, 0x1002000, 0x1000000, 0x4000000, 0x1000000, 0x1000000, 0x1000000, 0xC000000, 0x1000000, 0x1002000, 0x1000000, 0xC000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x8000000, 0x1000000, 0xA000000, 0x1000000, 0xC000000, 0x1000000, 0x1000000, 0x1000000, 0, 0x1000000, 0x2000000, 0x1000000, 0x4000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0xA000000, 0x1000000, 0xA000000, 0x1000000, 0x1002000, 0x1000000, 0x1000000, 0x1000000, 0x2000000, 0x1000000, 0x2000000, 0x1000000, 0x1002000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0xC000000, 0x1000000, 0x1002000, 0x1000000, 0xC000000, 0x1000000, 0x1000000, 0x1000000, 0x4000000, 0x1000000, 0x1002000, 0x1000000, 0x4000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000};
        QFP_SUB_FLG = new int[]{0, 0x1000000, 0xA000000, 0x1000000, Integer.MIN_VALUE, 0x1000000, 0x1000000, 0x1000000, 0, 0x1000000, 0x2000000, 0x1000000, Integer.MIN_VALUE, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x2000000, 0x1000000, 0x1002000, 0x1000000, 0x2000000, 0x1000000, 0x1000000, 0x1000000, 0x2000000, 0x1000000, 0x2000000, 0x1000000, 0x2000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, -1073741824, 0x1000000, 0xA000000, 0x1000000, 0x4000000, 0x1000000, 0x1000000, 0x1000000, -1073741824, 0x1000000, 0x2000000, 0x1000000, 0x4000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0, 0x1000000, 0xA000000, 0x1000000, Integer.MIN_VALUE, 0x1000000, 0x1000000, 0x1000000, 0, 0x1000000, 0x2000000, 0x1000000, Integer.MIN_VALUE, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0xA000000, 0x1000000, 0xA000000, 0x1000000, 0xA000000, 0x1000000, 0x1000000, 0x1000000, 0xA000000, 0x1000000, 0x1002000, 0x1000000, 0xA000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, -1073741824, 0x1000000, 0xA000000, 0x1000000, 0xC000000, 0x1000000, 0x1000000, 0x1000000, -1073741824, 0x1000000, 0x2000000, 0x1000000, 0x4000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000};
        QFP_TEN_P16QR = new QFP[]{new QFP(0, 0, 1.0, 0.0), new QFP(0, 0, 10.0, 0.0), new QFP(0, 0, 100.0, 0.0), new QFP(0, 0, 1000.0, 0.0), new QFP(0, 0, 10000.0, 0.0), new QFP(0, 0, 100000.0, 0.0), new QFP(0, 0, 1000000.0, 0.0), new QFP(0, 0, 1.0E7, 0.0), new QFP(0, 0, 1.0E8, 0.0), new QFP(0, 0, 1.0E9, 0.0), new QFP(0, 0, 1.0E10, 0.0), new QFP(0, 0, 1.0E11, 0.0), new QFP(0, 0, 1.0E12, 0.0), new QFP(0, 0, 1.0E13, 0.0), new QFP(0, 0, 1.0E14, 0.0), new QFP(0, 0, 1.0E15, 0.0), new QFP(0, 0, 1.0, 0.0), new QFP(0, 0, 1.0E16, 0.0), new QFP(0, 0, 1.0E32, -5.366162204393472E15), new QFP(0, 0, 1.0E48, -4.38458430450762E31), new QFP(0, 0, 1.0E64, -2.1320419009454396E47), new QFP(0, 512, 7.458340731200207E-75, -1.9846543780614255E-93), new QFP(0, 512, 7.458340731200207E-59, -3.718852047436987E-75), new QFP(0, 512, 7.458340731200206E-43, 5.211893373808849E-59), new QFP(0, 512, 7.458340731200207E-27, -5.6067693771654475E-43), new QFP(0, 512, 7.458340731200207E-11, -1.7710152534048694E-27), new QFP(0, 512, 745834.0731200207, -4.869108939492525E-12), new QFP(0, 512, 7.458340731200207E21, -55557.034684537066), new QFP(0, 512, 7.458340731200207E37, -3.0505270080294554E21), new QFP(0, 512, 7.458340731200207E53, 1.3527140501979656E37), new QFP(0, 512, 7.458340731200207E69, 2.271136712252051E53), new QFP(0, 1024, 5.562684646268004E-69, -7.757783313328416E-86), new QFP(0, 0, 1.0, 0.0), new QFP(0, 1024, 5.562684646268004E-53, -1.67590671154496E-69), new QFP(0, 1536, 4.1488397472082663E49, 1.153050984352261E33), new QFP(0, 2560, 0.002307868716162185, -7.868427218779074E-20), new QFP(0, 3584, 1.2837945872997635E-55, -8.848789238461125E-72), new QFP(0, 4096, 9.574977460952186E46, -3.059864419659218E30), new QFP(0, 5120, 5.326258011040091E-6, -1.147334653187795E-23), new QFP(0, 6144, 2.962829366007467E-58, 2.4211803322342545E-75), new QFP(0, 6656, 2.2097790940089577E44, -1.0432478144793977E28), new QFP(0, 7680, 1.2292304237887648E-8, 8.986487458531717E-26), new QFP(0, 8704, 6.837821205135273E-61, 1.1224804039915376E-77), new QFP(0, 9216, 5.099880040692489E41, -1.9532147447711818E24), new QFP(0, 10240, 2.836902440016875E-11, 1.0270834302822001E-27), new QFP(0, 11264, 1.5780793646042106E-63, -5.833578340510835E-80), new QFP(0, 11776, 1.1769853602094125E39, 7.493691874551089E22), new QFP(0, 12800, 6.547198392119115E-14, -9.025803638173035E-31), new QFP(0, 0, 1.0, 0.0), new QFP(0, 13824, 3.641999997191156E-66, -2.6050163056759375E-83), new QFP(0, 27136, 1.7784336298894045E23, 4621087.039620167)};
        QFP_TEN_M16QR = new QFP[]{new QFP(0, 0, 1.0, 0.0), new QFP(0, 0, 0.1, -5.551115123125783E-18), new QFP(0, 0, 0.01, -2.0816681711721684E-19), new QFP(0, 0, 0.001, -2.0816681711721686E-20), new QFP(0, 0, 1.0E-4, -4.79217360238593E-21), new QFP(0, 0, 1.0E-5, -8.180305391403131E-22), new QFP(0, 0, 1.0E-6, 4.525188817411374E-23), new QFP(0, 0, 1.0E-7, 4.525188817411374E-24), new QFP(0, 0, 1.0E-8, -2.092256083012847E-25), new QFP(0, 0, 1.0E-9, -6.228159145777985E-26), new QFP(0, 0, 1.0E-10, -3.643219731549774E-27), new QFP(0, 0, 1.0E-11, 6.050303071806019E-28), new QFP(0, 0, 1.0E-12, 2.0113352370744385E-29), new QFP(0, 0, 1.0E-13, -3.037374556340037E-30), new QFP(0, 0, 1.0E-14, 1.1806906454401013E-32), new QFP(0, 0, 1.0E-15, -7.770539987666108E-32), new QFP(0, 0, 1.0, 0.0), new QFP(0, 0, 1.0E-16, 2.0902213275965398E-33), new QFP(0, 0, 1.0E-32, -5.59673099762419E-49), new QFP(0, 0, 1.0E-48, 2.5618263404376953E-65), new QFP(0, 0, 1.0E-64, 3.469426116645307E-81), new QFP(0, -512, 1.3407807929942597E74, 5.172019337390201E57), new QFP(0, -512, 1.3407807929942596E58, 1.2564174510978475E42), new QFP(0, -512, 1.3407807929942596E42, 6.749597950723014E25), new QFP(0, -512, 1.3407807929942598E26, -7.242105254017941E9), new QFP(0, -512, 1.3407807929942596E10, 6.640271499982058E-7), new QFP(0, -512, 1.3407807929942597E-6, 1.5235764695327442E-23), new QFP(0, -512, 1.3407807929942597E-22, 5.4781479788023805E-40), new QFP(0, -512, 1.3407807929942598E-38, -1.2967997819733394E-54), new QFP(0, -512, 1.3407807929942598E-54, -1.3127071245774902E-70), new QFP(0, -512, 1.3407807929942597E-70, -2.5319578694594213E-87), new QFP(0, -1024, 1.7976931348623159E68, 5.506715214002095E51), new QFP(0, 0, 1.0, 0.0), new QFP(0, -1024, 1.7976931348623159E52, 4.0756775314277165E35), new QFP(0, -1536, 2.4103124269210325E-50, 1.252882165463406E-66), new QFP(0, -2560, 433.30021027492677, 1.0085127354285447E-14), new QFP(0, -3584, 7.789408133456338E54, 1.2596420913291934E38), new QFP(0, -4096, 1.0443888814131525E-47, 4.166905886062422E-64), new QFP(0, -5120, 187749.07222429576, 6.1733330946640175E-12), new QFP(0, -6144, 3.3751521821438564E57, -2.5642866433364137E41), new QFP(0, -6656, 4.5253392192511457E-45, -1.6399659169919476E-61), new QFP(0, -7680, 8.135171247370976E7, 6.63486550845793E-9), new QFP(0, -8704, 1.462454150232811E60, -8.882405654144154E43), new QFP(0, -9216, 1.9608304352668942E-42, 1.5104613022149837E-58), new QFP(0, -10240, 3.5249714121083824E10, 2.413633304648003E-6), new QFP(0, -11264, 6.336816908133163E62, -2.7714495557529886E46), new QFP(0, -11776, 8.496282399146215E-40, 4.885169805101194E-56), new QFP(0, -12800, 1.5273708540796678E13, 1.211925982308575E-4), new QFP(0, 0, 1.0, 0.0), new QFP(0, -13824, 2.745744098767811E65, -7.723293369655276E47), new QFP(0, -27136, 5.622925608206065E-24, 3.7797383926333106E-41)};
    }
}

