/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import xeij.ComponentFactory;
import xeij.LnF;
import xeij.MC68060;
import xeij.Multilingual;
import xeij.RestorableFrame;
import xeij.ScrollTextArea;
import xeij.XEiJ;

public class RegisterList {
    public static final char[] DRP_BASE_000 = "PC:xxxxxxxx USP:xxxxxxxx SSP:xxxxxxxx              SR:xxxx X:b N:b Z:b V:b C:b\nHI:b LS:b CC(HS):b CS(LO):b NE:b EQ:b VC:b VS:b PL:b MI:b GE:b LT:b GT:b LE:b\nD  xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx  xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx\nA  xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx  xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx\n                                                                            \n                                                                            \n                                                                           \n                                                                              \n                                                                              \n                                                                              \n                                                                              ".toCharArray();
    public static final char[] DRP_BASE_030 = "PC:xxxxxxxx USP:xxxxxxxx ISP:xxxxxxxx MSP:xxxxxxxx SR:xxxx X:b N:b Z:b V:b C:b\nHI:b LS:b CC(HS):b CS(LO):b NE:b EQ:b VC:b VS:b PL:b MI:b GE:b LT:b GT:b LE:b\nD  xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx  xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx\nA  xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx  xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx\nSFC:x   VBR:xxxxxxxx CACR:xxxxxxxx                                          \nDFC:x                                                                       \nFPCR:xxxxxxxx FPSR:xxxxxxxx M:b Z:b I:b N:b B:b S:b E:b O:b U:b D:b X:b P:b\nFP0:+x.xxxxxxxxxxxxxxxxxxxxxxxxe+xxxxx  FP1:+x.xxxxxxxxxxxxxxxxxxxxxxxxe+xxxxx\nFP2:+x.xxxxxxxxxxxxxxxxxxxxxxxxe+xxxxx  FP3:+x.xxxxxxxxxxxxxxxxxxxxxxxxe+xxxxx\nFP4:+x.xxxxxxxxxxxxxxxxxxxxxxxxe+xxxxx  FP5:+x.xxxxxxxxxxxxxxxxxxxxxxxxe+xxxxx\nFP6:+x.xxxxxxxxxxxxxxxxxxxxxxxxe+xxxxx  FP7:+x.xxxxxxxxxxxxxxxxxxxxxxxxe+xxxxx".toCharArray();
    public static final char[] DRP_BASE_060 = "PC:xxxxxxxx USP:xxxxxxxx SSP:xxxxxxxx              SR:xxxx X:b N:b Z:b V:b C:b\nHI:b LS:b CC(HS):b CS(LO):b NE:b EQ:b VC:b VS:b PL:b MI:b GE:b LT:b GT:b LE:b\nD  xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx  xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx\nA  xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx  xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx\nSFC:x   VBR:xxxxxxxx CACR:xxxxxxxx  TCR:xxxxxxxx  URP:xxxxxxxx  SRP:xxxxxxxx\nDFC:x  ITT0:xxxxxxxx ITT1:xxxxxxxx DTT0:xxxxxxxx DTT1:xxxxxxxx  PCR:xxxxxxxx\nFPCR:xxxxxxxx FPSR:xxxxxxxx M:b Z:b I:b N:b B:b S:b E:b O:b U:b D:b X:b P:b\nFP0:+x.xxxxxxxxxxxxxxxxxxxxxxxxe+xxxxx  FP1:+x.xxxxxxxxxxxxxxxxxxxxxxxxe+xxxxx\nFP2:+x.xxxxxxxxxxxxxxxxxxxxxxxxe+xxxxx  FP3:+x.xxxxxxxxxxxxxxxxxxxxxxxxe+xxxxx\nFP4:+x.xxxxxxxxxxxxxxxxxxxxxxxxe+xxxxx  FP5:+x.xxxxxxxxxxxxxxxxxxxxxxxxe+xxxxx\nFP6:+x.xxxxxxxxxxxxxxxxxxxxxxxxe+xxxxx  FP7:+x.xxxxxxxxxxxxxxxxxxxxxxxxe+xxxxx".toCharArray();
    public static final int DRP_1 = 79;
    public static final int DRP_2 = 157;
    public static final int DRP_3 = 233;
    public static final int DRP_4 = 309;
    public static final int DRP_5 = 386;
    public static final int DRP_6 = 463;
    public static final int DRP_7 = 539;
    public static final int DRP_8 = 618;
    public static final int DRP_9 = 697;
    public static final int DRP_10 = 776;
    public static final int DRP_END = 854;
    public static int[] DRP_FP_POS = new int[]{543, 583, 622, 662, 701, 741, 780, 820};
    public static char[] drpCurrentBase;
    public static JFrame drpFrame;
    public static ScrollTextArea drpBoard;
    public static JTextArea drpTextArea;

    public static void drpInit() {
        drpFrame = null;
    }

    public static void drpStart() {
        if (RestorableFrame.rfmGetOpened("drp")) {
            RegisterList.drpOpen();
        }
    }

    public static void drpOpen() {
        if (drpFrame == null) {
            RegisterList.drpMake();
        }
        RegisterList.drpUpdate();
        XEiJ.pnlExitFullScreen(false);
        drpFrame.setVisible(true);
        XEiJ.dbgVisibleMask |= 1;
    }

    public static void drpMake() {
        drpBoard = ComponentFactory.setPreferredSize(ComponentFactory.setFont(new ScrollTextArea(), LnF.lnfMonospacedFont), 500, 195);
        drpBoard.setMargin(new Insets(2, 4, 2, 4));
        drpTextArea = drpBoard.getTextArea();
        drpTextArea.setEditable(false);
        RegisterList.drpSetMPU();
        drpTextArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (XEiJ.mpuTask == null && mouseEvent.isPopupTrigger()) {
                    XEiJ.dbgShowPopup(mouseEvent, drpTextArea, false);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (XEiJ.mpuTask == null && mouseEvent.isPopupTrigger()) {
                    XEiJ.dbgShowPopup(mouseEvent, drpTextArea, false);
                }
            }
        });
        drpFrame = Multilingual.mlnTitle(ComponentFactory.createRestorableSubFrame("drp", "Register list", null, ComponentFactory.createBorderPanel(drpBoard, ComponentFactory.createHorizontalBox(Box.createHorizontalGlue(), ComponentFactory.createFlowPanel(2, XEiJ.mpuMakeOriIllegalCheckBox(), XEiJ.mpuMakeStopOnErrorCheckBox(), XEiJ.mpuMakeStopAtStartCheckBox(), Box.createHorizontalStrut(12), XEiJ.mpuMakeBreakButton(), XEiJ.mpuMakeTraceButton(), XEiJ.mpuMakeTrace10Button(), XEiJ.mpuMakeTrace100Button(), XEiJ.mpuMakeStepButton(), XEiJ.mpuMakeStep10Button(), XEiJ.mpuMakeStep100Button(), XEiJ.mpuMakeReturnButton(), XEiJ.mpuMakeRunButton())))), "ja", "\u30ec\u30b8\u30b9\u30bf\u30ea\u30b9\u30c8");
        ComponentFactory.addListener(drpFrame, new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                XEiJ.dbgVisibleMask &= 0xFFFFFFFE;
            }
        });
    }

    public static void drpSetMPU() {
        char[] cArray = XEiJ.currentMPU < 3 ? DRP_BASE_000 : (drpCurrentBase = XEiJ.currentMPU < 6 ? DRP_BASE_030 : DRP_BASE_060);
        if (drpTextArea != null) {
            drpTextArea.setText(String.valueOf(drpCurrentBase));
        }
    }

    public static void drpUpdate() {
        XEiJ.fmtHex8(drpCurrentBase, 3, XEiJ.regPC);
        XEiJ.fmtHex8(drpCurrentBase, 16, XEiJ.regSRS != 0 ? XEiJ.mpuUSP : XEiJ.regRn[15]);
        if (XEiJ.currentMPU < 3) {
            XEiJ.fmtHex8(drpCurrentBase, 29, XEiJ.regSRS != 0 ? XEiJ.regRn[15] : XEiJ.mpuISP);
            XEiJ.fmtHex4(drpCurrentBase, 54, XEiJ.regSRT1 | XEiJ.regSRS | XEiJ.regSRI | XEiJ.regCCR);
        } else if (XEiJ.currentMPU < 6) {
            XEiJ.fmtHex8(drpCurrentBase, 29, XEiJ.regSRS == 0 || XEiJ.regSRM != 0 ? XEiJ.mpuISP : XEiJ.regRn[15]);
            XEiJ.fmtHex8(drpCurrentBase, 42, XEiJ.regSRS == 0 || XEiJ.regSRM == 0 ? XEiJ.mpuMSP : XEiJ.regRn[15]);
            XEiJ.fmtHex4(drpCurrentBase, 54, XEiJ.regSRT1 | XEiJ.regSRT0 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR);
        } else {
            XEiJ.fmtHex8(drpCurrentBase, 29, XEiJ.regSRS != 0 ? XEiJ.regRn[15] : XEiJ.mpuISP);
            XEiJ.fmtHex4(drpCurrentBase, 54, XEiJ.regSRT1 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR);
        }
        RegisterList.drpCurrentBase[61] = XEiJ.REG_CCRXMAP[XEiJ.regCCR];
        RegisterList.drpCurrentBase[65] = XEiJ.REG_CCRNMAP[XEiJ.regCCR];
        RegisterList.drpCurrentBase[69] = XEiJ.REG_CCRZMAP[XEiJ.regCCR];
        RegisterList.drpCurrentBase[73] = XEiJ.REG_CCRVMAP[XEiJ.regCCR];
        RegisterList.drpCurrentBase[77] = XEiJ.REG_CCRCMAP[XEiJ.regCCR];
        RegisterList.drpCurrentBase[82] = XEiJ.MPU_CCCMAP[0x40 | XEiJ.regCCR];
        RegisterList.drpCurrentBase[87] = XEiJ.MPU_CCCMAP[0x60 | XEiJ.regCCR];
        RegisterList.drpCurrentBase[96] = XEiJ.MPU_CCCMAP[0x80 | XEiJ.regCCR];
        RegisterList.drpCurrentBase[105] = XEiJ.MPU_CCCMAP[0xA0 | XEiJ.regCCR];
        RegisterList.drpCurrentBase[110] = XEiJ.MPU_CCCMAP[0xC0 | XEiJ.regCCR];
        RegisterList.drpCurrentBase[115] = XEiJ.MPU_CCCMAP[0xE0 | XEiJ.regCCR];
        RegisterList.drpCurrentBase[120] = XEiJ.MPU_CCCMAP[0x100 | XEiJ.regCCR];
        RegisterList.drpCurrentBase[125] = XEiJ.MPU_CCCMAP[0x120 | XEiJ.regCCR];
        RegisterList.drpCurrentBase[130] = XEiJ.MPU_CCCMAP[0x140 | XEiJ.regCCR];
        RegisterList.drpCurrentBase[135] = XEiJ.MPU_CCCMAP[0x160 | XEiJ.regCCR];
        RegisterList.drpCurrentBase[140] = XEiJ.MPU_CCCMAP[0x180 | XEiJ.regCCR];
        RegisterList.drpCurrentBase[145] = XEiJ.MPU_CCCMAP[0x1A0 | XEiJ.regCCR];
        RegisterList.drpCurrentBase[150] = XEiJ.MPU_CCCMAP[0x1C0 | XEiJ.regCCR];
        RegisterList.drpCurrentBase[155] = XEiJ.MPU_CCCMAP[0x1E0 | XEiJ.regCCR];
        XEiJ.fmtHex8(drpCurrentBase, 160, XEiJ.regRn[0]);
        XEiJ.fmtHex8(drpCurrentBase, 169, XEiJ.regRn[1]);
        XEiJ.fmtHex8(drpCurrentBase, 178, XEiJ.regRn[2]);
        XEiJ.fmtHex8(drpCurrentBase, 187, XEiJ.regRn[3]);
        XEiJ.fmtHex8(drpCurrentBase, 197, XEiJ.regRn[4]);
        XEiJ.fmtHex8(drpCurrentBase, 206, XEiJ.regRn[5]);
        XEiJ.fmtHex8(drpCurrentBase, 215, XEiJ.regRn[6]);
        XEiJ.fmtHex8(drpCurrentBase, 224, XEiJ.regRn[7]);
        XEiJ.fmtHex8(drpCurrentBase, 236, XEiJ.regRn[8]);
        XEiJ.fmtHex8(drpCurrentBase, 245, XEiJ.regRn[9]);
        XEiJ.fmtHex8(drpCurrentBase, 254, XEiJ.regRn[10]);
        XEiJ.fmtHex8(drpCurrentBase, 263, XEiJ.regRn[11]);
        XEiJ.fmtHex8(drpCurrentBase, 273, XEiJ.regRn[12]);
        XEiJ.fmtHex8(drpCurrentBase, 282, XEiJ.regRn[13]);
        XEiJ.fmtHex8(drpCurrentBase, 291, XEiJ.regRn[14]);
        XEiJ.fmtHex8(drpCurrentBase, 300, XEiJ.regRn[15]);
        if (3 <= XEiJ.currentMPU) {
            RegisterList.drpCurrentBase[313] = (char)(48 + XEiJ.mpuSFC);
            RegisterList.drpCurrentBase[390] = (char)(48 + XEiJ.mpuDFC);
            XEiJ.fmtHex8(drpCurrentBase, 321, XEiJ.mpuVBR);
            XEiJ.fmtHex8(drpCurrentBase, 335, XEiJ.mpuCACR);
            if (6 <= XEiJ.currentMPU) {
                XEiJ.fmtHex8(drpCurrentBase, 349, MC68060.mmuTCR);
                XEiJ.fmtHex8(drpCurrentBase, 363, MC68060.mmuURP);
                XEiJ.fmtHex8(drpCurrentBase, 377, MC68060.mmuSRP);
                XEiJ.fmtHex8(drpCurrentBase, 398, MC68060.mmuITT0);
                XEiJ.fmtHex8(drpCurrentBase, 412, MC68060.mmuITT1);
                XEiJ.fmtHex8(drpCurrentBase, 426, MC68060.mmuDTT0);
                XEiJ.fmtHex8(drpCurrentBase, 440, MC68060.mmuDTT1);
                XEiJ.fmtHex8(drpCurrentBase, 454, XEiJ.mpuPCR);
            }
            XEiJ.fmtHex8(drpCurrentBase, 468, XEiJ.fpuBox.epbFpcr);
            XEiJ.fmtHex8(drpCurrentBase, 482, XEiJ.fpuBox.epbFpsr);
            RegisterList.drpCurrentBase[493] = (char)(48 + (XEiJ.fpuBox.epbFpsr >> 27 & 1));
            RegisterList.drpCurrentBase[497] = (char)(48 + (XEiJ.fpuBox.epbFpsr >> 26 & 1));
            RegisterList.drpCurrentBase[501] = (char)(48 + (XEiJ.fpuBox.epbFpsr >> 25 & 1));
            RegisterList.drpCurrentBase[505] = (char)(48 + (XEiJ.fpuBox.epbFpsr >> 24 & 1));
            RegisterList.drpCurrentBase[509] = (char)(48 + (XEiJ.fpuBox.epbFpsr >> 15 & 1));
            RegisterList.drpCurrentBase[513] = (char)(48 + (XEiJ.fpuBox.epbFpsr >> 14 & 1));
            RegisterList.drpCurrentBase[517] = (char)(48 + (XEiJ.fpuBox.epbFpsr >> 13 & 1));
            RegisterList.drpCurrentBase[521] = (char)(48 + (XEiJ.fpuBox.epbFpsr >> 12 & 1));
            RegisterList.drpCurrentBase[525] = (char)(48 + (XEiJ.fpuBox.epbFpsr >> 11 & 1));
            RegisterList.drpCurrentBase[529] = (char)(48 + (XEiJ.fpuBox.epbFpsr >> 10 & 1));
            RegisterList.drpCurrentBase[533] = (char)(48 + (XEiJ.fpuBox.epbFpsr >> 9 & 1));
            RegisterList.drpCurrentBase[537] = (char)(48 + (XEiJ.fpuBox.epbFpsr >> 8 & 1));
            for (int i = 0; i <= 7; ++i) {
                int n;
                int n2 = DRP_FP_POS[i];
                String string = XEiJ.fpuFPn[i].toString();
                int n3 = string.length();
                for (n = 0; n < 34 && n < n3; ++n) {
                    RegisterList.drpCurrentBase[n2 + n] = string.charAt(n);
                }
                while (n < 34) {
                    RegisterList.drpCurrentBase[n2 + n] = 32;
                    ++n;
                }
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                drpTextArea.replaceRange(String.valueOf(drpCurrentBase, 3, 75), 3, 78);
                drpTextArea.replaceRange(String.valueOf(drpCurrentBase, 82, 74), 82, 156);
                drpTextArea.replaceRange(String.valueOf(drpCurrentBase, 160, 72), 160, 232);
                drpTextArea.replaceRange(String.valueOf(drpCurrentBase, 236, 72), 236, 308);
                drpTextArea.replaceRange(String.valueOf(drpCurrentBase, 313, 72), 313, 385);
                drpTextArea.replaceRange(String.valueOf(drpCurrentBase, 390, 72), 390, 462);
                drpTextArea.replaceRange(String.valueOf(drpCurrentBase, 468, 70), 468, 538);
                drpTextArea.replaceRange(String.valueOf(drpCurrentBase, 543, 74), 543, 617);
                drpTextArea.replaceRange(String.valueOf(drpCurrentBase, 622, 74), 622, 696);
                drpTextArea.replaceRange(String.valueOf(drpCurrentBase, 701, 74), 701, 775);
                drpTextArea.replaceRange(String.valueOf(drpCurrentBase, 780, 74), 780, 854);
            }
        });
    }
}

