/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import xeij.CRTC;
import xeij.CharacterCode;
import xeij.ComponentFactory;
import xeij.MC68060;
import xeij.MainMemory;
import xeij.Multilingual;
import xeij.Settings;
import xeij.VideoController;
import xeij.XEiJ;

public class TextCopy {
    public static final int TXC_AREA_DISPLAY = 0;
    public static final int TXC_AREA_C_WIDTH = 1;
    public static final int TXC_AREA_VRAM = 2;
    public static final int TXC_AREA_ENCLOSED = 3;
    public static int txcAreaMode;
    public static boolean txcEncloseEachTime;
    static HanPat[] hanTable;
    static ZenPat[] zenTable;
    static int pressedX;
    static int pressedY;
    static int enclosedX1;
    static int enclosedY1;
    static int enclosedX2;
    static int enclosedY2;
    public static int txcRow1;
    public static int txcRow2;
    public static int txcCol1;
    public static int txcCol2;

    public static void txcInit() {
        String string = Settings.sgsGetString("textcopyarea").toLowerCase();
        txcAreaMode = string.equals("display") ? 0 : (string.equals("c_width") ? 1 : (string.equals("vram") ? 2 : (string.equals("enclosed") ? 3 : 0)));
        txcEncloseEachTime = Settings.sgsGetOnOff("textcopy");
        pressedX = -1;
        pressedY = -1;
        enclosedX1 = 0;
        enclosedY1 = 0;
        enclosedX2 = 0;
        enclosedY2 = 0;
        txcRow1 = -1;
        txcRow2 = -1;
        txcCol1 = -1;
        txcCol2 = -1;
    }

    public static void txcTini() {
        Settings.sgsPutString("textcopyarea", txcAreaMode == 0 ? "display" : (txcAreaMode == 1 ? "c_width" : (txcAreaMode == 2 ? "vram" : (txcAreaMode == 3 ? "enclosed" : "display"))));
        Settings.sgsPutOnOff("textcopy", txcEncloseEachTime);
    }

    public static JMenuItem txcMakeMenuItem() {
        return ComponentFactory.setEnabled(Multilingual.mlnText(ComponentFactory.createMenuItem("Text screen copy", 67, 576, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextCopy.txcCopy();
            }
        }), "ja", "\u30c6\u30ad\u30b9\u30c8\u753b\u9762\u30b3\u30d4\u30fc"), XEiJ.clpClipboard != null);
    }

    public static JMenu txcMakeSettingMenu() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                Object object = actionEvent.getSource();
                switch (string = actionEvent.getActionCommand()) {
                    case "Display area": {
                        txcAreaMode = 0;
                        break;
                    }
                    case "C_WIDTH": {
                        txcAreaMode = 1;
                        break;
                    }
                    case "Entire VRAM": {
                        txcAreaMode = 2;
                        break;
                    }
                    case "Last enclosed area": {
                        txcAreaMode = 3;
                        break;
                    }
                    case "Enclose each time with mouse": {
                        txcEncloseEachTime = ((JCheckBoxMenuItem)object).isSelected();
                    }
                }
            }
        };
        ButtonGroup buttonGroup = new ButtonGroup();
        return ComponentFactory.setEnabled(Multilingual.mlnText(ComponentFactory.createMenu("Text screen copy setting", Multilingual.mlnText(ComponentFactory.createRadioButtonMenuItem(buttonGroup, txcAreaMode == 0, "Display area", actionListener), "ja", "\u8868\u793a\u9818\u57df"), ComponentFactory.createRadioButtonMenuItem(buttonGroup, txcAreaMode == 1, "C_WIDTH", actionListener), Multilingual.mlnText(ComponentFactory.createRadioButtonMenuItem(buttonGroup, txcAreaMode == 2, "Entire VRAM", actionListener), "ja", "VRAM \u5168\u4f53"), Multilingual.mlnText(ComponentFactory.createRadioButtonMenuItem(buttonGroup, txcAreaMode == 3, "Last enclosed area", actionListener), "ja", "\u6700\u5f8c\u306b\u56f2\u3093\u3060\u7bc4\u56f2"), ComponentFactory.createHorizontalSeparator(), Multilingual.mlnText(ComponentFactory.createCheckBoxMenuItem(txcEncloseEachTime, "Enclose each time with mouse", actionListener), "ja", "\u30de\u30a6\u30b9\u3067\u90fd\u5ea6\u56f2\u3080")), "ja", "\u30c6\u30ad\u30b9\u30c8\u753b\u9762\u30b3\u30d4\u30fc\u8a2d\u5b9a"), XEiJ.clpClipboard != null);
    }

    public static void txcReset() {
        hanTable = null;
        zenTable = null;
    }

    public static void txcMousePressed(int n, int n2) {
        if ((VideoController.vcnReg3Curr & 0x20) == 0) {
            return;
        }
        n = Math.max(0, Math.min(XEiJ.pnlScreenWidth - 1, n));
        n2 = Math.max(0, Math.min(XEiJ.pnlScreenHeight - 1, n2));
        pressedX = n;
        pressedY = n2;
    }

    public static void txcMouseMoved(int n, int n2) {
        if ((VideoController.vcnReg3Curr & 0x20) == 0) {
            return;
        }
        if (pressedX < 0) {
            return;
        }
        n = Math.max(0, Math.min(XEiJ.pnlScreenWidth - 1, n));
        n2 = Math.max(0, Math.min(XEiJ.pnlScreenHeight - 1, n2));
        TextCopy.calcLocation(n, n2);
        if (0 <= txcRow1) {
            XEiJ.pnlPanel.repaint();
        }
    }

    public static void txcMouseReleased(int n, int n2) {
        if ((VideoController.vcnReg3Curr & 0x20) == 0) {
            return;
        }
        if (pressedX < 0) {
            return;
        }
        n = Math.max(0, Math.min(XEiJ.pnlScreenWidth - 1, n));
        n2 = Math.max(0, Math.min(XEiJ.pnlScreenHeight - 1, n2));
        TextCopy.calcLocation(n, n2);
        if (0 <= txcRow1) {
            XEiJ.clpCopy(TextCopy.getText(txcRow1, txcRow2, txcCol1, txcCol2));
        }
        pressedX = -1;
        pressedY = -1;
        txcRow1 = -1;
        txcRow2 = -1;
        txcCol1 = -1;
        txcCol2 = -1;
        XEiJ.pnlPanel.repaint();
    }

    static void calcLocation(int n, int n2) {
        int n3;
        int n4 = pressedX;
        int n5 = pressedY;
        int n6 = n;
        int n7 = n2;
        if (n6 < n4) {
            n3 = n4;
            n4 = n6;
            n6 = n3;
        }
        if (n7 < n5) {
            n3 = n5;
            n5 = n7;
            n7 = n3;
        }
        n3 = (n4 += CRTC.crtR10TxXCurr) + 4 >> 3;
        int n8 = (n6 += CRTC.crtR10TxXCurr) - 4 >> 3;
        int n9 = (n5 += CRTC.crtR11TxYCurr) + 8 >> 4;
        int n10 = (n7 += CRTC.crtR11TxYCurr) - 8 >> 4;
        if (n3 <= n8 && n9 <= n10) {
            enclosedX1 = n4;
            enclosedY1 = n5;
            enclosedX2 = n6;
            enclosedY2 = n7;
            txcCol1 = n3;
            txcCol2 = n8;
            txcRow1 = n9;
            txcRow2 = n10;
        } else {
            txcCol1 = -1;
            txcCol2 = -1;
            txcRow1 = -1;
            txcRow2 = -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void txcCopy() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = CRTC.crtR10TxXCurr;
        int n7 = CRTC.crtR11TxYCurr;
        if (txcAreaMode == 0) {
            n5 = CRTC.crtR03HDispEndCurr - CRTC.crtR02HBackEndCurr << 3;
            n4 = CRTC.crtR07VDispEndCurr - CRTC.crtR06VBackEndCurr;
            if (CRTC.crtDuplication || CRTC.crtDupExceptSp) {
                n4 >>= 1;
            } else if (CRTC.crtInterlace) {
                n4 <<= 1;
            }
            n3 = n6 + n5 - 1;
            n2 = n7 + n4 - 1;
        } else if (txcAreaMode == 1) {
            int n8;
            n5 = MainMemory.mmrHumanVersion;
            if (n5 == 770) {
                n8 = 80449;
            } else if (n5 == 769) {
                n8 = 80171;
            } else if (n5 == 527) {
                n8 = 80339;
            } else if (n5 == 515) {
                n8 = 75915;
            } else if (n5 == 514) {
                n8 = 76543;
            } else if (n5 == 513) {
                n8 = 76479;
            } else {
                if (n5 != 512) return;
                n8 = 76479;
            }
            n4 = n8;
            if (n4 < 0) {
                return;
            }
            n = MC68060.mmuPeekByteZeroData(n4, 1);
            if (0 <= n && n <= 1) {
                n3 = n6 + 768 - 1;
                n2 = n7 + 512 - 1;
            } else {
                if (2 > n) return;
                if (n > 5) return;
                n3 = n6 + 512 - 1;
                n2 = n7 + 512 - 1;
            }
        } else if (txcAreaMode == 2) {
            n3 = n6 + 1024 - 1;
            n2 = n7 + 1024 - 1;
        } else {
            if (txcAreaMode != 3) return;
            n6 = enclosedX1;
            n7 = enclosedY1;
            n3 = enclosedX2;
            n2 = enclosedY2;
        }
        n5 = n6 + 4 >> 3;
        n4 = n3 - 4 >> 3;
        n = n7 + 8 >> 4;
        int n9 = n2 - 8 >> 4;
        XEiJ.clpCopy(TextCopy.getText(n, n9, n5, n4));
    }

    static void makeHash() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        byte[] byArray = MainMemory.mmrM8;
        hanTable = new HanPat[65536];
        zenTable = new ZenPat[65536];
        for (n14 = 255; 32 <= n14; --n14) {
            n13 = CharacterCode.chrSJISToChar[n14 == 128 ? 92 : (n14 == 129 ? 126 : (n14 == 130 ? 124 : (134 <= n14 && n14 <= 159 && n14 != 144 || 224 <= n14 && n14 <= 253 ? n14 ^ 0x20 : n14)))];
            if (n13 == 0) continue;
            for (n12 = 2; 0 <= n12; --n12) {
                n11 = n12 == 0 ? 15968256 + (n14 << 4) : 15966208 + (n14 << 3);
                n10 = byArray[n11] << 24 | (byArray[n11 + 1] & 0xFF) << 16 | (byArray[n11 + 2] & 0xFF) << 8 | byArray[n11 + 3] & 0xFF;
                n9 = byArray[n11 + 4] << 24 | (byArray[n11 + 5] & 0xFF) << 16 | (byArray[n11 + 6] & 0xFF) << 8 | byArray[n11 + 7] & 0xFF;
                if (n12 == 0) {
                    n8 = byArray[n11 + 8] << 24 | (byArray[n11 + 9] & 0xFF) << 16 | (byArray[n11 + 10] & 0xFF) << 8 | byArray[n11 + 11] & 0xFF;
                    n7 = byArray[n11 + 12] << 24 | (byArray[n11 + 13] & 0xFF) << 16 | (byArray[n11 + 14] & 0xFF) << 8 | byArray[n11 + 15] & 0xFF;
                } else if (n12 == 1) {
                    n8 = 0;
                    n7 = 0;
                } else {
                    n8 = n10;
                    n7 = n9;
                    n10 = 0;
                    n9 = 0;
                }
                if ((n10 | n9 | n8 | n7) == 0 || (n10 & n9 & n8 & n7) == -1) continue;
                for (n6 = 3; 0 <= n6; --n6) {
                    n5 = n10;
                    n4 = n9;
                    n3 = n8;
                    n2 = n7;
                    if ((n6 & 1) != 0) {
                        n5 |= n5 >> 1 & 0x7F7F7F7F;
                        n4 |= n4 >> 1 & 0x7F7F7F7F;
                        n3 |= n3 >> 1 & 0x7F7F7F7F;
                        n2 |= n2 >> 1 & 0x7F7F7F7F;
                    }
                    if ((n6 & 2) != 0) {
                        n5 ^= 0xFFFFFFFF;
                        n4 ^= 0xFFFFFFFF;
                        n3 ^= 0xFFFFFFFF;
                        n2 ^= 0xFFFFFFFF;
                    }
                    n = ((n5 * 31 + n4) * 31 + n3) * 31 + n2;
                    n = (n >> 16) + n & 0xFFFF;
                    HanPat hanPat = new HanPat();
                    hanPat.c = n13;
                    hanPat.p0 = n5;
                    hanPat.p1 = n4;
                    hanPat.p2 = n3;
                    hanPat.p3 = n2;
                    hanPat.next = hanTable[n];
                    TextCopy.hanTable[n] = hanPat;
                }
            }
        }
        for (n14 = 76; 0 <= n14; --n14) {
            for (n13 = 93; 0 <= n13; --n13) {
                int n15;
                int n16;
                n12 = n14 < 8 ? n14 : n14 + 7;
                n11 = n12 >> 1;
                n10 = 94 * (n12 & 1) + n13;
                n10 += 64;
                if (160 <= (n11 += 129)) {
                    n11 += 64;
                }
                if (127 <= n10) {
                    ++n10;
                }
                if ((n8 = CharacterCode.chrSJISToChar[n9 = n11 << 8 | n10]) == 0 || ((n = byArray[n7 = 0xF00000 + (n13 + 94 * n14 << 5)] << 24 | (byArray[n7 + 1] & 0xFF) << 16 | (byArray[n7 + 2] & 0xFF) << 8 | byArray[n7 + 3] & 0xFF) | (n6 = byArray[n7 + 4] << 24 | (byArray[n7 + 5] & 0xFF) << 16 | (byArray[n7 + 6] & 0xFF) << 8 | byArray[n7 + 7] & 0xFF) | (n5 = byArray[n7 + 8] << 24 | (byArray[n7 + 9] & 0xFF) << 16 | (byArray[n7 + 10] & 0xFF) << 8 | byArray[n7 + 11] & 0xFF) | (n4 = byArray[n7 + 12] << 24 | (byArray[n7 + 13] & 0xFF) << 16 | (byArray[n7 + 14] & 0xFF) << 8 | byArray[n7 + 15] & 0xFF) | (n3 = byArray[n7 + 16] << 24 | (byArray[n7 + 17] & 0xFF) << 16 | (byArray[n7 + 18] & 0xFF) << 8 | byArray[n7 + 19] & 0xFF) | (n2 = byArray[n7 + 20] << 24 | (byArray[n7 + 21] & 0xFF) << 16 | (byArray[n7 + 22] & 0xFF) << 8 | byArray[n7 + 23] & 0xFF) | (n16 = byArray[n7 + 24] << 24 | (byArray[n7 + 25] & 0xFF) << 16 | (byArray[n7 + 26] & 0xFF) << 8 | byArray[n7 + 27] & 0xFF) | (n15 = byArray[n7 + 28] << 24 | (byArray[n7 + 29] & 0xFF) << 16 | (byArray[n7 + 30] & 0xFF) << 8 | byArray[n7 + 31] & 0xFF)) == 0 || (n & n6 & n5 & n4 & n3 & n2 & n16 & n15) == -1) continue;
                for (int i = 3; 0 <= i; --i) {
                    int n17 = n;
                    int n18 = n6;
                    int n19 = n5;
                    int n20 = n4;
                    int n21 = n3;
                    int n22 = n2;
                    int n23 = n16;
                    int n24 = n15;
                    if ((i & 1) != 0) {
                        n17 |= n17 >> 1 & 0x7FFF7FFF;
                        n18 |= n18 >> 1 & 0x7FFF7FFF;
                        n19 |= n19 >> 1 & 0x7FFF7FFF;
                        n20 |= n20 >> 1 & 0x7FFF7FFF;
                        n21 |= n21 >> 1 & 0x7FFF7FFF;
                        n22 |= n22 >> 1 & 0x7FFF7FFF;
                        n23 |= n23 >> 1 & 0x7FFF7FFF;
                        n24 |= n24 >> 1 & 0x7FFF7FFF;
                    }
                    if ((i & 2) != 0) {
                        n17 ^= 0xFFFFFFFF;
                        n18 ^= 0xFFFFFFFF;
                        n19 ^= 0xFFFFFFFF;
                        n20 ^= 0xFFFFFFFF;
                        n21 ^= 0xFFFFFFFF;
                        n22 ^= 0xFFFFFFFF;
                        n23 ^= 0xFFFFFFFF;
                        n24 ^= 0xFFFFFFFF;
                    }
                    int n25 = ((((((n17 * 31 + n18) * 31 + n19) * 31 + n20) * 31 + n21) * 31 + n22) * 31 + n23) * 31 + n24;
                    n25 = (n25 >> 16) + n25 & 0xFFFF;
                    ZenPat zenPat = new ZenPat();
                    zenPat.c = n8;
                    zenPat.p0 = n17;
                    zenPat.p1 = n18;
                    zenPat.p2 = n19;
                    zenPat.p3 = n20;
                    zenPat.p4 = n21;
                    zenPat.p5 = n22;
                    zenPat.p6 = n23;
                    zenPat.p7 = n24;
                    zenPat.next = zenTable[n25];
                    TextCopy.zenTable[n25] = zenPat;
                }
            }
        }
    }

    public static String getText(int n, int n2, int n3, int n4) {
        int n5 = n4 - n3 + 1;
        int n6 = n2 - n + 1;
        if (n5 <= 0 && n6 <= 0) {
            return "NO DATA";
        }
        int[] nArray = new int[n5 + 1];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n3 + i & 0x7F;
        }
        int[] nArray2 = new int[n6 + 15];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = 0xE00000 + ((n + i & 0x3F) << 11);
        }
        if (hanTable == null) {
            TextCopy.makeHash();
        }
        byte[] byArray = MainMemory.mmrM8;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n6; ++i) {
            int n7 = nArray2[i];
            if (0 < i) {
                stringBuilder.append('\n');
            }
            for (int j = 0; j < n5; ++j) {
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                if (j + 1 < n5) {
                    n13 = n7 + nArray[j];
                    n12 = n7 + nArray[j + 1];
                    n11 = byArray[n13] << 24 | (byArray[n12] & 0xFF) << 16 | (byArray[n13 + 128] & 0xFF) << 8 | byArray[n12 + 128] & 0xFF;
                    n10 = byArray[n13 + 256] << 24 | (byArray[n12 + 256] & 0xFF) << 16 | (byArray[n13 + 384] & 0xFF) << 8 | byArray[n12 + 384] & 0xFF;
                    n9 = byArray[n13 + 512] << 24 | (byArray[n12 + 512] & 0xFF) << 16 | (byArray[n13 + 640] & 0xFF) << 8 | byArray[n12 + 640] & 0xFF;
                    n8 = byArray[n13 + 768] << 24 | (byArray[n12 + 768] & 0xFF) << 16 | (byArray[n13 + 896] & 0xFF) << 8 | byArray[n12 + 896] & 0xFF;
                    int n14 = byArray[n13 + 1024] << 24 | (byArray[n12 + 1024] & 0xFF) << 16 | (byArray[n13 + 1152] & 0xFF) << 8 | byArray[n12 + 1152] & 0xFF;
                    int n15 = byArray[n13 + 1280] << 24 | (byArray[n12 + 1280] & 0xFF) << 16 | (byArray[n13 + 1408] & 0xFF) << 8 | byArray[n12 + 1408] & 0xFF;
                    int n16 = byArray[n13 + 1536] << 24 | (byArray[n12 + 1536] & 0xFF) << 16 | (byArray[n13 + 1664] & 0xFF) << 8 | byArray[n12 + 1664] & 0xFF;
                    int n17 = byArray[n13 + 1792] << 24 | (byArray[n12 + 1792] & 0xFF) << 16 | (byArray[n13 + 1920] & 0xFF) << 8 | byArray[n12 + 1920] & 0xFF;
                    if (!((n11 | n10 | n9 | n8 | n14 | n15 | n16 | n17) != 0 && (n11 & n10 & n9 & n8 & n14 & n15 & n16 & n17) != -1 || ((n11 = byArray[n13 += 131072] << 24 | (byArray[n12 += 131072] & 0xFF) << 16 | (byArray[n13 + 128] & 0xFF) << 8 | byArray[n12 + 128] & 0xFF) | (n10 = byArray[n13 + 256] << 24 | (byArray[n12 + 256] & 0xFF) << 16 | (byArray[n13 + 384] & 0xFF) << 8 | byArray[n12 + 384] & 0xFF) | (n9 = byArray[n13 + 512] << 24 | (byArray[n12 + 512] & 0xFF) << 16 | (byArray[n13 + 640] & 0xFF) << 8 | byArray[n12 + 640] & 0xFF) | (n8 = byArray[n13 + 768] << 24 | (byArray[n12 + 768] & 0xFF) << 16 | (byArray[n13 + 896] & 0xFF) << 8 | byArray[n12 + 896] & 0xFF) | (n14 = byArray[n13 + 1024] << 24 | (byArray[n12 + 1024] & 0xFF) << 16 | (byArray[n13 + 1152] & 0xFF) << 8 | byArray[n12 + 1152] & 0xFF) | (n15 = byArray[n13 + 1280] << 24 | (byArray[n12 + 1280] & 0xFF) << 16 | (byArray[n13 + 1408] & 0xFF) << 8 | byArray[n12 + 1408] & 0xFF) | (n16 = byArray[n13 + 1536] << 24 | (byArray[n12 + 1536] & 0xFF) << 16 | (byArray[n13 + 1664] & 0xFF) << 8 | byArray[n12 + 1664] & 0xFF) | (n17 = byArray[n13 + 1792] << 24 | (byArray[n12 + 1792] & 0xFF) << 16 | (byArray[n13 + 1920] & 0xFF) << 8 | byArray[n12 + 1920] & 0xFF)) != 0 && (n11 & n10 & n9 & n8 & n14 & n15 & n16 & n17) != -1)) {
                        stringBuilder.append("  ");
                        ++j;
                        continue;
                    }
                    int n18 = ((((((n11 * 31 + n10) * 31 + n9) * 31 + n8) * 31 + n14) * 31 + n15) * 31 + n16) * 31 + n17;
                    n18 = (n18 >> 16) + n18 & 0xFFFF;
                    ZenPat zenPat = zenTable[n18];
                    while (zenPat != null && (zenPat.p0 != n11 || zenPat.p1 != n10 || zenPat.p2 != n9 || zenPat.p3 != n8 || zenPat.p4 != n14 || zenPat.p5 != n15 || zenPat.p6 != n16 || zenPat.p7 != n17)) {
                        zenPat = zenPat.next;
                    }
                    if (zenPat != null) {
                        stringBuilder.append((char)zenPat.c);
                        ++j;
                        continue;
                    }
                }
                if (!(((n12 = byArray[n13 = n7 + nArray[j]] << 24 | (byArray[n13 + 128] & 0xFF) << 16 | (byArray[n13 + 256] & 0xFF) << 8 | byArray[n13 + 384] & 0xFF) | (n11 = byArray[n13 + 512] << 24 | (byArray[n13 + 640] & 0xFF) << 16 | (byArray[n13 + 768] & 0xFF) << 8 | byArray[n13 + 896] & 0xFF) | (n10 = byArray[n13 + 1024] << 24 | (byArray[n13 + 1152] & 0xFF) << 16 | (byArray[n13 + 1280] & 0xFF) << 8 | byArray[n13 + 1408] & 0xFF) | (n9 = byArray[n13 + 1536] << 24 | (byArray[n13 + 1664] & 0xFF) << 16 | (byArray[n13 + 1792] & 0xFF) << 8 | byArray[n13 + 1920] & 0xFF)) != 0 && (n12 & n11 & n10 & n9) != -1 || ((n12 = byArray[n13 += 131072] << 24 | (byArray[n13 + 128] & 0xFF) << 16 | (byArray[n13 + 256] & 0xFF) << 8 | byArray[n13 + 384] & 0xFF) | (n11 = byArray[n13 + 512] << 24 | (byArray[n13 + 640] & 0xFF) << 16 | (byArray[n13 + 768] & 0xFF) << 8 | byArray[n13 + 896] & 0xFF) | (n10 = byArray[n13 + 1024] << 24 | (byArray[n13 + 1152] & 0xFF) << 16 | (byArray[n13 + 1280] & 0xFF) << 8 | byArray[n13 + 1408] & 0xFF) | (n9 = byArray[n13 + 1536] << 24 | (byArray[n13 + 1664] & 0xFF) << 16 | (byArray[n13 + 1792] & 0xFF) << 8 | byArray[n13 + 1920] & 0xFF)) != 0 && (n12 & n11 & n10 & n9) != -1)) {
                    stringBuilder.append(' ');
                    continue;
                }
                n8 = ((n12 * 31 + n11) * 31 + n10) * 31 + n9;
                n8 = (n8 >> 16) + n8 & 0xFFFF;
                HanPat hanPat = hanTable[n8];
                while (hanPat != null && (hanPat.p0 != n12 || hanPat.p1 != n11 || hanPat.p2 != n10 || hanPat.p3 != n9)) {
                    hanPat = hanPat.next;
                }
                if (hanPat != null) {
                    stringBuilder.append((char)hanPat.c);
                    continue;
                }
                stringBuilder.append('?');
            }
        }
        return stringBuilder.toString();
    }

    static class HanPat {
        int c;
        int p0;
        int p1;
        int p2;
        int p3;
        HanPat next;

        HanPat() {
        }
    }

    static class ZenPat {
        int c;
        int p0;
        int p1;
        int p2;
        int p3;
        int p4;
        int p5;
        int p6;
        int p7;
        ZenPat next;

        ZenPat() {
        }
    }
}

