/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import xeij.ComponentFactory;
import xeij.Hex8Spinner;
import xeij.MemoryMappedDevice;
import xeij.Multilingual;
import xeij.RestorableFrame;
import xeij.XEiJ;

public class DataBreakPoint {
    public static final boolean DBP_ON = true;
    public static final int DBP_BYTE = 0;
    public static final int DBP_WORD = 1;
    public static final int DBP_LONG = 2;
    public static final List<String> DBP_SIZE_LIST_EN = Arrays.asList("Byte", "Word", "Long");
    public static final List<String> DBP_SIZE_LIST_JA = Arrays.asList("\u30d0\u30a4\u30c8", "\u30ef\u30fc\u30c9", "\u30ed\u30f3\u30b0");
    public static final MemoryMappedDevice[] dbpUserMap = new MemoryMappedDevice[0x100000];
    public static final MemoryMappedDevice[] dbpSuperMap = new MemoryMappedDevice[0x100000];
    public static MemoryMappedDevice[] dbpMemoryMap;
    public static ArrayList<DataBreakRecord> dbpList;
    public static int dbpLock;
    public static JFrame dbpFrame;
    public static GridLayout dbpListGridLayout;
    public static JPanel dbpListPanel;

    public static void dbpInit() {
        Arrays.fill((Object[])dbpUserMap, (Object)MemoryMappedDevice.MMD_NUL);
        Arrays.fill((Object[])dbpSuperMap, (Object)MemoryMappedDevice.MMD_NUL);
        dbpMemoryMap = dbpSuperMap;
        dbpList = new ArrayList();
    }

    public static void dbpStart() {
        if (RestorableFrame.rfmGetOpened("dbp")) {
            DataBreakPoint.dbpOpen();
        }
    }

    public static void dbpOpen() {
        if (dbpFrame == null) {
            DataBreakPoint.dbpMakeFrame();
        }
        XEiJ.dbgVisibleMask |= 0x40;
        XEiJ.pnlExitFullScreen(false);
        dbpFrame.setVisible(true);
    }

    public static void dbpMakeFrame() {
        dbpLock = 0;
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                switch (actionEvent.getActionCommand()) {
                    case "Add": {
                        new DataBreakRecord(0, 0, 255, 0, 255, true, true, false, 0, 0);
                    }
                }
            }
        };
        dbpListGridLayout = new GridLayout(1, 9);
        dbpListPanel = ComponentFactory.addComponents(new JPanel(dbpListGridLayout), Multilingual.mlnText(ComponentFactory.createLabel("Enabled"), "ja", "\u6709\u52b9"), Multilingual.mlnText(ComponentFactory.createLabel("Address"), "ja", "\u30a2\u30c9\u30ec\u30b9"), Multilingual.mlnText(ComponentFactory.createLabel("Size"), "ja", "\u30b5\u30a4\u30ba"), Multilingual.mlnText(ComponentFactory.createLabel("Mask"), "ja", "\u30de\u30b9\u30af"), Multilingual.mlnText(ComponentFactory.createLabel("Lower"), "ja", "\u4e0b\u9650"), Multilingual.mlnText(ComponentFactory.createLabel("Upper"), "ja", "\u4e0a\u9650"), Multilingual.mlnText(ComponentFactory.createLabel("Read"), "ja", "\u30ea\u30fc\u30c9"), Multilingual.mlnText(ComponentFactory.createLabel("Write"), "ja", "\u30e9\u30a4\u30c8"), Multilingual.mlnText(ComponentFactory.createLabel("Count"), "ja", "\u56de\u6570"), Multilingual.mlnText(ComponentFactory.createLabel("Threshold"), "ja", "\u95be\u5024"), Multilingual.mlnText(ComponentFactory.createLabel("Remove"), "ja", "\u524a\u9664"));
        dbpFrame = Multilingual.mlnTitle(ComponentFactory.createRestorableSubFrame("dbp", "Data break point", null, ComponentFactory.setPreferredSize(ComponentFactory.createBorderPanel(ComponentFactory.createScrollPane(dbpListPanel), null, null, ComponentFactory.createFlowPanel(1, Multilingual.mlnText(ComponentFactory.createButton("Add", actionListener), "ja", "\u8ffd\u52a0"))), 750, 100)), "ja", "\u30c7\u30fc\u30bf\u30d6\u30ec\u30fc\u30af\u30dd\u30a4\u30f3\u30c8");
        ComponentFactory.addListener(dbpFrame, new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                XEiJ.dbgVisibleMask &= 0xFFFFFFBF;
            }
        });
    }

    public static void dbpBreak(int n, int n2, int n3, boolean bl) {
        block12: {
            block13: {
                block11: {
                    if (n != 0) break block11;
                    for (DataBreakRecord dataBreakRecord : dbpList) {
                        if (!dataBreakRecord.dbrEnabled || !(bl ? dataBreakRecord.dbrWrite : dataBreakRecord.dbrRead) || dataBreakRecord.dbrSize != 0 || n2 != dataBreakRecord.dbrAddress) continue;
                        int n4 = n3 & dataBreakRecord.dbrMask;
                        if (!(dataBreakRecord.dbrLower <= dataBreakRecord.dbrUpper ? dataBreakRecord.dbrLower <= n4 && n4 <= dataBreakRecord.dbrUpper : n4 <= dataBreakRecord.dbrUpper || dataBreakRecord.dbrLower <= n4)) continue;
                        dataBreakRecord.dbrSetCount(dataBreakRecord.dbrCount + 1);
                        if (dataBreakRecord.dbrThreshold > dataBreakRecord.dbrCount) continue;
                        XEiJ.mpuStop(null);
                    }
                    break block12;
                }
                if (n != 1) break block13;
                for (DataBreakRecord dataBreakRecord : dbpList) {
                    int n5;
                    if (!dataBreakRecord.dbrEnabled || !(bl ? dataBreakRecord.dbrWrite : dataBreakRecord.dbrRead)) continue;
                    if (dataBreakRecord.dbrSize == 0) {
                        if (n2 == dataBreakRecord.dbrAddress) {
                            n5 = n3 >>> 8 & dataBreakRecord.dbrMask;
                            if (!(dataBreakRecord.dbrLower <= dataBreakRecord.dbrUpper ? dataBreakRecord.dbrLower <= n5 && n5 <= dataBreakRecord.dbrUpper : n5 <= dataBreakRecord.dbrUpper || dataBreakRecord.dbrLower <= n5)) continue;
                            dataBreakRecord.dbrSetCount(dataBreakRecord.dbrCount + 1);
                            if (dataBreakRecord.dbrThreshold > dataBreakRecord.dbrCount) continue;
                            XEiJ.mpuStop(null);
                            continue;
                        }
                        if (n2 + 1 != dataBreakRecord.dbrAddress) continue;
                        n5 = n3 & dataBreakRecord.dbrMask;
                        if (!(dataBreakRecord.dbrLower <= dataBreakRecord.dbrUpper ? dataBreakRecord.dbrLower <= n5 && n5 <= dataBreakRecord.dbrUpper : n5 <= dataBreakRecord.dbrUpper || dataBreakRecord.dbrLower <= n5)) continue;
                        dataBreakRecord.dbrSetCount(dataBreakRecord.dbrCount + 1);
                        if (dataBreakRecord.dbrThreshold > dataBreakRecord.dbrCount) continue;
                        XEiJ.mpuStop(null);
                        continue;
                    }
                    if (dataBreakRecord.dbrSize != 1 || n2 != dataBreakRecord.dbrAddress) continue;
                    n5 = n3 & dataBreakRecord.dbrMask;
                    if (!(dataBreakRecord.dbrLower <= dataBreakRecord.dbrUpper ? dataBreakRecord.dbrLower <= n5 && n5 <= dataBreakRecord.dbrUpper : n5 <= dataBreakRecord.dbrUpper || dataBreakRecord.dbrLower <= n5)) continue;
                    dataBreakRecord.dbrSetCount(dataBreakRecord.dbrCount + 1);
                    if (dataBreakRecord.dbrThreshold > dataBreakRecord.dbrCount) continue;
                    XEiJ.mpuStop(null);
                }
                break block12;
            }
            if (n != 2) break block12;
            for (DataBreakRecord dataBreakRecord : dbpList) {
                int n6;
                if (!dataBreakRecord.dbrEnabled || !(bl ? dataBreakRecord.dbrWrite : dataBreakRecord.dbrRead)) continue;
                if (dataBreakRecord.dbrSize == 0) {
                    if (n2 == dataBreakRecord.dbrAddress) {
                        n6 = n3 >>> 24 & dataBreakRecord.dbrMask;
                        if (!(dataBreakRecord.dbrLower <= dataBreakRecord.dbrUpper ? dataBreakRecord.dbrLower <= n6 && n6 <= dataBreakRecord.dbrUpper : n6 <= dataBreakRecord.dbrUpper || dataBreakRecord.dbrLower <= n6)) continue;
                        dataBreakRecord.dbrSetCount(dataBreakRecord.dbrCount + 1);
                        if (dataBreakRecord.dbrThreshold > dataBreakRecord.dbrCount) continue;
                        XEiJ.mpuStop(null);
                        continue;
                    }
                    if (n2 + 1 == dataBreakRecord.dbrAddress) {
                        n6 = n3 >>> 16 & dataBreakRecord.dbrMask;
                        if (!(dataBreakRecord.dbrLower <= dataBreakRecord.dbrUpper ? dataBreakRecord.dbrLower <= n6 && n6 <= dataBreakRecord.dbrUpper : n6 <= dataBreakRecord.dbrUpper || dataBreakRecord.dbrLower <= n6)) continue;
                        dataBreakRecord.dbrSetCount(dataBreakRecord.dbrCount + 1);
                        if (dataBreakRecord.dbrThreshold > dataBreakRecord.dbrCount) continue;
                        XEiJ.mpuStop(null);
                        continue;
                    }
                    if (n2 + 2 == dataBreakRecord.dbrAddress) {
                        n6 = n3 >>> 8 & dataBreakRecord.dbrMask;
                        if (!(dataBreakRecord.dbrLower <= dataBreakRecord.dbrUpper ? dataBreakRecord.dbrLower <= n6 && n6 <= dataBreakRecord.dbrUpper : n6 <= dataBreakRecord.dbrUpper || dataBreakRecord.dbrLower <= n6)) continue;
                        dataBreakRecord.dbrSetCount(dataBreakRecord.dbrCount + 1);
                        if (dataBreakRecord.dbrThreshold > dataBreakRecord.dbrCount) continue;
                        XEiJ.mpuStop(null);
                        continue;
                    }
                    if (n2 + 3 != dataBreakRecord.dbrAddress) continue;
                    n6 = n3 & dataBreakRecord.dbrMask;
                    if (!(dataBreakRecord.dbrLower <= dataBreakRecord.dbrUpper ? dataBreakRecord.dbrLower <= n6 && n6 <= dataBreakRecord.dbrUpper : n6 <= dataBreakRecord.dbrUpper || dataBreakRecord.dbrLower <= n6)) continue;
                    dataBreakRecord.dbrSetCount(dataBreakRecord.dbrCount + 1);
                    if (dataBreakRecord.dbrThreshold > dataBreakRecord.dbrCount) continue;
                    XEiJ.mpuStop(null);
                    continue;
                }
                if (dataBreakRecord.dbrSize == 1) {
                    if (n2 == dataBreakRecord.dbrAddress) {
                        n6 = n3 >> 16 & dataBreakRecord.dbrMask;
                        if (!(dataBreakRecord.dbrLower <= dataBreakRecord.dbrUpper ? dataBreakRecord.dbrLower <= n6 && n6 <= dataBreakRecord.dbrUpper : n6 <= dataBreakRecord.dbrUpper || dataBreakRecord.dbrLower <= n6)) continue;
                        dataBreakRecord.dbrSetCount(dataBreakRecord.dbrCount + 1);
                        if (dataBreakRecord.dbrThreshold > dataBreakRecord.dbrCount) continue;
                        XEiJ.mpuStop(null);
                        continue;
                    }
                    if (n2 + 2 != dataBreakRecord.dbrAddress) continue;
                    n6 = n3 & dataBreakRecord.dbrMask;
                    if (!(dataBreakRecord.dbrLower <= dataBreakRecord.dbrUpper ? dataBreakRecord.dbrLower <= n6 && n6 <= dataBreakRecord.dbrUpper : n6 <= dataBreakRecord.dbrUpper || dataBreakRecord.dbrLower <= n6)) continue;
                    dataBreakRecord.dbrSetCount(dataBreakRecord.dbrCount + 1);
                    if (dataBreakRecord.dbrThreshold > dataBreakRecord.dbrCount) continue;
                    XEiJ.mpuStop(null);
                    continue;
                }
                if (dataBreakRecord.dbrSize != 2 || n2 != dataBreakRecord.dbrAddress) continue;
                n6 = n3 & dataBreakRecord.dbrMask;
                if (!(Integer.compareUnsigned(dataBreakRecord.dbrLower, dataBreakRecord.dbrUpper) <= 0 ? Integer.compareUnsigned(dataBreakRecord.dbrLower, n6) <= 0 && Integer.compareUnsigned(n6, dataBreakRecord.dbrUpper) <= 0 : Integer.compareUnsigned(n6, dataBreakRecord.dbrUpper) <= 0 || Integer.compareUnsigned(dataBreakRecord.dbrLower, n6) <= 0)) continue;
                dataBreakRecord.dbrSetCount(dataBreakRecord.dbrCount + 1);
                if (dataBreakRecord.dbrThreshold > dataBreakRecord.dbrCount) continue;
                XEiJ.mpuStop(null);
            }
        }
    }

    public static class DataBreakRecord
    implements Comparable<DataBreakRecord> {
        public int dbrAddress;
        public int dbrSize;
        public int dbrMask;
        public int dbrLower;
        public int dbrUpper;
        public boolean dbrRead;
        public boolean dbrWrite;
        public boolean dbrEnabled;
        public int dbrCount;
        public int dbrThreshold;
        public Box dbrEnabledBox;
        public JCheckBox dbrEnabledCheckBox;
        public Hex8Spinner dbrAddressSpinner;
        public JSpinner dbrSizeSpinner;
        public JLabel[] dbrSizeLabels;
        public Hex8Spinner dbrMaskSpinner;
        public Hex8Spinner dbrLowerSpinner;
        public Hex8Spinner dbrUpperSpinner;
        public JCheckBox dbrReadCheckBox;
        public JCheckBox dbrWriteCheckBox;
        public JSpinner dbrCountSpinner;
        public SpinnerNumberModel dbrCountModel;
        public JSpinner dbrThresholdSpinner;
        public SpinnerNumberModel dbrThresholdModel;
        public Box dbrRemoveBox;
        public JButton dbrRemoveButton;

        @Override
        public int compareTo(DataBreakRecord dataBreakRecord) {
            int n = Integer.compareUnsigned(this.dbrAddress, dataBreakRecord.dbrAddress);
            if (n == 0 && (n = Integer.compareUnsigned(this.dbrSize, dataBreakRecord.dbrSize)) == 0 && (n = Integer.compareUnsigned(this.dbrMask, dataBreakRecord.dbrMask)) == 0 && (n = Integer.compareUnsigned(this.dbrLower, dataBreakRecord.dbrLower)) == 0) {
                n = Integer.compareUnsigned(this.dbrUpper, dataBreakRecord.dbrUpper);
            }
            return n;
        }

        public DataBreakRecord(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3, int n6, int n7) {
            int n8 = n2 == 0 ? 255 : (n2 == 1 ? 65535 : -1);
            this.dbrAddress = n;
            this.dbrSize = n2;
            this.dbrMask = n3;
            this.dbrLower = n4 &= (n3 &= n8);
            this.dbrUpper = n5 &= n3;
            this.dbrRead = bl;
            this.dbrWrite = bl2;
            this.dbrEnabled = bl3;
            this.dbrCount = n6;
            this.dbrThreshold = n7;
            ActionListener actionListener = new ActionListener(this){
                final /* synthetic */ DataBreakRecord this$0;
                {
                    DataBreakRecord dataBreakRecord2 = dataBreakRecord;
                    Objects.requireNonNull(dataBreakRecord2);
                    this.this$0 = dataBreakRecord2;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object = actionEvent.getSource();
                    switch (actionEvent.getActionCommand()) {
                        case "Enabled": {
                            this.this$0.dbrSetEnabled(((JCheckBox)object).isSelected());
                            break;
                        }
                        case "Read": {
                            this.this$0.dbrRead = ((JCheckBox)object).isSelected();
                            break;
                        }
                        case "Write": {
                            this.this$0.dbrWrite = ((JCheckBox)object).isSelected();
                            break;
                        }
                        case "Remove": {
                            this.this$0.dbrRemove();
                        }
                    }
                }
            };
            this.dbrEnabledCheckBox = Multilingual.mlnText(ComponentFactory.createCheckBox(this.dbrEnabled, "Enabled", actionListener), "ja", "\u6709\u52b9");
            this.dbrEnabledBox = ComponentFactory.createGlueBox(this.dbrEnabledCheckBox);
            this.dbrAddressSpinner = ComponentFactory.createHex8Spinner(this.dbrAddress, -1, false, new ChangeListener(this){
                final /* synthetic */ DataBreakRecord this$0;
                {
                    DataBreakRecord dataBreakRecord2 = dataBreakRecord;
                    Objects.requireNonNull(dataBreakRecord2);
                    this.this$0 = dataBreakRecord2;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (dbpLock == 0) {
                        this.this$0.dbrSetAddress(((Hex8Spinner)changeEvent.getSource()).getIntValue());
                    }
                }
            });
            this.dbrSizeSpinner = Multilingual.mlnList(ComponentFactory.createListSpinner(DBP_SIZE_LIST_EN, DBP_SIZE_LIST_EN.get(this.dbrSize), new ChangeListener(this){
                final /* synthetic */ DataBreakRecord this$0;
                {
                    DataBreakRecord dataBreakRecord2 = dataBreakRecord;
                    Objects.requireNonNull(dataBreakRecord2);
                    this.this$0 = dataBreakRecord2;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (dbpLock == 0) {
                        SpinnerListModel spinnerListModel = (SpinnerListModel)((JSpinner)changeEvent.getSource()).getModel();
                        this.this$0.dbrSetSize(spinnerListModel.getList().indexOf(spinnerListModel.getValue()));
                    }
                }
            }), "ja", DBP_SIZE_LIST_JA);
            this.dbrMaskSpinner = ComponentFactory.createHex8Spinner(this.dbrMask, -1, false, new ChangeListener(this){
                final /* synthetic */ DataBreakRecord this$0;
                {
                    DataBreakRecord dataBreakRecord2 = dataBreakRecord;
                    Objects.requireNonNull(dataBreakRecord2);
                    this.this$0 = dataBreakRecord2;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (dbpLock == 0) {
                        this.this$0.dbrSetMask(((Hex8Spinner)changeEvent.getSource()).getIntValue());
                    }
                }
            });
            this.dbrLowerSpinner = ComponentFactory.createHex8Spinner(this.dbrLower, -1, false, new ChangeListener(this){
                final /* synthetic */ DataBreakRecord this$0;
                {
                    DataBreakRecord dataBreakRecord2 = dataBreakRecord;
                    Objects.requireNonNull(dataBreakRecord2);
                    this.this$0 = dataBreakRecord2;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (dbpLock == 0) {
                        this.this$0.dbrSetLower(((Hex8Spinner)changeEvent.getSource()).getIntValue());
                    }
                }
            });
            this.dbrUpperSpinner = ComponentFactory.createHex8Spinner(this.dbrUpper, -1, false, new ChangeListener(this){
                final /* synthetic */ DataBreakRecord this$0;
                {
                    DataBreakRecord dataBreakRecord2 = dataBreakRecord;
                    Objects.requireNonNull(dataBreakRecord2);
                    this.this$0 = dataBreakRecord2;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (dbpLock == 0) {
                        this.this$0.dbrSetUpper(((Hex8Spinner)changeEvent.getSource()).getIntValue());
                    }
                }
            });
            this.dbrReadCheckBox = Multilingual.mlnText(ComponentFactory.createCheckBox(this.dbrRead, "Read", actionListener), "ja", "\u30ea\u30fc\u30c9");
            this.dbrWriteCheckBox = Multilingual.mlnText(ComponentFactory.createCheckBox(this.dbrWrite, "Write", actionListener), "ja", "\u30e9\u30a4\u30c8");
            this.dbrCountModel = new SpinnerNumberModel(this.dbrCount, 0, 99999999, 1);
            this.dbrCountSpinner = ComponentFactory.createNumberSpinner(this.dbrCountModel, 8, new ChangeListener(this){
                final /* synthetic */ DataBreakRecord this$0;
                {
                    DataBreakRecord dataBreakRecord2 = dataBreakRecord;
                    Objects.requireNonNull(dataBreakRecord2);
                    this.this$0 = dataBreakRecord2;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (dbpLock == 0) {
                        this.this$0.dbrSetCount(this.this$0.dbrCountModel.getNumber().intValue());
                    }
                }
            });
            this.dbrThresholdModel = new SpinnerNumberModel(this.dbrThreshold, 0, 99999999, 1);
            this.dbrThresholdSpinner = ComponentFactory.createNumberSpinner(this.dbrThresholdModel, 8, new ChangeListener(this){
                final /* synthetic */ DataBreakRecord this$0;
                {
                    DataBreakRecord dataBreakRecord2 = dataBreakRecord;
                    Objects.requireNonNull(dataBreakRecord2);
                    this.this$0 = dataBreakRecord2;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (dbpLock == 0) {
                        this.this$0.dbrSetThreshold(this.this$0.dbrThresholdModel.getNumber().intValue());
                    }
                }
            });
            this.dbrRemoveButton = Multilingual.mlnText(ComponentFactory.createButton("Remove", actionListener), "ja", "\u524a\u9664");
            this.dbrRemoveBox = ComponentFactory.createGlueBox(this.dbrRemoveButton);
            dbpList.add(this);
            dbpListGridLayout.setRows(dbpListGridLayout.getRows() + 1);
            ComponentFactory.addComponents(dbpListPanel, this.dbrEnabledBox, this.dbrAddressSpinner, this.dbrSizeSpinner, this.dbrMaskSpinner, this.dbrLowerSpinner, this.dbrUpperSpinner, this.dbrReadCheckBox, this.dbrWriteCheckBox, this.dbrCountSpinner, this.dbrThresholdSpinner, this.dbrRemoveBox);
            dbpListPanel.validate();
            dbpListPanel.repaint();
            this.dbrSetEnabled(this.dbrEnabled);
        }

        public void dbrRemove() {
            this.dbrSetEnabled(false);
            ComponentFactory.removeComponents(dbpListPanel, this.dbrEnabledBox, this.dbrAddressSpinner, this.dbrSizeSpinner, this.dbrMaskSpinner, this.dbrLowerSpinner, this.dbrUpperSpinner, this.dbrReadCheckBox, this.dbrWriteCheckBox, this.dbrCountSpinner, this.dbrThresholdSpinner, this.dbrRemoveBox);
            dbpListGridLayout.setRows(dbpListGridLayout.getRows() - 1);
            dbpListPanel.validate();
            dbpListPanel.repaint();
            dbpList.remove(this);
        }

        public void dbrSetAddress(int n) {
            if (this.dbrAddress != n) {
                this.dbrAddress = n;
                if (this.dbrAddressSpinner != null) {
                    ++dbpLock;
                    this.dbrAddressSpinner.setIntValue(n);
                    --dbpLock;
                }
            }
        }

        public void dbrSetSize(int n) {
            if (this.dbrSize != n) {
                this.dbrSize = n;
                if (this.dbrSizeSpinner != null) {
                    ++dbpLock;
                    this.dbrSizeSpinner.setValue(((SpinnerListModel)this.dbrSizeSpinner.getModel()).getList().get(n));
                    --dbpLock;
                }
                this.dbrSetMask(this.dbrMask & (this.dbrSize == 0 ? 255 : (this.dbrSize == 1 ? 65535 : -1)));
            }
        }

        public void dbrSetMask(int n) {
            if (this.dbrMask != (n &= this.dbrSize == 0 ? 255 : (this.dbrSize == 1 ? 65535 : -1))) {
                this.dbrMask = n;
                if (this.dbrMaskSpinner != null) {
                    ++dbpLock;
                    this.dbrMaskSpinner.setIntValue(n);
                    --dbpLock;
                }
                this.dbrSetLower(this.dbrLower);
                this.dbrSetUpper(this.dbrUpper);
            }
        }

        public void dbrSetLower(int n) {
            if (this.dbrLower != (n &= this.dbrMask)) {
                this.dbrLower = n;
                if (this.dbrLowerSpinner != null) {
                    ++dbpLock;
                    this.dbrLowerSpinner.setIntValue(n);
                    --dbpLock;
                }
            }
        }

        public void dbrSetUpper(int n) {
            if (this.dbrUpper != (n &= this.dbrMask)) {
                this.dbrUpper = n;
                if (this.dbrUpperSpinner != null) {
                    ++dbpLock;
                    this.dbrUpperSpinner.setIntValue(n);
                    --dbpLock;
                }
            }
        }

        public void dbrSetEnabled(boolean bl) {
            if (this.dbrEnabled != bl) {
                this.dbrEnabled = bl;
                this.dbrEnabledCheckBox.setSelected(bl);
            }
            int n = this.dbrAddress >>> 12;
            if (this.dbrEnabled) {
                DataBreakPoint.dbpUserMap[n] = DataBreakPoint.dbpSuperMap[n] = MemoryMappedDevice.MMD_DBP;
            } else {
                boolean bl2 = false;
                for (DataBreakRecord dataBreakRecord : dbpList) {
                    if (dataBreakRecord.dbrAddress >>> 12 != n || dataBreakRecord == this) continue;
                    bl2 = true;
                    break;
                }
                DataBreakPoint.dbpUserMap[n] = bl2 ? MemoryMappedDevice.MMD_DBP : XEiJ.busUserMap[n];
                DataBreakPoint.dbpSuperMap[n] = bl2 ? MemoryMappedDevice.MMD_DBP : XEiJ.busSuperMap[n];
            }
        }

        public void dbrSetCount(int n) {
            if (this.dbrCount != n) {
                this.dbrCount = n;
                if (this.dbrCountSpinner != null) {
                    ++dbpLock;
                    this.dbrCountSpinner.setValue(n);
                    --dbpLock;
                }
            }
        }

        public void dbrSetThreshold(int n) {
            if (this.dbrThreshold != n) {
                this.dbrThreshold = n;
                if (this.dbrThresholdSpinner != null) {
                    ++dbpLock;
                    this.dbrThresholdSpinner.setValue(n);
                    --dbpLock;
                }
            }
        }
    }
}

