/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.HashMap;
import xeij.ScrollCanvas;

public class DrawingCanvas
extends ScrollCanvas {
    protected AffineTransform transformToView;
    protected HashMap<Integer, Shape> shapes;
    protected HashMap<Integer, GeneralPath> scaledShapes;
    protected HashMap<Integer, Stroke> strokes;
    protected HashMap<Integer, Paint> drawPaints;
    protected HashMap<Integer, Paint> fillPaints;

    public DrawingCanvas() {
        this.init();
    }

    public DrawingCanvas(int n, int n2) {
        super(n, n2);
        this.init();
    }

    public DrawingCanvas(BufferedImage bufferedImage) {
        super(bufferedImage);
        this.init();
    }

    private void init() {
        this.shapes = new HashMap();
        this.scaledShapes = new HashMap();
        this.strokes = new HashMap();
        this.drawPaints = new HashMap();
        this.fillPaints = new HashMap();
    }

    @Override
    protected void paintView(Graphics graphics) {
        super.paintView(graphics);
        if (this.canvasImage != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object[] objectArray = this.shapes.keySet().toArray(new Integer[0]);
            Arrays.sort(objectArray);
            Object[] objectArray2 = objectArray;
            int n = objectArray2.length;
            for (int i = 0; i < n; ++i) {
                Paint paint;
                Paint paint2;
                int n2 = (Integer)objectArray2[i];
                Shape shape = this.scaledShapes.get(n2);
                if (shape == null) continue;
                Stroke stroke = this.strokes.get(n2);
                if (stroke != null) {
                    graphics2D.setStroke(stroke);
                }
                if ((paint2 = this.fillPaints.get(n2)) != null) {
                    graphics2D.setPaint(paint2);
                    graphics2D.fill(shape);
                }
                if ((paint = this.drawPaints.get(n2)) == null) continue;
                graphics2D.setPaint(paint);
                graphics2D.draw(shape);
            }
        }
    }

    @Override
    protected void calcAdditionalSize() {
        this.transformToView = new AffineTransform(this.scaleFactor, 0.0f, 0.0f, this.scaleFactor, this.originX, this.originY);
        for (int n : this.shapes.keySet()) {
            this.calcScaledShape(n);
        }
    }

    public void setShape(int n, Shape shape, Stroke stroke, Paint paint, Paint paint2) {
        this.shapes.put(n, shape);
        this.scaledShapes.put(n, new GeneralPath());
        this.calcScaledShape(n);
        this.strokes.put(n, stroke);
        this.drawPaints.put(n, paint);
        this.fillPaints.put(n, paint2);
        this.view.repaint();
    }

    protected void calcScaledShape(int n) {
        GeneralPath generalPath;
        Shape shape = this.shapes.get(n);
        if (shape != null && (generalPath = this.scaledShapes.get(n)) != null) {
            generalPath.reset();
            float[] fArray = new float[6];
            PathIterator pathIterator = shape.getPathIterator(this.transformToView);
            while (!pathIterator.isDone()) {
                switch (pathIterator.currentSegment(fArray)) {
                    case 4: {
                        generalPath.closePath();
                        break;
                    }
                    case 3: {
                        generalPath.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                        break;
                    }
                    case 1: {
                        generalPath.lineTo(fArray[0], fArray[1]);
                        break;
                    }
                    case 0: {
                        generalPath.moveTo(fArray[0], fArray[1]);
                        break;
                    }
                    case 2: {
                        generalPath.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                    }
                }
                pathIterator.next();
            }
        }
    }
}

