/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import xeij.ByteArray;
import xeij.XEiJ;

public class HumanMedia {
    protected static final int HUM_EXECUTABLE = 128;
    protected static final int HUM_LINK = 64;
    protected static final int HUM_ARCHIVE = 32;
    protected static final int HUM_DIRECTORY = 16;
    protected static final int HUM_VOLUME = 8;
    protected static final int HUM_SYSTEM = 4;
    protected static final int HUM_HIDDEN = 2;
    protected static final int HUM_READONLY = 1;
    public int humBytesShiftSector;
    public int humBytesPerSector;
    public int humSectorsShiftCluster;
    public int humSectorsPerCluster;
    public int humBytesShiftCluster;
    public int humBytesPerCluster;
    public int humFatCount;
    public int humReservedSectors;
    public int humRootEntries;
    public int humEntriesPerSector;
    public int humRootSectors;
    public int humMediaByte;
    public int humFatID;
    public boolean humFat12;
    public int humFatMarker;
    public int humFatTailCode;
    public int humFatSectors;
    public int humPartitionSectors;
    public int humFatAndDataSectors;
    public int humDataClustersPlus2;
    public long humPartitionStartByte;
    public long humFatStartByte;
    public int humRootStartSector;
    public long humRootStartByte;
    public int humDataStartSector;
    public long humDataStartByte;
    public long humDataEndByte;
    public long humPartitionEndByte;
    public long humDiskEndByte;

    public HumanMedia(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, long l) {
        this(n, n2, n3, n4, n5, n6, n7, n8, l, 0L, l);
    }

    public HumanMedia(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, long l, long l2) {
        this(n, n2, n3, n4, n5, n6, n7, n8, l, l2, l);
    }

    public HumanMedia(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, long l, long l2, long l3) {
        this.humBytesPerSector = n;
        this.humFatCount = n3;
        this.humReservedSectors = n4;
        this.humRootEntries = n5;
        this.humMediaByte = n6;
        this.humFatID = n7;
        this.humPartitionStartByte = l2;
        this.humPartitionEndByte = l3;
        this.humDiskEndByte = l;
        this.humBytesShiftSector = Integer.numberOfTrailingZeros(this.humBytesPerSector);
        this.humPartitionSectors = (int)(this.humPartitionEndByte - this.humPartitionStartByte >> this.humBytesShiftSector);
        this.humFatStartByte = this.humPartitionStartByte + (long)(this.humReservedSectors << this.humBytesShiftSector);
        this.humEntriesPerSector = this.humBytesPerSector >> 5;
        this.humRootSectors = this.humBytesToSectors(this.humRootEntries << 5);
        this.humFatAndDataSectors = this.humPartitionSectors - this.humReservedSectors - this.humRootSectors;
        if (n2 >= 0) {
            this.humSectorsShiftCluster = Integer.numberOfTrailingZeros(n2);
            this.humSectorsPerCluster = n2;
        } else {
            this.humSectorsShiftCluster = 0;
            this.humSectorsPerCluster = 1;
            while (this.humBytesToSectors(131044) * this.humFatCount + (65520 << this.humSectorsShiftCluster) < this.humFatAndDataSectors) {
                ++this.humSectorsShiftCluster;
            }
            this.humSectorsPerCluster = 1 << this.humSectorsShiftCluster;
        }
        this.humBytesShiftCluster = this.humBytesShiftSector + this.humSectorsShiftCluster;
        this.humBytesPerCluster = 1 << this.humBytesShiftCluster;
        this.humFat12 = this.humFatAndDataSectors < this.humBytesToSectors(8174) * this.humFatCount + (4085 << this.humSectorsShiftCluster);
        this.humFatMarker = this.humFatID << 24 | (this.humFat12 ? 0xFFFF00 : 0xFFFFFF);
        int n9 = this.humFatTailCode = this.humFat12 ? 4095 : 65535;
        if (n8 >= 0) {
            this.humFatSectors = n8;
            this.humDataClustersPlus2 = this.humFatAndDataSectors - this.humFatSectors * this.humFatCount >> this.humSectorsShiftCluster;
        } else {
            this.humDataClustersPlus2 = (this.humFatAndDataSectors >> this.humSectorsShiftCluster) + 2;
            this.humDataClustersPlus2 = (this.humFat12 ? Math.min(4084, this.humFatAndDataSectors - this.humBytesToSectors(3 * this.humDataClustersPlus2 + 1 >>> 1) * this.humFatCount >> this.humSectorsShiftCluster) : this.humFatAndDataSectors - this.humBytesToSectors(2 * this.humDataClustersPlus2) * this.humFatCount >> this.humSectorsShiftCluster) + 2;
            this.humFatSectors = (this.humFatAndDataSectors - (this.humDataClustersPlus2 - 2 << this.humSectorsShiftCluster)) / this.humFatCount;
        }
        this.humRootStartSector = this.humReservedSectors + this.humFatSectors * this.humFatCount;
        this.humRootStartByte = this.humPartitionStartByte + (long)(this.humRootStartSector << this.humBytesShiftSector);
        this.humDataStartSector = this.humRootStartSector + this.humRootSectors;
        this.humDataStartByte = this.humPartitionStartByte + (long)(this.humDataStartSector << this.humBytesShiftSector);
        this.humDataEndByte = this.humDataStartByte + ((long)(this.humDataClustersPlus2 - 2) << this.humBytesShiftCluster);
    }

    public final void humPrintInfo() {
        System.out.printf("   humBytesShiftSector=  %12d\n", this.humBytesShiftSector);
        System.out.printf("     humBytesPerSector=  %12d\n", this.humBytesPerSector);
        System.out.printf("humSectorsShiftCluster=  %12d\n", this.humSectorsShiftCluster);
        System.out.printf("  humSectorsPerCluster=  %12d\n", this.humSectorsPerCluster);
        System.out.printf("  humBytesShiftCluster=  %12d\n", this.humBytesShiftCluster);
        System.out.printf("    humBytesPerCluster=  %12d\n", this.humBytesPerCluster);
        System.out.printf("           humFatCount=  %12d\n", this.humFatCount);
        System.out.printf("    humReservedSectors=  %12d\n", this.humReservedSectors);
        System.out.printf("        humRootEntries=  %12d\n", this.humRootEntries);
        System.out.printf("   humEntriesPerSector=  %12d\n", this.humEntriesPerSector);
        System.out.printf("        humRootSectors=  %12d\n", this.humRootSectors);
        System.out.printf("          humMediaByte=    0x%08x\n", this.humMediaByte);
        System.out.printf("              humFatID=    0x%08x\n", this.humFatID);
        System.out.printf("              humFat12=  %12b\n", this.humFat12);
        System.out.printf("          humFatMarker=    0x%08x\n", this.humFatMarker);
        System.out.printf("        humFatTailCode=    0x%08x\n", this.humFatTailCode);
        System.out.printf("         humFatSectors=  %12d\n", this.humFatSectors);
        System.out.printf("   humPartitionSectors=  %12d\n", this.humPartitionSectors);
        System.out.printf("  humFatAndDataSectors=  %12d\n", this.humFatAndDataSectors);
        System.out.printf("  humDataClustersPlus2=  %12d\n", this.humDataClustersPlus2);
        System.out.printf(" humPartitionStartByte=0x%012x\n", this.humPartitionStartByte);
        System.out.printf("       humFatStartByte=0x%012x\n", this.humFatStartByte);
        System.out.printf("    humRootStartSector=  %12d\n", this.humRootStartSector);
        System.out.printf("      humRootStartByte=0x%012x\n", this.humRootStartByte);
        System.out.printf("    humDataStartSector=  %12d\n", this.humDataStartSector);
        System.out.printf("      humDataStartByte=0x%012x\n", this.humDataStartByte);
        System.out.printf("        humDataEndByte=0x%012x\n", this.humDataEndByte);
        System.out.printf("   humPartitionEndByte=0x%012x\n", this.humPartitionEndByte);
        System.out.printf("        humDiskEndByte=0x%012x\n", this.humDiskEndByte);
    }

    public final int humBytesToSectors(int n) {
        return n + (this.humBytesPerSector - 1) >> this.humBytesShiftSector;
    }

    public final int humBytesToSectors(long l) {
        return (int)(l + (long)(this.humBytesPerSector - 1) >> this.humBytesShiftSector);
    }

    public void humWriteFatMarker(byte[] byArray) {
        for (int i = 0; i < this.humFatCount; ++i) {
            ByteArray.byaWl(byArray, (int)this.humFatStartByte + (this.humFatSectors * i << this.humBytesShiftSector), this.humFatMarker);
        }
    }

    public boolean humCopyHumanSys(byte[] byArray) {
        byte[] byArray2 = XEiJ.rscGetResource("HUMAN.SYS", new int[0]);
        if (byArray2 == null || byArray2.length != 58496) {
            return false;
        }
        this.humCopySystemFile(byArray, "HUMAN   SYS", 36, 24576, 6959, byArray2);
        return true;
    }

    public boolean humCopyCommandX(byte[] byArray) {
        byte[] byArray2 = XEiJ.rscGetResource("COMMAND.X", new int[0]);
        if (byArray2 == null || byArray2.length != 28382) {
            return false;
        }
        this.humCopySystemFile(byArray, "COMMAND X  ", 32, 24576, 6745, byArray2);
        return true;
    }

    public void humCopySystemFile(byte[] byArray, String string, int n, int n2, int n3, byte[] byArray2) {
        int n4;
        int n5 = (int)this.humRootStartByte;
        while (byArray[n5] != 0) {
            n5 += 32;
        }
        ByteArray.byaWstr(byArray, n5, string);
        ByteArray.byaWb(byArray, n5 + 11, n);
        ByteArray.byaWstr(byArray, n5 + 12, "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
        ByteArray.byaWiw(byArray, n5 + 22, n2);
        ByteArray.byaWiw(byArray, n5 + 24, n3);
        int n6 = 0;
        int n7 = n4 = byArray2 == null ? 0 : byArray2.length;
        if (n4 > 0) {
            n6 = 2;
            while (this.humGetFat(byArray, n6) != 0) {
                ++n6;
            }
            int n8 = n6 + (n4 - 1 >> this.humBytesShiftCluster);
            for (int i = n6; i < n8; ++i) {
                this.humSetFat(byArray, i, i + 1);
            }
            this.humSetFat(byArray, n8, this.humFatTailCode);
            System.arraycopy(byArray2, 0, byArray, (int)this.humDataStartByte + (n6 - 2 << this.humBytesShiftCluster), n4);
        }
        ByteArray.byaWiw(byArray, n5 + 26, n6);
        ByteArray.byaWil(byArray, n5 + 28, n4);
    }

    public boolean humUndel(byte[] byArray, int n, int n2) {
        if ((byArray[n] & 0xFF) != 229) {
            return false;
        }
        int n3 = ByteArray.byaRils(byArray, n + 28);
        if (n3 > 0) {
            int n4;
            int n5 = ByteArray.byaRiwz(byArray, n + 26);
            int n6 = n5 + (n3 - 1 >> this.humBytesShiftCluster);
            if (this.humDataClustersPlus2 <= n6) {
                return false;
            }
            for (n4 = n5; n4 <= n6; ++n4) {
                if (this.humGetFat(byArray, n4) == 0) continue;
                return false;
            }
            for (n4 = n5; n4 < n6; ++n4) {
                this.humSetFat(byArray, n4, n4 + 1);
            }
            this.humSetFat(byArray, n6, this.humFatTailCode);
        }
        byArray[n] = (byte)n2;
        return true;
    }

    public void humDumpFat(byte[] byArray) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("       ");
        for (n = 0; n < 20; ++n) {
            stringBuilder.append(String.format(" %+5d", n));
        }
        stringBuilder.append('\n');
        n = 0;
        int n2 = 20;
        while (n < this.humDataClustersPlus2) {
            stringBuilder.append(String.format("%5d|", n));
            for (int i = n; i < n2; ++i) {
                if (i < 2 || this.humDataClustersPlus2 <= i) {
                    stringBuilder.append("      ");
                    continue;
                }
                int n3 = this.humGetFat(byArray, i);
                stringBuilder.append(n3 == 0 ? "   ---" : (n3 != this.humFatTailCode ? String.format(" %5d", n3) : "   END"));
            }
            stringBuilder.append('\n');
            n = n2;
            n2 += 20;
        }
        System.out.println(stringBuilder.toString());
    }

    public int humGetFat(byte[] byArray, int n) {
        if (this.humFat12) {
            int n2 = (int)this.humFatStartByte + 3 * (n >> 1);
            return (n & 1) == 0 ? byArray[n2 + 1] << 8 & 0xF00 | byArray[n2] & 0xFF : byArray[n2 + 2] << 4 & 0xFF0 | byArray[n2 + 1] >> 4 & 0xF;
        }
        int n3 = (int)this.humFatStartByte + (n << 1);
        return (char)(byArray[n3] << 8 | byArray[n3 + 1] & 0xFF);
    }

    public void humSetFat(byte[] byArray, int n, int n2) {
        if (this.humFat12) {
            int n3 = (int)this.humFatStartByte + 3 * (n >> 1);
            if ((n & 1) == 0) {
                byArray[n3] = (byte)n2;
                byArray[n3 + 1] = (byte)(byArray[n3 + 1] & 0xF0 | n2 >> 8 & 0xF);
            } else {
                byArray[n3 + 1] = (byte)(n2 << 4 | byArray[n3 + 1] & 0xF);
                byArray[n3 + 2] = (byte)(n2 >> 4);
            }
        } else {
            int n4 = (int)this.humFatStartByte + (n << 1);
            byArray[n4] = (byte)(n2 >> 8);
            byArray[n4 + 1] = (byte)n2;
        }
    }
}

