/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.util.Arrays;
import java.util.TreeMap;
import xeij.ExpressionEvaluator;
import xeij.MC68060;
import xeij.MemoryMappedDevice;
import xeij.WaitInstruction;
import xeij.XEiJ;

public class InstructionBreakPoint {
    public static final boolean IBP_ON = true;
    public static final int IBP_HASH_BITS = 8;
    public static final int IBP_HASH_SIZE = 256;
    public static final int IBP_HASH_MASK = 255;
    public static MemoryMappedDevice[] ibpUserMap;
    public static MemoryMappedDevice[] ibpSuperMap;
    public static MemoryMappedDevice[] ibpOp1UserMap;
    public static MemoryMappedDevice[] ibpOp1SuperMap;
    public static MemoryMappedDevice[] ibpOp1MemoryMap;
    public static TreeMap<Integer, InstructionBreakRecord> ibpPointTable;
    public static InstructionBreakRecord[] ibpHashTable;

    public static void ibpInit() {
        ibpUserMap = new MemoryMappedDevice[0x100000];
        ibpSuperMap = new MemoryMappedDevice[0x100000];
        Arrays.fill((Object[])ibpUserMap, (Object)MemoryMappedDevice.MMD_NUL);
        Arrays.fill((Object[])ibpSuperMap, (Object)MemoryMappedDevice.MMD_NUL);
        ibpOp1UserMap = XEiJ.busUserMap;
        ibpOp1SuperMap = XEiJ.busSuperMap;
        ibpOp1MemoryMap = ibpOp1SuperMap;
        ibpPointTable = new TreeMap();
        ibpHashTable = new InstructionBreakRecord[256];
    }

    public static void ibpReset() {
        for (InstructionBreakRecord instructionBreakRecord : ibpPointTable.values()) {
            instructionBreakRecord.ibrValue = 0;
            instructionBreakRecord.ibrTarget = instructionBreakRecord.ibrThreshold < 0 ? 0 : instructionBreakRecord.ibrThreshold;
        }
    }

    public static void ibpAddWaitPoint(int n, int n2, WaitInstruction waitInstruction) {
        TreeMap<Integer, InstructionBreakRecord> treeMap = ibpPointTable;
        InstructionBreakRecord instructionBreakRecord = treeMap.get(n);
        if (instructionBreakRecord == null) {
            instructionBreakRecord = InstructionBreakPoint.ibpPut(n, n2, 0, Integer.MAX_VALUE, null);
        }
        instructionBreakRecord.ibrWaitInstruction = waitInstruction;
    }

    public static void ibpRemoveWaitPoint(int n, int n2) {
        TreeMap<Integer, InstructionBreakRecord> treeMap = ibpPointTable;
        InstructionBreakRecord instructionBreakRecord = treeMap.get(n);
        if (instructionBreakRecord != null) {
            instructionBreakRecord.ibrWaitInstruction = null;
            if (instructionBreakRecord.ibrThreshold == Integer.MAX_VALUE) {
                InstructionBreakPoint.ibpRemove(n, n2);
            }
        }
    }

    public static void ibpInstant(int n, int n2) {
        TreeMap<Integer, InstructionBreakRecord> treeMap = ibpPointTable;
        InstructionBreakRecord instructionBreakRecord = treeMap.get(n);
        if (instructionBreakRecord == null) {
            InstructionBreakPoint.ibpPut(n, n2, 0, -1, null);
        } else {
            instructionBreakRecord.ibrTarget = instructionBreakRecord.ibrLogicalAddress == n ? instructionBreakRecord.ibrValue + 1 : instructionBreakRecord.ibrValue;
        }
    }

    public static InstructionBreakRecord ibpPut(int n, int n2, int n3, int n4, ExpressionEvaluator.ExpressionElement expressionElement) {
        int n5 = MC68060.mmuTranslatePeek(n, n2, 0);
        if ((n ^ n5) == 1) {
            return null;
        }
        TreeMap<Integer, InstructionBreakRecord> treeMap = ibpPointTable;
        InstructionBreakRecord instructionBreakRecord = treeMap.get(n);
        if (instructionBreakRecord == null) {
            if (treeMap.isEmpty()) {
                ibpOp1SuperMap = ibpSuperMap;
                ibpOp1UserMap = ibpUserMap;
                ibpOp1MemoryMap = XEiJ.regSRS != 0 ? ibpOp1SuperMap : ibpOp1UserMap;
            }
            instructionBreakRecord = new InstructionBreakRecord();
            instructionBreakRecord.ibrLogicalAddress = n;
            instructionBreakRecord.ibrPhysicalAddress = n5;
            treeMap.put(n, instructionBreakRecord);
            InstructionBreakRecord[] instructionBreakRecordArray = ibpHashTable;
            int n6 = n5 >>> 1 & 0xFF;
            instructionBreakRecord.ibrNext = instructionBreakRecordArray[n6];
            instructionBreakRecordArray[n6] = instructionBreakRecord;
            int n7 = n5 >>> 12;
            InstructionBreakPoint.ibpSuperMap[n7] = MemoryMappedDevice.MMD_IBP;
            InstructionBreakPoint.ibpUserMap[n7] = MemoryMappedDevice.MMD_IBP;
        }
        instructionBreakRecord.ibrValue = n3;
        instructionBreakRecord.ibrTarget = n4 < 0 ? 0 : n4;
        instructionBreakRecord.ibrThreshold = n4;
        instructionBreakRecord.ibrWaitInstruction = null;
        instructionBreakRecord.ibrScriptElement = expressionElement;
        return instructionBreakRecord;
    }

    public static void ibpRemove(int n, int n2) {
        int n3 = MC68060.mmuTranslatePeek(n, n2, 0);
        if ((n ^ n3) == 1) {
            return;
        }
        TreeMap<Integer, InstructionBreakRecord> treeMap = ibpPointTable;
        InstructionBreakRecord instructionBreakRecord = treeMap.get(n);
        if (instructionBreakRecord != null) {
            InstructionBreakRecord[] instructionBreakRecordArray = ibpHashTable;
            int n4 = n3 >>> 1 & 0xFF;
            Object object = instructionBreakRecordArray[n4];
            if (object == instructionBreakRecord) {
                instructionBreakRecordArray[n4] = instructionBreakRecord.ibrNext;
            } else {
                while (((InstructionBreakRecord)object).ibrNext != instructionBreakRecord) {
                    object = ((InstructionBreakRecord)object).ibrNext;
                }
                ((InstructionBreakRecord)object).ibrNext = instructionBreakRecord.ibrNext;
            }
            instructionBreakRecord.ibrNext = null;
            int n5 = n3 >>> 12;
            n4 = 0;
            for (InstructionBreakRecord instructionBreakRecord2 : treeMap.values()) {
                if (instructionBreakRecord2.ibrPhysicalAddress >>> 12 != n5) continue;
                n4 = 1;
                break;
            }
            InstructionBreakPoint.ibpSuperMap[n5] = n4 != 0 ? MemoryMappedDevice.MMD_IBP : XEiJ.busSuperMap[n5];
            InstructionBreakPoint.ibpUserMap[n5] = n4 != 0 ? MemoryMappedDevice.MMD_IBP : XEiJ.busUserMap[n5];
            treeMap.remove(n);
            if (treeMap.isEmpty()) {
                ibpOp1SuperMap = XEiJ.busSuperMap;
                ibpOp1UserMap = XEiJ.busUserMap;
                ibpOp1MemoryMap = XEiJ.regSRS != 0 ? ibpOp1SuperMap : ibpOp1UserMap;
            }
        }
    }

    public static class InstructionBreakRecord {
        public int ibrLogicalAddress;
        public int ibrPhysicalAddress;
        public int ibrThreshold;
        public int ibrValue;
        public int ibrTarget;
        public InstructionBreakRecord ibrNext;
        public ExpressionEvaluator.ExpressionElement ibrScriptElement;
        public WaitInstruction ibrWaitInstruction;
    }
}

