/*
 * Decompiled with CFR 0.152.
 */
package xeij;

public class Model {
    public static final int CODE_X68000 = 0;
    public static final int CODE_X68030 = 128;
    public static final int CODE_SHODAI = 0;
    public static final int CODE_ACE = 16;
    public static final int CODE_EXPERT = 32;
    public static final int CODE_PRO = 48;
    public static final int CODE_SUPER = 64;
    public static final int CODE_XVI = 80;
    public static final int CODE_COMPACT = 96;
    public static final int CODE_II = 8;
    public static final int CODE_HD = 4;
    public static final int CODE_OFFICE_GRAY = 0;
    public static final int CODE_GRAY = 1;
    public static final int CODE_TITAN_BLACK = 2;
    public static final int CODE_BLACK = 3;
    public static final String[] COLOR_NAMES = new String[]{"Office Gray", "Gray", "Titan Black", "Black"};
    public static final int MPU_MC68000 = 1;
    public static final int MPU_MC68010 = 2;
    public static final int MPU_MC68020 = 3;
    public static final int MPU_MC68EC030 = 4;
    public static final int MPU_MC68030 = 5;
    public static final int MPU_MC68LC040 = 6;
    public static final int MPU_MC68040 = 7;
    public static final int MPU_MC68LC060 = 8;
    public static final int MPU_MC68060 = 9;
    public static final String[] MPU_NAMES = new String[]{"", "MC68000", "MC68010", "MC68020", "MC68EC030", "MC68030", "MC68LC040", "MC68040", "MC68LC060", "MC68060"};
    public static final int FPU_MC68881 = 1;
    public static final int FPU_MC68882 = 2;
    public static final int FPU_MC68040 = 3;
    public static final int FPU_MC68060 = 4;
    public static final String[] FPU_NAMES = new String[]{"", "MC68881", "MC68882", "MC68040", "MC68060"};
    public static final Model CZ_600CE = new Model("CZ-600CE", 0, false, 1, 1, 10.0, 100, "Shodai");
    public static final Model CZ_600CB = new Model("CZ-600CB", 3, false, 1, 1, 10.0, 101, null);
    public static final Model CZ_601C_BK = new Model("CZ-601C-BK", 19, false, 1, 1, 10.0, 102, null);
    public static final Model CZ_601C_GY = new Model("CZ-601C-GY", 17, false, 1, 1, 10.0, 102, "ACE");
    public static final Model CZ_611C_BK = new Model("CZ-611C-BK", 23, false, 1, 1, 10.0, 102, null);
    public static final Model CZ_611C_GY = new Model("CZ-611C-GY", 21, false, 1, 1, 10.0, 102, null);
    public static final Model CZ_602C_BK = new Model("CZ-602C-BK", 35, false, 2, 1, 10.0, 102, "EXPERT");
    public static final Model CZ_602C_GY = new Model("CZ-602C-GY", 33, false, 2, 1, 10.0, 102, null);
    public static final Model CZ_612C_BK = new Model("CZ-612C-BK", 39, false, 2, 1, 10.0, 102, null);
    public static final Model CZ_652C_BK = new Model("CZ-652C-BK", 51, false, 1, 1, 10.0, 102, null);
    public static final Model CZ_652C_GY = new Model("CZ-652C-GY", 49, false, 1, 1, 10.0, 102, "PRO");
    public static final Model CZ_662C_BK = new Model("CZ-662C-BK", 55, false, 1, 1, 10.0, 102, null);
    public static final Model CZ_662C_GY = new Model("CZ-662C-GY", 53, false, 1, 1, 10.0, 102, null);
    public static final Model CZ_603C_BK = new Model("CZ-603C-BK", 43, false, 2, 1, 10.0, 102, "EXPERTII");
    public static final Model CZ_603C_GY = new Model("CZ-603C-GY", 41, false, 2, 1, 10.0, 102, null);
    public static final Model CZ_613C_BK = new Model("CZ-613C-BK", 47, false, 2, 1, 10.0, 102, null);
    public static final Model CZ_653C_BK = new Model("CZ-653C-BK", 59, false, 1, 1, 10.0, 102, null);
    public static final Model CZ_653C_GY = new Model("CZ-653C-GY", 57, false, 1, 1, 10.0, 102, "PROII");
    public static final Model CZ_663C_BK = new Model("CZ-663C-BK", 63, false, 1, 1, 10.0, 102, null);
    public static final Model CZ_663C_GY = new Model("CZ-663C-GY", 61, false, 1, 1, 10.0, 102, null);
    public static final Model CZ_623C_TN = new Model("CZ-623C-TN", 70, true, 2, 1, 10.0, 103, null);
    public static final Model CZ_604C_TN = new Model("CZ-604C-TN", 66, true, 2, 1, 10.0, 103, "SUPER");
    public static final Model CZ_634C_TN = new Model("CZ-634C-TN", 82, true, 2, 1, 16.666666666666668, 110, "XVI");
    public static final Model CZ_644C_TN = new Model("CZ-644C-TN", 86, true, 2, 1, 16.666666666666668, 110, null);
    public static final Model CZ_674C_H = new Model("CZ-674C-H", 97, true, 2, 1, 16.666666666666668, 120, "Compact");
    public static final Model CZ_500C_B = new Model("CZ-500C-B", 130, true, 4, 4, 25.0, 130, "X68030");
    public static final Model CZ_510C_B = new Model("CZ-510C-B", 134, true, 4, 4, 25.0, 130, null);
    public static final Model CZ_300C_B = new Model("CZ-300C-B", 226, true, 4, 4, 25.0, 130, "030Compact");
    public static final Model CZ_310C_B = new Model("CZ-310C-B", 230, true, 4, 4, 25.0, 130, null);
    public static final Model SHODAI = CZ_600CE;
    public static final Model ACE = CZ_601C_GY;
    public static final Model EXPERT = CZ_602C_BK;
    public static final Model PRO = CZ_652C_GY;
    public static final Model EXPERTII = CZ_603C_BK;
    public static final Model PROII = CZ_653C_GY;
    public static final Model SUPER = CZ_604C_TN;
    public static final Model XVI = CZ_634C_TN;
    public static final Model COMPACT = CZ_674C_H;
    public static final Model X68030 = CZ_500C_B;
    public static final Model X68030COMPACT = CZ_300C_B;
    public static final Model[] MODELS = new Model[]{CZ_600CE, CZ_600CB, CZ_601C_BK, CZ_601C_GY, CZ_611C_BK, CZ_611C_GY, CZ_602C_BK, CZ_602C_GY, CZ_612C_BK, CZ_652C_BK, CZ_652C_GY, CZ_662C_BK, CZ_662C_GY, CZ_603C_BK, CZ_603C_GY, CZ_613C_BK, CZ_653C_BK, CZ_653C_GY, CZ_663C_BK, CZ_663C_GY, CZ_623C_TN, CZ_604C_TN, CZ_634C_TN, CZ_644C_TN, CZ_674C_H, CZ_500C_B, CZ_510C_B, CZ_300C_B, CZ_310C_B};
    private String type;
    private int code;
    private boolean scsi;
    private int memory;
    private int mpu;
    private double clock;
    private int iplrom;
    private String synonym;

    public static Model fromTypeOrSynonym(String string) {
        for (Model model : MODELS) {
            if (!model.type.equalsIgnoreCase(string) && (model.synonym == null || !model.synonym.equalsIgnoreCase(string))) continue;
            return model;
        }
        return null;
    }

    public static String mpuNameOf(int n) {
        return MPU_NAMES[n];
    }

    public static String fpuNameOf(int n) {
        return FPU_NAMES[n];
    }

    private Model(String string, int n, boolean bl, int n2, int n3, double d, int n4, String string2) {
        this.type = string;
        this.code = n;
        this.scsi = bl;
        this.memory = n2;
        this.mpu = n3;
        this.clock = d;
        this.iplrom = n4;
        this.synonym = string2;
    }

    public String getType() {
        return this.type;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isSCSI() {
        return this.scsi;
    }

    public int getMemory() {
        return this.memory;
    }

    public int getMPU() {
        return this.mpu;
    }

    public double getClock() {
        return this.clock;
    }

    public int getIPLROM() {
        return this.iplrom;
    }

    public String getSynonym() {
        return this.synonym;
    }

    public String getName() {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.code & 0x80) {
            case 0: {
                stringBuilder.append("X68000");
                break;
            }
            case 128: {
                stringBuilder.append("X68030");
            }
        }
        switch (this.code & 0x70) {
            case 16: {
                stringBuilder.append(" ACE");
                break;
            }
            case 32: {
                stringBuilder.append(" EXPERT");
                break;
            }
            case 48: {
                stringBuilder.append(" PRO");
                break;
            }
            case 64: {
                stringBuilder.append(" SUPER");
                break;
            }
            case 80: {
                stringBuilder.append(" XVI");
                break;
            }
            case 96: {
                stringBuilder.append(" Compact");
            }
        }
        if ((this.code & 8) != 0) {
            stringBuilder.append("II");
        }
        if ((this.code & 4) != 0) {
            stringBuilder.append(" HD");
        }
        return stringBuilder.toString();
    }

    public boolean isX68030() {
        return (this.code & 0x80) != 0;
    }

    public boolean isShodai() {
        return (this.code & 0xF0) == 0;
    }

    public boolean isACE() {
        return (this.code & 0x70) == 16;
    }

    public boolean isEXPERT() {
        return (this.code & 0x70) == 32;
    }

    public boolean isPRO() {
        return (this.code & 0x70) == 48;
    }

    public boolean isSUPER() {
        return (this.code & 0x70) == 64;
    }

    public boolean isXVI() {
        return (this.code & 0x70) == 80;
    }

    public boolean isCompact() {
        return (this.code & 0x70) == 96;
    }

    public int getColorCode() {
        return this.code & 3;
    }

    public String getColorName() {
        return COLOR_NAMES[this.code & 3];
    }
}

