/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import xeij.ComponentFactory;
import xeij.Multilingual;
import xeij.RestorableFrame;
import xeij.SpriteScreen;
import xeij.VideoController;
import xeij.XEiJ;

public class SpritePatternViewer {
    public static final boolean SPV_ON = true;
    static final int SPV_COLS = 16;
    static final int SPV_ROWS = 16;
    static final int SPV_LEFT_MARGIN = 20;
    static final int SPV_TOP_MARGIN = 20;
    static final int SPV_SPACE = 4;
    static final int SPV_WIDTH = 596;
    static final int SPV_HEIGHT = 596;
    static final int SPV_BACKGROUND_RGB = -13421773;
    static final int SPV_FOREGROUND_RGB = -1;
    static final String SPV_FONT_NAME = "Dialog";
    static final int SPV_FONT_STYLE = 0;
    static final int SPV_FONT_SIZE = 12;
    static BufferedImage spvImage;
    static int[] spvBitmap;
    static JPanel spvCanvas;
    static JScrollPane spvScrollPane;
    static int spvBankNumber;
    static JSpinner spvBankSpinner;
    static SpinnerNumberModel spvBankModel;
    static final int[] spvLastBlockArray;
    static final int[] spvBlockArray;
    static boolean spvAutoBlock;
    static int spvFixedBlock;
    static JSpinner spvBlockSpinner;
    static SpinnerNumberModel spvBlockModel;
    static boolean spvStopped;
    static JFrame spvFrame;
    public static final int SPV_INTERVAL = 10;
    public static int spvTimer;

    public static void spvInit() {
        spvBankNumber = 0;
        for (int i = 0; i < 16384; ++i) {
            SpritePatternViewer.spvLastBlockArray[i] = 16;
        }
        spvAutoBlock = true;
        spvFixedBlock = 1;
        spvStopped = false;
        spvFrame = null;
        spvTimer = 0;
    }

    public static void spvStart() {
        if (RestorableFrame.rfmGetOpened("spv")) {
            SpritePatternViewer.spvOpen();
        }
    }

    public static void spvOpen() {
        if (spvFrame == null) {
            SpritePatternViewer.spvMakeFrame();
        } else {
            SpritePatternViewer.spvUpdateFrame();
        }
        XEiJ.dbgVisibleMask |= 0x800;
        XEiJ.pnlExitFullScreen(false);
        spvFrame.setVisible(true);
    }

    static void spvMakeFrame() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Rectangle2D rectangle2D;
        TextLayout textLayout;
        Object object;
        int n7;
        spvImage = new BufferedImage(596, 596, 2);
        Graphics2D graphics2D = spvImage.createGraphics();
        graphics2D.setColor(new Color(-13421773));
        graphics2D.fillRect(0, 0, 596, 596);
        graphics2D.setColor(new Color(-1));
        Font font = new Font(SPV_FONT_NAME, 0, 12);
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        for (n7 = 0; n7 < 16; ++n7) {
            object = String.format("x%X", n7);
            textLayout = new TextLayout((String)object, font, fontRenderContext);
            rectangle2D = textLayout.getBounds();
            n6 = (int)Math.round(rectangle2D.getX());
            n5 = (int)Math.round(rectangle2D.getY());
            n4 = (int)Math.round(rectangle2D.getWidth());
            n3 = (int)Math.round(rectangle2D.getHeight());
            n2 = 20 + 36 * n7 + 16;
            n = 16;
            graphics2D.drawString((String)object, n2 - n6 - n4 / 2, n - n5 - n3);
        }
        for (n7 = 0; n7 < 16; ++n7) {
            object = String.format("%Xx", n7);
            textLayout = new TextLayout((String)object, font, fontRenderContext);
            rectangle2D = textLayout.getBounds();
            n6 = (int)Math.round(rectangle2D.getX());
            n5 = (int)Math.round(rectangle2D.getY());
            n4 = (int)Math.round(rectangle2D.getWidth());
            n3 = (int)Math.round(rectangle2D.getHeight());
            n2 = 16;
            n = 20 + 36 * n7 + 16;
            graphics2D.drawString((String)object, n2 - n6 - n4, n - n5 - n3 / 2);
        }
        spvBitmap = ((DataBufferInt)spvImage.getRaster().getDataBuffer()).getData();
        spvCanvas = ComponentFactory.setFixedSize(new JPanel(){

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                graphics.drawImage(spvImage, 0, 0, null);
            }

            @Override
            protected void paintBorder(Graphics graphics) {
            }

            @Override
            protected void paintChildren(Graphics graphics) {
            }
        }, 596, 596);
        spvCanvas.setBackground(new Color(-13421773));
        spvCanvas.setOpaque(true);
        spvScrollPane = ComponentFactory.setPreferredSize(new JScrollPane(spvCanvas), 616, 616);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                Object object = actionEvent.getSource();
                switch (string = actionEvent.getActionCommand()) {
                    case "Stop": {
                        spvStopped = ((JCheckBox)object).isSelected();
                        break;
                    }
                    case "Auto ": {
                        spvAutoBlock = true;
                        break;
                    }
                    case "Fixed ": {
                        spvAutoBlock = false;
                        break;
                    }
                    default: {
                        System.out.println("unknown action command " + string);
                    }
                }
            }
        };
        object = new ButtonGroup();
        JComponent[] jComponentArray = new JComponent[2];
        jComponentArray[0] = spvScrollPane;
        Component[] componentArray = new Component[11];
        componentArray[0] = Box.createHorizontalGlue();
        componentArray[1] = Multilingual.mlnText(ComponentFactory.createLabel("Bank "), "ja", "\u30d0\u30f3\u30af ");
        spvBankModel = new SpinnerNumberModel(spvBankNumber, 0, 15, 1);
        spvBankSpinner = ComponentFactory.createNumberSpinner(spvBankModel, 2, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                spvBankNumber = spvBankModel.getNumber().intValue();
            }
        });
        componentArray[2] = spvBankSpinner;
        componentArray[3] = Box.createHorizontalStrut(20);
        componentArray[4] = Multilingual.mlnText(ComponentFactory.createLabel("Palet "), "ja", "\u30d1\u30ec\u30c3\u30c8 ");
        componentArray[5] = Multilingual.mlnText(ComponentFactory.createRadioButton((ButtonGroup)object, spvAutoBlock, "Auto ", actionListener), "ja", "\u81ea\u52d5 ");
        componentArray[6] = Multilingual.mlnText(ComponentFactory.createRadioButton((ButtonGroup)object, !spvAutoBlock, "Fixed ", actionListener), "ja", "\u56fa\u5b9a ");
        spvBlockModel = new SpinnerNumberModel(spvFixedBlock, 0, 15, 1);
        spvBlockSpinner = ComponentFactory.createNumberSpinner(spvBlockModel, 2, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                spvFixedBlock = spvBlockModel.getNumber().intValue();
            }
        });
        componentArray[7] = spvBlockSpinner;
        componentArray[8] = Box.createHorizontalStrut(20);
        componentArray[9] = Multilingual.mlnText(ComponentFactory.createCheckBox(spvStopped, "Stop", actionListener), "ja", "\u505c\u6b62");
        componentArray[10] = Box.createHorizontalGlue();
        jComponentArray[1] = ComponentFactory.createHorizontalBox(componentArray);
        spvFrame = Multilingual.mlnTitle(ComponentFactory.createRestorableSubFrame("spv", "Sprite Pattern Viewer", null, ComponentFactory.createBorderPanel(0, 0, jComponentArray)), "ja", "\u30b9\u30d7\u30e9\u30a4\u30c8\u30d1\u30bf\u30fc\u30f3\u30d3\u30e5\u30a2");
        ComponentFactory.addListener(spvFrame, new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                XEiJ.dbgVisibleMask &= 0xFFFFF7FF;
            }
        });
    }

    static void spvUpdateFrame() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (spvFrame == null) {
            return;
        }
        if (spvStopped) {
            return;
        }
        if (spvAutoBlock) {
            Arrays.fill(spvBlockArray, -1);
            for (n7 = 0; n7 < SpriteScreen.sprNumberOfSprites; ++n7) {
                if (256 <= n7 && n7 < 264 || SpriteScreen.sprPrw[n7] == 0) continue;
                n6 = 4 * SpriteScreen.sprNumPort[n7];
                n5 = SpriteScreen.sprColPort[n7];
                for (n4 = 0; n4 < 4; ++n4) {
                    if (spvBlockArray[n6] < 0) {
                        SpritePatternViewer.spvBlockArray[n6] = SpritePatternViewer.spvLastBlockArray[n6] = n5;
                    }
                    ++n6;
                }
            }
            n7 = 0;
            if ((SpriteScreen.sprReg4BgCtrlPort & 1) != 0) {
                n7 |= 1 << (SpriteScreen.sprReg4BgCtrlPort >> 1 & 3);
            }
            if (((SpriteScreen.sprReg8ResoPort & 3) == 0 || SpriteScreen.spr512bg1) && (SpriteScreen.sprReg4BgCtrlPort & 8) != 0) {
                n7 |= 1 << (SpriteScreen.sprReg4BgCtrlPort >> 4 & 3);
            }
            if ((SpriteScreen.sprReg8ResoPort & 3) == 0) {
                for (n6 = 0; n6 < 4; ++n6) {
                    if ((n7 & 1 << n6) == 0) continue;
                    n5 = 4096 * n6;
                    for (n4 = 0; n4 < 4096; ++n4) {
                        n3 = SpriteScreen.sprTNum[n5 + n4] >> 3;
                        n2 = SpriteScreen.sprTColPort[n5 + n4];
                        if (spvBlockArray[n3] >= 0) continue;
                        SpritePatternViewer.spvBlockArray[n3] = SpritePatternViewer.spvLastBlockArray[n3] = n2;
                    }
                }
            } else {
                for (n6 = 0; n6 < 4; ++n6) {
                    if ((n7 & 1 << n6) == 0) continue;
                    n5 = 4096 * n6;
                    for (n4 = 0; n4 < 4096; ++n4) {
                        n3 = SpriteScreen.sprTNum[n5 + n4] >> 1;
                        n2 = SpriteScreen.sprTColPort[n5 + n4];
                        for (n = 0; n < 4; ++n) {
                            if (spvBlockArray[n3] < 0) {
                                SpritePatternViewer.spvBlockArray[n3] = SpritePatternViewer.spvLastBlockArray[n3] = n2;
                            }
                            ++n3;
                        }
                    }
                }
            }
            for (n6 = 0; n6 < 16384; ++n6) {
                if (spvBlockArray[n6] >= 0) continue;
                SpritePatternViewer.spvBlockArray[n6] = spvLastBlockArray[n6];
            }
        } else {
            Arrays.fill(spvBlockArray, spvFixedBlock << 4);
        }
        n7 = 8192 * spvBankNumber;
        for (n6 = 0; n6 < 16; ++n6) {
            n5 = 20 + 36 * n6;
            for (n4 = 0; n4 < 16; ++n4) {
                int n8;
                n3 = 20 + 36 * n4;
                n2 = n3 + 596 * n5;
                n = n2 - 2;
                for (n8 = 0; n8 < 16; ++n8) {
                    SpritePatternViewer.spvBitmap[n + 596 + 1] = -13421773;
                    SpritePatternViewer.spvBitmap[n + 596] = -13421773;
                    SpritePatternViewer.spvBitmap[n + 1] = -13421773;
                    SpritePatternViewer.spvBitmap[n] = -13421773;
                    n += 1192;
                }
                n8 = 4 * (256 * spvBankNumber + n4 + 16 * n6);
                for (int i = 0; i < 2; ++i) {
                    int n9 = n3 + 16 * i;
                    for (int j = 0; j < 2; ++j) {
                        int n10 = n5 + 16 * j;
                        int n11 = n9 + 596 * n10;
                        int n12 = spvBlockArray[n8];
                        int n13 = n2 - 2 + 1192 * (n12 >> 4);
                        SpritePatternViewer.spvBitmap[n13 + 596 + 1] = -1;
                        SpritePatternViewer.spvBitmap[n13 + 596] = -1;
                        SpritePatternViewer.spvBitmap[n13 + 1] = -1;
                        SpritePatternViewer.spvBitmap[n13] = -1;
                        for (int k = 0; k < 8; ++k) {
                            int n14 = SpriteScreen.sprPatPort[n7++];
                            for (int i2 = 0; i2 < 8; ++i2) {
                                int n15 = VideoController.vcnPal32TS[n12 + (n14 >> ((~i2 & 7) << 2) & 0xF)];
                                SpritePatternViewer.spvBitmap[n11 + 596 + 1] = n15;
                                SpritePatternViewer.spvBitmap[n11 + 596] = n15;
                                SpritePatternViewer.spvBitmap[n11 + 1] = n15;
                                SpritePatternViewer.spvBitmap[n11] = n15;
                                n11 += 2;
                            }
                            n11 += 1176;
                        }
                        ++n8;
                    }
                }
            }
        }
        spvCanvas.repaint();
    }

    static {
        spvLastBlockArray = new int[16384];
        spvBlockArray = new int[16384];
    }
}

