/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import xeij.CharacterCode;
import xeij.ComponentFactory;
import xeij.DecimalSpinner;
import xeij.Hex8Spinner;
import xeij.LnF;
import xeij.MC68060;
import xeij.Multilingual;
import xeij.RestorableFrame;
import xeij.ScrollTextArea;
import xeij.XEiJ;

public class MemoryDumpList {
    public static final int DMP_ITEM_SIZE = 16;
    public static final int DMP_PAGE_SIZE = 1024;
    public static final int DMP_ITEM_MASK = -16;
    public static final int DMP_PAGE_MASK = -1024;
    public static final int DMP_MAX_ITEMS = 66;
    public static final char[] DMP_BASE = "xxxxxxxx  xx xx xx xx  xx xx xx xx  xx xx xx xx  xx xx xx xx ".toCharArray();
    public static final int DMP_DATA_START = 10;
    public static final int[] DMP_DATA_ADDRESS = new int[]{0, 1, -1, 2, 3, -1, 4, 5, -1, 6, 7, -1, -1, 8, 9, -1, 10, 11, -1, 12, 13, -1, 14, 15, -1, -1, 16, 17, -1, 18, 19, -1, 20, 21, -1, 22, 23, -1, -1, 24, 25, -1, 26, 27, -1, 28, 29, -1, 30, 31};
    public static final int[] DMP_DATA_OFFSET = new int[]{0, 1, 3, 4, 6, 7, 9, 10, 13, 14, 16, 17, 19, 20, 22, 23, 26, 27, 29, 30, 32, 33, 35, 36, 39, 40, 42, 43, 45, 46, 48, 49};
    public static int dmpItemCount;
    public static int dmpItemIndex;
    public static int dmpPageAddress;
    public static final int[] dmpAddressArray;
    public static final int[] dmpSplitArray;
    public static final int[] dmpCaretArray;
    public static JFrame dmpFrame;
    public static ScrollTextArea dmpBoard;
    public static JTextArea dmpTextArea;
    public static Hex8Spinner dmpSpinner;
    public static int dmpFunctionCode;
    public static DecimalSpinner dmpFCSpinner;
    public static boolean dmpSecondBridge;
    public static Color dmpCellophaneColor;

    public static void dmpInit() {
        dmpItemCount = 0;
        dmpItemIndex = 0;
        dmpPageAddress = 0;
        dmpFunctionCode = 5;
        dmpFrame = null;
    }

    public static void dmpStart() {
        if (RestorableFrame.rfmGetOpened("dmp")) {
            MemoryDumpList.dmpOpen(-1, -1, true);
        }
    }

    public static void dmpOpen(int n, int n2, boolean bl) {
        if (dmpFrame == null) {
            MemoryDumpList.dmpMake();
        }
        MemoryDumpList.dmpUpdate(n, n2, bl);
        XEiJ.pnlExitFullScreen(false);
        dmpFrame.setVisible(true);
        XEiJ.dbgVisibleMask |= 4;
    }

    public static void dmpMake() {
        dmpBoard = ComponentFactory.setPreferredSize(ComponentFactory.setFont(new MemoryDumpTextArea(), LnF.lnfMonospacedFont), 500, 400);
        dmpBoard.setMargin(new Insets(2, 4, 2, 4));
        dmpBoard.setHighlightCursorOn(true);
        dmpTextArea = dmpBoard.getTextArea();
        dmpTextArea.setEditable(false);
        dmpTextArea.addMouseWheelListener(mouseWheelEvent -> {
            int n = mouseWheelEvent.getWheelRotation();
            JViewport jViewport = dmpBoard.getViewport();
            Point point = jViewport.getViewPosition();
            jViewport.setViewPosition(new Point(point.x, Math.max(0, Math.min(MemoryDumpList.dmpTextArea.getSize().height - jViewport.getExtentSize().height, point.y + n * dmpTextArea.getFont().getSize() * 5))));
        });
        dmpSpinner = new Hex8Spinner(dmpPageAddress, -16, true);
        dmpSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (XEiJ.dbgEventMask == 0) {
                    MemoryDumpList.dmpUpdate(dmpSpinner.getIntValue(), dmpFunctionCode, false);
                }
            }
        });
        ComponentFactory.addListener(dmpTextArea, new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                int n;
                if (XEiJ.dbgEventMask == 0 && (n = caretEvent.getDot()) == caretEvent.getMark()) {
                    int n2 = Arrays.binarySearch(dmpSplitArray, 1, dmpItemCount, n + 1);
                    n2 = (n2 >> 31 ^ n2) - 1;
                    dmpSpinner.setHintIndex(n2);
                }
            }
        });
        ComponentFactory.addListener(dmpTextArea, new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (XEiJ.mpuTask == null && mouseEvent.isPopupTrigger()) {
                    XEiJ.dbgShowPopup(mouseEvent, dmpTextArea, false);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (XEiJ.mpuTask == null && mouseEvent.isPopupTrigger()) {
                    XEiJ.dbgShowPopup(mouseEvent, dmpTextArea, false);
                }
            }
        });
        ComponentFactory.addListener(dmpBoard, new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                dmpBoard.setCaretVisible(true);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                dmpBoard.setCaretVisible(false);
            }
        });
        ComponentFactory.addListener(dmpBoard, new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                int n;
                if (XEiJ.dbgEventMask == 0 && (n = Character.digit(keyEvent.getKeyChar(), 16)) >= 0) {
                    int n2 = dmpTextArea.getCaretPosition();
                    int n3 = Arrays.binarySearch(dmpSplitArray, 1, dmpItemCount, n2 + 1);
                    int n4 = n2 - dmpCaretArray[n3 = (n3 >> 31 ^ n3) - 1] - 10;
                    if (n4 >= 0 && n4 < DMP_DATA_ADDRESS.length && (n4 = DMP_DATA_ADDRESS[n4]) >= 0) {
                        int n5 = dmpAddressArray[n3] + (n4 >> 1);
                        ++XEiJ.dbgEventMask;
                        if ((n4 & 1) == 0) {
                            try {
                                MC68060.mmuPokeByte(n5, n << 4 | Character.digit(dmpTextArea.getText(n2 + 1, 1).charAt(0), 16), dmpFunctionCode);
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                            dmpTextArea.replaceRange(XEiJ.fmtHex2(MC68060.mmuPeekByteZero(n5, dmpFunctionCode)), n2, n2 + 2);
                            dmpTextArea.setCaretPosition(n2 + 1);
                        } else {
                            try {
                                MC68060.mmuPokeByte(n5, Character.digit(dmpTextArea.getText(n2 - 1, 1).charAt(0), 16) << 4 | n, dmpFunctionCode);
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                            dmpTextArea.replaceRange(XEiJ.fmtHex2(MC68060.mmuPeekByteZero(n5, dmpFunctionCode)), n2 - 1, n2 + 1);
                            if (n4 < 31) {
                                dmpTextArea.setCaretPosition(dmpCaretArray[n3] + 10 + DMP_DATA_OFFSET[n4 + 1]);
                            }
                        }
                        --XEiJ.dbgEventMask;
                    }
                }
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                switch (actionEvent.getActionCommand()) {
                    case "Reload": {
                        dmpItemCount = 0;
                        MemoryDumpList.dmpUpdate(dmpAddressArray[dmpItemIndex], dmpFunctionCode, true);
                        break;
                    }
                    case "Second bridge": {
                        dmpSecondBridge = ((JCheckBox)actionEvent.getSource()).isSelected();
                        dmpItemCount = 0;
                        MemoryDumpList.dmpUpdate(dmpAddressArray[dmpItemIndex], dmpFunctionCode, true);
                    }
                }
            }
        };
        JButton jButton = Multilingual.mlnToolTipText(ComponentFactory.createImageButton(LnF.LNF_RELOAD_IMAGE, "Reload", actionListener), "ja", "\u518d\u8aad\u307f\u8fbc\u307f");
        dmpFCSpinner = ComponentFactory.createDecimalSpinner(dmpFunctionCode, 0, 7, 1, 0, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (XEiJ.dbgEventMask == 0) {
                    MemoryDumpList.dmpUpdate(dmpPageAddress, dmpFCSpinner.getIntValue(), false);
                }
            }
        });
        dmpSecondBridge = false;
        dmpCellophaneColor = new Color(LnF.lnfRGB[5] & 0xFFFFFF | 0xCC000000, true);
        JCheckBox jCheckBox = Multilingual.mlnToolTipText(ComponentFactory.createIconCheckBox(dmpSecondBridge, XEiJ.createImage(20, 14, "222222222222222222222..................22...........11111..22...........11111..22....111111111111..22...........11111..22...........11111..22..................22..................22....1111111111....22..................22..................22..................222222222222222222222", LnF.lnfRGB[0], LnF.lnfRGB[12], LnF.lnfRGB[12]), XEiJ.createImage(20, 14, "222222222222222222222..................22...........11111..22...........11111..22....111111111111..22...........11111..22...........11111..22..11111...........22..11111...........22..111111111111....22..11111...........22..11111...........22..................222222222222222222222", LnF.lnfRGB[0], LnF.lnfRGB[12], LnF.lnfRGB[12]), "Second bridge", actionListener), "ja", "\u30bb\u30ab\u30f3\u30c9\u30d6\u30ea\u30c3\u30b8");
        dmpFrame = Multilingual.mlnTitle(ComponentFactory.createRestorableSubFrame("dmp", "Memory dump list", null, ComponentFactory.createBorderPanel(dmpBoard, ComponentFactory.createHorizontalBox(dmpFCSpinner, dmpSpinner, jButton, jCheckBox, Box.createHorizontalGlue()))), "ja", "\u30e1\u30e2\u30ea\u30c0\u30f3\u30d7\u30ea\u30b9\u30c8");
        ComponentFactory.addListener(dmpFrame, new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                XEiJ.dbgVisibleMask &= 0xFFFFFFFB;
            }
        });
    }

    public static void dmpUpdate(int n, int n2, boolean bl) {
        int n3;
        int n4;
        int n5;
        ++XEiJ.dbgEventMask;
        if (n == -1) {
            n = XEiJ.regRn[15];
            bl = true;
        }
        if (n2 == -1) {
            n2 = XEiJ.regSRS != 0 ? 5 : 1;
            bl = true;
        }
        if (dmpFunctionCode != n2) {
            dmpFunctionCode = n2;
            bl = true;
            dmpFCSpinner.setIntValue(n2);
        }
        if (bl) {
            dmpItemCount = 0;
        }
        if (dmpItemCount != 0) {
            n5 = Arrays.binarySearch(dmpAddressArray, 1, dmpItemCount, n + 1);
            if (0 < (n5 = (n5 >> 31 ^ n5) - 1) && n5 < dmpItemCount - 1 && dmpAddressArray[n5] == n) {
                if (dmpItemIndex != n5) {
                    dmpItemIndex = n5;
                    dmpTextArea.setCaretPosition(dmpCaretArray[n5]);
                }
                --XEiJ.dbgEventMask;
                return;
            }
        }
        dmpPageAddress = (n &= 0xFFFFFFF0) & 0xFFFFFC00;
        n5 = dmpPageAddress + 1024;
        MemoryDumpList.dmpAddressArray[0] = dmpPageAddress - 16;
        MemoryDumpList.dmpSplitArray[0] = 0;
        MemoryDumpList.dmpCaretArray[0] = 0;
        StringBuilder stringBuilder = new StringBuilder("\u25b2        +0 +1 +2 +3  +4 +5 +6 +7  +8 +9 +A +B  +C +D +E +F  0123456789ABCDEF\n");
        int n6 = 1;
        int n7 = dmpPageAddress;
        int n8 = 0;
        for (n4 = 1; n4 <= 200 && (129 <= (n3 = MC68060.mmuPeekByteZero(n7 - n4, n2)) && n3 <= 159 || 224 <= n3 && n3 <= 239); ++n4) {
            n8 = n8 == 0 ? 1 : 0;
        }
        do {
            int n9;
            n4 = n7 + 16;
            if (n7 == n) {
                dmpItemIndex = n6;
            }
            MemoryDumpList.dmpAddressArray[n6] = n7;
            MemoryDumpList.dmpSplitArray[n6] = stringBuilder.length();
            MemoryDumpList.dmpCaretArray[n6] = stringBuilder.length();
            XEiJ.fmtHex8(DMP_BASE, 0, n7);
            XEiJ.fmtHex2(DMP_BASE, 10, MC68060.mmuPeekByteZero(n7, n2));
            XEiJ.fmtHex2(DMP_BASE, 13, MC68060.mmuPeekByteZero(n7 + 1, n2));
            XEiJ.fmtHex2(DMP_BASE, 16, MC68060.mmuPeekByteZero(n7 + 2, n2));
            XEiJ.fmtHex2(DMP_BASE, 19, MC68060.mmuPeekByteZero(n7 + 3, n2));
            XEiJ.fmtHex2(DMP_BASE, 23, MC68060.mmuPeekByteZero(n7 + 4, n2));
            XEiJ.fmtHex2(DMP_BASE, 26, MC68060.mmuPeekByteZero(n7 + 5, n2));
            XEiJ.fmtHex2(DMP_BASE, 29, MC68060.mmuPeekByteZero(n7 + 6, n2));
            XEiJ.fmtHex2(DMP_BASE, 32, MC68060.mmuPeekByteZero(n7 + 7, n2));
            XEiJ.fmtHex2(DMP_BASE, 36, MC68060.mmuPeekByteZero(n7 + 8, n2));
            XEiJ.fmtHex2(DMP_BASE, 39, MC68060.mmuPeekByteZero(n7 + 9, n2));
            XEiJ.fmtHex2(DMP_BASE, 42, MC68060.mmuPeekByteZero(n7 + 10, n2));
            XEiJ.fmtHex2(DMP_BASE, 45, MC68060.mmuPeekByteZero(n7 + 11, n2));
            XEiJ.fmtHex2(DMP_BASE, 49, MC68060.mmuPeekByteZero(n7 + 12, n2));
            XEiJ.fmtHex2(DMP_BASE, 52, MC68060.mmuPeekByteZero(n7 + 13, n2));
            XEiJ.fmtHex2(DMP_BASE, 55, MC68060.mmuPeekByteZero(n7 + 14, n2));
            XEiJ.fmtHex2(DMP_BASE, 58, MC68060.mmuPeekByteZero(n7 + 15, n2));
            stringBuilder.append(DMP_BASE);
            n3 = 0;
            if (n8 == 0) {
                stringBuilder.append(' ');
                n9 = n7;
            } else if (n7 == dmpPageAddress || dmpSecondBridge) {
                n9 = n7 - 1;
            } else {
                stringBuilder.append("  ");
                n9 = n7 + 1;
            }
            while (n9 < n4) {
                int n10;
                int n11 = MC68060.mmuPeekByteZero(n9, n2);
                if (129 <= n11 && n11 <= 159 || 224 <= n11 && n11 <= 239) {
                    int n12 = MC68060.mmuPeekByteZero(n9 + 1, n2);
                    if (64 <= n12 && n12 <= 252 && n12 != 127) {
                        n10 = CharacterCode.chrSJISToChar[n11 << 8 | n12];
                        if (n10 == 0) {
                            n10 = 8251;
                        } else if (n10 == 12288) {
                            n10 = 11034;
                        }
                        if (++n9 == n4) {
                            n3 = 1;
                        }
                    } else {
                        n10 = 46;
                    }
                } else {
                    n10 = CharacterCode.chrSJISToChar[n11];
                    if (n10 < 32 || n10 == 127) {
                        n10 = 46;
                    }
                }
                stringBuilder.append((char)n10);
                ++n9;
            }
            stringBuilder.append('\n');
            ++n6;
            n7 = n4;
            n8 = n3;
        } while (n7 < n5);
        MemoryDumpList.dmpAddressArray[n6] = n7;
        MemoryDumpList.dmpSplitArray[n6] = stringBuilder.length();
        MemoryDumpList.dmpCaretArray[n6] = stringBuilder.length();
        stringBuilder.append("\u25bc        +0 +1 +2 +3  +4 +5 +6 +7  +8 +9 +A +B  +C +D +E +F  0123456789ABCDEF");
        dmpItemCount = ++n6;
        dmpTextArea.setText(stringBuilder.toString());
        dmpTextArea.setCaretPosition(dmpCaretArray[dmpItemIndex]);
        dmpSpinner.setHintArray(dmpAddressArray, n6);
        dmpSpinner.setHintIndex(dmpItemIndex);
        --XEiJ.dbgEventMask;
    }

    static {
        dmpAddressArray = new int[66];
        dmpSplitArray = new int[66];
        dmpCaretArray = new int[66];
    }

    static class MemoryDumpTextArea
    extends ScrollTextArea {
        MemoryDumpTextArea() {
        }

        @Override
        public void paintAfterText(JTextArea jTextArea, Graphics2D graphics2D) {
            if (dmpSecondBridge) {
                try {
                    graphics2D.setPaint(dmpCellophaneColor);
                    Rectangle rectangle = jTextArea.modelToView2D(61).getBounds();
                    Rectangle rectangle2 = jTextArea.modelToView2D(62).getBounds();
                    graphics2D.fillRect(rectangle.x - (rectangle2.x - rectangle.x), rectangle.y, rectangle2.x - rectangle.x, rectangle.height * 66);
                    graphics2D.fillRect(rectangle.x + (rectangle2.x - rectangle.x) * 16, rectangle.y, rectangle2.x - rectangle.x, rectangle.height * 66);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }
}

