/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import xeij.ADPCM;
import xeij.FDC;
import xeij.MC68901;
import xeij.OPMLog;
import xeij.TickerQueue;
import xeij.XEiJ;
import xeij.YM2151;

public class OPM {
    public static final boolean OPM_ON = true;
    public static final int OPM_OSC_FREQ = 4000000;
    public static final int OPM_SAMPLE_FREQ = 62500;
    public static final long OPM_SAMPLE_TIME = 16000000L;
    public static final int OPM_BLOCK_SAMPLES = 2500;
    public static int opmOutputMask;
    public static YM2151 opmYM2151;
    public static TickerQueue.Ticker opmTimerATicker;
    public static TickerQueue.Ticker opmTimerBTicker;
    public static int[] opmRegister;
    public static int[] opmBuffer;
    public static int opmPointer;
    public static long opmBusyClock;

    public static void opmInit() {
        opmYM2151 = new YM2151();
        opmTimerATicker = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                opmYM2151.timerAExpired();
            }
        };
        opmTimerBTicker = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                opmYM2151.timerBExpired();
            }
        };
        opmRegister = new int[266];
        opmYM2151.setListener(new YM2151.Listener(){

            @Override
            public void timerA(int n) {
                if (n != -1) {
                    TickerQueue.tkqAdd(opmTimerATicker, XEiJ.mpuClockTime + 250000L * (long)n);
                } else {
                    TickerQueue.tkqRemove(opmTimerATicker);
                }
            }

            @Override
            public void timerB(int n) {
                if (n != -1) {
                    TickerQueue.tkqAdd(opmTimerBTicker, XEiJ.mpuClockTime + 250000L * (long)n);
                } else {
                    TickerQueue.tkqRemove(opmTimerBTicker);
                }
            }

            @Override
            public void busy(int n) {
                opmBusyClock = XEiJ.mpuClockTime + 250000L * (long)n;
            }

            @Override
            public boolean isBusy() {
                return XEiJ.mpuClockTime < opmBusyClock;
            }

            @Override
            public void irq(boolean bl) {
                if (bl) {
                    MC68901.mfpOpmirqFall();
                } else {
                    MC68901.mfpOpmirqRise();
                }
            }

            @Override
            public void control(int n) {
                FDC.fdcSetEnforcedReady((n & 1) != 0);
                ADPCM.pcmOscillator = n >> 1 & 1;
                ADPCM.pcmUpdateRepeatInterval();
            }

            @Override
            public void written(int n, int n2, int n3) {
                if (n2 == 8) {
                    OPM.opmRegister[256 + (n3 & 7)] = n3 >> 3 & 0xF;
                } else if (n2 == 25) {
                    OPM.opmRegister[264 + (n3 >> 7)] = n3 & 0x7F;
                } else {
                    OPM.opmRegister[n2] = n3;
                }
                OPMLog.olgSetData(n2, n3);
            }
        });
        opmYM2151.allocate(5002);
        OPM.opmReset();
    }

    public static void opmReset() {
        opmYM2151.reset();
        opmYM2151.clear();
        opmBuffer = opmYM2151.getBuffer();
        opmPointer = opmYM2151.getPointer();
        opmBusyClock = 0L;
    }

    public static void opmSetOutputOn(boolean bl) {
        opmOutputMask = bl ? -1 : 0;
        opmYM2151.setChannelMask(opmOutputMask & 0xFF);
    }
}

