;========================================================================================
;  r00bit0test.s
;  Copyright (C) 2003-2024 Makoto Kamada
;
;  This file is part of the XEiJ (X68000 Emulator in Java).
;  You can use, modify and redistribute the XEiJ if the conditions are met.
;  Read the XEiJ License for more details.
;  https://stdkmd.net/xeij/
;========================================================================================

;----------------------------------------------------------------------------------------
;	r00bit0test.x
;	CRTC R00bit01ɌŒ肳Ă邱ƂmF܂
;	384x256̉ʂ𐅕g[^68A69A70̏ꍇɂčAꂼꐂv܂
;	X68030@ł69̐70̐ƓɂȂ邱ƂACRTC R00bit01ɌŒ肳Ă邱Ƃ܂
;	CRTC R00bit01ɌŒ肳ĂȂG~[^ł́A69̐68̐70̐̒ԂɂȂ܂
;----------------------------------------------------------------------------------------

TITLE		reg	'r00bit0test.x (2024-02-17)'
TESTS		equ	14

	.include	bioswork.equ
	.include	control2.mac
	.include	crtc.equ
	.include	doscall.mac
	.include	iocscall.mac
	.include	mfp.equ
	.include	misc.mac
	.include	push2.mac
	.include	sprc.equ
	.include	sram.equ
	.include	sysport.equ
	.include	vicon.equ

;X[p[oCU[h
	supervisormode

;v
	lea.l	results(pc),a2
	moveq.l	#28,d1
	moveq.l	#0,d2
	moveq.l	#TESTS-1,d3
	for	d3
		bsr	iocs_10_CRTMOD
		bsr	measure
		move.l	d0,(a2)+
		addq.w	#1,d2
	next

;[U[h
	usermode

;W̉ʂɖ߂
	moveq.l	#16,d1
	IOCS	_CRTMOD
	move.l	#(16<<16)|$FFFF,-(sp)
	DOS	_CONCTRL
	move.w	d0,2(sp)
	DOS	_CONCTRL
	addq.l	#4,sp

;ʂ\
;	IV[^cOSC=69.552(MHz)
;	cDIV=4
;	g[^cHT=69(z)
;	g[^cVT=568
;	cVP=18032(us)(z)
;	VP=8*HT*VT*DIV/OSC
;	  =HT*(8*VT*DIV/OSC)
;	  =HT*(8*VT*DIV/OSC)
;	  =HT*(8*VT*DIV/OSC*2**7)/2**7
;	  =HT*(33450.1955...)/2**7
;	  =round(HT*33450/2**7)
;	HT=VP*OSC/8/VT/DIV
;	  =VP*(OSC/8/VT/DIV*2**24)/2**24
;	  =VP*(64199.4348...)/2**24
;	  =round(VP*64199/2**24)
	lea.l	buffer(pc),a0		;a0=buffer
	leastrdata	<TITLE,13,10>,a1
	bsr	strcpy
	lea.l	results(pc),a2		;a2=results
	moveq.l	#TESTS-1,d1		;d1=count
	for	d1
		if	<cmp.w #TESTS-1,d1>,eq	;ŏ
			moveq.l	#68,d2			;d2=HTin
			moveq.l	#68,d3			;d3=exp_HTout
		elif	<tst.w d1>,hi		;̃P[X
			moveq.l	#69,d2			;d2=HTin
			moveq.l	#70,d3			;d3=exp_HTout
		else				;Ō
			moveq.l	#70,d2			;d2=HTin
			moveq.l	#70,d3			;d3=exp_HTout
		endif
		move.l	d3,d4
		mulu.w	#33450,d4
		add.l	#$00000040,d4
		lsr.l	#7,d4			;d4=exp_VP
		move.l	(a2)+,d5		;d5=obs_VP
		move.l	d5,d6
		mulu.w	#64199,d6
		add.l	#$00800000,d6
		and.l	#$FF000000,d6
		rol.l	#8,d6			;d6=obs_HTout
		leastrdata	<'TEST '>,a1
		bsr	strcpy
		moveq.l	#TESTS,d0
		sub.w	d1,d0			;d1=count
		bsr	utos
		leastrdata	<': HTin='>,a1
		bsr	strcpy
		move.l	d2,d0			;d2=HTin
		bsr	utos
		leastrdata	<' exp_HTout='>,a1
		bsr	strcpy
		move.l	d3,d0			;d3=exp_HTout
		bsr	utos
		leastrdata	<' exp_VP='>,a1
		bsr	strcpy
		move.l	d4,d0			;d4=exp_VP
		bsr	utos
		leastrdata	<' obs_VP='>,a1
		bsr	strcpy
		move.l	d5,d0			;d5=obs_VP
		bsr	utos
		leastrdata	<' obs_HTout='>,a1
		bsr	strcpy
		move.l	d6,d0			;d6=obs_HTout
		bsr	utos
		if	<cmp.w d3,d6>,eq
			leastrdata	<' OK'>,a1
		else
			leastrdata	<' ERROR'>,a1
		endif
		bsr	strcpy
		bsr	crlf
	next
	lea.l	buffer(pc),a0
	bsr	print

;I
	DOS	_EXIT

	.bss
	.even
results:
	.ds.l	TESTS
buffer:
	.ds.b	4096
	.text



;v
;>d0.l:(us)
measure:
	push	d1/d2/d3/d7/a0/a1/a6

;O[oWX^
dZERO	reg	d7
	moveq.l	#0,dZERO
aTCDCR	reg	a6
	lea.l	MFP_TCDCR,aTCDCR

;荞݋֎~
	di

;^C}ۑ
	move.b	MFP_IERB-MFP_TCDCR(aTCDCR),-(sp)
	move.b	MFP_IMRB-MFP_TCDCR(aTCDCR),-(sp)
	move.b	MFP_TCDCR-MFP_TCDCR(aTCDCR),-(sp)

;^C}ݒ
	andi.b	#.notb.(MFP_B_TIMERC_MASK|MFP_B_TIMERD_MASK),MFP_IMRB-MFP_TCDCR(aTCDCR)	;Timer-C/D荞݋֎~
	andi.b	#.notb.(MFP_B_TIMERC_MASK|MFP_B_TIMERD_MASK),MFP_IERB-MFP_TCDCR(aTCDCR)	;Timer-C/D荞ݒ~BIPRBNA

;JEg~
	move.b	dZERO,(aTCDCR)		;Timer-C/DJEg~
	do
	while	<tst.b (aTCDCR)>,ne	;Sɒ~܂ő҂

;V-DISP10҂
	do
	while	<btst.b #MFP_G_VDISP_BIT,MFP_GPDR>,eq	;?1҂
	do
	while	<btst.b #MFP_G_VDISP_BIT,MFP_GPDR>,ne	;10҂

;JEgJn
	moveq.l	#0,d2			;neg(TCDR)bit710̉
	moveq.l	#0,d3			;Oneg(TCDR)
	move.b	dZERO,MFP_TCDR-MFP_TCDCR(aTCDCR)	;Timer-CJE^NA
	move.b	dZERO,MFP_TDDR-MFP_TCDCR(aTCDCR)	;Timer-DJE^NA
	move.b	#MFP_50US<<4|MFP_1US,(aTCDCR)	;Timer-C/DJEgJn
					;Timer-C1/200vXP[(50us)
					;Timer-D1/4vXP[(1us)

;V-DISP10҂
	do
		moveq.l	#0,d0
		sub.b	MFP_TCDR-MFP_TCDCR(aTCDCR),d0	;neg(TCDR)
		eor.b	d0,d3
		ifand	<>,mi,<tst.b d0>,pl	;neg(TCDR)bit710
			addq.w	#1,d2			;
		endif
		move.b	d0,d3
	while	<btst.b #MFP_G_VDISP_BIT,MFP_GPDR>,eq	;V-DISP?1҂
	do
		moveq.l	#0,d0
		sub.b	MFP_TCDR-MFP_TCDCR(aTCDCR),d0	;neg(TCDR)
		eor.b	d0,d3
		ifand	<>,mi,<tst.b d0>,pl	;neg(TCDR)bit710
			addq.w	#1,d2			;
		endif
		move.b	d0,d3
	while	<btst.b #MFP_G_VDISP_BIT,MFP_GPDR>,ne	;V-DISP10҂

;JEg~
	move.b	dZERO,(aTCDCR)		;Timer-C/DJEg~
	do
	while	<tst.b (aTCDCR)>,ne	;Sɒ~܂ő҂

;^C}擾
	moveq.l	#0,d0
	moveq.l	#0,d1
	sub.b	MFP_TCDR-MFP_TCDCR(aTCDCR),d0	;Timer-CJEg
	sub.b	MFP_TDDR-MFP_TCDCR(aTCDCR),d1	;Timer-DJEg(I[o[t[)
	eor.b	d0,d3
	ifand	<>,mi,<tst.b d0>,pl	;neg(TCDR)bit710
		addq.w	#1,d2			;
	endif

;^C}
	move.b	#200,MFP_TCDR-MFP_TCDCR(aTCDCR)	;Timer-CJE^
	move.b	dZERO,MFP_TDDR-MFP_TCDCR(aTCDCR)	;Timer-DJE^NA
	move.b	(sp)+,(aTCDCR)
	move.b	(sp)+,MFP_IMRB-MFP_TCDCR(aTCDCR)
	move.b	(sp)+,MFP_IERB-MFP_TCDCR(aTCDCR)

;荞݋
	ei

;JE^
	mulu.w	#50,d0
	if	<cmp.b d1,d0>,hi
		add.w	#256,d0
	endif
	move.b	d1,d0
	mulu.w	#50*256,d2
	add.l	d2,d0			;(us)

;I
	pop
	rts



;----------------------------------------------------------------
;sRs[
;<a0.l:Rs[
;>a0.l:Rs[0̈ʒu
crlf::
	move.b	#13,(a0)+
	move.b	#10,(a0)+
	clr.b	(a0)
	rts

;----------------------------------------------------------------
;\
;<a0.l:
print::
	push	d0
	bsr	strlen
	move.l	d0,-(sp)
	move.l	a0,-(sp)
	move.w	#1,-(sp)
	DOS	_WRITE
	lea.l	(10,sp),sp
	pop
	rts

;----------------------------------------------------------------
;Rs[
;<a0.l:Rs[
;<a1.l:Rs[
;>a0.l:Rs[0̈ʒu
;>a1.l:Rs[0̎̈ʒu
strcpy::
	do
		move.b	(a1)+,(a0)+
	while	ne			;0łȂΌJԂ
	subq.l	#1,a0			;i݉߂߂
	rts

;----------------------------------------------------------------
;̒𐔂
;<a0.l:
;>d0.l:
strlen::
	move.l	a0,d0			;d0=擪
	do
		tst.b (a0)+
	while	ne			;0łȂΌJԂ
	subq.l	#1,a0			;i݉߂߂Ba0=
	exg.l	d0,a0			;d0=,a0=擪
	sub.l	a0,d0			;d0=-擪=
	rts

;----------------------------------------------------------------
;32rbgȂ10i̕ɕϊ
;<d0.l:Ȃ
;<a0.l:obt@B10i̐̕擪
;>a0.l:10i̖̕0̈ʒu
utos::
	if	<tst.l d0>,eq		;0
		move.b	#'0',(a0)+
	else				;0ȊO
		push	d0-d2/a1
		lea.l	utos_table(pc),a1
		do
			move.l	(a1)+,d1
		while	<cmp.l d1,d0>,lo	;Ƃ܂ŐiށB[TvX
		do
			moveq.l	#'0'-1,d2
			do
				addq.b	#1,d2
				sub.l	d1,d0
			while	hs			;񐔂𐔂
			move.b	d2,(a0)+
			add.l	d1,d0			;߂߂
			move.l	(a1)+,d1
		while	ne
		pop
	endif
	clr.b	(a0)
	rts

utos_table::
	.dc.l	1000000000
	.dc.l	100000000
	.dc.l	10000000
	.dc.l	1000000
	.dc.l	100000
	.dc.l	10000
	.dc.l	1000
	.dc.l	100
	.dc.l	10
	.dc.l	1
	.dc.l	0



CRTMOD_VERSION	equ	$16_231115	;_CRTMOD̃o[W



;----------------------------------------------------------------
;IOCSR[$10 _CRTMOD ʃ[h̎擾Ɛݒ
;<d1.w:ݒ̉ʃ[h
;	$01xx	Ȃ
;	$16FF	o[WmFB$16_xxxxxx(CRT)܂$96_xxxxxx(LCD)Ԃ
;	$43xx	CRTBSRAMɕۑB$43FFSRAM̕ύX̂
;	$4Cxx	LCDBSRAMɕۑB$4CFFSRAM̕ύX̂
;	$56FF	o[WmFB$16_xxxxxxԂ
;	$FFFF	擾̂
  .if TESTS
;<d2.w:384x256CRTC R00
;	0	HT=68,R00=67
;	1	HT=69,R00=68
;	2	HT=70,R00=69
  .endif
;>d0.l:ݒỎʃ[hBo[WmF$16_xxxxxx܂$96_xxxxxxԂ
;----------------------------------------------------------------
;	ʃ[h
;
;	ʃ[h	𑜓x	ʃTCY	ʃTCY	F	y[W
;	0			512x512		1024x1024	16	1
;	1			512x512		1024x1024	16	1
;	2			256x256		1024x1024	16	1
;	3			256x256		1024x1024	16	1
;	4			512x512		512x512		16	4
;	5			512x512		512x512		16	4
;	6			256x256		512x512		16	4
;	7			256x256		512x512		16	4
;	8			512x512		512x512		256	2
;	9			512x512		512x512		256	2
;	10			256x256		512x512		256	2
;	11			256x256		512x512		256	2
;	12			512x512		512x512		65536	1
;	13			512x512		512x512		65536	1
;	14			256x256		512x512		65536	1
;	15			256x256		512x512		65536	1
;	16			768x512		1024x1024	16	1
;	17			1024x424	1024x1024	16	1
;	18			1024x848	1024x1024	16	1
;	19		VGA	640x480		1024x1024	16	1
;	20			768x512		512x512		256	2
;	21			1024x424	512x512		256	2
;	22			1024x848	512x512		256	2
;	23		VGA	640x480		512x512		256	2
;	24			768x512		512x512		65536	1
;	25			1024x424	512x512		65536	1
;	26			1024x848	512x512		65536	1
;	27		VGA	640x480		512x512		65536	1
;	$100+(0`27)	Ȃ
;	-1	擾̂
;
;	ȉ͊g
;	28			384x256		1024x1024	16	1
;	29			384x256		512x512		16	4
;	30			384x256		512x512		256	2
;	31			384x256		512x512		65536	1
;	32			512x512(`)	1024x1024	16	1
;	33			512x512(`)	512x512		16	4
;	34			512x512(`)	512x512		256	2
;	35			512x512(`)	512x512		65536	1
;	36			256x256(`)	1024x1024	16	1
;	37			256x256(`)	512x512		16	4
;	38			256x256(`)	512x512		256	2
;	39			256x256(`)	512x512		65536	1
;
;----------------------------------------------------------------
;	낢
;
;	CRTLCD
;		eʃ[h̓gꂼCRTLCDɕ
;		SRAM_XEIJSRAM_XEIJ_LCD_BIT0̂ƂCRTA1̂ƂLCD̓gŏo͂
;
;	ʃ[h17
;		24.699kHzA53.116HzA1024x424A1024x1024A16F
;		X68000ォ炠邪J
;		LCD̂Ƃ͉ʃ[h16̏㉺
;
;	ʃ[h18
;		24.699kHzA53.116HzA1024x848(C^[[X)A1024x1024A16F
;		X68000ォ炠邪J
;		LCD̂Ƃ͉ʃ[h16̏㉺ăC^[[Xɂ
;
;	ʃ[h19(VGA[h)
;		31.469kHzA59.940HzA640x480A1024x1024A16F
;		X68000 CompactŒǉꂽ
;		CRT̂Ƃ͉ʃ[h16̎͂
;		LCD̂Ƃ͂̂܂
;
;	ʃ[h20`23
;		ʃ[h16`19512x512A256FɕύX
;		X68030ŒǉꂽBJ
;
;	ʃ[h24`27
;		ʃ[h16`19512x512A65536FɕύX
;		X68030ŒǉꂽBJ
;
;	OtBbNpbg̃oO(IPLROM 1.0`1.3)
;		_CRTMODw肳ꂽʃ[hƈقȂFŃOtBbNpbg
;			https://stdkmd.net/bugsx68k/#rom_crtmod_gpalet
;		256x25616FA512x512256FAȊO65536FɂȂ
;
;	ʃ[h20`27̃oO(IPLROM 1.3)
;		ʃ[h20`27w肳ꂽƂʃ[h16`19ɂĂ256F܂65536FɕύXĂ邪A
;		̂ƂBIOS[NGẢʃ[h16`19̂܂ܕuĂ
;		_G_CLR_ONĂяoƉʃ[h16`19Ȃ̂16Fɖ߂Ă܂
;
;	NbsOGÃoO(IPLROM 1.3)
;		_CRTMODŉʃ[h22܂26ɂƃNbsOGA512x848ɂȂ
;
;	VGAIV[^̖
;		`XVIɂVGAIV[^Ȃ̂VGA[hgŏo͂Ȃ
;		VGAIV[^ꍇ
;			(50.350MHz/2)/(8*100)=31.469kHz
;			(50.350MHz/2)/(8*100*525)=59.940Hz
;		VGAIV[^Ȃꍇ
;			(69.552MHz/3)/(8*100)=28.980kHz
;			(69.552MHz/3)/(8*100*525)=55.200Hz
;		傫O킯ł͂Ȃ̂Ń}`XLj^͒Ǐ]ł邪C
;
;	VGAIV[^̗L̔
;		VGA[h̐VGAIV[^Ƃ16.683msAȂƂ18.116ms
;		荞݂̊ԂTimer-C110ms7.5msi񂾂ǂVGAIV[^̗L𔻕ʂł͂
;		ŎH
;
;----------------------------------------------------------------
;	MCRTCݒl̊֌W
;
;	HT	J
;	HS	pXJ
;	HB	obN|[`J
;	HD	fԃJ
;	HF	tg|[`J
;	VT	X^
;	VS	pXX^
;	VB	obN|[`X^
;	VD	fԃX^
;	VF	tg|[`X^
;
;	R00	HT-1=HS+HB+HD+HF-1	tg|[`IJ
;	R01	HS-1			pXIJ
;	R02	HS+HB-5			obN|[`IJ-4
;	R03	HS+HB+HD-5		fԏIJ-4
;	R04	VT-1=VS+VB+VD+VF-1	tg|[`IX^
;	R05	VS-1			pXIX^
;	R06	VS+VB-1			obN|[`IX^
;	R07	VS+VB+VD-1		fԏIX^
;
;----------------------------------------------------------------
;	IV[^ƕR20LHRL̊֌W
;
;	OSC/DIV	R20L	HRL
;	38/8	%0**00	*
;	38/4	%0**01	*
;	38/8	%0**1*	*
;	69/6	%1**00	0
;	69/8	%1**00	1
;	69/3	%1**01	0
;	69/4	%1**01	1
;	69/2	%1**10	*	XvCgs
;	50/2	%1**11	*	XvCgsBCompact
;
;----------------------------------------------------------------
;	CRTCݒl(CRT)
;
;	CRT 0/4/8/12: 512x512 31.500kHz 55.458Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10101   0   91   9  17  81      567   5  40 552     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   3   92  10  12  64   6  568   6  35 512  15 |
;	  +------------------------------------------------------+
;	  (69.552MHz/3)/(8*92)=31.500kHz (69.552MHz/3)/(8*92*568)=55.458Hz
;	  64/92=0.696 512/568=0.901 (0.696/0.901)/(512/512)=0.772
;	  31k
;
;	CRT 1/5/9/13: 512x512 15.980kHz 61.463Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %00101   0   75   3   5  69      259   2  16 256     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 38.864   4   76   4   6  64   2  260   3  14 240   3 |
;	  +------------------------------------------------------+
;	  (38.864MHz/4)/(8*76)=15.980kHz (38.864MHz/4)/(8*76*260)=61.463Hz
;	  64/76=0.842 240/260=0.923 (0.842/0.923)/(512/512)=0.912
;	  15k C^[[X
;
;	CRT 2/6/10/14: 256x256 31.500kHz 55.458Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10000   0   45   4   6  38      567   5  40 552     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   6   46   5   6  32   3  568   6  35 512  15 |
;	  +------------------------------------------------------+
;	  (69.552MHz/6)/(8*46)=31.500kHz (69.552MHz/6)/(8*46*568)=55.458Hz
;	  32/46=0.696 512/568=0.901 (0.696/0.901)/(256/256)=0.772
;	  31k X^2xǂ
;
;	CRT 3/7/11/15: 256x256 15.980kHz 61.463Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %00000   0   37   1   0  32      259   2  16 256     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 38.864   8   38   2   3  32   1  260   3  14 240   3 |
;	  +------------------------------------------------------+
;	  (38.864MHz/8)/(8*38)=15.980kHz (38.864MHz/8)/(8*38*260)=61.463Hz
;	  32/38=0.842 240/260=0.923 (0.842/0.923)/(256/256)=0.912
;	  15k
;
;	CRT 16/20/24: 768x512 31.500kHz 55.458Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10110   0  137  14  28 124      567   5  40 552     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   2  138  15  18  96   9  568   6  35 512  15 |
;	  +------------------------------------------------------+
;	  (69.552MHz/2)/(8*138)=31.500kHz (69.552MHz/2)/(8*138*568)=55.458Hz
;	  96/138=0.696 512/568=0.901 (0.696/0.901)/(768/512)=0.514
;	  31k
;
;	CRT 17/21/25: 1024x424 24.699kHz 53.116Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10110   0  175  15  31 159      464   7  32 456     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   2  176  16  20 128  12  465   8  25 424   8 |
;	  +------------------------------------------------------+
;	  (69.552MHz/2)/(8*176)=24.699kHz (69.552MHz/2)/(8*176*465)=53.116Hz
;	  128/176=0.727 424/465=0.912 (0.727/0.912)/(1024/424)=0.330
;	  24k
;
;	CRT 18/22/26: 1024x848 24.699kHz 53.116Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %11010   0  175  15  31 159      464   7  32 456     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   2  176  16  20 128  12  465   8  25 424   8 |
;	  +------------------------------------------------------+
;	  (69.552MHz/2)/(8*176)=24.699kHz (69.552MHz/2)/(8*176*465)=53.116Hz
;	  128/176=0.727 424/465=0.912 (0.727/0.912)/(1024/848)=0.661
;	  24k C^[[X
;
;	CRT 19/23/27: 640x480 31.500kHz 55.458Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10110   0  137  14  36 116      567   5  56 536     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   2  138  15  26  80  17  568   6  51 480  31 |
;	  +------------------------------------------------------+
;	  (69.552MHz/2)/(8*138)=31.500kHz (69.552MHz/2)/(8*138*568)=55.458Hz
;	  80/138=0.580 480/568=0.845 (0.580/0.845)/(640/480)=0.514
;	  31k
;
;	CRT 28/29/30/31: 384x256 31.963kHz 56.273Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10001   1   67   6  11  59      567   5  40 552     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   4   68   7   9  48   4  568   6  35 512  15 |
;	  +------------------------------------------------------+
;	  (69.552MHz/4)/(8*68)=31.963kHz (69.552MHz/4)/(8*68*568)=56.273Hz
;	  48/68=0.706 512/568=0.901 (0.706/0.901)/(384/256)=0.522
;	  31k X^2xǂ
;
;	CRT 32/33/34/35: 512x512 31.500kHz 55.458Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10110   0  137  14  44 108      567   5  40 552     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   2  138  15  34  64  25  568   6  35 512  15 |
;	  +------------------------------------------------------+
;	  (69.552MHz/2)/(8*138)=31.500kHz (69.552MHz/2)/(8*138*568)=55.458Hz
;	  64/138=0.464 512/568=0.901 (0.464/0.901)/(512/512)=0.514
;	  31k
;
;	CRT 36/37/38/39: 256x256 31.963kHz 56.273Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10001   1   67   6  19  51      567   5  40 552     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   4   68   7  17  32  12  568   6  35 512  15 |
;	  +------------------------------------------------------+
;	  (69.552MHz/4)/(8*68)=31.963kHz (69.552MHz/4)/(8*68*568)=56.273Hz
;	  32/68=0.471 512/568=0.901 (0.471/0.901)/(256/256)=0.522
;	  31k X^2xǂ
;
;----------------------------------------------------------------
;	CRTCݒl(LCD)
;
;	LCD 0/4/8/12: 512x512 35.341kHz 56.546Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10101   0   81   5  11  75      624   1  67 579     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   3   82   6  10  64   2  625   2  66 512  45 |
;	  +------------------------------------------------------+
;	  (69.552MHz/3)/(8*82)=35.341kHz (69.552MHz/3)/(8*82*625)=56.546Hz
;	  64/82=0.780 512/625=0.819 (0.780/0.819)/(512/512)=0.953
;	  SVGA
;
;	LCD 1/5/9/13: 512x512 35.341kHz 56.546Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10101   0   81   5  11  75      624   1  83 563     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   3   82   6  10  64   2  625   2  82 480  61 |
;	  +------------------------------------------------------+
;	  (69.552MHz/3)/(8*82)=35.341kHz (69.552MHz/3)/(8*82*625)=56.546Hz
;	  64/82=0.780 480/625=0.768 (0.780/0.768)/(512/512)=1.016
;	  SVGA
;
;	LCD 2/6/10/14: 256x256 34.500kHz 55.200Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10000   0   41   2   3  35      624   1  67 579     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   6   42   3   5  32   2  625   2  66 512  45 |
;	  +------------------------------------------------------+
;	  (69.552MHz/6)/(8*42)=34.500kHz (69.552MHz/6)/(8*42*625)=55.200Hz
;	  32/42=0.762 512/625=0.819 (0.762/0.819)/(256/256)=0.930
;	  SVGA X^2xǂ
;
;	LCD 3/7/11/15: 256x256 34.500kHz 55.200Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10000   0   41   2   3  35      624   1  83 563     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   6   42   3   5  32   2  625   2  82 480  61 |
;	  +------------------------------------------------------+
;	  (69.552MHz/6)/(8*42)=34.500kHz (69.552MHz/6)/(8*42*625)=55.200Hz
;	  32/42=0.762 480/625=0.768 (0.762/0.768)/(256/256)=0.992
;	  SVGA X^2xǂ
;
;	LCD 16/20/24: 768x512 35.056kHz 56.090Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10110   0  123   8  19 115      624   1  67 579     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   2  124   9  15  96   4  625   2  66 512  45 |
;	  +------------------------------------------------------+
;	  (69.552MHz/2)/(8*124)=35.056kHz (69.552MHz/2)/(8*124*625)=56.090Hz
;	  96/124=0.774 512/625=0.819 (0.774/0.819)/(768/512)=0.630
;	  SVGA
;
;	LCD 17/21/25: 768x600 35.056kHz 56.090Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10110   0  123   8  19 115      624   1  23 623     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   2  124   9  15  96   4  625   2  22 600   1 |
;	  +------------------------------------------------------+
;	  (69.552MHz/2)/(8*124)=35.056kHz (69.552MHz/2)/(8*124*625)=56.090Hz
;	  96/124=0.774 600/625=0.960 (0.774/0.960)/(768/600)=0.630
;	  SVGA
;
;	LCD 18/22/26: 768x1024 35.056kHz 56.090Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %11010   0  123   8  19 115      624   1  67 579     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   2  124   9  15  96   4  625   2  66 512  45 |
;	  +------------------------------------------------------+
;	  (69.552MHz/2)/(8*124)=35.056kHz (69.552MHz/2)/(8*124*625)=56.090Hz
;	  96/124=0.774 512/625=0.819 (0.774/0.819)/(768/1024)=1.260
;	  SVGA C^[[X
;
;	LCD 19/23/27: 640x480 31.469kHz 59.940Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10111   0   99  11  13  93      524   1  34 514     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 50.350   2  100  12   6  80   2  525   2  33 480  10 |
;	  +------------------------------------------------------+
;	  (50.350MHz/2)/(8*100)=31.469kHz (50.350MHz/2)/(8*100*525)=59.940Hz
;	  80/100=0.800 480/525=0.914 (0.800/0.914)/(640/480)=0.656
;	  VGA
;
;	LCD 28/29/30/31: 384x256 31.963kHz 51.141Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10001   1   67   6  11  59      624   1  67 579     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   4   68   7   9  48   4  625   2  66 512  45 |
;	  +------------------------------------------------------+
;	  (69.552MHz/4)/(8*68)=31.963kHz (69.552MHz/4)/(8*68*625)=51.141Hz
;	  48/68=0.706 512/625=0.819 (0.706/0.819)/(384/256)=0.574
;	  X^2xǂ
;
;	LCD 32/33/34/35: 512x512 35.056kHz 56.090Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10110   0  123   8  35  99      624   1  67 579     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   2  124   9  31  64  20  625   2  66 512  45 |
;	  +------------------------------------------------------+
;	  (69.552MHz/2)/(8*124)=35.056kHz (69.552MHz/2)/(8*124*625)=56.090Hz
;	  64/124=0.516 512/625=0.819 (0.516/0.819)/(512/512)=0.630
;	  SVGA
;
;	LCD 36/37/38/39: 256x256 31.963kHz 51.141Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10001   1   67   6  19  51      624   1  67 579     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   4   68   7  17  32  12  625   2  66 512  45 |
;	  +------------------------------------------------------+
;	  (69.552MHz/4)/(8*68)=31.963kHz (69.552MHz/4)/(8*68*625)=51.141Hz
;	  32/68=0.471 512/625=0.819 (0.471/0.819)/(256/256)=0.574
;	  X^2xǂ
;
;	yQlzVGA: 640x480 31.469kHz 59.940Hz
;	  +------------------------------------------------------+
;	  |    OSC       HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 25.175      100  12   6  80   2  525   2  33 480  10 |
;	  +------------------------------------------------------+
;	  25.175MHz/(8*100)=31.469kHz (25.175MHz/1)/(8*100*525)=59.940Hz
;	  80/100=0.800 480/525=0.914 (0.800/0.914)/(640/480)=0.656
;
;	yQlzSVGA: 800x600 35.156kHz 56.250Hz
;	  +------------------------------------------------------+
;	  |    OSC       HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 36.000      128   9  16 100   3  625   2  22 600   1 |
;	  +------------------------------------------------------+
;	  36.000MHz/(8*128)=35.156kHz (36.000MHz/1)/(8*128*625)=56.250Hz
;	  100/128=0.781 600/625=0.960 (0.781/0.960)/(800/600)=0.610
;
;	yQlzSVGA: 800x600 37.879kHz 60.317Hz
;	  +------------------------------------------------------+
;	  |    OSC       HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 40.000      132  16  11 100   5  628   4  23 600   1 |
;	  +------------------------------------------------------+
;	  40.000MHz/(8*132)=37.879kHz (40.000MHz/1)/(8*132*628)=60.317Hz
;	  100/132=0.758 600/628=0.955 (0.758/0.955)/(800/600)=0.595
;
;	yQlzSVGA: 800x600 46.875kHz 75.000Hz
;	  +------------------------------------------------------+
;	  |    OSC       HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 49.500      132  10  20 100   2  625   3  21 600   1 |
;	  +------------------------------------------------------+
;	  49.500MHz/(8*132)=46.875kHz (49.500MHz/1)/(8*132*625)=75.000Hz
;	  100/132=0.758 600/625=0.960 (0.758/0.960)/(800/600)=0.592
;
;----------------------------------------------------------------

;p[^1
	.offset	0
crtmod_param_1_width:	.ds.w	1
crtmod_param_1_height:	.ds.w	1
crtmod_param_1_r20h:	.ds.b	1
			.ds.b	1
crtmod_param_1_2nd:	.ds.w	1
crtmod_param_1_size:
	.text

;p[^2
	.offset	0
crtmod_param_2_r20l:	.ds.b	1
crtmod_param_2_hrl:	.ds.b	1
crtmod_param_2_r00:	.ds.w	1
crtmod_param_2_r01:	.ds.w	1
crtmod_param_2_r02:	.ds.w	1
crtmod_param_2_r03:	.ds.w	1
crtmod_param_2_r04:	.ds.w	1
crtmod_param_2_r05:	.ds.w	1
crtmod_param_2_r06:	.ds.w	1
crtmod_param_2_r07:	.ds.w	1
crtmod_param_2_r08:	.ds.w	1
crtmod_param_2_size:
	.text

crtmod_param_1	.macro	width,height,r20h,offset2nd
	.dc.w	width
	.dc.w	height
	.dc.b	r20h			;R20H
	.dc.b	0
	.dc.w	crtmod_param_2_size*offset2nd
	.endm

crtmod_param_2	.macro	r20l,hrl,ht,hs,hb,hd,hf,vt,vs,vb,vd,vf,r08
  .if TESTS
;	.fail	(ht.and.1)!=0
  .else
	.fail	(ht.and.1)!=0
  .endif
	.fail	ht!=hs+hb+hd+hf
	.fail	vt!=vs+vb+vd+vf
	.dc.b	r20l			;R20L
	.dc.b	hrl			;HRL
	.dc.w	hs+hb+hd+hf-1		;R00
	.dc.w	hs-1			;R01
	.dc.w	hs+hb-5			;R02
	.dc.w	hs+hb+hd-5		;R03
	.dc.w	vs+vb+vd+vf-1		;R04
	.dc.w	vs-1			;R05
	.dc.w	vs+vb-1			;R06
	.dc.w	vs+vb+vd-1		;R07
	.dc.w	r08			;R08
	.endm

crtmod_modes	equ	(crtmod_table_1_crt_end-crtmod_table_1_crt)/crtmod_param_1_size	;ʃ[h̐

	.text
	.even
iocs_10_CRTMOD:

;o[WmF
	move.l	#CRTMOD_VERSION,d0
	goto	<cmp.w #$56FF,d1>,eq,@f
	if	<cmp.w #$16FF,d1>,eq
		if	<btst.b #SRAM_XEIJ_LCD_BIT,SRAM_XEIJ>,ne
			bset.l	#31,d0
		endif
@@:		rts
	endif

	push	d1/d2/d3/d7/a0/a1/a3/a4/a5/a6

;(`)OOŃANZX
;	$00E80000	CRTC
;	$00E82000	VICON
;	$00E84000	DMAC
;	$00E86000	SUPERAREA
;	$00E88000	MFP
;	$00E8A000	RTC
;	$00E8C000	PRNPORT
;	$00E8E000	SYSPORT
	lea.l	$00E88000,a6
OO	reg	-$00E88000(a6)
;<a6.l:(`)OÕx[XAhX

;(`)SSŃANZX
;	$00EB0000	SPRC
	lea.l	$00EB8000,a3
SS	reg	-$00EB8000(a3)
;<a3.l:(`)SS̃x[XAhX

;ݒỎʃ[hmF
	moveq.l	#0,d7
	move.b	BIOS_CRTMOD.w,d7	;ݒỎʃ[h
	swap.w	d7
;<d7.l:ݒỎʃ[h<<16

;邩
	move.w	d1,d7
	clr.b	d7
	sub.w	d7,d1
;<d1.w:ʃ[h
;<d7.w:$0000=,$0100=Ȃ,$4300=CRT,$4C00=LCD

;CRTLCD̃XCb`̐؂ւ
	if	<cmp.w #$4300,d7>,eq	;CRT
		unlocksram
		bclr.b	#SRAM_XEIJ_LCD_BIT,SRAM_XEIJ
		locksram
		clr.w	d7			;
	elif	<cmp.w #$4C00,d7>,eq	;LCD
		unlocksram
		bset.b	#SRAM_XEIJ_LCD_BIT,SRAM_XEIJ
		locksram
		clr.w	d7			;
	endif
;<d7.w:$0000=,$0100=Ȃ

;擾݂̂
;	IPLROM 1.0`1.3$FFFFĐݒ̉ʃ[h͈͊ÔƂȂ
;	ł$FFFF܂߂Đݒ̉ʃ[h͈͊ÔƂ擾݂̂Ƃ
;	$43FF$4CFFCRTLCD̃XCb`̐؂ւs
	goto	<cmp.w #crtmod_modes,d1>,hs,crtmod_end	;ݒ̉ʃ[h͈͊O

;ݒ肷

;p[^1̃AhX߂
	lea.l	crtmod_table_1_crt(pc),a4
	if	<btst.b #SRAM_XEIJ_LCD_BIT,SRAM_XEIJ>,ne	;LCD
		lea.l	crtmod_table_1_lcd(pc),a4
	endif
	move.w	d1,d0
  .if crtmod_param_1_size=8
	lsl.w	#3,d0
  .else
	mulu.w	#crtmod_param_1_size,d0
  .endif
	adda.w	d0,a4
;<a4.l:p[^1̃AhX

;p[^2̃AhX߂
	lea.l	crtmod_table_2(pc),a5
  .if TESTS
	lsl.l	#2,d2
	movea.l	(a5,d2.w),a5
  .endif
	adda.w	crtmod_param_1_2nd(a4),a5
;<a5.l:p[^2̃AhX

;[hmF
	moveq.l	#7,d3
	and.b	crtmod_param_1_r20h(a4),d3	;[hB0`7
;<d3.w:[hB0`7

;邩
	if	<tst.w d7>,eq

	;

	;ݒ̉ʃ[hۑ
		move.b	d1,BIOS_CRTMOD.w	;ݒ̉ʃ[h

	;OtBbNOFFAeLXgOFFAXvCgOFF
		clr.w	(VICON_VISIBLE)OO

	;eLXgJ[\OFF
		IOCS	_B_CUROFF

	;eLXgv[0`1NA
	;	X^Rs[gƑR[hȂ
	;	CRTCĂȂ̂ŃX^Rs[IȂ
		move.w	#$0133,(CRTC_ACCESS)OO	;ANZXJn
		moveq.l	#0,d0
		lea.l	$00E00000,a0		;eLXgVRAM
		move.w	#($00E20000-$00E00000)/(4*2)-1,d1	;16384
		for	d1
			move.l	d0,(a0)+
			move.l	d0,(a0)+
		next
		move.w	#$0033,(CRTC_ACCESS)OO	;ANZXI

	;OtBbNʎgps
		clr.w	BIOS_GRAPHIC_PALETS.w	;OtBbNʂ̐F-1B0=OtBbNʎgps

	;/Ȃ
		bsr	crtmod_common

	;CRTCR}h~
		clr.w	(CRTC_ACTION)OO

	;OtBbNpbg
		move.w	d3,d0			;[hB0`7
		bsr	initialize_gpalet	;OtBbNpbg

	;OtBbNXg[WON
	;	IPLROM 1.0`1.3_CRTMOD̓OtBbNXg[WON̏ԂŕA
		bset.b	#CRTC_GRAPHIC_STORAGE_BIT,(CRTC_MODE_BYTE)OO	;OtBbNXg[WON

	;eLXgJ[\ON
		IOCS	_B_CURON

	;eLXgpbg
		lea.l	SRAM_TEXT_PALET_0,a0
		lea.l	(VICON_TSPALET)OO,a1
		move.l	(a0)+,(a1)+		;0,1
		move.l	(a0)+,(a1)+		;2,3
		move.l	(a0),d0			;d0=4|8
		move.l	d0,d1			;d1=4|8
		swap.w	d0			;d0=8|4
		move.w	d0,(a1)+		;4
		move.w	d0,(a1)+		;5
		move.w	d0,(a1)+		;6
		move.w	d0,(a1)+		;7
		move.w	d1,d0			;d0=8|8
		move.l	d0,(a1)+		;8,9
		move.l	d0,(a1)+		;10,11
		move.l	d0,(a1)+		;12,13
		move.l	d0,(a1)+		;14,15

	;RgXg
		move.b	SRAM_CONTRAST,(SYSPORT_CONTRAST)OO

	;XvCgRg[ݒ肷
~i = SPRC_SPRITE_OFF|SPRC_BG_1_TEXT_1|SPRC_BG_1_OFF|SPRC_BG_0_TEXT_0|SPRC_BG_0_OFF
		move.w	#~i,SPRC_CONTROL

	;eLXgON
		move.w	#VICON_TXON_MASK,(VICON_VISIBLE)OO

	;D揇ʂݒ肷
~i = 0<<VICON_SPPR_BIT|1<<VICON_TXPR_BIT|2<<VICON_GRPR_BIT			;SP>TX>GR
~j = 3<<VICON_G4TH_BIT|2<<VICON_G3RD_BIT|1<<VICON_G2ND_BIT|0<<VICON_G1ST_BIT	;G1>G2>G3>G4
		move.w	#~i|~j,(VICON_PRIORITY)OO

	else

	;Ȃ

	;ݒ̉ʃ[hۑ
		move.b	d1,BIOS_CRTMOD.w	;ݒ̉ʃ[h

	;OtBbNʎgps
		clr.w	BIOS_GRAPHIC_PALETS.w	;OtBbNʂ̐F-1B0=OtBbNʎgps

	;/Ȃ
		bsr	crtmod_common

	;OtBbNʂ\Ă邩
		moveq.l	#VICON_GXON_MASK|VICON_G4ON_MASK|VICON_G3ON_MASK|VICON_G2ON_MASK|VICON_G1ON_MASK,d0
		and.w	(VICON_VISIBLE)OO,d0
		if	ne			;OtBbNʂ\ĂƂ

		;[hݒ肷
		;	Xg[W͕ωȂ
			andi.b	#.notb.7,(CRTC_MODE_BYTE)OO
			or.b	d3,(CRTC_MODE_BYTE)OO
			move.w	d3,(VICON_MEMORY_MODE)OO

		;BIOS[NGA
			move.l	#$00C00000,BIOS_GRAPHIC_PAGE.w
			if	<cmp.w #4,d3>,lo	;[h0`3B512x512hbg
				move.l	#2*512,BIOS_GRAPHIC_Y_OFFSET.w
				if	<cmp.w #1,d3>,lo	;[h0B512x512hbgA16FA4y[W
					move.w	#16-1,BIOS_GRAPHIC_PALETS.w
				elif	eq			;[h1B512x512hbgA256FA2y[W
					move.w	#256-1,BIOS_GRAPHIC_PALETS.w
				else				;[h2`3B512x512hbgA65536FA1y[W
					move.w	#65536-1,BIOS_GRAPHIC_PALETS.w
				endif
			else					;[h4`7B1024x1024hbgA16FA1y[W
				move.l	#2*1024,BIOS_GRAPHIC_Y_OFFSET.w
				move.w	#16-1,BIOS_GRAPHIC_PALETS.w
			endif

		endif

	endif

;I
;<d7.l:ݒỎʃ[h<<16
crtmod_end:
	clr.w	d7
	swap.w	d7			;ݒỎʃ[h
	move.l	d7,d0
	pop
	rts

;/Ȃ
crtmod_common:

;CRTCƃVXe|[gR20,HRL,R00`R07ݒ肷
;	ׂẲʃ[h[h3ɂȂ
;	Xg[WOFFɂȂ
	move.w	#3<<8,d2		;R20H(V)
	move.b	crtmod_param_2_r20l(a5),d2	;R20L(V)
;<d2.w:R20(V)
	lea.l	dot_clock_rank(pc),a0
	moveq.l	#%00011111,d0
	and.b	(CRTC_RESOLUTION_BYTE)OO,d0	;R20L()
	moveq.l	#SYSPORT_HRL,d1
	and.b	(SYSPORT_MISC)OO,d1
	neg.b	d1
	addx.b	d0,d0				;R20L<<1|HRL()
	move.b	(a0,d0.w),d0			;ÂhbgNbÑN
	moveq.l	#%00011111,d1
	and.b	d2,d1				;R20L(V)
	add.b	d1,d1
	add.b	crtmod_param_2_hrl(a5),d1	;R20L<<1|HRL(V)
	move.b	(a0,d1.w),d1			;VhbgNbÑN
	if	<cmp.b d0,d1>,lo	;hbgNbN
		move.w	d2,(CRTC_MODE_RESOLUTION)OO	;R20
		tst.b	crtmod_param_2_hrl(a5)
		bsne.b	#SYSPORT_HRL_BIT,(SYSPORT_MISC)OO	;HRL
		lea.l	(CRTC_H_SYNC_END)OO,a0	;R01
		lea.l	crtmod_param_2_r01(a5),a1
		move.w	(a1)+,(a0)+		;R01
		move.l	(a1)+,(a0)+		;R02,R03
		move.l	(a1)+,(a0)+		;R04,R05
		move.l	(a1)+,(a0)+		;R06,R07
		move.w	crtmod_param_2_r00(a5),(CRTC_H_FRONT_END)OO	;R00
	else				;hbgNbNオ
		lea.l	(CRTC_H_FRONT_END)OO,a0	;R00
		lea.l	crtmod_param_2_r00(a5),a1
		move.l	(a1)+,(a0)+		;R00,R01
		move.l	(a1)+,(a0)+		;R02,R03
		move.l	(a1)+,(a0)+		;R04,R05
		move.l	(a1)+,(a0)+		;R06,R07
		move.w	d2,(CRTC_MODE_RESOLUTION)OO	;R20
		tst.b	crtmod_param_2_hrl(a5)
		bsne.b	#SYSPORT_HRL_BIT,(SYSPORT_MISC)OO	;HRL
	endif

;CRTCR08ݒ肷
;	OAWXg
;	X[p[C|[YƂrfỈfX68000̉fd˂邽߂ɁA
;	rfIX68000̐pX̐擪̎ԍ38.863632MHz̃TCNŎw肷
;	𑜓x512x512̂Ƃ
;		pX4LN^BR01=4-1=3
;		obN|[`6LN^BR02=4+6-5=5
;		OAWXg44
;		perl -e "print((4.7+4.7)*38.863632-(4*8*(4+6))-1)"
;		44.3181408
;	𑜓x256x256̂ƂB1hbgǉ
;		pX2LN^BR01=2-1=1
;		obN|[`3LN^BR02=2+3-5=0
;		OAWXg36
;		perl -e "print((4.7+4.7)*38.863632-(8*(8*(2+3)+1))-1)"
;		36.3181408
	move.w	crtmod_param_2_r08(a5),(CRTC_ADJUST)OO	;R08

;CRTCR09`R19,R21`R24
	moveq.l	#0,d0
	lea.l	(CRTC_RASTER)OO,a0	;R09
	move.w	d0,(a0)+		;R09
	move.l	d0,(a0)+		;R10,R11
	move.l	d0,(a0)+		;R12,R13
	move.l	d0,(a0)+		;R14,R15
	move.l	d0,(a0)+		;R16,R17
	move.l	d0,(a0)+		;R18,R19
	addq.l	#2,a0
	move.w	#$0033,(a0)+		;R21
	move.l	d0,(a0)+		;R22,R23
	move.w	d0,(a0)+		;R24

;rfIRg[̃[hݒ肷
;	ׂẲʃ[h[h3ɂȂ
	move.w	#3,(VICON_MEMORY_MODE)OO

;XvCgRg[
;	XvCgR20L̉5rbg%1_??_1?̂Ƃ
	moveq.l	#%1_00_10,d0
	and.b	crtmod_param_2_r20l(a5),d0	;R20L
	if	<cmp.w #%1_00_10,d0>,eq	;XvCg
		move.w	#255,d1
		move.w	d1,(SPRC_H_BACK_END)SS	;XvCgobN|[`IJ
		moveq.l	#500/50,d0		;500us
		bsr	wait_50us		;50usPʂ̃EFCg
		move.w	d1,(SPRC_H_FRONT_END)SS	;XvCgtg|[`IJ
		move.w	d1,(SPRC_V_BACK_END)SS	;XvCgobN|[`IX^
		move.w	d1,(SPRC_RESOLUTION)SS	;XvCg𑜓xB--------|---|𑜓x|TCY##|TCY##
	else				;XvCgL
	;𑜓x
		moveq.l	#%1_11_11,d1
		and.b	crtmod_param_2_r20l(a5),d1	;R20L
	;<d1.w:𑜓x
	;obN|[`IJ
		moveq.l	#4,d0
		add.w	crtmod_param_2_r02(a5),d0
		move.w	d0,(SPRC_H_BACK_END)SS	;XvCgobN|[`IJBR02+4
	;tg|[`IJ
	;	obN|[`IJݒ130us҂Ă琅tg|[`IJݒ肷
	;	tg|[`IJ͐256hbĝƂR00ƓlAȊO255
	;		Inside X68000ɒ𑜓x256x256̂ƂR00ƓlAȊO255ݒ肷ƏĂ邪A
	;		𑜓x256x256̂Ƃ255ɂƃXvCgꍇ
	;		512hbĝƂ255ɂȂƐ256hbg琅512hbgɐ؂ւƂXvCg̐̈ʒu邱Ƃ
	;	IPLROM 1.3dbraX68030 25MHẑƂ500us҂ĂB060turbôƂEGCgs
		moveq.l	#500/50,d0		;500us
		bsr	wait_50us		;50usPʂ̃EFCg
		moveq.l	#%0_00_11,d0
		and.b	d1,d0
		if	eq			;256hbg
			move.w	crtmod_param_2_r00(a5),(SPRC_H_FRONT_END)SS	;XvCgtg|[`IJBR00
		else				;256hbgȊO
			move.w	#255,(SPRC_H_FRONT_END)SS	;XvCgtg|[`IJB255
		endif
	;obN|[`IX^
		move.w	crtmod_param_2_r06(a5),(SPRC_V_BACK_END)SS	;XvCgobN|[`IX^BR06
	;𑜓x
		ifand	<cmp.w #%10001,d1>,eq,<cmpi.w #256,crtmod_param_1_width(a4)>,eq	;𑜓x512x256ŕ256̂Ƃ
			moveq.l	#%10000,d1		;XvCg256x256ɂ
		endif
		move.w	d1,(SPRC_RESOLUTION)SS	;XvCg𑜓xB--------|---|𑜓x|TCY##|TCY##
	endif

;OtBbNʂ̃NbsOGA
;	ʃ[h20`27͕\ʂʂ傫Ƃɒӂ
	move.w	crtmod_param_1_width(a4),d0	;
	move.w	crtmod_param_1_height(a4),d1	;
	if	<cmp.w #4,d3>,lo	;[h0`3B512x512܂
		move.w	#512,d2
		if	<cmp.w d2,d0>,hi
			move.w	d2,d0
		endif
		if	<cmp.w d2,d1>,hi
			move.w	d2,d1
		endif
	endif
	subq.w	#1,d0			;Xő
	subq.w	#1,d1			;Yő
	clr.l	BIOS_GRAPHIC_LEFT.w	;BIOS_GRAPHIC_TOP
	move.w	d0,BIOS_GRAPHIC_RIGHT.w
	move.w	d1,BIOS_GRAPHIC_BOTTOM.w

;OtBbNVRAMỸItZbg
					;d3=0 1 2 3 4 5 6 7
	moveq.l	#4,d0			;d0=4 4 4 4 4 4 4 4
	and.w	d3,d0			;d0=0 0 0 0 4 4 4 4
	addq.w	#4,d0			;d0=4 4 4 4 8 8 8 8
	lsl.w	#8,d0			;d0=1024 1024 1024 1024 2048 2048 2048 2048
	move.l	d0,BIOS_GRAPHIC_Y_OFFSET.w

;OtBbNʂ̃y[W
					;d3=0 1 2  3  4  5  6  7
	moveq.l	#4,d0			;d0=4 4 4  4  4  4  4  4
	lsr.b	d3,d0			;d0=4 2 1  0  0  0  0  0
	seq.b	d1			;d1=0 0 0 -1 -1 -1 -1 -1
	sub.b	d1,d0			;d0=4 2 1  1  1  1  1  1
	move.b	d0,BIOS_GRAPHIC_PAGES.w

;eLXgʂ̈ʒu
	move.l	#$00E00000,BIOS_TEXT_PLANE.w
	clr.l	BIOS_CONSOLE_OFFSET.w

;eLXgʂ̑傫
	move.w	crtmod_param_1_width(a4),d0	;
	move.w	crtmod_param_1_height(a4),d1	;
	lsr.w	#3,d0			;/8
	lsr.w	#4,d1			;/16B42416Ŋ؂ȂƂɒ
	subq.w	#1,d0			;/8-1
	subq.w	#1,d1			;/16-1
	move.w	d0,BIOS_CONSOLE_RIGHT.w
	move.w	d1,BIOS_CONSOLE_BOTTOM.w

;eLXgJ[\̈ʒu
	clr.l	BIOS_CURSOR_COLUMN.w	;BIOS_CURSOR_ROW

;}EXJ[\̈ړ͈
	clr.l	d1
	move.l	BIOS_GRAPHIC_RIGHT,d2	;BIOS_GRAPHIC_BOTTOM
	IOCS	_MS_LIMIT		;IOCSR[$77 _MS_LIMIT }EXJ[\̈ړ͈͂ݒ肷

	rts

;p[^1(CRT)
crtmod_table_1_crt:
;			 WIDTH HEIGHT R20H  2ND    1ST
	crtmod_param_1	   512,   512,   4,   0  ; CRT 0
	crtmod_param_1	   512,   512,   4,   1  ; CRT 1
	crtmod_param_1	   256,   256,   4,   2  ; CRT 2
	crtmod_param_1	   256,   256,   4,   3  ; CRT 3
	crtmod_param_1	   512,   512,   0,   0  ; CRT 4
	crtmod_param_1	   512,   512,   0,   1  ; CRT 5
	crtmod_param_1	   256,   256,   0,   2  ; CRT 6
	crtmod_param_1	   256,   256,   0,   3  ; CRT 7
	crtmod_param_1	   512,   512,   1,   0  ; CRT 8
	crtmod_param_1	   512,   512,   1,   1  ; CRT 9
	crtmod_param_1	   256,   256,   1,   2  ; CRT 10
	crtmod_param_1	   256,   256,   1,   3  ; CRT 11
	crtmod_param_1	   512,   512,   3,   0  ; CRT 12
	crtmod_param_1	   512,   512,   3,   1  ; CRT 13
	crtmod_param_1	   256,   256,   3,   2  ; CRT 14
	crtmod_param_1	   256,   256,   3,   3  ; CRT 15
	crtmod_param_1	   768,   512,   4,   4  ; CRT 16
	crtmod_param_1	  1024,   424,   4,   5  ; CRT 17
	crtmod_param_1	  1024,   848,   4,   6  ; CRT 18
	crtmod_param_1	   640,   480,   4,   7  ; CRT 19
	crtmod_param_1	   768,   512,   1,   4  ; CRT 20
	crtmod_param_1	  1024,   424,   1,   5  ; CRT 21
	crtmod_param_1	  1024,   848,   1,   6  ; CRT 22
	crtmod_param_1	   640,   480,   1,   7  ; CRT 23
	crtmod_param_1	   768,   512,   3,   4  ; CRT 24
	crtmod_param_1	  1024,   424,   3,   5  ; CRT 25
	crtmod_param_1	  1024,   848,   3,   6  ; CRT 26
	crtmod_param_1	   640,   480,   3,   7  ; CRT 27
	crtmod_param_1	   384,   256,   4,   8  ; CRT 28
	crtmod_param_1	   384,   256,   0,   8  ; CRT 29
	crtmod_param_1	   384,   256,   1,   8  ; CRT 30
	crtmod_param_1	   384,   256,   3,   8  ; CRT 31
	crtmod_param_1	   512,   512,   4,   9  ; CRT 32
	crtmod_param_1	   512,   512,   0,   9  ; CRT 33
	crtmod_param_1	   512,   512,   1,   9  ; CRT 34
	crtmod_param_1	   512,   512,   3,   9  ; CRT 35
	crtmod_param_1	   256,   256,   4,  10  ; CRT 36
	crtmod_param_1	   256,   256,   0,  10  ; CRT 37
	crtmod_param_1	   256,   256,   1,  10  ; CRT 38
	crtmod_param_1	   256,   256,   3,  10  ; CRT 39
crtmod_table_1_crt_end:

;p[^1(LCD)
crtmod_table_1_lcd:
;			 WIDTH HEIGHT R20H  2ND    1ST
	crtmod_param_1	   512,   512,   4,  11  ; LCD 0
	crtmod_param_1	   512,   512,   4,  12  ; LCD 1
	crtmod_param_1	   256,   256,   4,  13  ; LCD 2
	crtmod_param_1	   256,   256,   4,  14  ; LCD 3
	crtmod_param_1	   512,   512,   0,  11  ; LCD 4
	crtmod_param_1	   512,   512,   0,  12  ; LCD 5
	crtmod_param_1	   256,   256,   0,  13  ; LCD 6
	crtmod_param_1	   256,   256,   0,  14  ; LCD 7
	crtmod_param_1	   512,   512,   1,  11  ; LCD 8
	crtmod_param_1	   512,   512,   1,  12  ; LCD 9
	crtmod_param_1	   256,   256,   1,  13  ; LCD 10
	crtmod_param_1	   256,   256,   1,  14  ; LCD 11
	crtmod_param_1	   512,   512,   3,  11  ; LCD 12
	crtmod_param_1	   512,   512,   3,  12  ; LCD 13
	crtmod_param_1	   256,   256,   3,  13  ; LCD 14
	crtmod_param_1	   256,   256,   3,  14  ; LCD 15
	crtmod_param_1	   768,   512,   4,  15  ; LCD 16
	crtmod_param_1	   768,   600,   4,  16  ; LCD 17
	crtmod_param_1	   768,  1024,   4,  17  ; LCD 18
	crtmod_param_1	   640,   480,   4,  18  ; LCD 19
	crtmod_param_1	   768,   512,   1,  15  ; LCD 20
	crtmod_param_1	   768,   600,   1,  16  ; LCD 21
	crtmod_param_1	   768,  1024,   1,  17  ; LCD 22
	crtmod_param_1	   640,   480,   1,  18  ; LCD 23
	crtmod_param_1	   768,   512,   3,  15  ; LCD 24
	crtmod_param_1	   768,   600,   3,  16  ; LCD 25
	crtmod_param_1	   768,  1024,   3,  17  ; LCD 26
	crtmod_param_1	   640,   480,   3,  18  ; LCD 27
	crtmod_param_1	   384,   256,   4,  19  ; LCD 28
	crtmod_param_1	   384,   256,   0,  19  ; LCD 29
	crtmod_param_1	   384,   256,   1,  19  ; LCD 30
	crtmod_param_1	   384,   256,   3,  19  ; LCD 31
	crtmod_param_1	   512,   512,   4,  20  ; LCD 32
	crtmod_param_1	   512,   512,   0,  20  ; LCD 33
	crtmod_param_1	   512,   512,   1,  20  ; LCD 34
	crtmod_param_1	   512,   512,   3,  20  ; LCD 35
	crtmod_param_1	   256,   256,   4,  21  ; LCD 36
	crtmod_param_1	   256,   256,   0,  21  ; LCD 37
	crtmod_param_1	   256,   256,   1,  21  ; LCD 38
	crtmod_param_1	   256,   256,   3,  21  ; LCD 39

;p[^2
crtmod_table_2:
  .if TESTS
n=0
    .rept TESTS
	.dc.l	crtmod_table_2_%n
n=n+1
    .endm
n=0
    .rept TESTS
crtmod_table_2_%n:
;			   R20L  HRL    HT   HS   HB   HD   HF    VT   VS   VB   VD   VF   R08    2ND  1ST
	crtmod_param_2	 %10101,   0,   92,  10,  12,  64,   6,  568,   6,  35, 512,  15,   27  ;   0  CRT 0/4/8/12
	crtmod_param_2	 %00101,   0,   76,   4,   6,  64,   2,  260,   3,  14, 240,   3,   44  ;   1  CRT 1/5/9/13
	crtmod_param_2	 %10000,   0,   46,   5,   6,  32,   3,  568,   6,  35, 512,  15,   27  ;   2  CRT 2/6/10/14
	crtmod_param_2	 %00000,   0,   38,   2,   3,  32,   1,  260,   3,  14, 240,   3,   36  ;   3  CRT 3/7/11/15
	crtmod_param_2	 %10110,   0,  138,  15,  18,  96,   9,  568,   6,  35, 512,  15,   27  ;   4  CRT 16/20/24
	crtmod_param_2	 %10110,   0,  176,  16,  20, 128,  12,  465,   8,  25, 424,   8,   27  ;   5  CRT 17/21/25
	crtmod_param_2	 %11010,   0,  176,  16,  20, 128,  12,  465,   8,  25, 424,   8,   27  ;   6  CRT 18/22/26
	crtmod_param_2	 %10110,   0,  138,  15,  26,  80,  17,  568,   6,  51, 480,  31,   27  ;   7  CRT 19/23/27
      .if n=0
	crtmod_param_2	 %10001,   1,   68,   7,   9,  48,   4,  568,   6,  35, 512,  15,   27  ;   8  CRT 28/29/30/31
      .elif n=1
	crtmod_param_2	 %10001,   1, 68+1, 7-1,   9,  48, 4+2,  568,   6,  35, 512,  15,   27  ;   8  CRT 28/29/30/31
      .elif n=2
	crtmod_param_2	 %10001,   1, 68+1, 7-1, 9+1,  48, 4+1,  568,   6,  35, 512,  15,   27  ;   8  CRT 28/29/30/31
      .elif n=3
	crtmod_param_2	 %10001,   1, 68+1, 7-1, 9+2,  48,   4,  568,   6,  35, 512,  15,   27  ;   8  CRT 28/29/30/31
      .elif n=4
	crtmod_param_2	 %10001,   1, 68+1,   7, 9-1,  48, 4+2,  568,   6,  35, 512,  15,   27  ;   8  CRT 28/29/30/31
      .elif n=5
	crtmod_param_2	 %10001,   1, 68+1,   7,   9,  48, 4+1,  568,   6,  35, 512,  15,   27  ;   8  CRT 28/29/30/31
      .elif n=6
	crtmod_param_2	 %10001,   1, 68+1,   7, 9+1,  48,   4,  568,   6,  35, 512,  15,   27  ;   8  CRT 28/29/30/31
      .elif n=7
	crtmod_param_2	 %10001,   1, 68+1,   7, 9+2,  48, 4-1,  568,   6,  35, 512,  15,   27  ;   8  CRT 28/29/30/31
      .elif n=8
	crtmod_param_2	 %10001,   1, 68+1, 7+1, 9-1,  48, 4+1,  568,   6,  35, 512,  15,   27  ;   8  CRT 28/29/30/31
      .elif n=9
	crtmod_param_2	 %10001,   1, 68+1, 7+1,   9,  48,   4,  568,   6,  35, 512,  15,   27  ;   8  CRT 28/29/30/31
      .elif n=10
	crtmod_param_2	 %10001,   1, 68+1, 7+1, 9+1,  48, 4-1,  568,   6,  35, 512,  15,   27  ;   8  CRT 28/29/30/31
      .elif n=11
	crtmod_param_2	 %10001,   1, 68+1, 7+2, 9-1,  48,   4,  568,   6,  35, 512,  15,   27  ;   8  CRT 28/29/30/31
      .elif n=12
	crtmod_param_2	 %10001,   1, 68+1, 7+2,   9,  48, 4-1,  568,   6,  35, 512,  15,   27  ;   8  CRT 28/29/30/31
      .elif n=13
	crtmod_param_2	 %10001,   1, 68+2, 7+1,   9,  48, 4+1,  568,   6,  35, 512,  15,   27  ;   8  CRT 28/29/30/31
      .endif
	crtmod_param_2	 %10110,   0,  138,  15,  34,  64,  25,  568,   6,  35, 512,  15,   27  ;   9  CRT 32/33/34/35
	crtmod_param_2	 %10001,   1,   68,   7,  17,  32,  12,  568,   6,  35, 512,  15,   27  ;  10  CRT 36/37/38/39
	crtmod_param_2	 %10101,   0,   82,   6,  10,  64,   2,  625,   2,  66, 512,  45,   27  ;  11  LCD 0/4/8/12
	crtmod_param_2	 %10101,   0,   82,   6,  10,  64,   2,  625,   2,  82, 480,  61,   27  ;  12  LCD 1/5/9/13
	crtmod_param_2	 %10000,   0,   42,   3,   5,  32,   2,  625,   2,  66, 512,  45,   27  ;  13  LCD 2/6/10/14
	crtmod_param_2	 %10000,   0,   42,   3,   5,  32,   2,  625,   2,  82, 480,  61,   27  ;  14  LCD 3/7/11/15
	crtmod_param_2	 %10110,   0,  124,   9,  15,  96,   4,  625,   2,  66, 512,  45,   27  ;  15  LCD 16/20/24
	crtmod_param_2	 %10110,   0,  124,   9,  15,  96,   4,  625,   2,  22, 600,   1,   27  ;  16  LCD 17/21/25
	crtmod_param_2	 %11010,   0,  124,   9,  15,  96,   4,  625,   2,  66, 512,  45,   27  ;  17  LCD 18/22/26
	crtmod_param_2	 %10111,   0,  100,  12,   6,  80,   2,  525,   2,  33, 480,  10,   27  ;  18  LCD 19/23/27
	crtmod_param_2	 %10001,   1,   68,   7,   9,  48,   4,  625,   2,  66, 512,  45,   27  ;  19  LCD 28/29/30/31
	crtmod_param_2	 %10110,   0,  124,   9,  31,  64,  20,  625,   2,  66, 512,  45,   27  ;  20  LCD 32/33/34/35
	crtmod_param_2	 %10001,   1,   68,   7,  17,  32,  12,  625,   2,  66, 512,  45,   27  ;  21  LCD 36/37/38/39
n=n+1
    .endm
  .else
;			   R20L  HRL    HT   HS   HB   HD   HF    VT   VS   VB   VD   VF   R08    2ND  1ST
	crtmod_param_2	 %10101,   0,   92,  10,  12,  64,   6,  568,   6,  35, 512,  15,   27  ;   0  CRT 0/4/8/12
	crtmod_param_2	 %00101,   0,   76,   4,   6,  64,   2,  260,   3,  14, 240,   3,   44  ;   1  CRT 1/5/9/13
	crtmod_param_2	 %10000,   0,   46,   5,   6,  32,   3,  568,   6,  35, 512,  15,   27  ;   2  CRT 2/6/10/14
	crtmod_param_2	 %00000,   0,   38,   2,   3,  32,   1,  260,   3,  14, 240,   3,   36  ;   3  CRT 3/7/11/15
	crtmod_param_2	 %10110,   0,  138,  15,  18,  96,   9,  568,   6,  35, 512,  15,   27  ;   4  CRT 16/20/24
	crtmod_param_2	 %10110,   0,  176,  16,  20, 128,  12,  465,   8,  25, 424,   8,   27  ;   5  CRT 17/21/25
	crtmod_param_2	 %11010,   0,  176,  16,  20, 128,  12,  465,   8,  25, 424,   8,   27  ;   6  CRT 18/22/26
	crtmod_param_2	 %10110,   0,  138,  15,  26,  80,  17,  568,   6,  51, 480,  31,   27  ;   7  CRT 19/23/27
	crtmod_param_2	 %10001,   1,   68,   7,   9,  48,   4,  568,   6,  35, 512,  15,   27  ;   8  CRT 28/29/30/31
	crtmod_param_2	 %10110,   0,  138,  15,  34,  64,  25,  568,   6,  35, 512,  15,   27  ;   9  CRT 32/33/34/35
	crtmod_param_2	 %10001,   1,   68,   7,  17,  32,  12,  568,   6,  35, 512,  15,   27  ;  10  CRT 36/37/38/39
	crtmod_param_2	 %10101,   0,   82,   6,  10,  64,   2,  625,   2,  66, 512,  45,   27  ;  11  LCD 0/4/8/12
	crtmod_param_2	 %10101,   0,   82,   6,  10,  64,   2,  625,   2,  82, 480,  61,   27  ;  12  LCD 1/5/9/13
	crtmod_param_2	 %10000,   0,   42,   3,   5,  32,   2,  625,   2,  66, 512,  45,   27  ;  13  LCD 2/6/10/14
	crtmod_param_2	 %10000,   0,   42,   3,   5,  32,   2,  625,   2,  82, 480,  61,   27  ;  14  LCD 3/7/11/15
	crtmod_param_2	 %10110,   0,  124,   9,  15,  96,   4,  625,   2,  66, 512,  45,   27  ;  15  LCD 16/20/24
	crtmod_param_2	 %10110,   0,  124,   9,  15,  96,   4,  625,   2,  22, 600,   1,   27  ;  16  LCD 17/21/25
	crtmod_param_2	 %11010,   0,  124,   9,  15,  96,   4,  625,   2,  66, 512,  45,   27  ;  17  LCD 18/22/26
	crtmod_param_2	 %10111,   0,  100,  12,   6,  80,   2,  525,   2,  33, 480,  10,   27  ;  18  LCD 19/23/27
	crtmod_param_2	 %10001,   1,   68,   7,   9,  48,   4,  625,   2,  66, 512,  45,   27  ;  19  LCD 28/29/30/31
	crtmod_param_2	 %10110,   0,  124,   9,  31,  64,  20,  625,   2,  66, 512,  45,   27  ;  20  LCD 32/33/34/35
	crtmod_param_2	 %10001,   1,   68,   7,  17,  32,  12,  625,   2,  66, 512,  45,   27  ;  21  LCD 36/37/38/39
  .endif

;R20L<<1|HRLhbgNbÑN
;	rank	R20L	HRL	osc	div	dotclk	mode
;	7	1**10	*	69.552	2	34.776	768x512()
;	6	1**11	*	50.350	2	25.175	640x480
;	5	1**01	0	69.552	3	23.184	512x512()
;	4	1**01	1	69.552	4	17.388	384x256
;	3	1**00	0	69.552	6	11.592	256x256()
;	2	0**01	*	38.864	4	9.716	512x512()
;	1	1**00	1	69.552	8	8.694
;	0	0**00	*	38.864	8	4.858	256x256()
;	0	0**1*	*	38.864	8	4.858
dot_clock_rank:
  .rept 4
	.dc.b	0	;0**00 0
	.dc.b	0	;0**00 1
	.dc.b	2	;0**01 0
	.dc.b	2	;0**01 1
	.dc.b	0	;0**10 0
	.dc.b	0	;0**10 1
	.dc.b	0	;0**11 0
	.dc.b	0	;0**11 1
  .endm
  .rept 4
	.dc.b	3	;1**00 0
	.dc.b	1	;1**00 1
	.dc.b	5	;1**01 0
	.dc.b	4	;1**01 1
	.dc.b	7	;1**10 0
	.dc.b	7	;1**10 1
	.dc.b	6	;1**11 0
	.dc.b	6	;1**11 1
  .endm



;----------------------------------------------------------------
;IOCSR[$90 _G_CLR_ON OtBbNʂ̏ƃpbgƕ\ON
;p[^Ȃ
	.text
	.even
iocs_90_G_CLR_ON:
	push	d0/d1/d3/a0/a4/a6

;(`)OOŃANZX
;	$00E80000	CRTC
;	$00E82000	VICON
;	$00E84000	DMAC
;	$00E86000	SUPERAREA
;	$00E88000	MFP
;	$00E8A000	RTC
;	$00E8C000	PRNPORT
;	$00E8E000	SYSPORT
	lea.l	$00E88000,a6
OO	reg	-$00E88000(a6)
;<a6.l:(`)OÕx[XAhX

;݂̉ʃ[hmF
	moveq.l	#0,d1
	move.b	BIOS_CRTMOD.w,d1	;݂̉ʃ[h
	if	<cmp.w #crtmod_modes,d1>,hs	;݂̉ʃ[h͈͊ÔƂ
		move.b	SRAM_CRTMOD,d1		;N̉ʃ[hg
		if	<cmp.w #crtmod_modes,d1>,hs	;N̉ʃ[h͈͊ÔƂ
			moveq.l	#16,d1			;16g
  .if 0
			unlocksram
			move.b	d1,SRAM_CRTMOD
			locksram
  .endif
		endif
	endif

;p[^1̃AhX߂
	lea.l	crtmod_table_1_crt(pc),a4
	if	<btst.b #SRAM_XEIJ_LCD_BIT,SRAM_XEIJ>,ne	;LCD
		lea.l	crtmod_table_1_lcd(pc),a4
	endif
	move.w	d1,d0
  .if crtmod_param_1_size=8
	lsl.w	#3,d0
  .else
	mulu.w	#crtmod_param_1_size,d0
  .endif
	adda.w	d0,a4
;<a4.l:p[^1̃AhX

;[hmF
	moveq.l	#7,d3
	and.b	crtmod_param_1_r20h(a4),d3	;[hB0`7
;<d3.w:[hB0`7

;eLXgʂ̂ON
	move.w	#VICON_TXON_MASK,(VICON_VISIBLE)OO

;OtBbNXg[WON
	bset.b	#CRTC_GRAPHIC_STORAGE_BIT,(CRTC_MODE_BYTE)OO	;OtBbNXg[WON

;OtBbNVRAMNA
	lea.l	$00C00000,a0
	moveq.l	#0,d0
	moveq.l	#-1,d1			;1024*512/8=65536
	for	d1
		move.l	d0,(a0)+
		move.l	d0,(a0)+
	next

;OtBbNXg[WOFF
;[hݒ肷
	move.b	d3,(CRTC_MODE_BYTE)OO
	move.w	d3,(VICON_MEMORY_MODE)OO

;BIOS[NGA
	move.l	#$00C00000,BIOS_GRAPHIC_PAGE.w
	if	<cmp.w #4,d3>,lo	;[h0`3B512x512hbg
		move.l	#2*512,BIOS_GRAPHIC_Y_OFFSET.w
		if	<cmp.w #1,d3>,lo	;[h0B512x512hbgA16FA4y[W
			move.w	#16-1,BIOS_GRAPHIC_PALETS.w
		elif	eq			;[h1B512x512hbgA256FA2y[W
			move.w	#256-1,BIOS_GRAPHIC_PALETS.w
		else				;[h2`3B512x512hbgA65536FA1y[W
			move.w	#65536-1,BIOS_GRAPHIC_PALETS.w
		endif
	else					;[h4`7B1024x1024hbgA16FA1y[W
		move.l	#2*1024,BIOS_GRAPHIC_Y_OFFSET.w
		move.w	#16-1,BIOS_GRAPHIC_PALETS.w
	endif

;OtBbNpbg
	move.w	d3,d0
	bsr	initialize_gpalet

;eLXgONAOtBbNON
;	if	<cmp.w #4,d3>,lo	;[h0`3B512x512hbg
;		move.w	#VICON_TXON_MASK|VICON_G4ON_MASK|VICON_G3ON_MASK|VICON_G2ON_MASK|VICON_G1ON_MASK,(VICON_VISIBLE)OO
;	else				;[h4`7B1024x1024hbg
;		move.w	#VICON_TXON_MASK|VICON_GXON_MASK,(VICON_VISIBLE)OO
;	endif
;	IPLROM 1.0`1.31024x1024hbg512x512hbg𗼕ONɂĂ
	move.w	#VICON_TXON_MASK|VICON_GXON_MASK|VICON_G4ON_MASK|VICON_G3ON_MASK|VICON_G2ON_MASK|VICON_G1ON_MASK,(VICON_VISIBLE)OO

	pop
	rts

;----------------------------------------------------------------
;OtBbNpbg
;<d0.w:[hB0`7
	.text
	.even
initialize_gpalet:
	push	d0/d1/d2/d3/d4/a0/a1
	lea.l	VICON_GPALET,a0
	ifor	<tst.w d0>,eq,<cmp.w #4,d0>,hs	;[h0B512x512hbgA16FA4y[W
						;[h4`7B1024x1024hbgA16FA1y[W
		lea.l	gpalet_16_array(pc),a1
		moveq.l	#16/2-1,d0
		for	d0
			move.l	(a1)+,(a0)+
		next
	elif	<cmp.w #1,d0>,eq	;[h1B512x512hbgA256FA2y[W
		move.l	#%0000000000010010_0000000000010010,d1
		moveq.l	#%0000000000000000_0000000000000000,d4
		do
			moveq.l	#%0000000000000000_0000000000001000,d3
			moveq.l	#8-1,d2
			for	d2
				move.l	d4,d0
				and.l	#%1111101111111111_1111101111111111,d0
				or.l	d3,d0
				and.l	#%1111111111011111_1111111111011111,d0
				move.l	d0,(a0)+
				add.l	d1,d0
				move.l	d0,(a0)+
				add.l	d1,d0
				move.l	d0,(a0)+
				add.l	d1,d0
				move.l	d0,(a0)+
				add.l	#%0000000100100000_0000000100100000,d3
			next
			add.l	#%0101010000000000_0101010000000000,d4
		while	cc
	else				;[h2`3B512x512hbgA65536FA1y[W
		move.l	#$00_01_00_01,d0
		move.l	#$02_02_02_02,d1
		moveq.l	#256/2-1,d2
		for	d2
			move.l	d0,(a0)+
			add.l	d1,d0
		next
	endif
	pop
	rts

;OtBbN16Fpbg
gpalet_16_array:
	dcrgb	0,0,0
	dcrgb	10,10,10
	dcrgb	0,0,16
	dcrgb	0,0,31
	dcrgb	16,0,0
	dcrgb	31,0,0
	dcrgb	16,0,16
	dcrgb	31,0,31
	dcrgb	0,16,0
	dcrgb	0,31,0
	dcrgb	0,16,16
	dcrgb	0,31,31
	dcrgb	16,16,0
	dcrgb	31,31,0
	dcrgb	21,21,21
	dcrgb	31,31,31

;----------------------------------------------------------------
;50usPʂ̃EFCg
;<d0.l:(50usP)
	.text
	.even
wait_50us:
  .if 0
;Timer-Cg
;	Timer-C1/200vXP[(50us)œ삵ĂȂ΂ȂȂ
aTCDR	reg	a0
	push	d0-d2/aTCDR
	lea.l	MFP_TCDR,aTCDR
	moveq.l	#0,d1
	move.b	(aTCDR),d1
	move.b	(aTCDR),d1
	do
		moveq.l	#0,d2
		move.b	(aTCDR),d2
		redo	<cmp.b (aTCDR),d2>,cs
		sub.w	d2,d1
		if	cs
			add.w	#200,d1
		endif
		exg.l	d1,d2
		sub.l	d2,d0
	while	hi
	pop
	rts
  .else
;dbra󃋁[vg
;	BIOS_MPU_SPEED_ROM.wBIOS_MPU_TYPE.wݒ肳ĂȂ΂ȂȂ
	push	d0-d2
	subq.l	#1,d0
	if	cc
		move.w	BIOS_MPU_SPEED_ROM.w,d1	;000/010MHzl*1000/12A020/030/040/060MHzl*1000/6
		if	<cmpi.b #4,BIOS_MPU_TYPE.w>,lo	;000/010/020/030
			mulu.w	#3277,d1		;65536*50/1000
		elif	eq			;040
			mulu.w	#4915,d1		;65536*50/1000*6/4
		else				;060
			mulu.w	#19661,d1		;65536*50/1000*6/1
		endif
		swap.w	d1			;/50us
		move.w	d1,d2
		swap.w	d0
		for	d0
			swap.w	d0
			for	d0
				move.w	d2,d1
				for	d1
				next
			next
			swap.w	d0
		next
	endif
	pop
	rts
  .endif



