;========================================================================================
;  cylindertest.s
;  Copyright (C) 2003-2023 Makoto Kamada
;
;  This file is part of the XEiJ (X68000 Emulator in Java).
;  You can use, modify and redistribute the XEiJ if the conditions are met.
;  Read the XEiJ License for more details.
;  https://stdkmd.net/xeij/
;========================================================================================

	.include	doscall.mac
	.include	iocscall.mac
	.include	control2.mac

	clr.w	-(sp)			;768x512
	move.w	#16,-(sp)
	DOS	_CONCTRL
	addq.l	#4,sp

	lea.l	kanji,a2		;Ŗߐs
	moveq.l	#0,d5
	do
		moveq.l	#3,d1			;
		moveq.l	#0,d2			;W
		move.l	d5,d3			;sW
		moveq.l	#128-1,d4		;\錅-1
		movea.l	a2,a1			;̃AhX
		IOCS	_B_PUTMES
		lea.l	128(a2),a2
		addq.w	#1,d5
	while	<cmp.w #64,d5>,lo

	move.w	#-384+2,d4		;X̃XN[ʒu
	move.w	#-256+2,d5		;ỸXN[ʒu
	do
		lea.l	$00E80014,a1		;XN[
		move.w	d4,d1
		swap.w	d1
		move.w	d5,d1
		and.l	#$03FF03FF,d1
		IOCS	_B_LPOKE
		IOCS	_B_SFTSNS		;L[ŃXN[ʒuύX
		moveq.l	#1,d2
		if	<btst.l #1,d0>,ne	;CTRL
			moveq.l	#16,d2
		endif
		IOCS	_B_KEYINP
		if	<cmp.w #$3600,d0>,eq	;HOME
			move.w	#-384,d4
			move.w	#-256,d5
		elif	<cmp.w #$3B00,d0>,eq	;
			sub.w	d2,d4
		elif	<cmp.w #$3C00,d0>,eq	;
			sub.w	d2,d5
		elif	<cmp.w #$3D00,d0>,eq	;
			add.w	d2,d4
		elif	<cmp.w #$3E00,d0>,eq	;
			add.w	d2,d5
		endif
	while	<cmp.b #$1B,d0>,ne	;ESC

	clr.w	-(sp)			;768x512
	move.w	#16,-(sp)
	DOS	_CONCTRL
	addq.l	#4,sp

	DOS	_EXIT

kanji:
	.dc.b	''
	.dc.b	'ÈĈňƈǈȈɈʈˈ͈̈ΈψЈш҈ӈԈՈֈ׈؈وڈۈ܈݈'
	.dc.b	'߈@A'
	.dc.b	'BCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`a'
	.dc.b	'bcdefghijklmnopqrstuvwxyz{|}~'
	.dc.b	''
	.dc.b	''
	.dc.b	'ÉĉŉƉǉȉɉʉˉ͉̉ΉωЉщ҉ӉԉՉ։׉؉ىډۉ܉݉މ߉'
	.dc.b	'@ABCDE'
	.dc.b	'FGHIJKLMNOPQRSTUVWXYZ[\]^_`abcde'
	.dc.b	'fghijklmnopqrstuvwxyz{|}~'
	.dc.b	''
	.dc.b	'ÊĊŊ'
	.dc.b	'ǊȊɊʊˊ̊͊ΊϊЊъҊӊԊՊ֊׊؊يڊۊ܊݊ފߊ'
	.dc.b	'@ABCDEFGHI'
	.dc.b	'JKLMNOPQRSTUVWXYZ[\]^_`abcdefghi'
	.dc.b	'jklmnopqrstuvwxyz{|}~'
	.dc.b	''
	.dc.b	'ËċŋƋǋȋɋ'
	.dc.b	'ˋ̋͋΋ϋЋыҋӋԋՋ֋׋؋ًڋۋ܋݋ދߋ'
	.dc.b	'@ABCDEFGHIJKLM'
	.dc.b	'NOPQRSTUVWXYZ[\]^_`abcdefghijklm'
	.dc.b	'nopqrstuvwxyz{|}~'
	.dc.b	''
	.dc.b	'ÌČŌƌǌȌɌʌˌ̌͌'
	.dc.b	'όЌьҌӌԌՌ֌׌،ٌڌی܌݌ތߌ'
	.dc.b	'@ABCDEFGHIJKLMNOPQ'
	.dc.b	'RSTUVWXYZ[\]^_`abcdefghijklmnopq'
	.dc.b	'rstuvwxyz{|}~'
	.dc.b	''
	.dc.b	'ÍčōƍǍȍɍʍˍ͍̍΍ύЍэ'
	.dc.b	'ӍԍՍ֍׍؍ٍڍۍ܍ݍލߍ'
	.dc.b	'@ABCDEFGHIJKLMNOPQRSTU'
	.dc.b	'VWXYZ[\]^_`abcdefghijklmnopqrstu'
	.dc.b	'vwxyz{|}~'
	.dc.b	''
	.dc.b	'ÎĎŎƎǎȎɎʎˎ͎̎ΎώЎюҎӎԎՎ'
	.dc.b	'׎؎َڎێ܎ݎގߎ'
	.dc.b	'@ABCDEFGHIJKLMNOPQRSTUVWXY'
	.dc.b	'Z[\]^_`abcdefghijklmnopqrstuvwxy'
	.dc.b	'z{|}~'
	.dc.b	''
	.dc.b	'ÏďŏƏǏȏɏʏˏ̏͏ΏϏЏяҏӏԏՏ֏׏؏ُ'
	.dc.b	'ۏ܏ݏޏߏ'
	.dc.b	'@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]'
	.dc.b	'^_`abcdefghijklmnopqrstuvwxyz{|}'
	.dc.b	'~'
	.dc.b	''
	.dc.b	'ÐĐŐƐǐȐɐʐː̐͐ΐϐАѐҐӐԐՐ֐אِؐڐېܐݐ'
	.dc.b	'ߐ@A'
	.dc.b	'BCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`a'
	.dc.b	'bcdefghijklmnopqrstuvwxyz{|}~'
	.dc.b	''
	.dc.b	''
	.dc.b	'ÑđőƑǑȑɑʑˑ̑͑ΑϑБёґӑԑՑ֑בّؑڑۑܑݑޑߑ'
	.dc.b	'@ABCDE'
	.dc.b	'FGHIJKLMNOPQRSTUVWXYZ[\]^_`abcde'
	.dc.b	'fghijklmnopqrstuvwxyz{|}~'
	.dc.b	''
	.dc.b	'ÒĒŒ'
	.dc.b	'ǒȒɒʒ˒̒͒ΒϒВђҒӒԒՒ֒גْؒڒےܒݒޒߒ'
	.dc.b	'@ABCDEFGHI'
	.dc.b	'JKLMNOPQRSTUVWXYZ[\]^_`abcdefghi'
	.dc.b	'jklmnopqrstuvwxyz{|}~'
	.dc.b	''
	.dc.b	'ÓēœƓǓȓɓ'
	.dc.b	'˓͓̓ΓϓГѓғӓԓՓ֓דؓٓړۓܓݓޓߓ'
	.dc.b	'@ABCDEFGHIJKLM'
	.dc.b	'NOPQRSTUVWXYZ[\]^_`abcdefghijklm'
	.dc.b	'nopqrstuvwxyz{|}~'
	.dc.b	''
	.dc.b	'ÔĔŔƔǔȔɔʔ˔͔̔'
	.dc.b	'ϔДєҔӔԔՔ֔הؔٔڔ۔ܔݔޔߔ'
	.dc.b	'@ABCDEFGHIJKLMNOPQ'
	.dc.b	'RSTUVWXYZ[\]^_`abcdefghijklmnopq'
	.dc.b	'rstuvwxyz{|}~'
	.dc.b	''
	.dc.b	'ÕĕŕƕǕȕɕʕ˕͕̕ΕϕЕѕ'
	.dc.b	'ӕԕՕ֕וٕؕڕەܕݕޕߕ'
	.dc.b	'@ABCDEFGHIJKLMNOPQRSTU'
	.dc.b	'VWXYZ[\]^_`abcdefghijklmnopqrstu'
	.dc.b	'vwxyz{|}~'
	.dc.b	''
	.dc.b	'ÖĖŖƖǖȖɖʖ˖̖͖ΖϖЖіҖӖԖՖ'
	.dc.b	'זٖؖږۖܖݖޖߖ'
	.dc.b	'@ABCDEFGHIJKLMNOPQRSTUVWXY'
	.dc.b	'Z[\]^_`abcdefghijklmnopqrstuvwxy'
	.dc.b	'z{|}~'
	.dc.b	''
	.dc.b	'×ėŗƗǗȗɗʗ˗̗͗ΗϗЗїҗӗԗ՗֗חؗٗ'
	.dc.b	'ۗܗݗޗߗ'
	.dc.b	'@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]'
	.dc.b	'^_`abcdefghijklmnopqr'
	.dc.b	'ØĘŘƘǘȘ'
	.dc.b	'ʘ˘̘͘ΘϘИјҘӘԘ՘֘טؘ٘ژۘܘݘޘߘ'
	.dc.b	'@ABCDEFGHIJKL'
	.dc.b	'MNOPQRSTUVWXYZ[\]^_`abcdefghijkl'
	.dc.b	'mnopqrstuvwxyz{|}~'
	.dc.b	''
	.dc.b	'ÙęřƙǙșəʙ˙̙'
	.dc.b	'ΙϙЙљҙәԙՙ֙יؙٙڙۙܙݙޙߙ'
	.dc.b	'@ABCDEFGHIJKLMNOP'
	.dc.b	'QRSTUVWXYZ[\]^_`abcdefghijklmnop'
	.dc.b	'qrstuvwxyz{|}~'
	.dc.b	''
	.dc.b	'ÚĚŚƚǚȚɚʚ˚͚̚ΚϚК'
	.dc.b	'ҚӚԚ՚֚ךؚٚښۚܚݚޚߚ'
	.dc.b	'@ABCDEFGHIJKLMNOPQRST'
	.dc.b	'UVWXYZ[\]^_`abcdefghijklmnopqrst'
	.dc.b	'uvwxyz{|}~'
	.dc.b	''
	.dc.b	'ÛěśƛǛțɛʛ˛̛͛ΛϛЛћқӛԛ'
	.dc.b	'֛כ؛ٛڛۛܛݛޛߛ'
	.dc.b	'@ABCDEFGHIJKLMNOPQRSTUVWX'
	.dc.b	'YZ[\]^_`abcdefghijklmnopqrstuvwx'
	.dc.b	'yz{|}~'
	.dc.b	''
	.dc.b	'ÜĜŜƜǜȜɜʜ˜̜͜ΜϜМќҜӜԜ՜֜ל؜'
	.dc.b	'ڜۜܜݜޜߜ'
	.dc.b	'@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\'
	.dc.b	']^_`abcdefghijklmnopqrstuvwxyz{|'
	.dc.b	'}~'
	.dc.b	''
	.dc.b	'ÝĝŝƝǝȝɝʝ˝̝͝ΝϝНѝҝӝԝ՝֝ם؝ٝڝ۝ܝ'
	.dc.b	'ޝߝ@'
	.dc.b	'ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`'
	.dc.b	'abcdefghijklmnopqrstuvwxyz{|}~'
	.dc.b	''
