;========================================================================================
;  hypotrochoid.s
;  Copyright (C) 2003-2025 Makoto Kamada
;
;  This file is part of the XEiJ (X68000 Emulator in Java).
;  You can use, modify and redistribute the XEiJ if the conditions are met.
;  Read the XEiJ License for more details.
;  https://stdkmd.net/xeij/
;========================================================================================

;----------------------------------------------------------------
;  hypotrochoid.x
;	XEiJ̋^OtBbN(4096̃p^[~l߂obNOEh)ɃnC|gRCh`܂B
;	(S)Ǝ(S)̓XvCg(BG0BG1)A(T)̓eLXgʁA(G)̓OtBbNʂłB
;	j[4096̃p^[`FbN{bNX768x512ŃXvCg\`FbN{bNX
;	512x512BG1\`FbN{bNXONɂăZbgĂs܂B
;	BREAK/CTRL+C/ESCL[ŏIA쒆͂̑̃L[Œ~B~ENTERL[ōĊJȂ̃L[ŃR}肵܂B
;	X68000@ł͓܂B
;----------------------------------------------------------------

;----------------------------------------------------------------
;nC|gRCh
;	~̓ɉē~]ƂA~ɌŒ肳ꂽ_̋OՂnC|gRChƌĂт܂B
;	~̒S(0,0)AaRA~̔arA~̒S_܂ł̋dƂ܂B
;	~Ɠ~̎̒̔䂩A~1Ԃɓ~͐ڐɑ΂ĉER/r]܂B
;	ɐڐ1]̂ŁA킹ē~͉E(R-r)/r]܂B
;	~̒S̕tƂƁA_̈ʒu((R-r)*cos(t)+d*cos((R-r)/r*t),(R-r)*sin(t)-d*sin((R-r)/r*t))ƂȂ܂B
;	~nԂɓ~͉E(R-r)/r*n]܂B
;	R,r̂ƂA_ŏ̈ʒuɖ߂܂ł̎n0(R-r)/r*nɂȂŏnAȂ킿n0=r/gcd(R-r,r)łB
;	https://en.wikipedia.org/wiki/Hypotrochoid
;----------------------------------------------------------------

	.include	control2.mac
	.include	crtc.equ
	.include	doscall.mac
	.include	fefunc.mac
	.include	iocscall.mac
	.include	mfp.equ
	.include	misc.mac
	.include	push2.mac
	.include	sprc.equ
	.include	vicon.equ

;
	lea.l	1(a2),a0
	do
	;R ~̔a
		bsr	nextword
		break	eq			;wȂBlg
		FPACK	__STOL
		goto	cs,error		;ȂBG[I
		goto	<tst.l d0>,le,error	;1菬BG[I
		goto	<cmp.l #1000000,d0>,gt,error	;1000000傫BG[I
		move.l	d0,int_R
	;r ~̔a
		bsr	nextword
		break	eq			;wȂBlg
		FPACK	__STOL
		goto	cs,error		;ȂBG[I
		goto	<tst.l d0>,le,error	;1菬BG[I
		goto	<cmp.l #1000000,d0>,gt,error	;1000000傫BG[I
		goto	<cmp.l int_R,d0>,ge,error	;rRƓ傫BG[I
		move.l	d0,int_r
	;d ~̒S_܂ł̋
		bsr	nextword
		break	eq			;wȂBlg
		FPACK	__STOD
		goto	cs,error		;lȂBG[I
		FPACK	__DTST
		goto	lt,error		;0菬BG[I
		move.l	d0,d2
		move.l	d1,d3
		move.l	#1000000,d0
		FPACK	__LTOD
		FPACK	__DCMP
		goto	lt,error		;1000000傫BG[I
		movem.l	d2-d3,dbl_d
	;f 1(1)̓_̐
		bsr	nextword
		break	eq			;wȂBlg
		FPACK	__STOL
		goto	cs,error		;lȂBG[I
		goto	<tst.l d0>,le,error	;1菬BG[I
		goto	<cmp.l #1000000,d0>,gt,error	;1000000傫BG[I
		move.l	d0,int_f
	while	f

;Ō܂l
;R ~̔a
	move.l	int_R,d0
	FPACK	__LTOD
	movem.l	d0-d1,dbl_R
;r ~̔a
	move.l	int_r,d0
	FPACK	__LTOD
	movem.l	d0-d1,dbl_r
;Rr=R-r ~̒S瓮~̒S܂ł̋
	move.l	int_R,d0
	sub.l	int_r,d0
	move.l	d0,int_Rr
	FPACK	__LTOD
	movem.l	d0-d1,dbl_Rr
;Rrr=(R-r)/r _̑x
;	movem.l	dbl_Rr,d0-d1
	movem.l	dbl_r,d2-d3
	FPACK	__DDIV
	movem.l	d0-d1,dbl_Rrr
;n0=r/gcd(R-r,r) 
	move.l	int_Rr,d0		;d0=O̗]=R-rB0ł͂Ȃ
	move.l	int_r,d1		;d1=Ȍ=rB0ł͂Ȃ
	do
					;d0=O̗],d1=Ȍ
					;Ȍ폜,O̗]聨
		exg.l	d0,d1		;d0=폜,d1=
		FPACK	__LMOD		;d0=],d1=
	while	<tst.l d0>,ne		;]肪0ɂȂ܂ŌJԂ
					;]肪0ɂȂƂ̏=gcd(R-r,r)
	move.l	int_r,d0		;d0=r
	FPACK	__LDIV			;d0=n0=r/gcd(R-r,r)
	move.l	d0,int_n0
;fn0=f*n0 n0(=1)̓_̐
	move.l	int_f,d0
	move.l	int_n0,d1
	FPACK	__LMUL
	move.l	d0,int_fn0
;s=RR/(R-r+d) {
	movem.l	dbl_Rr,d0-d1
	movem.l	dbl_d,d2-d3
	FPACK	__DADD
	move.l	d0,d2
	move.l	d1,d3
	movem.l	dbl_RR,d0-d1
	FPACK	__DDIV
	movem.l	d0-d1,dbl_s
;f 1(1)̓_̐
	move.l	int_f,d0
	FPACK	__LTOD
	movem.l	d0-d1,dbl_f
;dt=2*pi/f px̑
	moveq.l	#2,d0
	FPACK	__LTOD
	FPACK	__NPI
	movem.l	dbl_f,d2-d3
	FPACK	__DDIV
	movem.l	d0-d1,dbl_dt

;XN[̋O
;	S(128,256)a(128,256)̉~
orbit_length	equ	(orbit_end-orbit)/4
	move.l	#orbit_length,d0
	FPACK	__LTOD
	move.l	d0,d2			;d2d3=n
	move.l	d1,d3
	moveq.l	#2,d0
	FPACK	__LTOD
	FPACK	__NPI			;d0d1=2*pi
	FPACK	__DDIV			;d0d1=2*pi/n=dt
	movea.l	d0,a4			;a4a5=dt
	movea.l	d1,a5
	move.l	#128,d0
	FPACK	__LTOD
	movea.l	d0,a0			;a0a1=128
	movea.l	d1,a1
	move.l	#256,d0
	FPACK	__LTOD
	movea.l	d0,a2			;a2a3=256
	movea.l	d1,a3
	moveq.l	#0,d4			;d4d5=t
	moveq.l	#0,d5
	lea.l	orbit,a6
	move.w	#orbit_length-1,d7
	for	d7
		move.l	d4,d0			;d0d1=t
		move.l	d5,d1
		FPACK	__COS			;d0d1=cos(t)
		move.l	a0,d2			;d2d3=128
		move.l	a1,d3
		FPACK	__DMUL			;d0d1=128*cos(t)
		exg.l	d0,d2			;d0d1=128
		exg.l	d1,d3			;d2d3=128*cos(t)
		FPACK	__DSUB			;d0d1=128-128*cos(t)
		FPACK	__DTOL			;d0=128-128*cos(t)
		move.w	d0,(a6)+		;x
	;
		move.l	d4,d0			;d0d1=t
		move.l	d5,d1
		FPACK	__SIN			;d0d1=sin(t)
		move.l	a2,d2			;d2d3=256
		move.l	a3,d3
		FPACK	__DMUL			;d0d1=256*sin(t)
		FPACK	__DADD			;d0d1=256+256*sin(t)
		FPACK	__DTOL			;d0=256+256*sin(t)
		move.w	d0,(a6)+		;y
	;
		move.l	d4,d0			;d0d1=t
		move.l	d5,d1
		move.l	a4,d2			;d2d3=dt
		move.l	a5,d3
		FPACK	__DADD			;d0d1=t+dt
		move.l	d0,d4			;d4d5=t+dt
		move.l	d1,d5
	next

;ʃ[hύX
	move.w	#3,-(sp)		;t@NVL[\Ȃ
	move.w	#14,-(sp)
	DOS	_CONCTRL
	move.w	d0,function_mode
	move.w	#1,-(sp)		;768x512OtBbN
	move.w	#16,-(sp)
	DOS	_CONCTRL
	move.w	d0,screen_mode
	addq.l	#8,sp

;J[\OFF
	IOCS	_B_CUROFF

;X[p[oCU[h
	supervisormode

;XvCgRg[
	move.w	#28+4,SPRC_H_BACK_END	;obN|[`IJBR02+4
	move.w	#255,SPRC_H_FRONT_END	;tg|[`IJB255BEFCg͏ȗ
	move.w	#40,SPRC_V_BACK_END	;obN|[`IX^BR06
	move.w	#%10101,SPRC_RESOLUTION	;𑜓xB--------|---|𑜓x|TCY##|TCY##
	moveq.l	#0,d0
	move.l	d0,SPRC_BG_0_X		;BG0XN[XW,BG0XN[YW
	move.l	d0,SPRC_BG_1_X		;BG1XN[XW,BG1XN[YW
	move.w	d0,SPRC_CONTROL		;Rg[B------|XvCgON|---|BG1eLXg##|BG1\ON|BG0eLXg##|BG0\ON

;p^[4096`ON
	move.w	#$0005,$00EB0812

;XvCgNA
	lea.l	$00EB0000,a0
	moveq.l	#0,d0
	move.w	#256-1,d1
	for	d1
		move.l	d0,(a0)+
		move.l	d0,(a0)+
	next

;p^[NA
	moveq.l	#0,d0
	moveq.l	#0,d2			;oN
	do
		move.w	d2,$00EB0814		;oNԍ
		lea.l	$00EB8000,a0
		move.w	#32768/8-1,d1
		for	d1
			move.l	d0,(a0)+
			move.l	d0,(a0)+
		next
		add.w	#$0100,d2
	while	<cmp.w #$0F00,d2>,ls

;eLXgGAɃp^[~l߂
	lea.l	$00EB4000,a0		;Jnʒu(0,0)
	moveq.l	#0,d4			;p^[ԍ4bit<<12
	move.w	#1<<8,d5		;pbgubN<<8BpbgubN1
	moveq.l	#0,d6			;p^[ԍ8bit
	do
		moveq.l	#16-1,d3		;Y[v16
		for	d3
			moveq.l	#4-1,d2			;Y[v4
			for	d2
				moveq.l	#64-1,d1		;X[v64
				for	d1
					move.w	d4,d0			;p^[ԍ4bit<<12
					add.w	d5,d0			;pbgubN<<8
					add.w	d6,d0			;p^[ԍ8bit
					move.w	d0,(a0)+
					addq.b	#1,d6			;p^[ԍ8bit
				next
			next
			add.w	#1<<12,d4		;p^[ԍ4bit<<12
		next
		add.w	#1<<8,d5		;pbgubN<<8
	while	<cmp.w #2<<8,d5>,ls	;pbgubN2܂

;XvCg\ON
;	BG0ɃeLXgGA0ABG1ɃeLXgGA1蓖Ăĕ\
	move.w	#SPRC_SPRITE_ON|SPRC_BG_1_TEXT_1|SPRC_BG_1_ON|SPRC_BG_0_TEXT_0|SPRC_BG_0_ON,SPRC_CONTROL
	ori.w	#VICON_SPON_MASK,VICON_VISIBLE
	move.w	#%00_00_01_10_11_10_01_00,VICON_PRIORITY

;pbgݒ肷
	movehsv	104,31,31,VICON_TSPALET+2*$11	;BBG0BXvCgpbg$11
	movehsv	152,31,31,VICON_TSPALET+2*$21	;BBG1BXvCgpbg$21
	movehsv	8,31,31,VICON_TSPALET+2*1	;ԁBeLXgʁBeLXgpbg1
	movehsv	56,31,31,VICON_GPALET+2*1	;΁BOtBbNʁBOtBbNpbg1

;Jnʒu܂ŃXN[
	lea.l	orbit,a0
	move.w	(a0),SPRC_BG_0_X	;BG0𓮂
	move.w	2(a0),SPRC_BG_0_Y
	move.w	4*(orbit_length*1/4)(a0),SPRC_BG_1_X	;BG1𓮂
	move.w	4*(orbit_length*1/4)+2(a0),SPRC_BG_1_Y
	move.w	4*(orbit_length*2/4)(a0),CRTC_TEXT_X	;eLXgʂ𓮂
	move.w	4*(orbit_length*2/4)+2(a0),CRTC_TEXT_Y
	move.w	4*(orbit_length*3/4)(a0),CRTC_GRAPHIC_X_0	;OtBbNʂ𓮂
	move.w	4*(orbit_length*3/4)+2(a0),CRTC_GRAPHIC_Y_0

;`
	lea.l	moji(pc),a0		;a0=
	moveq.l	#2,d7			;2=S,1=T,0=G
	for	d7
	;R[hoBSJISɌ
		moveq.l	#0,d0
		moveq.l	#0,d1
		move.b	(a0)+,d0		;sh
		move.b	(a0)+,d1		;sl
	;9494_̒ʂԍ߂
	;	((sh - (sh < 0xe0 ? 0x81 : 0xe0 - (0xa0 - 0x81))) * 188 +
	;	 (sl - (sl < 0x80 ? 0x40 : 0x80 - (0x7f - 0x40))))
		moveq.l	#$81,d2
		if	<cmp.b #$E0,d0>,hs
			moveq.l	#$E0-($A0-$81),d2
		endif
		sub.b	d2,d0
		moveq.l	#$40,d2
		if	<cmp.b #$80,d1>,hs
			moveq.l	#$80-($7F-$40),d2
		endif
		sub.b	d2,d1
		mulu.w	#188,d0
		add.w	d1,d0
	;9悩15܂łȂ̂ŋl߂
		if	<cmp.w #94*(16-1),d0>,hs	;16`
			sub.w	#94*(16-9),d0		;16恨9
		endif
	;tHgAhX߂
		mulu.w	#3*24,d0
		add.l	#$00F40000,d0		;24x24
		movea.l	d0,a1
	;_ׂ
		moveq.l	#1,d3			;F
		move.w	#512-12,d2		;YW
		moveq.l	#24-1,d6		;24C
		for	d6
			move.w	#512-12,d1		;XW
			moveq.l	#3-1,d5			;3oCg
			for	d5
				move.b	(a1)+,d0
				moveq.l	#8-1,d4			;8hbg
				for	d4
					add.b	d0,d0
					if	cs
						if	<cmp.w #1,d7>,hi	;2=S
							bsr	sp_pset
						elif	eq			;1=T
							bsr	tx_pset
						else				;0=G
							bsr	gr_pset
						endif
					endif
					addq.w	#1,d1			;XWi߂
				next
			next
			sub.w	#24,d1			;XW߂
			addq.w	#1,d2			;YWi߂
		next
	next

;nC|gRCh`
;	t=0
;	for i=1 to fn0
;		pset(floor(ox+s*(Rr*cos(t)+d*cos(Rrr*t))),
;		     floor(oy-s*(Rr*sin(t)-d*sin(Rrr*t))))
;		t=t+dt
;	next
	moveq.l	#0,d4			;d4d5=t
	moveq.l	#0,d5
	move.l	int_fn0,d7
	forlong	d7
		movem.l	dbl_Rrr,d0-d1		;d0d1=Rrr
		move.l	d4,d2			;d2d3=t
		move.l	d5,d3
		FPACK	__DMUL			;d0d1=Rrr*t
		movea.l	d0,a4			;a4a5=Rrr*t
		movea.l	d1,a5
		FPACK	__COS			;d0d1=cos(Rrr*t)
		movem.l	dbl_d,d2-d3		;d2d3=d
		FPACK	__DMUL			;d0d1=d*cos(Rrr*t)
		movea.l	d0,a2			;a2a3=d*cos(Rrr*t)
		movea.l	d1,a3
		move.l	d4,d0			;d0d1=t
		move.l	d5,d1
		FPACK	__COS			;d0d1=cos(t)
		movem.l	dbl_Rr,d2-d3		;d2d3=Rr
		FPACK	__DMUL			;d0d1=Rr*cos(t)
		move.l	a2,d2			;d2d3=d*cos(Rrr*t)
		move.l	a3,d3
		FPACK	__DADD			;d0d1=Rr*cos(t)+d*cos(Rrr*t)
		movem.l	dbl_s,d2-d3		;d2d3=s
		FPACK	__DMUL			;d0d1=s*(Rr*cos(t)+d*cos(Rrr*t))
		movem.l	dbl_ox,d2-d3	;d2d3=ox
		FPACK	__DADD			;d0d1=ox+s*(Rr*cos(t)+d*cos(Rrr*t))
		FPACK	__DFLOOR		;d0d1=floor(ox+s*(Rr*cos(t)+d*cos(Rrr*t)))
		FPACK	__DTOL			;d0=floor(ox+s*(Rr*cos(t)+d*cos(Rrr*t)))
		movea.l	d0,a0			;a0=floor(ox+s*(Rr*cos(t)+d*cos(Rrr*t))) XW
	;
		move.l	a4,d0
		move.l	a5,d1			;d0d1=Rrr*t
		FPACK	__SIN			;d0d1=sin(Rrr*t)
		movem.l	dbl_d,d2-d3		;d2d3=d
		FPACK	__DMUL			;d0d1=d*sin(Rrr*t)
		movea.l	d0,a2			;a2a3=d*sin(Rrr*t)
		movea.l	d1,a3
		move.l	d4,d0			;d0d1=t
		move.l	d5,d1
		FPACK	__SIN			;d0d1=sin(t)
		movem.l	dbl_Rr,d2-d3		;d2d3=Rr
		FPACK	__DMUL			;d0d1=Rr*sin(t)
		move.l	a2,d2			;d2d3=d*sin(Rrr*t)
		move.l	a3,d3
		FPACK	__DSUB			;d0d1=Rr*sin(t)-d*sin(Rrr*t)
		movem.l	dbl_s,d2-d3		;d2d3=s
		FPACK	__DMUL			;d0d1=s*(Rr*sin(t)-d*sin(Rrr*t))
		move.l	d0,d2			;d2d3=s*(Rr*sin(t)-d*sin(Rrr*t))
		move.l	d1,d3
		movem.l	dbl_oy,d0-d1	;d0d1=oy
		FPACK	__DSUB			;d0d1=oy-s*(Rr*sin(t)-d*sin(Rrr*t))
		FPACK	__DFLOOR		;d0d1=floor(oy-s*(Rr*sin(t)-d*sin(Rrr*t)))
		FPACK	__DTOL			;d0=floor(oy-s*(Rr*sin(t)-d*sin(Rrr*t)))
		movea.l	d0,a1			;a1=floor(oy-s*(Rr*sin(t)-d*sin(Rrr*t))) YW
	;
		move.l	a0,d1
		move.l	a1,d2
		moveq.l	#1,d3
		bsr	sp_pset
		bsr	tx_pset
		bsr	gr_pset
	;
		move.l	d4,d0			;d0d1=t
		move.l	d5,d1
		movem.l	dbl_dt,d2-d3		;d2d3=dt
		FPACK	__DADD			;d0d1=t+dt
		move.l	d0,d4			;d4d5=t+dt
		move.l	d1,d5
	next

;
	lea.l	orbit,a0
	movea.l	a0,a1
	lea.l	4*(orbit_length*1/4)(a0),a2
	lea.l	4*(orbit_length*2/4)(a0),a3
	lea.l	4*(orbit_length*3/4)(a0),a4
	lea.l	orbit_end-orbit(a0),a5
	moveq.l	#0,d1			;-1=~,0=쒆,1=R}
	dostart
		ifand	<tst.l d1>,mi,<cmp.b #13,d0>,eq	;~ENTERL[ꂽƂ
			moveq.l	#0,d1			;쒆ɂ
		elif	<tst.b d0>,ne		;~ENTERȊÕL[ꂽA쒆ɉL[ꂽƂ
			moveq.l	#1,d1			;R}ɂ
		endif
	start
		do
		while	<btst.b #MFP_G_VDISP_BIT,MFP_GPDR>,eq	;\Ԃ҂
		do
		while	<btst.b #MFP_G_VDISP_BIT,MFP_GPDR>,ne	;AԂ҂
		if	<tst.l d1>,pl		;쒆܂̓R}̂Ƃ
			if	ne			;R}̂Ƃ
				moveq.l	#-1,d1			;~ɂ
			endif
			move.w	(a1)+,SPRC_BG_0_X	;BG0𓮂
			move.w	(a1)+,SPRC_BG_0_Y
			if	<cmpa.l a5,a1>,eq
				movea.l	a0,a1
			endif
			move.w	(a2)+,SPRC_BG_1_X	;BG1𓮂
			move.w	(a2)+,SPRC_BG_1_Y
			if	<cmpa.l a5,a2>,eq
				movea.l	a0,a2
			endif
			move.w	(a3)+,CRTC_TEXT_X	;eLXgʂ𓮂
			move.w	(a3)+,CRTC_TEXT_Y
			if	<cmpa.l a5,a3>,eq
				movea.l	a0,a3
			endif
			move.w	(a4)+,CRTC_GRAPHIC_X_0	;OtBbNʂ𓮂
			move.w	(a4)+,CRTC_GRAPHIC_Y_0
			if	<cmpa.l a5,a4>,eq
				movea.l	a0,a4
			endif
		endif
		bsr	inkey0
	whileand	<cmp.b #27,d0>,ne,<cmp.b #3,d0>,ne	;ESC܂CTRL+C܂ŌJԂ

;XvCg\OFF
	move.w	#$0000,SPRC_CONTROL
	andi.w	#.notw.VICON_SPON_MASK,VICON_VISIBLE

;p^[4096`OFF
	move.w	#$0000,$00EB0812
	move.w	#$0000,$00EB0814

;[U[h
	usermode

;J[\ON
	IOCS	_B_CURON

;ʃ[h𕜌
	move.w	screen_mode,-(sp)
	move.w	#16,-(sp)
	DOS	_CONCTRL
	move.w	function_mode,-(sp)
	move.w	#14,-(sp)
	DOS	_CONCTRL
	addq.l	#8,sp

;I
exit:
	DOS	_EXIT

moji:		.dc.w	'r','s','f'

;G[I
error:
	pea.l	usage(pc)
	DOS	_PRINT
	addq.l	#4,sp
	move.w	#1,-(sp)
	DOS	_EXIT2

usage:		.dc.b	'>hypotrochoid.x R r d f',13,10
		.dc.b	'                               l  ŏl   ől',13,10
		.dc.b	'  R  ~̔a()              97     r+1  1000000',13,10
		.dc.b	'  r  ~̔a()              47       1      R-1',13,10
		.dc.b	'  d  ~̒S_܂ł̋    37       1  1000000',13,10
		.dc.b	'  f  1(1)̓_̐()   720       1  1000000',13,10
		.dc.b	0
	.even

;sp_pset
;	obNOEhʂɓ_`
;	1024x1024hbg̉ʂ64x6416x16hbg(128oCg)̃p^[ɕĂ
;	ʍW(%LLLLLLSTXX,%BBBBHHYYYY)
;	p^[W(%LLLLLL,%BBBBHH) p^[W(%STXX,%YYYY)
;	p^[ԍ%BBBBHHLLLLLL oNԍ%BBBB oNp^[ԍ%HHLLLLLL
;	[hAhX$00EB8000+%HHLLLLLLSYYYYT0 [hrbgԍ%XX00^%1100
;<d1.w:XWB0`1023B͈͊ÔƂȂ
;<d2.w:YWB0`1023B͈͊ÔƂȂ
;<d3.w:pbgR[hB0`15B4bitg
sp_pset:
	ifand	<cmp.w #1023,d1>,ls,<cmp.w #1023,d2>,ls
		push	d1-d5/a0
		moveq.l	#%1111,d4		;d1.w=%LLLLLLSTXX
		moveq.l	#%1111,d5		;d2.w=%BBBBHHYYYY
		and.w	d4,d3			;d3.w=%PPPP
		and.w	d1,d4			;d4.l=%STXX
		and.w	d2,d5			;d5.l=%YYYY
		lsr.w	#4,d1			;d1.w=%LLLLLL
		lsr.w	#4,d2			;d2.w=%BBBBHH
		lsl.w	#6,d2			;d2.w=%BBBBHH000000
		or.w	d2,d1			;d1.w=%BBBBHHLLLLLL p^[ԍ
		move.w	d1,$00EB0814		;%BBBB oNԍ
		moveq.l	#0,d2
		move.b	d1,d2			;d2.l=%HHLLLLLL
		lsl.b	#5,d4			;d4.b=%TXX00000,x=S
		addx.w	d2,d2			;d2.l=%HHLLLLLLS
		lsl.w	#4,d2			;d2.l=%HHLLLLLLS0000
		or.w	d5,d2			;d2.l=%HHLLLLLLSYYYY
		add.b	d4,d4			;d4.b=%XX000000,x=T
		addx.w	d2,d2			;d2.l=%HHLLLLLLSYYYYT
		add.w	d2,d2			;d2.l=%HHLLLLLLSYYYYT0
		lea.l	$00EB8000,a0
		adda.l	d2,a0			;a0=$00EB8000+%HHLLLLLLSYYYYT0 [hAhX
		lsr.b	#4,d4			;d4.b=%XX00
		eor.b	#%1100,d4		;d4.b=%XX00^%1100 [hrbgԍ
		move.w	(a0),d2			;[hǂݏo
		ror.w	d4,d2			;ړÏʒu4bitֈړ
		and.w	#%1111111111110000,d2	;4bit
		or.w	d3,d2			;4bitɃpbgR[h
		rol.w	d4,d2			;̈ʒuɖ߂
		move.w	d2,(a0)			;[h߂
		pop
	endif
	rts

tx_pset:
	ifand	<cmp.w #1023,d1>,ls,<cmp.w #1023,d2>,ls
		push	d0-d3/a0
		move.w	CRTC_ACCESS,-(sp)
		move.w	#$0200,CRTC_ACCESS	;}XNON,OFF
		move.w	CRTC_MASK,-(sp)
		lea.l	$00E60000,a0		;v[3
		ext.l	d2
		lsl.l	#7,d2			;y*128
		adda.l	d2,a0
		moveq.l	#15,d0
		and.w	d1,d0			;x̉4bit
		move.w	#$8000,d2
		lsr.w	d0,d2			;ރrbg1
		not.w	d2			;ރrbg0
		move.w	d2,CRTC_MASK
		lsr.w	#4,d1
		add.w	d1,d1			;x/16*2
		adda.w	d1,a0
		ror.w	#4,d3			;bit3ŏʂ
		moveq.l	#4-1,d2
		for	d2
			add.w	d3,d3			;o
			subx.w	d0,d0			;SrbgɓWJ
			move.w	d0,(a0)			;
			suba.l	#$00020000,a0
		next
		move.w	(sp)+,CRTC_MASK
		move.w	(sp)+,CRTC_ACCESS
		pop
	endif
	rts

gr_pset:
	ifand	<cmp.w #1023,d1>,ls,<cmp.w #1023,d2>,ls
		push	d1-d2/a0
		lea.l	$00C00000,a0
		swap.w	d2
		clr.w	d2
		lsr.l	#5,d2			;y*2048
		adda.l	d2,a0
		add.w	d1,d1			;x*2
		move.w	d3,(a0,d1.w)
		pop
	endif
	rts

	.data
	.even
;萔
dbl_ox:		.dc.d	512.0		;ox SXW
dbl_oy:		.dc.d	512.0		;oy SYW
dbl_RR:		.dc.d	510.0		;RR \a
;
int_R:		.dc.l	97		;R ~̔a
int_r:		.dc.l	47		;r ~̔a
dbl_d:		.dc.d	37.0		;d ~̒S_܂ł̋
int_f:		.dc.l	720		;f 1(1)̓_̐

	.bss
	.even
;Ō܂l
dbl_R:		.ds.d	1		;R ~̔a
dbl_r:		.ds.d	1		;r ~̔a
int_Rr:		.ds.l	1		;Rr=R-r ~̒S瓮~̒S܂ł̋
dbl_Rr:		.ds.d	1		;Rr=R-r ~̒S瓮~̒S܂ł̋
dbl_Rrr:	.ds.d	1		;Rrr=(R-r)/r _̑x
int_n0:		.ds.l	1		;n0=r/gcd(R-r,r) 
int_fn0:	.ds.l	1		;fn0=f*n0 n0(=1)̓_̐
dbl_s:		.ds.d	1		;s=RR/(R-r+d) {
dbl_f:		.ds.d	1		;f 1(1)̓_̐
dbl_dt:		.ds.d	1		;dt=2*pi/f px̑

;ۑʃ[h
function_mode:	.ds.w	1
screen_mode:	.ds.w	1

;XN[̋O
orbit:		.ds.w	2*720
orbit_end:

	.text

;----------------------------------------------------------------
;R[h0łȂL[͂BĂȂĂ҂Ȃ
;>d0.l:R[hB0=ĂȂ
inkey0::
	dostart
		IOCS	_B_KEYINP		;L[obt@菜
		break	<tst.b d0>,ne		;R[h0łȂL[ꂽƂI
	start
		IOCS	_B_KEYSNS		;L[obt@ǂ݂
	while	<tst.l d0>,ne		;ĂƂJԂ
	and.l	#$000000FF,d0		;R[h
	rts

;----------------------------------------------------------------
;󔒂ǂݔ΂
;<a0.l:
;>d0.l:ŏ̋󔒈ȊO̕܂0
;>a0.l:ŏ̋󔒈ȊO̕܂0̈ʒu
;>z:ne=󔒈ȊO̕,eq=󔒈ȊO̕Ȃ
nextword::
	moveq.l	#0,d0
	do
		move.b	(a0)+,d0		;̕
		break	eq			;0ȂΏI
		redo	<cmp.b #' ',d0>,eq	;' 'ȂΌJԂ
	whileand	<cmp.b #9,d0>,hs,<cmp.b #13,d0>,ls	;\t\n\v\f\rȂΌJԂ
	subq.l	#1,a0			;i݉߂߂
	tst.l	d0
	rts

	.end
