;========================================================================================
;  isXEiJ.s
;  Copyright (C) 2003-2024 Makoto Kamada
;
;  This file is part of the XEiJ (X68000 Emulator in Java).
;  You can use, modify and redistribute the XEiJ if the conditions are met.
;  Read the XEiJ License for more details.
;  https://stdkmd.net/xeij/
;========================================================================================

;----------------------------------------------------------------
;
;	isXEiJ.x
;		XEiJœ삵Ă邩ׂ܂B
;
;	ŏIXV
;		2024-08-08
;
;	
;		has060 -i include -o isXEiJ.o -w isXEiJ.s
;		lk -o isXEiJ.x isXEiJ.o
;
;	g
;		>isXEiJ
;
;	IR[h
;		0	XEiJł͂Ȃ
;		1	XEiJ
;
;----------------------------------------------------------------

	.include	doscall.mac

;XEiJׂ
;>d0.l:0=XEiJł͂Ȃ,1=XEiJ
_isXEiJ::
	clr.l	-(sp)			;ޏꏊ
	move.w	#4,-(sp)		;TCYBO[h
	pea.l	2(sp)			;ރAhXBޏꏊ
	move.l	#$00E9F03C,-(sp)	;ǂݏoAhXBHFSROM̖
	DOS	_BUS_ERR		;ROM̓eRs[
	lea.l	10(sp),sp
	cmpi.l	#'JHFS',(sp)+		;mF
	seq.b	-(sp)			;$00=ǂݏoȂ/sv,$FF=v
	moveq.l	#1,d0
	and.b	(sp)+,d0		;0=XEiJł͂Ȃ,1=XEiJ
	rts

;Jnʒu
start:
;󔒂ǂݔ΂
	addq.l	#1,a2			;a2=R}hC
	moveq.l	#0,d0
10:	move.b	(a2)+,d0
	beq	20f			;ȂBXEiJׂ
	cmpi.b	#' ',d0
	beq	10b
	cmpi.b	#9,d0
	beq	10b
	bra	40f			;@G[Bgp@\ďI

;XEiJׂ
20:	bsr	_isXEiJ
;ʂ\ďIR[hŕԂ
	move.w	d0,-(sp)		;0=XEiJł͂Ȃ,1=XEiJ
	lea.l	no(pc),a0		;XEiJł͂܂
	beq	30f
	lea.l	yes(pc),a0		;XEiJł
30:	move.l	a0,-(sp)		;XEiJł͂܂/XEiJł
	DOS	_PRINT
	addq.l	#4,sp
	DOS	_EXIT2

;gp@\ďI
40:	pea.l	usage(pc)		;gp@
	DOS	_PRINT
	move.w	#-1,(sp)
	DOS	_EXIT2

usage:	.dc.b	'isXEiJ.x',13,10
	.dc.b	'  XEiJׂ܂',13,10
	.dc.b	'  gp@: isXEiJ',13,10
	.dc.b	'  IR[h: 0=XEiJł͂Ȃ 1=XEiJ',13,10,0
no:	.dc.b	'XEiJł͂܂',13,10,0
yes:	.dc.b	'XEiJł',13,10,0

	.end	start
